/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipStream {
    public static boolean isGzip(String string) {
        return string.toLowerCase().endsWith(".gz");
    }

    public static boolean isZip(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static InputStream getInputStream(InputStream inputStream, String string) throws IOException {
        if (inputStream == null) {
            return null;
        }
        InputStream inputStream2 = inputStream;
        if (ZipStream.isGzip(string)) {
            try {
                inputStream2 = new GZIPInputStream(inputStream2);
            }
            catch (IOException iOException) {
                throw new IOException("ERROR: IOException opening GZIP file: " + iOException.getMessage() + ": " + string);
            }
        }
        if (ZipStream.isZip(string)) {
            try {
                inputStream2 = new ZipInputStream(inputStream2);
                ((ZipInputStream)inputStream2).getNextEntry();
            }
            catch (ZipException zipException) {
                throw new IOException("ERROR: ZipException opening ZIP file: " + string);
            }
            catch (IOException iOException) {
                throw new IOException("ERROR: IOException opening ZIP file: " + string);
            }
        }
        return inputStream2;
    }

    public static OutputStream getOutputStream(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            return null;
        }
        OutputStream outputStream2 = outputStream;
        if (string.toLowerCase().endsWith(".gz")) {
            try {
                outputStream2 = new GZIPOutputStream(outputStream2);
            }
            catch (IOException iOException) {
                throw new IOException("ERROR: IOException opening GZIP file: " + string);
            }
        }
        if (string.toLowerCase().endsWith(".zip")) {
            try {
                outputStream2 = new ZipOutputStream(outputStream2);
                ((ZipOutputStream)outputStream2).putNextEntry(new ZipEntry(string));
            }
            catch (ZipException zipException) {
                throw new IOException("ERROR: ZipException writing ZIP file: " + string);
            }
            catch (IOException iOException) {
                throw new IOException("ERROR: IOException opening ZIP file: " + string);
            }
        }
        return outputStream2;
    }
}

