/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import net.alomax.io.DirectoryFilter;

public class DirectoryLister {
    private DirectoryLister() {
    }

    public static String[] getDirectoryList(Reader reader, String[] stringArray, boolean bl) {
        Object[] objectArray;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        Vector<String> vector = new Vector<String>();
        try {
            while ((objectArray = lineNumberReader.readLine()) != null) {
                String string;
                String string2;
                int n = objectArray.toUpperCase().indexOf("<A HREF=");
                if (n <= 0 || (n = (string2 = objectArray.substring(n + 9)).indexOf("\"")) < 0 || (string = string2.substring(0, n)).startsWith("/")) continue;
                if (stringArray != null) {
                    int n2 = 0;
                    for (n2 = 0; n2 < stringArray.length && !string.endsWith(stringArray[n2]); ++n2) {
                    }
                    if (n2 < stringArray.length) continue;
                }
                if (bl && !string.endsWith("/")) continue;
                vector.addElement(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("ERROR: Getting directory list:" + iOException);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getDirectoryList(String string, String[] stringArray, boolean bl) throws IOException {
        String[] stringArray2 = new String[]{};
        Reader reader = null;
        try {
            URL uRL = new URL(string);
            reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String[] stringArray3 = stringArray2 = DirectoryLister.getDirectoryList(reader, stringArray, bl);
            return stringArray3;
        }
        catch (IOException iOException) {
            File file = null;
            try {
                file = new File(string);
            }
            catch (Exception exception) {
                throw new IOException(iOException.getMessage() + ": " + exception.getMessage());
            }
            if (!file.exists()) {
                throw new IOException("ERROR: Directory does not exits: " + string);
            }
            try {
                if (bl) {
                    String[] stringArray4 = file.list(new DirectoryFilter());
                    return stringArray4;
                }
                String[] stringArray5 = file.list();
                return stringArray5;
            }
            catch (Exception exception) {
                throw new IOException(iOException.getMessage() + ": " + exception.getMessage());
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            reader = null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java DirectoryLister pathname");
            System.exit(-1);
        }
        String string = null;
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{};
        try {
            stringArray3 = DirectoryLister.getDirectoryList(string, stringArray2, true);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        System.out.println("\nSub-directory listing of: " + string);
        for (int i = 0; i < stringArray3.length; ++i) {
            System.out.println(stringArray3[i]);
        }
        stringArray2 = new String[]{};
        stringArray3 = new String[]{};
        try {
            stringArray3 = DirectoryLister.getDirectoryList(string, stringArray2, false);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        System.out.println("\nDirectory listing of: " + string);
        for (int i = 0; i < stringArray3.length; ++i) {
            System.out.println(stringArray3[i]);
        }
    }
}

