/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import net.alomax.graphics2d.objects.CircleDataMarker;
import net.alomax.graphics2d.objects.DataMarker;
import net.alomax.graphics2d.objects.SquareDataMarker;

public abstract class JGraphPanel
extends JPanel
implements MouseMotionListener {
    public static final DataMarker FILLED_SQUARE = new SquareDataMarker(10, true, Color.RED);
    public static final DataMarker FILLED_CIRCLE = new CircleDataMarker(10, true, Color.RED);
    protected boolean displayCursorPosition = false;

    public final void setDisplayCursorPosition(boolean bl) {
        this.displayCursorPosition = bl;
        if (bl) {
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseMotionListener(this);
        }
    }

    public abstract double getXMinimum();

    public abstract double getXMaximum();

    public abstract double getYMinimum();

    public abstract double getYMaximum();

    public abstract Point dataToScreen(double var1, double var3);

    public abstract Point2D.Double screenToData(Point var1);

    public abstract String dataToString(Point2D.Double var1);

    public void mouseDragged(MouseEvent mouseEvent) {
        this.setToolTipText(null);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.displayCursorPosition) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        String string = "";
        try {
            Point2D.Double double_ = this.screenToData(point);
            if (double_.x >= this.getXMinimum() && double_.x <= this.getXMaximum() && double_.y >= this.getYMinimum() && double_.y <= this.getYMaximum()) {
                double_ = this.screenToData(point);
                string = this.dataToString(double_);
                this.setToolTipText(string);
            } else {
                this.setToolTipText(null);
            }
        }
        catch (Exception exception) {
            this.setToolTipText(null);
        }
    }
}

