/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import java.awt.Color;
import java.awt.Graphics;
import net.alomax.graphics2d.Axes;
import net.alomax.util.NumberFormat;
import net.alomax.util.TimeInstant;
import net.alomax.util.TimeInstantConverter;

public class AxesHorizTime
extends Axes {
    public TimeInstantConverter timeInstConv;
    public String timeString;
    public String axisLabel;
    public Color axisColor;
    public Color timeStringColor;
    public Color channelIdColor;
    public Color backgroundColor = null;
    public static final int INC_SUB_SEC = 0;
    public static final int INC_SEC = 1;
    public static final int INC_MIN = 2;
    public static final int INC_HOUR = 3;
    public static final int INC_DAY = 4;
    public int incrementUnits;
    public double incementSize;

    public AxesHorizTime(TimeInstantConverter timeInstantConverter, int n, int n2, double d, double d2, String string, String string2, String string3, int n3, int n4, Color color) {
        super(n, n2, d, d2, string, n3, n4);
        this.timeInstConv = timeInstantConverter;
        this.timeString = string2;
        this.axisLabel = string3;
        this.tickSpace = this.getTickSpace(d, d2, 3.0);
        this.tickStart = this.getTickStart(d, this.tickSpace);
        this.backgroundColor = color;
    }

    public double getTickSpace(double d, double d2, double d3) {
        double d4 = d2 - d;
        if ((d4 *= 1.01) < (double)1.4E-45f) {
            d4 = 1.4E-45f;
        }
        if (d4 / 86400.0 > (double)((int)d3)) {
            this.incrementUnits = 4;
            this.incementSize = 86400.0;
        } else if (d4 / 3600.0 > (double)((int)d3)) {
            this.incrementUnits = 3;
            this.incementSize = 3600.0;
        } else if (d4 / 60.0 > (double)((int)d3)) {
            this.incrementUnits = 2;
            this.incementSize = 60.0;
        } else if (d4 > 0.5) {
            this.incrementUnits = 1;
            this.incementSize = 1.0;
        } else {
            this.incrementUnits = 0;
            this.incementSize = 1.0;
        }
        double d5 = super.getTickSpace(0.0, (d2 - d) / this.incementSize, d3);
        return d5 * this.incementSize;
    }

    public double getTickStart(double d, double d2) {
        double d3;
        double d4;
        double d5 = d2 / this.incementSize;
        TimeInstant timeInstant = this.timeInstConv.refTimeToTimeInstant(d);
        if (this.incrementUnits == 4) {
            d4 = (double)timeInstant.getDoY() % d5;
            d3 = d - d4 * 86400.0 - (double)timeInstant.getHours() * 3600.0 - (double)timeInstant.getMinutes() * 60.0 - timeInstant.getSeconds();
        } else if (this.incrementUnits == 3) {
            d4 = (double)timeInstant.getHours() % d5;
            d3 = d - d4 * 3600.0 - (double)timeInstant.getMinutes() * 60.0 - timeInstant.getSeconds();
        } else if (this.incrementUnits == 2) {
            d4 = (double)timeInstant.getMinutes() % d5;
            d3 = d - d4 * 60.0 - timeInstant.getSeconds();
        } else {
            d4 = timeInstant.getSeconds() % d2;
            d3 = d - d4;
        }
        while (d3 < d) {
            d3 += d2;
        }
        return d3;
    }

    public void paint(Graphics graphics, Color color, Color color2, Color color3) {
        this.paint(graphics, color, color2, color3, true, true);
    }

    public void paint(Graphics graphics, Color color, Color color2, Color color3, boolean bl, boolean bl2) {
        this.timeStringColor = color2;
        this.channelIdColor = color3;
        this.axisColor = color;
        AxesHorizTime.setFontSizes(graphics);
        int n = AxesHorizTime.getTickLength(this.iMin, this.iMax);
        this.drawAxisTitle(graphics);
        if (bl) {
            graphics.setColor(this.axisColor);
            this.drawAxes(graphics, n, 2, false);
            graphics.drawLine(this.iMin, this.iPosMin, this.iMax, this.iPosMin);
            graphics.drawLine(this.iMin, this.iPosMin, this.iMin, this.iPosMin - n);
        }
        if (bl2) {
            graphics.setColor(this.axisColor);
            this.drawAxes(graphics, n, 0, true);
            graphics.drawLine(this.iMin, this.iPosMax, this.iMax, this.iPosMax);
        }
    }

    public void drawAxes(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (n2 == 0) {
            n5 = this.iPosMax;
            n6 = this.iPosMax - n;
            d = this.valMin;
            d2 = this.valMax;
        } else if (n2 == 2) {
            n5 = this.iPosMin;
            n6 = this.iPosMin + n;
            d = this.valMin;
            d2 = this.valMax;
        }
        int n7 = 0;
        for (double d3 = this.tickStart; n7++ < 1000 && d3 <= d2; d3 += this.tickSpace) {
            n3 = n4 = this.iMin + (int)(0.5 + (d3 - d) * this.scale);
            graphics.drawLine(n3, n5, n4, n6);
            if (!bl) continue;
            this.drawTickLabel(graphics, d3, n3, n5, n2);
        }
    }

    public void drawTickLabel(Graphics graphics, double d, int n, int n2, int n3) {
        TimeInstant timeInstant = this.timeInstConv.refTimeToTimeInstant(d);
        String string = this.incrementUnits == 4 ? new String(timeInstant.getYear() + " (" + timeInstant.getDoY() + ")") : (this.incrementUnits == 3 ? new String("(" + timeInstant.getDoY() + ") " + NumberFormat.intString(timeInstant.getHours(), 2) + "h") : (this.incrementUnits == 2 ? new String(NumberFormat.intString(timeInstant.getHours(), 2) + "h" + NumberFormat.intString(timeInstant.getMinutes(), 2) + "m") : (this.incrementUnits == 1 ? new String(NumberFormat.intString(timeInstant.getMinutes(), 2) + "m" + String.valueOf((float)timeInstant.getSeconds()) + "s") : new String(String.valueOf((float)timeInstant.getSeconds()) + "s"))));
        int n4 = fontMetrics.stringWidth(string);
        if (n3 == 0) {
            graphics.drawString(string, n - n4 / 2, n2 + 2 * iCharHeight / 2);
        } else if (n3 == 2) {
            graphics.drawString(string, n - n4 / 2, n2 - iCharHeight / 4);
        }
    }

    public void drawAxisTitle(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(this.iMin, 0, this.iMax - this.iMin, iCharHeight);
        graphics.setColor(this.timeStringColor);
        graphics.drawString(this.timeString, this.iMin + iCharWidth, iCharAscent);
        graphics.setColor(this.channelIdColor);
        int n = fontMetrics.stringWidth(this.axisLabel);
        graphics.drawString(this.axisLabel, this.iMax - n, iCharAscent);
    }
}

