/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.earthworm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import net.alomax.earthworm.Util;
import net.alomax.earthworm.WSPacket;
import net.alomax.earthworm.WSSiteChanNet;
import net.alomax.earthworm.WaveserverException;
import net.alomax.util.StringExt;
import nl.knmi.orfeus.seedlink.SLLog;

public class WaveserverConnection {
    public static final String WAVESERVER_PROTOCOL_PREFIX = "waveserver://";
    protected static final int DFT_READBUF_SIZE = 1024;
    protected String wsaddr = null;
    protected int keepalive = 0;
    protected int netto = 120;
    protected int netdly = 30;
    protected SLLog sllog = null;
    protected String infoString = "";
    protected String statefile = null;
    protected double fillValue = 0.0;
    protected Vector streams = new Vector();
    protected boolean terminateFlag = false;
    protected String server_id = null;
    protected int request_id_num = 0;
    protected String infoRequestString = null;
    protected Socket socket = null;
    protected InputStream socketInputStream = null;
    protected OutputStream socketOutputStream = null;

    public WaveserverConnection(SLLog sLLog) {
        this.sllog = sLLog != null ? sLLog : new SLLog();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public void setLog(SLLog sLLog) {
        if (sLLog != null) {
            this.sllog = sLLog;
        }
    }

    public SLLog getLog() {
        return this.sllog;
    }

    public void setNetTimout(int n) {
        this.netto = n;
    }

    public int getNetTimout() {
        return this.netto;
    }

    public void setKeepAlive(int n) {
        this.keepalive = n;
    }

    public int getKeepAlive() {
        return this.keepalive;
    }

    public void setNetDelay(int n) {
        this.netdly = n;
    }

    public int getNetDelay() {
        return this.netdly;
    }

    public void setWSAddress(String string) {
        if (string.startsWith(WAVESERVER_PROTOCOL_PREFIX)) {
            string = string.substring(WAVESERVER_PROTOCOL_PREFIX.length());
        }
        this.wsaddr = string;
    }

    public void terminate() {
        this.terminateFlag = true;
    }

    public String getWSAddress() {
        return this.wsaddr;
    }

    protected boolean checkwscd() {
        boolean bl = true;
        if (this.streams.size() < 1 && this.infoRequestString == null) {
            this.sllog.log(true, 0, "[" + this.wsaddr + "] stream chain AND info type are empty");
            bl = false;
        }
        int n = 0;
        if (this.wsaddr == null) {
            this.sllog.log(false, 1, "[" + this.wsaddr + "] [" + this.wsaddr + "] server address is empty");
            bl = false;
        } else {
            n = this.wsaddr.indexOf(58);
            if (n < 1 || this.wsaddr.length() < n + 2) {
                this.sllog.log(true, 0, "[" + this.wsaddr + "] host address: [" + this.wsaddr + "] is not in `[hostname]:port' format");
                bl = false;
            }
        }
        return bl;
    }

    public void connect() throws WaveserverException, IOException {
        try {
            String string = this.wsaddr.substring(0, this.wsaddr.indexOf(58));
            int n = Integer.parseInt(this.wsaddr.substring(this.wsaddr.indexOf(58) + 1));
            Socket socket = new Socket();
            socket.setReceiveBufferSize(65536);
            socket.setReuseAddress(true);
            socket.setKeepAlive(true);
            int n2 = 10;
            int n3 = 3;
            while (n3-- > 0) {
                socket.connect(new InetSocketAddress(string, n));
                int n4 = 0;
                while (n4++ < n2 && !socket.isConnected()) {
                    Util.sleep(1000L);
                }
                if (socket.isConnected()) break;
                String string2 = "[" + this.wsaddr + "] socket connect time-out (" + n2 + "s)";
                if (n3 > 0) {
                    this.sllog.log(false, 0, string2);
                    continue;
                }
                throw new WaveserverException(string2);
            }
            this.sllog.log(false, 1, "[" + this.wsaddr + "] network socket opened");
            socket.setKeepAlive(true);
            this.socket = socket;
            this.socketInputStream = this.socket.getInputStream();
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            throw new WaveserverException("[" + this.wsaddr + "] cannot connect to Waveserver: " + exception);
        }
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.sllog.log(true, 1, "[" + this.wsaddr + "] network socket close failed: " + iOException);
            }
            this.socket = null;
            this.sllog.log(false, 1, "[" + this.wsaddr + "] network socket closed");
        }
    }

    public void close() {
        this.sllog.log(false, 1, "[" + this.wsaddr + "] closing WaveserverConnection()");
        this.disconnect();
    }

    public byte[] sendRequest(String string, String string2, String string3, int n) throws WaveserverException {
        ++this.request_id_num;
        String string4 = string + " " + this.request_id_num + " " + string2;
        byte[] byArray = new String(string4 + " \n").getBytes();
        this.sllog.log(false, n, "[" + string3 + "] sending request: \"" + string4 + "\"");
        try {
            if (!this.isConnected()) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            throw new WaveserverException("[" + string3 + "] " + iOException + ": reconnecting before sending '" + string4 + "'");
        }
        try {
            this.socketOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            this.disconnect();
            throw new WaveserverException("[" + string3 + "] " + iOException + ": sending '" + string4 + "'");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this.receiveData(string3);
        }
        catch (IOException iOException) {
            this.disconnect();
            throw new WaveserverException("[" + string3 + "] " + iOException + ": receiving '" + string4 + "'");
        }
        if (byArray2 == null) {
            throw new WaveserverException("[" + string3 + "] no response or bad response to '" + string4 + "'");
        }
        return byArray2;
    }

    public byte[] receiveData(String string) throws WaveserverException, IOException {
        byte[] byArray;
        int n;
        byte[] byArray2 = new byte[1024];
        int n2 = 0;
        int n3 = 50;
        int n4 = 30000;
        if (!this.isConnected()) {
            this.connect();
        }
        int n5 = 0;
        try {
            while (true) {
                if (this.socketInputStream.available() > 0) {
                    n = this.socketInputStream.read();
                    if (n >= 0) {
                        byArray2[n5++] = (byte)n;
                        if (n5 == byArray2.length) {
                            byArray = new byte[2 * byArray2.length];
                            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                            byArray2 = byArray;
                        }
                        if (n != 10) continue;
                    }
                    break;
                }
                if (n2 > n4) {
                    return null;
                }
                Util.sleep(n3);
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
        if (n == -1) {
            this.sllog.log(true, 1, "[" + string + "] socket.read(): " + n5 + ": TCP FIN or EOF received");
        }
        if (n5 <= 0) {
            return new byte[0];
        }
        byArray = new byte[n5];
        System.arraycopy(byArray2, 0, byArray, 0, n5);
        return byArray;
    }

    public byte[] receiveData(int n, String string) throws WaveserverException, IOException {
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[4140];
        int n2 = 0;
        int n3 = 50;
        int n4 = 30000;
        if (!this.isConnected()) {
            this.connect();
        }
        int n5 = 0;
        try {
            while (n5 < n) {
                if (this.socketInputStream.available() > 0) {
                    if (n - n5 < byArray2.length) {
                        byArray2 = new byte[n - n5];
                    }
                    int n6 = this.socketInputStream.read(byArray2);
                    System.arraycopy(byArray2, 0, byArray, n5, n6);
                    n5 += n6;
                    continue;
                }
                if (n2 > n4) {
                    return null;
                }
                Util.sleep(n3);
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
        if (n5 == -1) {
            this.sllog.log(true, 1, "[" + string + "] socket.read(): " + n5 + ": TCP FIN or EOF received");
            return null;
        }
        if (n5 == 0) {
            return new byte[0];
        }
        return byArray;
    }

    public WSPacket sendRequest_MENU(int n) throws WaveserverException {
        String string = "MENU:";
        String string2 = "";
        byte[] byArray = null;
        byArray = this.sendRequest(string, string2, this.wsaddr, n);
        return new WSPacket(byArray, 0);
    }

    public WSPacket sendRequest_MENUSCN(WSSiteChanNet wSSiteChanNet, int n) throws WaveserverException {
        String string = "MENUSCN:";
        String string2 = wSSiteChanNet.toSCNString();
        byte[] byArray = null;
        byArray = this.sendRequest(string, string2, this.wsaddr, n);
        return new WSPacket(byArray, 2);
    }

    public WSPacket sendRequest_GETSCNRAW(WSSiteChanNet wSSiteChanNet, int n) throws WaveserverException {
        String string = "GETSCNRAW:";
        String string2 = wSSiteChanNet.toSCNStartStopString();
        byte[] byArray = null;
        byArray = this.sendRequest(string, string2, this.wsaddr, n);
        WSPacket wSPacket = new WSPacket(byArray, 5);
        int n2 = wSPacket.scnList[0].numBytesData;
        byte[] byArray2 = null;
        if (n2 > 0) {
            try {
                byArray2 = this.receiveData(n2, this.wsaddr);
            }
            catch (IOException iOException) {
                this.disconnect();
                throw new WaveserverException("[" + this.wsaddr + "] " + iOException + ": receiving GETSCNRAW data bytes");
            }
            if (byArray2 == null) {
                throw new WaveserverException("[" + this.wsaddr + "] no response or bad response reveiving data for " + wSSiteChanNet);
            }
        }
        wSPacket.reply_data = byArray2;
        return wSPacket;
    }

    public WSPacket sendRequest_GETSCN(WSSiteChanNet wSSiteChanNet, int n) throws WaveserverException {
        String string = "GETSCN:";
        String string2 = wSSiteChanNet.toSCNStartStopString();
        string2 = string2 + " " + this.fillValue;
        byte[] byArray = null;
        byArray = this.sendRequest(string, string2, this.wsaddr, n);
        WSPacket wSPacket = new WSPacket(byArray, 4);
        return wSPacket;
    }

    public WSSiteChanNet[] parseStreamlist(String string) throws WaveserverException {
        WSSiteChanNet[] wSSiteChanNetArray = null;
        if (string.indexOf(42) >= 0) {
            return this.getAllStreams();
        }
        String[] stringArray = StringExt.parse(string, ",");
        if (stringArray != null && stringArray.length > 0) {
            wSSiteChanNetArray = new WSSiteChanNet[stringArray.length];
            WSSiteChanNet[] wSSiteChanNetArray2 = this.getAllStreams();
            block0: for (int i = 0; i < stringArray.length; ++i) {
                WSSiteChanNet wSSiteChanNet = WSSiteChanNet.createFromSCN(stringArray[i]);
                for (int j = 0; j < wSSiteChanNetArray2.length; ++j) {
                    if (!wSSiteChanNet.equals(wSSiteChanNetArray2[j])) continue;
                    wSSiteChanNetArray[i] = new WSSiteChanNet(wSSiteChanNetArray2[j]);
                    continue block0;
                }
            }
        }
        if (wSSiteChanNetArray == null || wSSiteChanNetArray.length == 0) {
            this.sllog.log(true, 0, "[" + this.wsaddr + "] no streams defined in stream list");
        } else if (wSSiteChanNetArray.length > 0) {
            this.sllog.log(false, 2, "parsed " + wSSiteChanNetArray.length + " streams from stream list");
        }
        return wSSiteChanNetArray;
    }

    public WSSiteChanNet[] getAllStreams() throws WaveserverException {
        WSPacket wSPacket = this.sendRequest_MENU(0);
        this.sllog.log(false, 0, "[" + this.wsaddr + "] response: " + wSPacket.toString());
        return wSPacket.scnList;
    }
}

