/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Assert;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import java.io.Serializable;

public class SlownessLayer
implements Serializable,
Cloneable {
    public double topP;
    public double botP;
    public double topDepth;
    public double botDepth;

    public SlownessLayer(double d, double d2, double d3, double d4) {
        Assert.isFalse(d2 > d4, "topDepth > botDepth: " + d2 + " > " + d4);
        Assert.isFalse(d2 < 0.0 || Double.isNaN(d2) || Double.isInfinite(d2), "topDepth is not a number or is negative: " + d2);
        Assert.isFalse(d4 < 0.0 || Double.isNaN(d4) || Double.isInfinite(d4), "botDepth is not a number or is negative: " + d4);
        this.topP = d;
        this.topDepth = d2;
        this.botP = d3;
        this.botDepth = d4;
    }

    public SlownessLayer(VelocityLayer velocityLayer, boolean bl, double d, boolean bl2) {
        Assert.isFalse(velocityLayer.topDepth > velocityLayer.botDepth, "vLayer.topDepth > vLayer.botDepth :" + velocityLayer.topDepth + " " + velocityLayer.botDepth);
        this.topDepth = velocityLayer.topDepth;
        this.botDepth = velocityLayer.botDepth;
        char c = bl2 ? (char)'P' : 'S';
        try {
            if (bl) {
                this.topP = (d - this.topDepth) / velocityLayer.evaluateAtTop(c);
                this.botP = (d - this.botDepth) / velocityLayer.evaluateAtBottom(c);
            } else {
                this.topP = 1.0 / velocityLayer.evaluateAtTop(c);
                this.botP = 1.0 / velocityLayer.evaluateAtBottom(c);
            }
            Assert.isFalse(Double.isNaN(this.topP) || Double.isNaN(this.botP), "Slowness sample is NaN: topP=" + this.topP + " botP=" + this.botP);
        }
        catch (NoSuchMatPropException noSuchMatPropException) {
            noSuchMatPropException.printStackTrace();
        }
    }

    public SlownessLayer(VelocityLayer velocityLayer, boolean bl, double d) {
        this(velocityLayer, true, d, bl);
    }

    public SlownessLayer(VelocityLayer velocityLayer, boolean bl) {
        this(velocityLayer, false, 0.0, bl);
    }

    public boolean isZeroThickness() {
        return this.topDepth == this.botDepth;
    }

    public double evaluateAt_bullen(double d, double d2) throws SlownessModelException {
        Assert.isFalse(this.botDepth > d2, "SlownessLayer.evaluateAt_bullen: radiusOfEarth=" + d2 + " is smaller than the maximum depth of this layer." + " topDepth=" + this.topDepth + " botDepth=" + this.botDepth);
        Assert.isFalse((this.topDepth - d) * (d - this.botDepth) < 0.0, "SlownessLayer.evaluateAt_bullen: depth=" + d + " is not contained within this layer." + " topDepth=" + this.topDepth + " botDepth=" + this.botDepth);
        if (d == this.topDepth) {
            return this.topP;
        }
        if (d == this.botDepth) {
            return this.botP;
        }
        double d3 = Math.log(this.topP / this.botP) / Math.log((d2 - this.topDepth) / (d2 - this.botDepth));
        double d4 = this.topP / Math.pow(d2 - this.topDepth, d3);
        double d5 = d4 * Math.pow(d2 - d, d3);
        if (d5 < 0.0 || Double.isNaN(d5) || Double.isInfinite(d5)) {
            double d6;
            if (this.botDepth - this.topDepth < 2.0 && !((d6 = (this.botP - this.topP) / (this.botDepth - this.topDepth) * (d - this.topDepth) + this.topP) < 0.0) && !Double.isNaN(d6) && !Double.isInfinite(d6)) {
                return d6;
            }
            throw new SlownessModelException("calculated slowness is not a number or is negative: " + d5 + "\n" + this.toString() + "\n A=" + d4 + "   B=" + d3);
        }
        return d5;
    }

    public TimeDist bullenRadialSlowness(double d, double d2) throws SlownessModelException {
        TimeDist timeDist = new TimeDist(d);
        if (this.topDepth == this.botDepth) {
            timeDist.dist = 0.0;
            timeDist.time = 0.0;
            return timeDist;
        }
        if (this.botDepth - this.topDepth < 1.0E-9) {
            return timeDist;
        }
        double d3 = Math.log(this.topP / this.botP) / Math.log((d2 - this.topDepth) / (d2 - this.botDepth));
        double d4 = Math.sqrt(this.topP * this.topP - d * d);
        double d5 = Math.sqrt(this.botP * this.botP - d * d);
        timeDist.dist = 1.0 / d3 * (Math.atan2(d, d5) - Math.atan2(d, d4));
        timeDist.time = 1.0 / d3 * (d4 - d5);
        if (timeDist.dist < 0.0 || timeDist.time < 0.0 || Double.isNaN(timeDist.time) || Double.isNaN(timeDist.dist)) {
            throw new SlownessModelException("timedist <0.0 or NaN: \n RayParam= " + d + "\n topDepth = " + this.topDepth + "\n botDepth = " + this.botDepth + "\n dist=" + timeDist.dist + "\n time=" + timeDist.time + "\n topP = " + this.topP + "\n botP = " + this.botP + "\n B = " + d3 + " " + this.toString());
        }
        return timeDist;
    }

    public double bullenDepthFor(double d, double d2) throws SlownessModelException {
        if ((this.topP - d) * (d - this.botP) >= 0.0) {
            if (this.topDepth == this.botDepth) {
                return this.botDepth;
            }
            if (this.botP != 0.0 && this.botDepth != d2) {
                double d3;
                double d4 = Math.log(this.topP / this.botP) / Math.log((d2 - this.topDepth) / (d2 - this.botDepth));
                double d5 = d2 - Math.exp(1.0 / d4 * Math.log(d / (d3 = this.topP / Math.pow(d2 - this.topDepth, d4))));
                if (d5 < 0.0 || Double.isNaN(d5) || Double.isInfinite(d5) || d5 < this.topDepth || d5 > this.botDepth) {
                    double d6;
                    if (this.botDepth - this.topDepth < 5.0 && !((d6 = (this.botDepth - this.topDepth) / (this.botP - this.topP) * (d - this.topP) + this.topDepth) < 0.0) && !Double.isNaN(d6) && !Double.isInfinite(d6)) {
                        return d6;
                    }
                    throw new SlownessModelException("claculated depth is not a number or is negative: " + d5 + "\n" + this + "\n" + d3 + "  " + d4 + "\n" + d);
                }
                if (d5 < this.topDepth && this.topDepth - d5 < 1.0E-10) {
                    return this.topDepth;
                }
                if (d5 > this.botDepth && d5 - this.botDepth < 1.0E-10) {
                    return this.botDepth;
                }
                return d5;
            }
            if (this.topP != this.botP) {
                return this.botDepth + (d - this.botP) * (this.topDepth - this.botDepth) / (this.topP - this.botP);
            }
            return this.botDepth;
        }
        throw new SlownessModelException("Ray parameter = " + d + " is not contained within this slowness layer. topP=" + this.topP + " botP=" + this.botP);
    }

    public Object clone() {
        try {
            SlownessLayer slownessLayer = (SlownessLayer)super.clone();
            return slownessLayer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Caught CloneNotSupportedException: " + cloneNotSupportedException.getMessage());
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        String string = "top p " + this.topP + ", topDepth " + this.topDepth + ", bot p " + this.botP + ", botDepth " + this.botDepth;
        return string;
    }

    public boolean validate() throws SlownessModelException {
        if (Double.isNaN(this.topP) || Double.isNaN(this.topDepth) || Double.isNaN(this.botP) || Double.isNaN(this.botDepth)) {
            throw new SlownessModelException("Slowness layer has NaN values.\n " + this);
        }
        if (this.topP < 0.0 || this.botP < 0.0) {
            throw new SlownessModelException("Slowness layer has negative slownesses. \n " + this);
        }
        if (this.topDepth > this.botDepth) {
            throw new SlownessModelException("Slowness layer has negative thickness. \n" + this);
        }
        return true;
    }
}

