/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Format;
import java.util.Properties;

public class Outputs {
    protected Format depthFormat;
    protected Format distanceFormat;
    protected Format timeFormat;
    protected Format rayParamFormat;
    protected Format latLonFormat;

    public Outputs(Properties properties) {
        String string = "%8." + properties.getProperty("taup.depth.precision", "1") + "f";
        this.depthFormat = new Format(string);
        string = "%8." + properties.getProperty("taup.distance.precision", "2") + "f";
        this.distanceFormat = new Format(string);
        string = "%8." + properties.getProperty("taup.time.precision", "2") + "f";
        this.timeFormat = new Format(string);
        string = "%8." + properties.getProperty("taup.rayparam.precision", "3") + "f";
        this.rayParamFormat = new Format(string);
        string = "%8." + properties.getProperty("taup.latlon.precision", "2") + "f";
        this.latLonFormat = new Format(string);
    }

    public String formatDepth(double d) {
        return this.depthFormat.form(d);
    }

    public String formatDistance(double d) {
        return this.distanceFormat.form(d);
    }

    public String formatTime(double d) {
        return this.timeFormat.form(d);
    }

    public String formatRayParam(double d) {
        return this.rayParamFormat.form(d);
    }

    public String formatLatLon(double d) {
        return this.latLonFormat.form(d);
    }
}

