/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.SeedException;

public class SeedBlocketteRankMap {
    public static int getHeaderCode(Blockette blockette) throws BuilderException, SeedException {
        String string = blockette.getCategory();
        if (string.equals("Volume Index")) {
            return 1;
        }
        if (string.equals("Abbreviation Dictionary")) {
            return 2;
        }
        if (string.equals("Station")) {
            return 3;
        }
        if (string.equals("Time Span")) {
            return 4;
        }
        if (string.equals("Data Record")) {
            return 5;
        }
        throw new BuilderException("Unknown blockette category: '" + string + "'");
    }

    public static int getRank(Blockette blockette) throws BuilderException, SeedException {
        int n = SeedBlocketteRankMap.getHeaderCode(blockette);
        int n2 = blockette.getType();
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                switch (n2) {
                    case 50: {
                        return 0;
                    }
                    case 51: {
                        return 1;
                    }
                    case 52: {
                        return 1;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: {
                        return 2;
                    }
                }
                throw new BuilderException("Blockette " + n2 + " unrecognized");
            }
            case 4: {
                return 0;
            }
            case 5: {
                switch (n2) {
                    case 999: {
                        return 0;
                    }
                    case 100: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 300: 
                    case 310: 
                    case 320: 
                    case 390: 
                    case 395: 
                    case 400: 
                    case 405: 
                    case 500: 
                    case 1000: 
                    case 1001: {
                        return 1;
                    }
                }
                throw new BuilderException("Blockette " + n2 + " unrecognized");
            }
        }
        throw new BuilderException("Blockette category " + n + " unrecognized");
    }
}

