/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.fields;

import JSci.maths.MathDouble;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class RealField
implements Field {
    public static final MathDouble ZERO = new MathDouble(0.0);
    public static final MathDouble ONE = new MathDouble(1.0);
    public static final MathDouble PI = new MathDouble(Math.PI);
    public static final MathDouble E = new MathDouble(Math.E);
    public static final MathDouble GAMMA = new MathDouble(0.5772156649015329);
    public static final MathDouble INFINITY = new MathDouble(Double.POSITIVE_INFINITY);
    public static final MathDouble NaN = new MathDouble(Double.NaN);
    private static final RealField _instance = new RealField();

    private RealField() {
    }

    public static final RealField getInstance() {
        return _instance;
    }

    public AbelianGroup.Member zero() {
        return ZERO;
    }

    public boolean isZero(AbelianGroup.Member member) {
        return ZERO.equals(member);
    }

    public boolean isNegative(AbelianGroup.Member member, AbelianGroup.Member member2) {
        return ZERO.equals(member.add(member2));
    }

    public Ring.Member one() {
        return ONE;
    }

    public boolean isOne(Ring.Member member) {
        return ONE.equals(member);
    }

    public boolean isInverse(Field.Member member, Field.Member member2) {
        return ONE.equals(member.multiply(member2));
    }
}

