
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class WishlistItem(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getWishlistItem(self,wishlistId, wishlistItemId, responseFields = None):
		""" Retrieves the details of an item in a shopper wish list.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
			| wishlistItemId (string) - Unique identifier of the item to remove from the shopper wish list.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items/{wishlistItemId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistId", wishlistId);
		url.formatUrl("wishlistItemId", wishlistItemId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getWishlistItems(self,wishlistId, startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves a list of items in a shopper wish list according to any specified filter and sort criteria.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistItemCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		url.formatUrl("wishlistId", wishlistId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getWishlistItemsByWishlistName(self,customerAccountId, wishlistName, startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieve a list of items in a customer wish list by supplying the wish list name.
		
		Args:
			| customerAccountId (int) - The unique identifier of the customer account for which to retrieve wish lists.
			| wishlistName (string) - The name of the wish list to retrieve.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistItemCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/customers/{customerAccountId}/{wishlistName}/items?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("customerAccountId", customerAccountId);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		url.formatUrl("wishlistName", wishlistName);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addItemToWishlist(self,wishlistItem, wishlistId, responseFields = None):
		""" Adds a product in a site's catalog as an item in a shopper wish list.
		
		Args:
			| wishlistItem(wishlistItem) - Properties of an item in a shopper wish list.
			| wishlistId (string) - Unique identifier of the wish list.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistId", wishlistId);
		self.client.withResourceUrl(url).withBody(wishlistItem).execute();
		return self.client.result();

	
		
	def updateWishlistItemQuantity(self,wishlistId, wishlistItemId, quantity, responseFields = None):
		""" Updates the quantity of an item in a shopper wish list.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
			| wishlistItemId (string) - Unique identifier of the item to remove from the shopper wish list.
			| quantity (int) - The number of cart items in the shopper's active cart.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items/{wishlistItemId}/{quantity}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("quantity", quantity);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistId", wishlistId);
		url.formatUrl("wishlistItemId", wishlistItemId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateWishlistItem(self,wishlistItem, wishlistId, wishlistItemId, responseFields = None):
		""" Updates the details of an item in a shopper wish list.
		
		Args:
			| wishlistItem(wishlistItem) - Properties of an item in a shopper wish list.
			| wishlistId (string) - Unique identifier of the wish list.
			| wishlistItemId (string) - Unique identifier of the item to remove from the shopper wish list.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items/{wishlistItemId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistId", wishlistId);
		url.formatUrl("wishlistItemId", wishlistItemId);
		self.client.withResourceUrl(url).withBody(wishlistItem).execute();
		return self.client.result();

	
		
	def removeAllWishlistItems(self,wishlistId):
		""" Removes all items associated with a shopper wish list.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
		
		Returns:
			| Wishlist 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("wishlistId", wishlistId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def deleteWishlistItem(self,wishlistId, wishlistItemId):
		""" Removes an item from the wish list specified in the request.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
			| wishlistItemId (string) - Unique identifier of the item to remove from the shopper wish list.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}/items/{wishlistItemId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("wishlistId", wishlistId);
		url.formatUrl("wishlistItemId", wishlistItemId);
		self.client.withResourceUrl(url).execute();

	
	
	