
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Wishlist(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getWishlists(self,startIndex = None, pageSize = None, sortBy = None, filter = None, q = None, qLimit = None, responseFields = None):
		""" Retrieves a list of shopper wish lists according to any filter and sort criteria.
		
		Args:
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| q (string) - A list of order search terms (not phrases) to use in the query when searching across order number and the name or email of the billing contact. When entering, separate multiple search terms with a space character.
			| qLimit (int) - The maximum number of search results to return in the response. You can limit any range between 1-100.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| WishlistCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&q={q}&qLimit={qLimit}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("q", q);
		url.formatUrl("qLimit", qLimit);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getWishlist(self,wishlistId, responseFields = None):
		""" Retrieves the details of the shopper wish list specified in the request.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Wishlist 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistId", wishlistId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getWishlistByName(self,customerAccountId, wishlistName, responseFields = None):
		""" Retrieves the details of a wish list by supplying the wish list name.
		
		Args:
			| customerAccountId (int) - The unique identifier of the customer account for which to retrieve wish lists.
			| wishlistName (string) - The name of the wish list to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Wishlist 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/customers/{customerAccountId}/{wishlistName}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("customerAccountId", customerAccountId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistName", wishlistName);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createWishlist(self,wishlist, responseFields = None):
		""" Creates a new shopper wish list for the associated customer account. Although customer accounts are maintained at the tenant level, the system stores wish lists at the site level. Newly created wish lists do not have any items.
		
		Args:
			| wishlist(wishlist) - Properties of a shopper wish list defined for a site, associated with a customer account.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Wishlist 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(wishlist).execute();
		return self.client.result();

	
		
	def updateWishlist(self,wishlist, wishlistId, responseFields = None):
		""" Updates one or more properties of a shopper wish list defined for a customer account.
		
		Args:
			| wishlist(wishlist) - Properties of a shopper wish list defined for a site, associated with a customer account.
			| wishlistId (string) - Unique identifier of the wish list.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Wishlist 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("wishlistId", wishlistId);
		self.client.withResourceUrl(url).withBody(wishlist).execute();
		return self.client.result();

	
		
	def deleteWishlist(self,wishlistId):
		""" Deletes the shopper wish list specified in the request and all items associated with it.
		
		Args:
			| wishlistId (string) - Unique identifier of the wish list.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/wishlists/{wishlistId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("wishlistId", wishlistId);
		self.client.withResourceUrl(url).execute();

	
	
	