# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutoHealTriggers(Model):
    """
    AutoHealTriggers - describes the triggers for auto-heal.

    :param requests: Requests - Defines a rule based on total requests
    :type requests: :class:`RequestsBasedTrigger
     <azure.mgmt.web.models.RequestsBasedTrigger>`
    :param private_bytes_in_kb: PrivateBytesInKB - Defines a rule based on
     private bytes
    :type private_bytes_in_kb: int
    :param status_codes: StatusCodes - Defines a rule based on status codes
    :type status_codes: list of :class:`StatusCodesBasedTrigger
     <azure.mgmt.web.models.StatusCodesBasedTrigger>`
    :param slow_requests: SlowRequests - Defines a rule based on request
     execution time
    :type slow_requests: :class:`SlowRequestsBasedTrigger
     <azure.mgmt.web.models.SlowRequestsBasedTrigger>`
    """ 

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(self, requests=None, private_bytes_in_kb=None, status_codes=None, slow_requests=None):
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests
