"""
To run element tests:
$ python 3v.py --test
or
$ 3v --test


Regular cases
>>> ln('''                                      a[""]: n                               ''')
(['a[""]'], ':', ' ', 'n', [])
>>> ln('''                                      a[""]| n                               ''')
(['a[""]'], '|', ' ', 'n', [])
>>> ln('''                                      regular"[text                          ''')
(False, [])
>>> ln('''                                      a[]:                                   ''')
(['a[]'], ':', '', '', [])
>>> ln('''                                      a[]|                                   ''')
(['a[]'], '|', '', '', [])
>>> ln('''                                      a[""]:                                 ''')
(['a[""]'], ':', '', '', [])
>>> ln('''                                      a[""]|                                 ''')
(['a[""]'], '|', '', '', [])

Non-matching quoting mode and similar syntax
>>> ln('''                                      a["]|b: ]                              ''')
(False, [])
>>> ln('''                                      a["]'b: ]                              ''')
(False, [])
>>> ln('''                                      a["]:b: ]:                             ''')
(['a["]', 'b'], ':', ' ', ']:', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]: ]:                               ''')
(['a["]'], ':', ' ', ']:', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:: ]:                              ''')
(['a["]', ''], ':', ' ', ']:', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b: ]|                             ''')
(['a["]', 'b'], ':', ' ', ']|', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]|b: ]|                             ''')
(False, [])
>>> ln('''                                      a["]|b: ]:                             ''')
(['a["]|b: ]'], ':', '', '', ['NonMatchingQuoteInAttributeString', 'UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      a["]:a: "]:                            ''')
(['a["]:a: "]'], ':', '', '', [])
>>> ln('''                                      a["]: a"]:                             ''')
(['a["]: a"]'], ':', '', '', [])
>>> ln('''                                      a["]: "]: n                            ''')
(['a["]: "]'], ':', ' ', 'n', [])
>>> ln('''                                      a["]:a: " a]:                          ''')
(['a["]:a: " a]'], ':', '', '', [])
>>> ln('''                                      a["]: n"]                              ''')
(['a["]'], ':', ' ', 'n"]', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]: n"                               ''')
(['a["]'], ':', ' ', 'n"', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]: "n                               ''')
(['a["]'], ':', ' ', '"n', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]: n                                ''')
(['a["]'], ':', ' ', 'n', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:                                  ''')
(['a["]'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b[]:                              ''')
(['a["]', 'b[]'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b[[]:                             ''')
(['a["]', 'b[[]'], ':', '', '', ['NonMatchingQuoteInAttributeString', 'UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      a["]:a|a: a"]:                         ''')
(['a["]:a|a: a"]'], ':', '', '', [])
>>> ln('''                                      a:["]:b|b["]:                          ''')
(['a', '["]:b|b["]'], ':', '', '', [])
>>> ln('''                                      a:["]:c|c[c]:                          ''')
(['a', '["]', 'c|c[c]'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a|["]|b:b["]|                          ''')
(False, ['DefaultBwmElement'])
>>> ln('''                                      a|["]|c:c[c]|                          ''')
(False, ['DefaultBwmElement'])
>>> ln('''                                      a|["]|a:a["]:                          ''')
(['a|["]|a:a["]'], ':', '', '', [])
>>> ln('''                                      a["]|a:a["]:                           ''')
(['a["]|a:a["]'], ':', '', '', [])
>>> ln('''                                      a["]:a[a="[]:                          ''')
(['a["]:a[a="[]'], ':', '', '', ['UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      a["]:a[a="["]:                         ''')
(['a["]:a[a="["]'], ':', '', '', ['UnquotedSquareBracketInAttributeString', 'NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a[""]:b["["]:                          ''')
(['a[""]', 'b["["]'], ':', '', '', [])
>>> ln('''                                      a["[]:                                 ''')
(['a["[]'], ':', '', '', ['NonMatchingQuoteInAttributeString', 'UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      a["]:"a":                              ''')
(False, [])
>>> ln('''                                      a["]:b[]]:                             ''')
(['a["]', 'b[]]'], ':', '', '', ['NonMatchingQuoteInAttributeString', 'UnquotedSquareBracketInAttributeString'])

Mixed placement mark character in element name or attribute-string
>>> ln('''                                      a[a: a| a: a| a:]:                     ''')
(['a[a: a| a: a| a:]'], ':', '', '', [])
>>> ln('''                                      a|a:b:                                 ''')
(['a|a', 'b'], ':', '', '', [])
>>> ln('''                                      a:a|b|                                 ''')
(['a:a', 'b'], '|', '', '', [])

Expression notation
>>> ln('''                                      a[a]:b[b]:c[c]: abc                    ''')
(['a[a]', 'b[b]', 'c[c]'], ':', ' ', 'abc', [])

Matching quoting in attribute-string
>>> ln('''                                      a["["]:                                ''')
(['a["["]'], ':', '', '', [])
>>> ln('''                                      a["]:a["]:                             ''')
(['a["]:a["]'], ':', '', '', [])
>>> ln('''                                      a["]:"]:                               ''')
(['a["]:"]'], ':', '', '', [])
>>> ln('''                                      a["]"]:                                ''')
(['a["]"]'], ':', '', '', [])
>>> ln('''                                      a|b["]:"]|                             ''')
(['a', 'b["]:"]'], '|', '', '', [])
>>> ln('''                                      a:b["]|"]:                             ''')
(['a', 'b["]|"]'], ':', '', '', [])
>>> ln('''                                      a[""]: n"]:                            ''')
(['a[""]'], ':', ' ', 'n"]:', [])

Mixed matching quoting in attribute-string
>>> ln('''                                      a[""]:b['']:                           ''')
(['a[""]', "b['']"], ':', '', '', [])

>>> ln('''                                      a["''"]:                               ''')
(['a["\'\'"]'], ':', '', '', [])
>>> ln('''                                      a[""'']:                               ''')
(['a[""\'\']'], ':', '', '', [])
>>> ln('''                                      a[''""]:                               ''')
(['a[\'\'""]'], ':', '', '', [])
>>> ln('''                                      a["']:                                 ''')
(['a["\']'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["'"']:                               ''')
(['a["\'"\']'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["']:a["']:                           ''')
(['a["\']:a["\']'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b['']:                            ''')
(['a["]', "b['']"], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b['']:c:                          ''')
(['a["]', "b['']", 'c'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b[']:                             ''')
(['a["]', "b[']"], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:b[']:c:                           ''')
(['a["]', "b[']", 'c'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:a[']:a["]:                        ''')
(['a["]:a[\']:a["]'], ':', '', '', [])
>>> ln('''                                      a[""]:b[']:c["]:d[]//                  ''')
(['a[""]', "b[']", 'c["]'], ':', ['d[]'], '//', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a["]:'':                               ''')
(False, ['QuotedElementName'])
>>> ln('''                                      a["]:b'':                              ''')
(False, [])

Expression notation with matching quoting in attribute-string
>>> ln('''                                      a["]:"]:b:c:                           ''')
(['a["]:"]', 'b', 'c'], ':', '', '', [])
>>> ln('''                                      a["]:"]:b:c|                           ''')
(False, [])
>>> ln('''                                      a["]:b:c|                              ''')
(False, [])
>>> ln('''                                      a["]:b|c:                              ''')
(['a["]', 'b|c'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a|b["]:c|                              ''')
(False, [])
>>> ln('''                                      a|b["]:c:                              ''')
(['a|b["]', 'c'], ':', '', '', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a:b["]: c"]:                           ''')
(['a', 'b["]: c"]'], ':', '', '', [])
>>> ln('''                                      a:b["]: c"]                            ''')
(['a', 'b["]'], ':', ' ', 'c"]', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a:b["]|c: "]:                          ''')
(['a', 'b["]|c: "]'], ':', '', '', [])
>>> ln('''                                      a:b["]|c: "]|                          ''')
(['a:b["]|c: "]'], '|', '', '', [])
>>> ln('''                                      a:b:c["]: "n                           ''')
(['a', 'b', 'c["]'], ':', ' ', '"n', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a:b:c["]: "]: n                        ''')
(['a', 'b', 'c["]: "]'], ':', ' ', 'n', [])

Unquoted square bracket in attribute string
>>> ln('''                                      a[[]:                                  ''')
(['a[[]'], ':', '', '', ['UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      a[]]:                                  ''')
(['a[]]'], ':', '', '', ['UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      a[][]:                                 ''')
(['a[][]'], ':', '', '', ['UnquotedSquareBracketInAttributeString'])
>>> ln('''                                      []a[]:                                 ''')
(['[]a[]'], ':', '', '', ['UnquotedSquareBracketInAttributeString'])

Postfix
>>> ln('''                                      a[]_:                                  ''')
(['a[]_'], ':', '', '', [])
>>> ln('''                                      a[""]_:                                ''')
(['a[""]_'], ':', '', '', [])
>>> ln('''                                      a["]_:a["]:                            ''')
(['a["]_:a["]'], ':', '', '', [])
>>> ln('''                                      a[""]_:b[""]:                          ''')
(['a[""]_', 'b[""]'], ':', '', '', [])
>>> ln('''                                      a[""]_:b[""]_:                         ''')
(['a[""]_', 'b[""]_'], ':', '', '', [])


Self-closing element
>>> ln('''                                      a[]//                                  ''')
([], ':', ['a[]'], '//', [])
>>> ln('''                                      a[]_//                                 ''')
([], ':', ['a[]_'], '//', [])
>>> ln('''                                      a:a[]//                                ''')
(['a'], ':', ['a[]'], '//', [])
>>> ln('''                                      a|a[]//                                ''')
(['a'], '|', ['a[]'], '//', [])
>>> ln('''                                      a[]:b[]//                              ''')
(['a[]'], ':', ['b[]'], '//', [])
>>> ln('''                                      a[]|b[]//                              ''')
(['a[]'], '|', ['b[]'], '//', [])
>>> ln('''                                      a:a|b[]//                              ''')
(['a:a'], '|', ['b[]'], '//', [])
>>> ln('''                                      a|a:b[]//                              ''')
(['a|a'], ':', ['b[]'], '//', [])
>>> ln('''                                      a["]//                                 ''')
([], ':', ['a["]'], '//', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a:a["]//                               ''')
(['a'], ':', ['a["]'], '//', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a|a["]//                               ''')
(['a'], '|', ['a["]'], '//', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a:a|b["]//                             ''')
(['a:a'], '|', ['b["]'], '//', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a|a:b["]//                             ''')
(['a|a'], ':', ['b["]'], '//', ['NonMatchingQuoteInAttributeString'])
>>> ln('''                                      a:a|b["]|c//                           ''')
(False, [])
>>> ln('''                                      a|a:b["]:c//                           ''')
(False, [])
>>> ln('''                                      []//                                   ''')
(False, ['DefaultSelfClosingElement'])
>>> ln('''                                      :[]//                                  ''')
(False, ['DefaultSelfClosingElement'])

Default element notation and similar syntax
>>> ln('''                                      []:                                    ''')
(['[]'], ':', '', '', [])
>>> ln('''                                      []|                                    ''')
(False, ['DefaultBwmElement'])
>>> ln('''                                      :|                                     ''')
([':'], '|', '', '', [])
>>> ln('''                                      |:                                     ''')
(['|'], ':', '', '', [])
>>> ln('''                                      :|:                                    ''')
(['', '|'], ':', '', '', [])
>>> ln('''                                      |:|                                    ''')
(False, ['DefaultBwmElement'])

Default-to-content line
>>> ln('''         a[]         ''')
(False, [])
>>> ln('''         ]:          ''')
(False, [])
>>> ln('''         :]:          ''')
(False, [])
>>> ln('''         [:          ''')
(False, [])
>>> ln('''         :[:          ''')
(False, [])
>>> ln('''         ][:         ''')
(False, [])
>>> ln('''         :][:         ''')
(False, [])
>>> ln('''         a"=["]:     ''')
(False, [])
>>> ln('''         a]:         ''')
(False, [])
>>> ln('''         a[:         ''')
(False, [])
>>> ln('''         a :         ''')
(False, [])
>>> ln('''         a |         ''')
(False, [])
>>> ln('''         a "]:       ''')
(False, [])
>>> ln('''         a[]%%:      ''')
(False, [])
>>> ln('''         a[]b:       ''')
(False, [])
>>> ln('''         a["]%%:     ''')
(False, [])
>>> ln('''         a["]:b[]%%: ''')
(False, [])
>>> ln('''         a["[]%%:    ''')
(False, [])
>>> ln('''         a"":        ''')
(False, [])
>>> ln('''         a'':        ''')
(False, [])
>>> ln('''         a[]/b:c:    ''')
(False, [])
>>> ln('''         a[]/b|c|    ''')
(False, [])
>>> ln('''         a[]//b:c:   ''')
(False, [])
>>> ln('''         a[]//b|c|   ''')
(False, [])
>>> ln('''         a[]/b:c[]/: ''')
(False, [])
>>> ln('''         a[]/b|c[]/| ''')
(False, [])
>>> ln('''         a[]//b:c[]//: ''')
(False, [])
>>> ln('''         a[]//b|c[]//| ''')
(False, [])
>>> ln('''         _/          ''')
(False, [])
>>> ln('''         _//         ''')
(False, [])
>>> ln('''         a:_/        ''')
(False, [])
>>> ln('''         a|_//       ''')
(False, [])

Not implemented
>>> ln('''                                      "a":                                   ''')
(False, ['QuotedElementName'])

"""

"""
Prior to sortedDict, occasional occurrance:
"""
"""
Due to `for delim in prospectiveLineASTs`
    ln('''                                      a[]//                                  ''')
Expected:
    ([], ':', ['a[]'], '//', [])
Got:
    ([], '|', ['a[]'], '//', [])
"""
"""
Due to `for delim in prospectiveLineASTs`
    ln('''                                      a["]//                                 ''')
Expected:
    ([], ':', ['a["]'], '//', ['NonMatchingQuoteInAttributeString'])
Got:
    ([], '|', ['a["]'], '//', ['NonMatchingQuoteInAttributeString'])
"""
"""
Due to `byLargestLastSeenLikelyDelimIndex = sorted(prospectiveLineASTs.items() ...`) when comparison was -1 and -1`
    ln('''         :[]//       ''')
Expected:
    (False, [])
Got:
    ([], '|', [':[]'], '//', [])
"""
