/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedMethodResolver;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedPropertyAccessor;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedTypeLocator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ModelValidatorContext {
    private final StandardEvaluationContext spelContext;
    private SpELVariables spELVariables;

    public ModelValidatorContext(StandardEvaluationContext context) {
        this.spelContext = context;
    }

    private ModelValidatorContext(Map<String, Serializable> variablesValues) {
        this.spELVariables = new SpELVariables(variablesValues);
        this.spelContext = new StandardEvaluationContext((Object)this.spELVariables);
        this.spelContext.setTypeLocator((TypeLocator)new RestrictedTypeLocator());
        this.spelContext.setMethodResolvers(Collections.singletonList(new RestrictedMethodResolver()));
        this.spelContext.addPropertyAccessor((PropertyAccessor)new RestrictedPropertyAccessor());
    }

    public ModelValidatorContext(Task task) {
        this(task.getVariables().values().stream().collect(HashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll));
    }

    public ModelValidatorContext(TaskFlowJob job) {
        this(job.getVariables().values().stream().collect(HashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll));
    }

    public StandardEvaluationContext getSpELContext() {
        return this.spelContext;
    }

    public SpELVariables getSpELVariables() {
        return this.spELVariables;
    }

    public void updateJobWithContext(TaskFlowJob job) {
        for (JobVariable jobVariable : job.getVariables().values()) {
            jobVariable.setValue(this.spELVariables.getVariables().get(jobVariable.getName()).toString());
        }
    }

    public void updateTaskWithContext(Task task) {
        for (TaskVariable taskVariable : task.getVariables().values()) {
            taskVariable.setValue(this.spELVariables.getVariables().get(taskVariable.getName()).toString());
        }
    }

    public class SpELVariables {
        private Map<String, Serializable> variables;

        public SpELVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }

        public Map<String, Serializable> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }
    }
}

