/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskInfo;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.rest.data.DataUtility;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateData;

public class JobStateImpl
extends JobState {
    private static final long serialVersionUID = 1L;
    private JobStateData jobStateData;

    JobStateImpl(JobStateData d) {
        this.jobStateData = d;
        this.copyGenericInformation(this.jobStateData);
    }

    private void copyGenericInformation(JobStateData jobStateData) {
        super.setGenericInformation(jobStateData.getGenericInformation());
    }

    public Map<TaskId, TaskState> getHMTasks() {
        Map taskStateDataMap = this.jobStateData.getTasks();
        HashMap<TaskId, TaskState> taskStateMap = new HashMap<TaskId, TaskState>();
        for (TaskStateData taskStateData : taskStateDataMap.values()) {
            TaskIdData taskIdData = taskStateData.getTaskInfo().getTaskId();
            taskStateMap.put(DataUtility.taskId(DataUtility.jobId(this.jobStateData.getJobInfo().getJobId()), taskIdData), DataUtility.taskState(taskStateData));
        }
        return taskStateMap;
    }

    public JobInfo getJobInfo() {
        return DataUtility.toJobInfo(this.jobStateData.getJobInfo());
    }

    public String getOwner() {
        return this.jobStateData.getOwner();
    }

    public List<TaskState> getTasks() {
        Map taskStateMap = this.jobStateData.getTasks();
        ArrayList<TaskState> taskStateList = new ArrayList<TaskState>(taskStateMap.size());
        for (TaskStateData ts : taskStateMap.values()) {
            taskStateList.add(DataUtility.taskState(ts));
        }
        return taskStateList;
    }

    public List<TaskState> getTasksByTag(String tag) {
        Map taskStateMap = this.jobStateData.getTasks();
        ArrayList<TaskState> taskStateList = new ArrayList<TaskState>(taskStateMap.size());
        for (TaskStateData ts : taskStateMap.values()) {
            String taskTag = ts.getTag();
            if (taskTag == null || !taskTag.equals(tag)) continue;
            taskStateList.add(DataUtility.taskState(ts));
        }
        return taskStateList;
    }

    public void update(TaskInfo taskInfo) {
        throw new UnsupportedOperationException();
    }

    public void update(JobInfo jobInfo) {
        throw new UnsupportedOperationException();
    }

    public JobType getType() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.jobStateData.getName();
    }

    public JobPriority getPriority() {
        return JobPriority.valueOf((String)this.jobStateData.getPriority());
    }

    public JobStateData getJobStateData() {
        return this.jobStateData;
    }
}

