# PySNMP SMI module. Autogenerated from smidump -f python IEEE8023-LAG-MIB
# by libsmi2pysnmp-0.1.3 at Thu May 22 11:57:47 2014,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, enterprises, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "enterprises")
( DisplayString, MacAddress, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "MacAddress", "TextualConvention", "TruthValue")

# Types

class ChurnState(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,1,2,)
    namedValues = NamedValues(("noChurn", 1), ("churn", 2), ("churnMonitor", 3), )
    
class InterfaceIndex(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class LacpKey(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,65535)
    
class LacpState(Bits):
    namedValues = NamedValues(("lacpActivity", 0), ("lacpTimeout", 1), ("aggregation", 2), ("synchronization", 3), ("collecting", 4), ("distributing", 5), ("defaulted", 6), ("expired", 7), )
    
class PortList(OctetString):
    pass


# Objects

lagMIB = ModuleIdentity((1, 2, 840, 10006, 300, 43)).setRevisions(("2000-06-27 00:00",))
if mibBuilder.loadTexts: lagMIB.setOrganization("IEEE 802.3 Working Group")
if mibBuilder.loadTexts: lagMIB.setContactInfo(" stds-802-3-trunking@majordomo.ieee.org")
if mibBuilder.loadTexts: lagMIB.setDescription("The Link Aggregation module for managing IEEE Std\n802.3ad.")
lagMIBObjects = MibIdentifier((1, 2, 840, 10006, 300, 43, 1))
dot3adAgg = MibIdentifier((1, 2, 840, 10006, 300, 43, 1, 1))
dot3adAggTable = MibTable((1, 2, 840, 10006, 300, 43, 1, 1, 1))
if mibBuilder.loadTexts: dot3adAggTable.setDescription("A table that contains information about every\nAggregator that is associated with this System.")
dot3adAggEntry = MibTableRow((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1)).setIndexNames((0, "IEEE8023-LAG-MIB", "dot3adAggIndex"))
if mibBuilder.loadTexts: dot3adAggEntry.setDescription("A list of the Aggregator parameters. This is indexed\nby the ifIndex of the Aggregator.")
dot3adAggIndex = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3adAggIndex.setDescription("The unique identifier allocated to this Aggregator by\nthe local System.  This attribute identifies an\nAggregator instance among the subordinate managed\nobjects of the containing object.\nThis value is read-only.")
dot3adAggMACAddress = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggMACAddress.setDescription("A 6-octet read-only value carrying the individual\nMAC address assigned to the Aggregator.")
dot3adAggActorSystemPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggActorSystemPriority.setDescription("A 2-octet read-write value indicating the priority\nvalue associated with the Actor's System ID.")
dot3adAggActorSystemID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 4), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggActorSystemID.setDescription("A 6-octet read-write MAC address value used as a unique\nidentifier for the System that contains this Aggregator.\nNOTE-From the perspective of the Link Aggregation\nmechanisms described in Clause 43, only a single\ncombination of Actor's System ID and System Priority are\nconsidered, and no distinction is made between the\nvalues of these parameters for an Aggregator and the\nport(s) that are associated with it; i.e., the protocol\nis described in terms of the operation of aggregation\nwithin a single System. However, the managed objects\nprovided for the Aggregator and the port both allow\nmanagement of these parameters. The result of this is to\npermit a single piece of equipment to be configured by\nmanagement to contain more than one System from the\npoint of view of the operation of Link Aggregation. This\nmay be of particular use in the configuration of\nequipment that has limited aggregation capability (see\n43.6).")
dot3adAggAggregateOrIndividual = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 5), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggAggregateOrIndividual.setDescription("A read-only Boolean value indicating whether the\nAggregator represents an Aggregate (`TRUE') or\nan Individual link (`FALSE').")
dot3adAggActorAdminKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 6), LacpKey()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggActorAdminKey.setDescription("The current administrative value of the Key for the\nAggregator. The administrative Key value may differ from\nthe operational Key value for the reasons discussed in\n43.6.2. This is a 16-bit, read-write value. The meaning\nof particular Key values is of local significance.")
dot3adAggActorOperKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 7), LacpKey()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggActorOperKey.setDescription("The current operational value of the Key for the\nAggregator. The administrative Key value may differ from\nthe operational Key value for the reasons discussed in\n43.6.2.  This is a 16-bit read-only value. The meaning\nof particular Key values is of local significance.")
dot3adAggPartnerSystemID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 8), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPartnerSystemID.setDescription("A 6-octet read-only MAC address value consisting of the\nunique identifier for the current protocol Partner of\nthis Aggregator. A value of zero indicates that there is\nno known Partner. If the aggregation is manually\nconfigured, this System ID value will be a value\nassigned by the local System.")
dot3adAggPartnerSystemPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPartnerSystemPriority.setDescription("A 2-octet read-only value that indicates the priority\nvalue associated with the Partner's System ID. If the\naggregation is manually configured, this System Priority\nvalue will be a value assigned by the local System.")
dot3adAggPartnerOperKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 10), LacpKey()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPartnerOperKey.setDescription("The current operational value of the Key for the\nAggregator's current protocol Partner. This is a 16-bit\nread-only value. If the aggregation is manually\nconfigured, this Key value will be a value assigned by\nthe local System.")
dot3adAggCollectorMaxDelay = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 1, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggCollectorMaxDelay.setDescription("The value of this 16-bit read-write attribute defines\nthe maximum delay, in tens of microseconds, that may be\nimposed by the Frame Collector between receiving a frame\nfrom an Aggregator Parser, and either delivering the\nframe to its MAC Client or discarding the frame (see\n43.2.3.1.1).")
dot3adAggPortListTable = MibTable((1, 2, 840, 10006, 300, 43, 1, 1, 2))
if mibBuilder.loadTexts: dot3adAggPortListTable.setDescription("A table that contains a list of all the ports\nassociated with each Aggregator.")
dot3adAggPortListEntry = MibTableRow((1, 2, 840, 10006, 300, 43, 1, 1, 2, 1)).setIndexNames((0, "IEEE8023-LAG-MIB", "dot3adAggIndex"))
if mibBuilder.loadTexts: dot3adAggPortListEntry.setDescription("A list of the ports associated with a given Aggregator.\nThis is indexed by the ifIndex of the Aggregator.")
dot3adAggPortListPorts = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 1, 2, 1, 1), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortListPorts.setDescription("The complete set of ports currently associated with\nthis Aggregator.  Each bit set in this list represents\nan Actor Port member of this Link Aggregation.")
dot3adAggPort = MibIdentifier((1, 2, 840, 10006, 300, 43, 1, 2))
dot3adAggPortTable = MibTable((1, 2, 840, 10006, 300, 43, 1, 2, 1))
if mibBuilder.loadTexts: dot3adAggPortTable.setDescription("A table that contains Link Aggregation Control\nconfiguration information about every\nAggregation Port associated with this device.\nA row appears in this table for each physical port.")
dot3adAggPortEntry = MibTableRow((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1)).setIndexNames((0, "IEEE8023-LAG-MIB", "dot3adAggPortIndex"))
if mibBuilder.loadTexts: dot3adAggPortEntry.setDescription("A list of Link Aggregation Control configuration\nparameters for each Aggregation Port on this device.")
dot3adAggPortIndex = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3adAggPortIndex.setDescription("The ifIndex of the port")
dot3adAggPortActorSystemPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortActorSystemPriority.setDescription("A 2-octet read-write value used to define the priority\nvalue associated with the Actor's System ID.")
dot3adAggPortActorSystemID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 3), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortActorSystemID.setDescription("A 6-octet read-only MAC address value that defines the\nvalue of the System ID for the System that contains this\nAggregation Port.")
dot3adAggPortActorAdminKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 4), LacpKey()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortActorAdminKey.setDescription("The current administrative value of the Key for the\nAggregation Port. This is a 16-bit read-write value.\nThe meaning of particular Key values is of local\nsignificance.")
dot3adAggPortActorOperKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 5), LacpKey()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortActorOperKey.setDescription("The current operational value of the Key for the\nAggregation Port. This is a 16-bit read-only value.\nThe meaning of particular Key values is of local\nsignificance.")
dot3adAggPortPartnerAdminSystemPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortPartnerAdminSystemPriority.setDescription("A 2-octet read-write value used to define the\nadministrative value of priority associated with the\nPartner's System ID. The assigned value is used, along\nwith the value of aAggPortPartnerAdminSystemID,\naAggPortPartnerAdminKey, aAggPortPartnerAdminPort, and\naAggPortPartnerAdminPortPriority, in order to achieve\nmanually configured aggregation.")
dot3adAggPortPartnerOperSystemPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortPartnerOperSystemPriority.setDescription("A 2-octet read-only value indicating the operational\nvalue of priority associated with the Partner's System\nID. The value of this attribute may contain the manually\nconfigured value carried in\naAggPortPartnerAdminSystemPriority if there is no\nprotocol Partner.")
dot3adAggPortPartnerAdminSystemID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 8), MacAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortPartnerAdminSystemID.setDescription("A 6-octet read-write MACAddress value representing the\nadministrative value of the Aggregation Port's protocol\nPartner's System ID. The assigned value is used, along\nwith the value of aAggPortPartnerAdminSystemPriority,\naAggPortPartnerAdminKey, aAggPortPartnerAdminPort, and\naAggPortPartnerAdminPortPriority, in order to achieve\nmanually configured aggregation.")
dot3adAggPortPartnerOperSystemID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 9), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortPartnerOperSystemID.setDescription("A 6-octet read-only MACAddress value representing the\ncurrent value of the Aggregation Port's protocol\nPartner's System ID. A value of zero indicates that\nthere is no known protocol Partner. The value of this\nattribute may contain the manually configured value\ncarried in aAggPortPartnerAdminSystemID if there is no\nprotocol Partner.")
dot3adAggPortPartnerAdminKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 10), LacpKey()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortPartnerAdminKey.setDescription("The current administrative value of the Key for the\nprotocol Partner. This is a 16-bit read-write value.\nThe assigned value is used, along with the value of\naAggPortPartnerAdminSystemPriority,\naAggPortPartnerAdminSystemID, aAggPortPartnerAdminPort,\nand aAggPortPartnerAdminPortPriority, in order to\nachieve manually configured aggregation.")
dot3adAggPortPartnerOperKey = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 11), LacpKey()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortPartnerOperKey.setDescription("The current operational value of the Key for the\nprotocol Partner. The value of this attribute may\ncontain the manually configured value carried in\naAggPortPartnerAdminKey if there is no protocol Partner.\nThis is a 16-bit read-only value.")
dot3adAggPortSelectedAggID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 12), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortSelectedAggID.setDescription("The identifier value of the Aggregator that this\nAggregation Port has currently selected. Zero indicates\nthat the Aggregation Port has not selected an\nAggregator, either because it is in the process of\ndetaching from an Aggregator or because there is no\nsuitable Aggregator available for it to select.\nThis value is read-only.")
dot3adAggPortAttachedAggID = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 13), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortAttachedAggID.setDescription("The identifier value of the Aggregator that this\nAggregation Port is currently attached to. Zero\nindicates that the Aggregation Port is not currently\nattached to an Aggregator.  This value is read-only.")
dot3adAggPortActorPort = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortActorPort.setDescription("The port number locally assigned to the Aggregation\nPort. The port number is communicated in LACPDUs as the\nActor_Port. This value is read-only.")
dot3adAggPortActorPortPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortActorPortPriority.setDescription("The priority value assigned to this Aggregation Port.\nThis 16-bit value is read-write.")
dot3adAggPortPartnerAdminPort = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortPartnerAdminPort.setDescription("The current administrative value of the port number for\nthe protocol Partner. This is a 16-bit read-write value.\nThe assigned value is used, along with the value of\naAggPortPartnerAdminSystemPriority,\naAggPortPartnerAdminSystemID, aAggPortPartnerAdminKey,\nand aAggPortPartnerAdminPortPriority, in order to\nachieve manually configured aggregation.")
dot3adAggPortPartnerOperPort = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortPartnerOperPort.setDescription("The operational port number assigned to this\nAggregation Port by the Aggregation Port's protocol\nPartner. The value of this attribute may contain the\nmanually configured value carried in\naAggPortPartnerAdminPort if there is no protocol\nPartner. This 16-bit value is read-only.")
dot3adAggPortPartnerAdminPortPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortPartnerAdminPortPriority.setDescription("The current administrative value of the port priority\nfor the protocol Partner. This is a 16-bit read-write\nvalue. The assigned value is used, along with the value\nof aAggPortPartnerAdminSystemPriority,\naAggPortPartnerAdminSystemID, aAggPortPartnerAdminKey,\nand aAggPortPartnerAdminPort, in order to achieve\nmanually configured aggregation.")
dot3adAggPortPartnerOperPortPriority = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortPartnerOperPortPriority.setDescription("The priority value assigned to this Aggregation Port by\nthe Partner. The value of this attribute may contain the\nmanually configured value carried in\naAggPortPartnerAdminPortPriority if there is no protocol\nPartner. This 16-bit value is read-only.")
dot3adAggPortActorAdminState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 20), LacpState()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortActorAdminState.setDescription("A string of 8 bits, corresponding to the administrative\nvalues of Actor_State (43.4.2) as transmitted by the\nActor in LACPDUs. The first bit corresponds to bit 0 of\nActor_State (LACP_Activity),\nthe second bit corresponds to bit 1 (LACP_Timeout),\nthe third bit corresponds to bit 2 (Aggregation),\nthe fourth bit corresponds to bit 3 (Synchronization),\nthe fifth bit corresponds to bit 4 (Collecting),\nthe sixth bit corresponds to bit 5 (Distributing),\nthe seventh bit corresponds to bit 6 (Defaulted),\nand the eighth bit corresponds to bit 7 (Expired).\nThese values allow administrative control over the\nvalues of LACP_Activity, LACP_Timeout and Aggregation.\nThis attribute value is read-write.")
dot3adAggPortActorOperState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 21), LacpState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortActorOperState.setDescription("A string of 8 bits, corresponding to the current\noperational values of Actor_State as transmitted by the\nActor in LACPDUs. The bit allocations are as defined in\n30.7.2.1.20. This attribute value is read-only.")
dot3adAggPortPartnerAdminState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 22), LacpState()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3adAggPortPartnerAdminState.setDescription("A string of 8 bits, corresponding to the current\nadministrative value of Actor_State for the protocol\nPartner. The bit allocations are as defined in\n30.7.2.1.20. This attribute value is read-write. The\nassigned value is used in order to achieve manually\nconfigured aggregation.")
dot3adAggPortPartnerOperState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 23), LacpState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortPartnerOperState.setDescription("A string of 8 bits, corresponding to the current values\nof Actor_State in the most recently received LACPDU\ntransmitted by the protocol Partner. The bit allocations\nare as defined in 30.7.2.1.20. In the absence of an\nactive protocol Partner, this value may reflect the\nmanually configured value aAggPortPartnerAdminState.\nThis attribute value is read-only.")
dot3adAggPortAggregateOrIndividual = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 1, 1, 24), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortAggregateOrIndividual.setDescription("A read-only Boolean value indicating whether the\nAggregation Port is able to Aggregate (`TRUE') or is\nonly able to operate as an Individual link (`FALSE').")
dot3adAggPortStatsTable = MibTable((1, 2, 840, 10006, 300, 43, 1, 2, 2))
if mibBuilder.loadTexts: dot3adAggPortStatsTable.setDescription("A table that contains Link Aggregation information\nabout every port that is associated with this device.\nA row appears in this table for each physical port.")
dot3adAggPortStatsEntry = MibTableRow((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1)).setIndexNames((0, "IEEE8023-LAG-MIB", "dot3adAggPortIndex"))
if mibBuilder.loadTexts: dot3adAggPortStatsEntry.setDescription("A list of Link Aggregation Control Protocol statistics\nfor each port on this device.")
dot3adAggPortStatsLACPDUsRx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsLACPDUsRx.setDescription("The number of valid LACPDUs received on this\nAggregation Port. This value is read-only.")
dot3adAggPortStatsMarkerPDUsRx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsMarkerPDUsRx.setDescription("The number of valid Marker PDUs received on this\nAggregation Port. This value is read-only.")
dot3adAggPortStatsMarkerResponsePDUsRx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsMarkerResponsePDUsRx.setDescription("The number of valid Marker Response PDUs received on\nthis Aggregation Port. This value is read-only.")
dot3adAggPortStatsUnknownRx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsUnknownRx.setDescription("The number of frames received that either:\n- carry the Slow Protocols Ethernet Type value (43B.4),\n  but contain an unknown PDU,  or:\n- are addressed to the Slow Protocols group MAC\n  Address (43B.3), but do not carry the Slow Protocols\n  Ethernet Type.\nThis value is read-only.")
dot3adAggPortStatsIllegalRx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsIllegalRx.setDescription("The number of frames received that carry the Slow\nProtocols Ethernet Type value (43B.4), but contain a\nbadly formed PDU or an illegal value of Protocol Subtype\n(43B.4). This value is read-only.")
dot3adAggPortStatsLACPDUsTx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsLACPDUsTx.setDescription("The number of LACPDUs transmitted on this\nAggregation Port. This value is read-only.")
dot3adAggPortStatsMarkerPDUsTx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsMarkerPDUsTx.setDescription("The number of Marker PDUs transmitted on this\nAggregation Port. This value is read-only.")
dot3adAggPortStatsMarkerResponsePDUsTx = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortStatsMarkerResponsePDUsTx.setDescription("The number of Marker Response PDUs transmitted\non this Aggregation Port. This value is read-only.")
dot3adAggPortDebugTable = MibTable((1, 2, 840, 10006, 300, 43, 1, 2, 3))
if mibBuilder.loadTexts: dot3adAggPortDebugTable.setDescription("A table that contains Link Aggregation debug\ninformation about every port that is associated with\nthis device.  A row appears in this table for each\nphysical port.")
dot3adAggPortDebugEntry = MibTableRow((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1)).setIndexNames((0, "IEEE8023-LAG-MIB", "dot3adAggPortIndex"))
if mibBuilder.loadTexts: dot3adAggPortDebugEntry.setDescription("A list of the debug parameters for a port.")
dot3adAggPortDebugRxState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(5,6,1,3,4,2,)).subtype(namedValues=NamedValues(("currentRx", 1), ("expired", 2), ("defaulted", 3), ("initialize", 4), ("lacpDisabled", 5), ("portDisabled", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugRxState.setDescription("This attribute holds the value `currentRx' if the\nReceive state machine for the Aggregation Port is in the\nCURRENT state, `expired' if the Receive state machine is\nin the EXPIRED state, `defaulted' if the Receive state\nmachine is in the DEFAULTED state, `initialize' if the\nReceive state machine is in the INITIALIZE state,\n`lacpDisabled' if the Receive state machine is in the\nLACP_DISABLED state, or `portDisabled' if the Receive\nstate machine is in the PORT_DISABLED state.\nThis value is read-only.")
dot3adAggPortDebugLastRxTime = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugLastRxTime.setDescription("The value of aTimeSinceSystemReset (F.2.1) when\nthe last LACPDU was received by this Aggregation Port.\nThis value is read-only.")
dot3adAggPortDebugMuxState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(4,6,3,5,2,1,)).subtype(namedValues=NamedValues(("detached", 1), ("waiting", 2), ("attached", 3), ("collecting", 4), ("distributing", 5), ("collectingDistributing", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugMuxState.setDescription("This attribute holds the value `detached' if the Mux\nstate machine (43.4.14) for the Aggregation Port is in\nthe DETACHED state, `waiting' if the Mux state machine\nis in the WAITING state, `attached' if the Mux state\nmachine for the Aggregation Port is in the ATTACHED\nstate, `collecting' if the Mux state machine for the\nAggregation Port is in the COLLECTING state,\n`distributing' if the Mux state machine for the\nAggregation Port is in the DISTRIBUTING state, and\n`collectingDistributing' if the Mux state machine for\nthe Aggregation Port is in the COLLECTING_DISTRIBUTING\nstate. This value is read-only.")
dot3adAggPortDebugMuxReason = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 4), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugMuxReason.setDescription("A human-readable text string indicating the reason\nfor the most recent change of Mux machine state.\nThis value is read-only.")
dot3adAggPortDebugActorChurnState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 5), ChurnState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugActorChurnState.setDescription("The state of the Actor Churn Detection machine\n(43.4.17) for the Aggregation Port. A value of `noChurn'\nindicates that the state machine is in either the\nNO_ACTOR_CHURN or the ACTOR_CHURN_MONITOR state, and\n`churn' indicates that the state machine is in the\nACTOR_CHURN state. This value is read-only.")
dot3adAggPortDebugPartnerChurnState = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 6), ChurnState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugPartnerChurnState.setDescription("The state of the Partner Churn Detection machine\n(43.4.17) for the Aggregation Port. A value of `noChurn'\nindicates that the state machine is in either the\nNO_PARTNER_CHURN or the PARTNER_CHURN_MONITOR state, and\n`churn' indicates that the state machine is in the\nPARTNER_CHURN state. This value is read-only.")
dot3adAggPortDebugActorChurnCount = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugActorChurnCount.setDescription("Count of the number of times the Actor Churn state\nmachine has entered the ACTOR_CHURN state.\nThis value is read-only.")
dot3adAggPortDebugPartnerChurnCount = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugPartnerChurnCount.setDescription("Count of the number of times the Partner Churn\nstate machine has entered the PARTNER_CHURN state.\nThis value is read-only.")
dot3adAggPortDebugActorSyncTransitionCount = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugActorSyncTransitionCount.setDescription("Count of the number of times the Actor's Mux state\nmachine (43.4.15) has entered the IN_SYNC state.\nThis value is read-only.")
dot3adAggPortDebugPartnerSyncTransitionCount = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugPartnerSyncTransitionCount.setDescription("Count of the number of times the Partner's Mux\nstate machine (43.4.15) has entered the IN_SYNC state.\nThis value is read-only.")
dot3adAggPortDebugActorChangeCount = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugActorChangeCount.setDescription("Count of the number of times the Actor's perception of\nthe LAG ID for this Aggregation Port has changed.\nThis value is read-only.")
dot3adAggPortDebugPartnerChangeCount = MibTableColumn((1, 2, 840, 10006, 300, 43, 1, 2, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adAggPortDebugPartnerChangeCount.setDescription("Count of the number of times the Partner's perception\nof the LAG ID (see 43.3.6.1) for this Aggregation Port\nhas changed. This value is read-only.")
dot3adTablesLastChanged = MibScalar((1, 2, 840, 10006, 300, 43, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3adTablesLastChanged.setDescription("This object indicates the time of the most recent\nchange to the dot3adAggTable, dot3adAggPortListTable, or\ndot3adAggPortTable.")
dot3adAggConformance = MibIdentifier((1, 2, 840, 10006, 300, 43, 2))
dot3adAggGroups = MibIdentifier((1, 2, 840, 10006, 300, 43, 2, 1))
dot3adAggCompliances = MibIdentifier((1, 2, 840, 10006, 300, 43, 2, 2))

# Augmentions

# Groups

dot3adAggGroup = ObjectGroup((1, 2, 840, 10006, 300, 43, 2, 1, 1)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adAggCollectorMaxDelay"), ("IEEE8023-LAG-MIB", "dot3adAggPartnerSystemPriority"), ("IEEE8023-LAG-MIB", "dot3adAggActorSystemPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPartnerOperKey"), ("IEEE8023-LAG-MIB", "dot3adAggMACAddress"), ("IEEE8023-LAG-MIB", "dot3adAggActorOperKey"), ("IEEE8023-LAG-MIB", "dot3adAggActorAdminKey"), ("IEEE8023-LAG-MIB", "dot3adAggAggregateOrIndividual"), ("IEEE8023-LAG-MIB", "dot3adAggPartnerSystemID"), ("IEEE8023-LAG-MIB", "dot3adAggActorSystemID"), ) )
if mibBuilder.loadTexts: dot3adAggGroup.setDescription("A collection of objects providing information about an\naggregation.")
dot3adTablesLastChangedGroup = ObjectGroup((1, 2, 840, 10006, 300, 43, 2, 1, 1, 6)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adTablesLastChanged"), ) )
if mibBuilder.loadTexts: dot3adTablesLastChangedGroup.setDescription("A collection of objects providing information about the\ntime of changes to the configuration of aggregations and\ntheir ports.")
dot3adAggPortListGroup = ObjectGroup((1, 2, 840, 10006, 300, 43, 2, 1, 2)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adAggPortListPorts"), ) )
if mibBuilder.loadTexts: dot3adAggPortListGroup.setDescription("A collection of objects providing information about\nevery port in an aggregation.")
dot3adAggPortGroup = ObjectGroup((1, 2, 840, 10006, 300, 43, 2, 1, 3)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adAggPortPartnerOperPort"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorSystemID"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerOperSystemPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPortAttachedAggID"), ("IEEE8023-LAG-MIB", "dot3adAggPortSelectedAggID"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorOperKey"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerAdminSystemPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPortAggregateOrIndividual"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorOperState"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerOperKey"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerAdminSystemID"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorSystemPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorPort"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerAdminState"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorAdminKey"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerAdminPortPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorAdminState"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerOperState"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerAdminKey"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerOperPortPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerAdminPort"), ("IEEE8023-LAG-MIB", "dot3adAggPortActorPortPriority"), ("IEEE8023-LAG-MIB", "dot3adAggPortPartnerOperSystemID"), ) )
if mibBuilder.loadTexts: dot3adAggPortGroup.setDescription("A collection of objects providing information about\nevery port in an aggregation.")
dot3adAggPortStatsGroup = ObjectGroup((1, 2, 840, 10006, 300, 43, 2, 1, 4)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adAggPortStatsLACPDUsRx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsMarkerPDUsRx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsMarkerResponsePDUsRx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsMarkerResponsePDUsTx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsMarkerPDUsTx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsIllegalRx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsLACPDUsTx"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsUnknownRx"), ) )
if mibBuilder.loadTexts: dot3adAggPortStatsGroup.setDescription("A collection of objects providing information about\nevery port in an aggregation.")
dot3adAggPortDebugGroup = ObjectGroup((1, 2, 840, 10006, 300, 43, 2, 1, 5)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adAggPortDebugMuxState"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugRxState"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugActorChurnState"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugMuxReason"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugActorSyncTransitionCount"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugPartnerChurnState"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugActorChurnCount"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugPartnerSyncTransitionCount"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugActorChangeCount"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugLastRxTime"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugPartnerChurnCount"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugPartnerChangeCount"), ) )
if mibBuilder.loadTexts: dot3adAggPortDebugGroup.setDescription("A collection of objects providing debug information\nabout every aggregated port.")

# Compliances

dot3adAggCompliance = ModuleCompliance((1, 2, 840, 10006, 300, 43, 2, 2, 1)).setObjects(*(("IEEE8023-LAG-MIB", "dot3adAggGroup"), ("IEEE8023-LAG-MIB", "dot3adAggPortListGroup"), ("IEEE8023-LAG-MIB", "dot3adTablesLastChangedGroup"), ("IEEE8023-LAG-MIB", "dot3adAggPortGroup"), ("IEEE8023-LAG-MIB", "dot3adAggPortDebugGroup"), ("IEEE8023-LAG-MIB", "dot3adAggPortStatsGroup"), ) )
if mibBuilder.loadTexts: dot3adAggCompliance.setDescription("The compliance statement for device support of\nLink Aggregation.")

# Exports

# Module identity
mibBuilder.exportSymbols("IEEE8023-LAG-MIB", PYSNMP_MODULE_ID=lagMIB)

# Types
mibBuilder.exportSymbols("IEEE8023-LAG-MIB", ChurnState=ChurnState, InterfaceIndex=InterfaceIndex, LacpKey=LacpKey, LacpState=LacpState, PortList=PortList)

# Objects
mibBuilder.exportSymbols("IEEE8023-LAG-MIB", lagMIB=lagMIB, lagMIBObjects=lagMIBObjects, dot3adAgg=dot3adAgg, dot3adAggTable=dot3adAggTable, dot3adAggEntry=dot3adAggEntry, dot3adAggIndex=dot3adAggIndex, dot3adAggMACAddress=dot3adAggMACAddress, dot3adAggActorSystemPriority=dot3adAggActorSystemPriority, dot3adAggActorSystemID=dot3adAggActorSystemID, dot3adAggAggregateOrIndividual=dot3adAggAggregateOrIndividual, dot3adAggActorAdminKey=dot3adAggActorAdminKey, dot3adAggActorOperKey=dot3adAggActorOperKey, dot3adAggPartnerSystemID=dot3adAggPartnerSystemID, dot3adAggPartnerSystemPriority=dot3adAggPartnerSystemPriority, dot3adAggPartnerOperKey=dot3adAggPartnerOperKey, dot3adAggCollectorMaxDelay=dot3adAggCollectorMaxDelay, dot3adAggPortListTable=dot3adAggPortListTable, dot3adAggPortListEntry=dot3adAggPortListEntry, dot3adAggPortListPorts=dot3adAggPortListPorts, dot3adAggPort=dot3adAggPort, dot3adAggPortTable=dot3adAggPortTable, dot3adAggPortEntry=dot3adAggPortEntry, dot3adAggPortIndex=dot3adAggPortIndex, dot3adAggPortActorSystemPriority=dot3adAggPortActorSystemPriority, dot3adAggPortActorSystemID=dot3adAggPortActorSystemID, dot3adAggPortActorAdminKey=dot3adAggPortActorAdminKey, dot3adAggPortActorOperKey=dot3adAggPortActorOperKey, dot3adAggPortPartnerAdminSystemPriority=dot3adAggPortPartnerAdminSystemPriority, dot3adAggPortPartnerOperSystemPriority=dot3adAggPortPartnerOperSystemPriority, dot3adAggPortPartnerAdminSystemID=dot3adAggPortPartnerAdminSystemID, dot3adAggPortPartnerOperSystemID=dot3adAggPortPartnerOperSystemID, dot3adAggPortPartnerAdminKey=dot3adAggPortPartnerAdminKey, dot3adAggPortPartnerOperKey=dot3adAggPortPartnerOperKey, dot3adAggPortSelectedAggID=dot3adAggPortSelectedAggID, dot3adAggPortAttachedAggID=dot3adAggPortAttachedAggID, dot3adAggPortActorPort=dot3adAggPortActorPort, dot3adAggPortActorPortPriority=dot3adAggPortActorPortPriority, dot3adAggPortPartnerAdminPort=dot3adAggPortPartnerAdminPort, dot3adAggPortPartnerOperPort=dot3adAggPortPartnerOperPort, dot3adAggPortPartnerAdminPortPriority=dot3adAggPortPartnerAdminPortPriority, dot3adAggPortPartnerOperPortPriority=dot3adAggPortPartnerOperPortPriority, dot3adAggPortActorAdminState=dot3adAggPortActorAdminState, dot3adAggPortActorOperState=dot3adAggPortActorOperState, dot3adAggPortPartnerAdminState=dot3adAggPortPartnerAdminState, dot3adAggPortPartnerOperState=dot3adAggPortPartnerOperState, dot3adAggPortAggregateOrIndividual=dot3adAggPortAggregateOrIndividual, dot3adAggPortStatsTable=dot3adAggPortStatsTable, dot3adAggPortStatsEntry=dot3adAggPortStatsEntry, dot3adAggPortStatsLACPDUsRx=dot3adAggPortStatsLACPDUsRx, dot3adAggPortStatsMarkerPDUsRx=dot3adAggPortStatsMarkerPDUsRx, dot3adAggPortStatsMarkerResponsePDUsRx=dot3adAggPortStatsMarkerResponsePDUsRx, dot3adAggPortStatsUnknownRx=dot3adAggPortStatsUnknownRx, dot3adAggPortStatsIllegalRx=dot3adAggPortStatsIllegalRx, dot3adAggPortStatsLACPDUsTx=dot3adAggPortStatsLACPDUsTx, dot3adAggPortStatsMarkerPDUsTx=dot3adAggPortStatsMarkerPDUsTx, dot3adAggPortStatsMarkerResponsePDUsTx=dot3adAggPortStatsMarkerResponsePDUsTx, dot3adAggPortDebugTable=dot3adAggPortDebugTable, dot3adAggPortDebugEntry=dot3adAggPortDebugEntry, dot3adAggPortDebugRxState=dot3adAggPortDebugRxState, dot3adAggPortDebugLastRxTime=dot3adAggPortDebugLastRxTime, dot3adAggPortDebugMuxState=dot3adAggPortDebugMuxState, dot3adAggPortDebugMuxReason=dot3adAggPortDebugMuxReason, dot3adAggPortDebugActorChurnState=dot3adAggPortDebugActorChurnState, dot3adAggPortDebugPartnerChurnState=dot3adAggPortDebugPartnerChurnState, dot3adAggPortDebugActorChurnCount=dot3adAggPortDebugActorChurnCount, dot3adAggPortDebugPartnerChurnCount=dot3adAggPortDebugPartnerChurnCount, dot3adAggPortDebugActorSyncTransitionCount=dot3adAggPortDebugActorSyncTransitionCount, dot3adAggPortDebugPartnerSyncTransitionCount=dot3adAggPortDebugPartnerSyncTransitionCount, dot3adAggPortDebugActorChangeCount=dot3adAggPortDebugActorChangeCount, dot3adAggPortDebugPartnerChangeCount=dot3adAggPortDebugPartnerChangeCount, dot3adTablesLastChanged=dot3adTablesLastChanged, dot3adAggConformance=dot3adAggConformance, dot3adAggGroups=dot3adAggGroups, dot3adAggCompliances=dot3adAggCompliances)

# Groups
mibBuilder.exportSymbols("IEEE8023-LAG-MIB", dot3adAggGroup=dot3adAggGroup, dot3adTablesLastChangedGroup=dot3adTablesLastChangedGroup, dot3adAggPortListGroup=dot3adAggPortListGroup, dot3adAggPortGroup=dot3adAggPortGroup, dot3adAggPortStatsGroup=dot3adAggPortStatsGroup, dot3adAggPortDebugGroup=dot3adAggPortDebugGroup)

# Compliances
mibBuilder.exportSymbols("IEEE8023-LAG-MIB", dot3adAggCompliance=dot3adAggCompliance)
