
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def StorageDrsPodConfigInfo(vim, *args, **kwargs):
    '''The StorageDrsPodConfigInfo data object contains pod-wide configuration
    information for the storage DRS service.NOTE: This data object type and all of
    its methods are experimental and subject to change in future releases.'''
    
    obj = vim.client.factory.create('ns0:StorageDrsPodConfigInfo')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 3:
        raise IndexError('Expected at least 4 arguments got: %d' % len(args))

    required = [ 'defaultVmBehavior', 'enabled', 'ioLoadBalanceEnabled' ]
    optional = [ 'defaultIntraVmAffinity', 'ioLoadBalanceConfig', 'loadBalanceInterval',
        'option', 'rule', 'spaceLoadBalanceConfig', 'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
    