# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._dashboard_management_client_enums import *


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dashboard.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dashboard.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dashboard.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.dashboard.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ManagedGrafana(msrest.serialization.Model):
    """The grafana resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM id of the grafana resource.
    :vartype id: str
    :ivar name: Name of the grafana resource.
    :vartype name: str
    :ivar type: The type of the grafana resource.
    :vartype type: str
    :ivar sku: The Sku of the grafana resource.
    :vartype sku: ~azure.mgmt.dashboard.models.ResourceSku
    :ivar properties: Properties specific to the grafana resource.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaProperties
    :ivar identity: The managed identity of the grafana resource.
    :vartype identity: ~azure.mgmt.dashboard.models.ManagedIdentity
    :ivar system_data: The system meta data relating to this grafana resource.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: A set of tags. The tags for grafana resource.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the grafana resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'properties': {'key': 'properties', 'type': 'ManagedGrafanaProperties'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: Optional["ResourceSku"] = None,
        properties: Optional["ManagedGrafanaProperties"] = None,
        identity: Optional["ManagedIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sku: The Sku of the grafana resource.
        :paramtype sku: ~azure.mgmt.dashboard.models.ResourceSku
        :keyword properties: Properties specific to the grafana resource.
        :paramtype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaProperties
        :keyword identity: The managed identity of the grafana resource.
        :paramtype identity: ~azure.mgmt.dashboard.models.ManagedIdentity
        :keyword tags: A set of tags. The tags for grafana resource.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the grafana resource lives.
        :paramtype location: str
        """
        super(ManagedGrafana, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.sku = sku
        self.properties = properties
        self.identity = identity
        self.system_data = None
        self.tags = tags
        self.location = location


class ManagedGrafanaListResponse(msrest.serialization.Model):
    """ManagedGrafanaListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.dashboard.models.ManagedGrafana]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedGrafana]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedGrafana"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.dashboard.models.ManagedGrafana]
        :keyword next_link:
        :paramtype next_link: str
        """
        super(ManagedGrafanaListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedGrafanaProperties(msrest.serialization.Model):
    """Properties specific to the grafana resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar grafana_version: The Grafana software version.
    :vartype grafana_version: str
    :ivar endpoint: The endpoint of the Grafana instance.
    :vartype endpoint: str
    :ivar zone_redundancy: Possible values include: "Disabled", "Enabled". Default value:
     "Disabled".
    :vartype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
    :ivar auto_generated_domain_name_label_scope: Possible values include: "TenantReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.dashboard.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        'grafana_version': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'grafana_version': {'key': 'grafanaVersion', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'zone_redundancy': {'key': 'zoneRedundancy', 'type': 'str'},
        'auto_generated_domain_name_label_scope': {'key': 'autoGeneratedDomainNameLabelScope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        zone_redundancy: Optional[Union[str, "ZoneRedundancy"]] = "Disabled",
        auto_generated_domain_name_label_scope: Optional[Union[str, "AutoGeneratedDomainNameLabelScope"]] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Provisioning state of the resource. Possible values include:
         "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
         "NotSpecified".
        :paramtype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
        :keyword zone_redundancy: Possible values include: "Disabled", "Enabled". Default value:
         "Disabled".
        :paramtype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
        :keyword auto_generated_domain_name_label_scope: Possible values include: "TenantReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.dashboard.models.AutoGeneratedDomainNameLabelScope
        """
        super(ManagedGrafanaProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.grafana_version = None
        self.endpoint = None
        self.zone_redundancy = zone_redundancy
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class ManagedGrafanaUpdateParameters(msrest.serialization.Model):
    """The parameters for a PATCH request to a grafana resource.

    :ivar identity: The managed identity of the grafana resource.
    :vartype identity: ~azure.mgmt.dashboard.models.ManagedIdentity
    :ivar tags: A set of tags. The new tags of the grafana resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        identity: Optional["ManagedIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword identity: The managed identity of the grafana resource.
        :paramtype identity: ~azure.mgmt.dashboard.models.ManagedIdentity
        :keyword tags: A set of tags. The new tags of the grafana resource.
        :paramtype tags: dict[str, str]
        """
        super(ManagedGrafanaUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.tags = tags


class ManagedIdentity(msrest.serialization.Model):
    """The managed identity of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type 'SystemAssigned, UserAssigned' includes both an implicitly created
     identity and a set of user assigned identities. The type 'None' will remove any identities from
     the resource. Possible values include: "None", "SystemAssigned".
    :vartype type: str or ~azure.mgmt.dashboard.models.IdentityType
    :ivar principal_id: The principal id of the system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: Dictionary of user assigned identities.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.dashboard.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type 'SystemAssigned, UserAssigned' includes both an implicitly created
         identity and a set of user assigned identities. The type 'None' will remove any identities from
         the resource. Possible values include: "None", "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.dashboard.models.IdentityType
        :keyword user_assigned_identities: Dictionary of user assigned identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.dashboard.models.UserAssignedIdentity]
        """
        super(ManagedIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, i.e.,
     Microsoft.Dashboard.
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation,
     e.g., 'grafana'.
    :vartype resource: str
    :ivar operation: Operation type, e.g., read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation, e.g., 'Read grafana'.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by Microsoft.Dashboard provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the Microsoft.Dashboard provider.
    :vartype value: list[~azure.mgmt.dashboard.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationResult(msrest.serialization.Model):
    """A Microsoft.Dashboard REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name, i.e., {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation applies to data-plane. Set "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.dashboard.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.dashboard.models.Origin
    :ivar action_type: Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.dashboard.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.dashboard.models.OperationDisplay
        """
        super(OperationResult, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class ResourceSku(msrest.serialization.Model):
    """ResourceSku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        """
        super(ResourceSku, self).__init__(**kwargs)
        self.name = name


class SystemData(msrest.serialization.Model):
    """SystemData.

    :ivar created_by:
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
    :ivar created_at:
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by:
    :vartype last_modified_by: str
    :ivar last_modified_by_type: Possible values include: "User", "Application", "ManagedIdentity",
     "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dashboard.models.LastModifiedByType
    :ivar last_modified_at:
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "LastModifiedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by:
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
        :keyword created_at:
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by:
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: Possible values include: "User", "Application",
         "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.dashboard.models.LastModifiedByType
        :keyword last_modified_at:
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
