/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.PageRule;
import be.re.css.Property;
import be.re.css.Rule;
import be.re.css.Util;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

class RuleCollector
implements DocumentHandler {
    private URL baseUrl;
    private RuleEmitter ruleEmitter;
    private PageRule currentPageRule = null;
    private Rule[] currentRules = null;
    private boolean ignore = false;
    private int offset;
    private List pageRules;
    private Map prefixMap = new HashMap();
    private int position;

    RuleCollector(RuleEmitter ruleEmitter, List pageRules, URL baseUrl, int startPosition, int offset) {
        this.ruleEmitter = ruleEmitter;
        this.pageRules = pageRules;
        this.baseUrl = baseUrl;
        this.position = startPosition;
        this.offset = offset;
    }

    public void comment(String text) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.ignore = false;
    }

    public void endPage(String name, String pseudoPage) throws CSSException {
        if (this.currentPageRule.getProperties().length > 0) {
            PageRule[] split = this.currentPageRule.split();
            for (int i = 0; i < split.length; ++i) {
                this.pageRules.add(split[i]);
            }
        }
        this.currentPageRule = null;
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        if (!this.ignore) {
            for (int i = 0; i < this.currentRules.length; ++i) {
                if (this.currentRules[i].getProperties().length <= 0) continue;
                Rule[] split = this.currentRules[i].split();
                for (int j = 0; j < split.length; ++j) {
                    this.ruleEmitter.addRule(split[j]);
                }
            }
            this.currentRules = null;
        }
    }

    int getCurrentPosition() {
        return this.position;
    }

    private boolean hasOneOfMedia(SACMediaList media, String[] choices) {
        if (media == null) {
            return false;
        }
        for (int i = 0; i < media.getLength(); ++i) {
            for (int j = 0; j < choices.length; ++j) {
                if (!media.item(i).equals(choices[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void ignorableAtRule(String atRule) throws CSSException {
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        if (!this.ignore && (media == null || this.hasOneOfMedia(media, new String[]{"all", "print"}))) {
            try {
                Parser parser = Util.getSacParser();
                URL url = this.baseUrl != null ? new URL(this.baseUrl, uri) : new URL(uri);
                RuleCollector importCollector = new RuleCollector(this.ruleEmitter, this.pageRules, url, this.position, this.offset);
                parser.setDocumentHandler(importCollector);
                parser.parseStyleSheet(url.toString());
                this.position = importCollector.getCurrentPosition();
            }
            catch (Exception e) {
                throw new CSSException(e);
            }
        }
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        this.prefixMap.put(prefix, uri);
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        block4: {
            Property[] properties;
            block5: {
                if (this.ignore) break block4;
                properties = new Property(name.toLowerCase(), value, important, this.prefixMap, this.baseUrl).split();
                if (this.currentRules == null) break block5;
                for (int i = 0; i < this.currentRules.length; ++i) {
                    for (int j = 0; j < properties.length; ++j) {
                        this.currentRules[i].addProperty(properties[j]);
                    }
                }
                break block4;
            }
            if (this.currentPageRule == null) break block4;
            for (int i = 0; i < properties.length; ++i) {
                LexicalUnit unit = properties[i].getLexicalUnit();
                if ("counter-reset".equals(properties[i].getName()) && unit.getLexicalUnitType() == 35 && "page".equals(unit.getStringValue()) && (unit.getNextLexicalUnit() == null || unit.getNextLexicalUnit().getLexicalUnitType() == 13)) {
                    properties[i] = unit.getNextLexicalUnit() == null ? new Property("initial-page-number", "1", properties[i].getImportant(), this.prefixMap) : new Property("initial-page-number", unit.getNextLexicalUnit(), properties[i].getImportant(), this.prefixMap, this.baseUrl);
                }
                this.currentPageRule.addProperty(properties[i]);
            }
        }
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void startMedia(SACMediaList media) throws CSSException {
        this.ignore = !this.hasOneOfMedia(media, new String[]{"all", "print"});
    }

    public void startPage(String name, String pseudoPage) throws CSSException {
        if (!this.ignore) {
            this.currentPageRule = new PageRule(name != null && pseudoPage != null ? pseudoPage + "-" + name : (name != null ? name : (pseudoPage != null ? pseudoPage : "unnamed")), this.position++);
        }
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        if (this.ignore || selectors.getLength() == 0) {
            this.currentRules = null;
            return;
        }
        this.currentRules = new Rule[selectors.getLength()];
        for (int i = 0; i < this.currentRules.length; ++i) {
            this.currentRules[i] = new Rule(selectors.item(i), this.position++, this.offset);
        }
    }

    static interface RuleEmitter {
        public void addRule(Rule var1);
    }
}

