/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util.logforwarder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.DefaultRepositorySelector;

public class Log4JRemover {
    private static final Logger logger = Logger.getLogger(Log4JRemover.class);

    public static void removeLogger(String name) {
        Log4JRemover.removeLogger(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogger(String name, Hierarchy hierarchy) {
        try {
            Hierarchy usedHierarchy;
            if (hierarchy == null) {
                Field repositorySelectorField = LogManager.class.getDeclaredField("repositorySelector");
                repositorySelectorField.setAccessible(true);
                DefaultRepositorySelector selector = (DefaultRepositorySelector)repositorySelectorField.get(null);
                Field repositoryField = DefaultRepositorySelector.class.getDeclaredField("repository");
                repositoryField.setAccessible(true);
                usedHierarchy = (Hierarchy)repositoryField.get(selector);
            } else {
                usedHierarchy = hierarchy;
            }
            Field htField = Hierarchy.class.getDeclaredField("ht");
            htField.setAccessible(true);
            Hashtable ht = (Hashtable)htField.get(usedHierarchy);
            Class<?> categoryKeyclazz = Class.forName("org.apache.log4j.CategoryKey");
            Constructor<?> categoryKeyConstructor = categoryKeyclazz.getDeclaredConstructor(String.class);
            categoryKeyConstructor.setAccessible(true);
            Object key = categoryKeyConstructor.newInstance(name);
            Hashtable hashtable = ht;
            synchronized (hashtable) {
                Logger logger = (Logger)ht.remove(key);
                if (logger != null) {
                    String parentLogger = null;
                    while ((parentLogger = Log4JRemover.getParentLogger(name)) != null) {
                        key = categoryKeyConstructor.newInstance(parentLogger);
                        Vector categoryEntries = (Vector)ht.get(key);
                        categoryEntries.remove(logger);
                        if (categoryEntries.isEmpty()) {
                            ht.remove(key);
                        }
                        name = parentLogger;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to access Log4J logger table, logger removal will be disabled", (Throwable)e);
        }
    }

    private static String getParentLogger(String loggerName) {
        if (loggerName.indexOf(".") >= 0) {
            return loggerName.substring(0, loggerName.lastIndexOf("."));
        }
        return null;
    }
}

