/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.web;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ow2.proactive.core.properties.PACommonProperties;
import org.ow2.proactive.core.properties.PACommonPropertiesHelper;
import org.ow2.proactive.core.properties.PropertyType;
import org.ow2.proactive.utils.PAPropertiesLazyLoader;

public enum WebProperties implements PACommonProperties
{
    REST_HOME("pa.rest.home", PropertyType.STRING),
    WEB_DEPLOY("web.deploy", PropertyType.BOOLEAN, "true"),
    WEB_HTTP_PORT("web.http.port", PropertyType.INTEGER, "8080"),
    WEB_HTTPS("web.https", PropertyType.BOOLEAN, "false"),
    WEB_HTTPS_ALLOW_ANY_CERTIFICATE("web.https.allow_any_certificate", PropertyType.BOOLEAN, "false"),
    WEB_HTTPS_ALLOW_ANY_HOSTNAME("web.https.allow_any_hostname", PropertyType.BOOLEAN, "false"),
    WEB_HTTPS_KEYSTORE("web.https.keystore", PropertyType.STRING, "config/web/keystore"),
    WEB_HTTPS_KEYSTORE_PASSWORD("web.https.keystore.password", PropertyType.STRING, "activeeon"),
    WEB_HTTPS_TRUSTSTORE("web.https.truststore", PropertyType.STRING),
    WEB_HTTPS_TRUSTSTORE_PASSWORD("web.https.truststore.password", PropertyType.STRING),
    WEB_HTTPS_PORT("web.https.port", PropertyType.INTEGER, "8443"),
    WEB_HTTPS_PROTOCOLS_INCLUDED("web.https.protocols.included", PropertyType.LIST, "TLSv1.2,TLSv1.3"),
    WEB_HTTPS_PROTOCOLS_EXCLUDED("web.https.protocols.excluded", PropertyType.LIST),
    WEB_HTTPS_CYPHERS_INCLUDED_ADD("web.https.cyphers.included.add", PropertyType.LIST),
    WEB_HTTPS_CYPHERS_EXCLUDED_ADD("web.https.cyphers.excluded.add", PropertyType.LIST, "TLS_DHE.*,TLS_EDH.*"),
    WEB_HTTPS_RENEGOTIATION_ALLOWED("web.https.renegotiation.allowed", PropertyType.BOOLEAN),
    WEB_HTTPS_SECURE_RANDOM_ALGORITHM("web.https.secure.random.algorithm", PropertyType.STRING),
    WEB_HTTPS_KEY_FACTORY_ALGORITHM("web.https.key.factory.algorithm", PropertyType.STRING),
    WEB_HTTPS_TRUST_FACTORY_ALGORITHM("web.https.trust.factory.algorithm", PropertyType.STRING),
    WEB_HTTPS_MAX_CERT_PATH("web.https.max.cert.path", PropertyType.INTEGER),
    WEB_HTTPS_CERT_ALIAS("web.https.cert.alias", PropertyType.STRING),
    WEB_HTTPS_ENABLE_CRLDP("web.https.enable.crldp", PropertyType.BOOLEAN),
    WEB_HTTPS_CRL_PATH("web.https.crl.path", PropertyType.STRING),
    WEB_HTTPS_ENABLE_OCSP("web.https.enable.ocsp", PropertyType.BOOLEAN),
    WEB_HTTPS_OCSP_RESPONDER_URL("web.https.ocsp.responder.url", PropertyType.STRING),
    WEB_HTTPS_SESSION_CACHING("web.https.session.caching", PropertyType.BOOLEAN),
    WEB_HTTPS_SESSION_CACHE_SIZE("web.https.session.cache.size", PropertyType.INTEGER),
    WEB_HTTPS_SESSION_TIMEOUT("web.https.session.timeout", PropertyType.INTEGER),
    WEB_MAX_THREADS("web.max_threads", PropertyType.INTEGER, "400"),
    WEB_IDLE_TIMEOUT("web.idle_timeout", PropertyType.INTEGER, "60000"),
    WEB_REQUEST_HEADER_SIZE("web.request_header_size", PropertyType.INTEGER, "8192"),
    WEB_REDIRECT_HTTP_TO_HTTPS("web.redirect_http_to_https", PropertyType.BOOLEAN, "false"),
    WEB_X_FRAME_OPTIONS("web.x_frame_options", PropertyType.STRING, "SAMEORIGIN"),
    WEB_X_XSS_PROTECTION("web.x_xss_protection", PropertyType.STRING, "1"),
    WEB_X_CONTENT_TYPE_OPTIONS("web.x_content_type_options", PropertyType.STRING, "nosniff"),
    WEB_STRICT_TRANSPORT_SECURITY("web.strict_transport_security", PropertyType.STRING, "max-age=63072000; includeSubDomains; preload"),
    WEB_EXPECT_CT("web.expect_ct", PropertyType.STRING),
    WEB_REFERRER_POLICY("web.referrer_policy", PropertyType.STRING, "strict-origin-when-cross-origin"),
    WEB_PCA_PROXY_REWRITE_ENABLED("web.pca.proxy.rewrite.enabled", PropertyType.BOOLEAN, "true"),
    WEB_PCA_PROXY_REWRITE_REFERER_CACHE_SIZE("web.pca.proxy.rewrite.referer.cache.size", PropertyType.INTEGER, "10000"),
    WEB_PCA_PROXY_REWRITE_EXCLUDED_PATHS("web.pca.proxy.rewrite.excluded.paths", PropertyType.LIST, "/automation-dashboard/,/studio/,/scheduler/,/rm/"),
    METADATA_CONTENT_TYPE("content.type", PropertyType.STRING),
    METADATA_FILE_NAME("file.name", PropertyType.STRING),
    METADATA_FILE_EXTENSION("file.extension", PropertyType.STRING),
    RESOURCE_DOWNLOADER_PROXY("resource.downloader.proxy", PropertyType.STRING),
    RESOURCE_DOWNLOADER_PROXY_PORT("resource.downloader.proxy.port", PropertyType.INTEGER),
    RESOURCE_DOWNLOADER_PROXY_SCHEME("resource.downloader.proxy.scheme", PropertyType.STRING),
    WAR_WRAPPER_HTTP_PORT("war.wrapper.target.server.http.port", PropertyType.INTEGER, "9080"),
    WAR_WRAPPER_HTTPS_PORT("war.wrapper.target.server.https.port", PropertyType.INTEGER, "9443"),
    WAR_WRAPPER_HTTPS_ENABLED("war.wrapper.https.enabled", PropertyType.BOOLEAN, "false"),
    WAR_WRAPPER_CONTEXT_ROOT("war.wrapper.context.root", PropertyType.STRING, "/"),
    JETTY_LOG_FILE("jetty.log.file", PropertyType.STRING),
    JETTY_LOG_RETAIN_DAYS("jetty.log.retain.days", PropertyType.INTEGER, "5"),
    SESSION_CLEANING_PERIOD("session.cleaning.period", PropertyType.INTEGER, "300"),
    SESSION_TIMEOUT("session.timeout", PropertyType.INTEGER, "3600");

    public static final String PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME = "pa.portal.configuration.filepath";
    public static final String PA_WEB_PROPERTIES_RELATIVE_FILEPATH = "config/web/settings.ini";
    private static PAPropertiesLazyLoader propertiesLoader;
    private static PACommonPropertiesHelper propertiesHelper;
    private String key;
    private PropertyType type;
    private String defaultValue;

    private WebProperties(String str, PropertyType type, String defaultValue) {
        this.key = str;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    private WebProperties(String str, PropertyType type) {
        this(str, type, null);
    }

    protected static void loadProperties(String filename) {
        propertiesLoader = new PAPropertiesLazyLoader(WebProperties.REST_HOME.key, PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME, PA_WEB_PROPERTIES_RELATIVE_FILEPATH, filename);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static void updateProperties(String filename) {
        propertiesHelper.updateProperties(filename);
    }

    public static Map<String, Object> getPropertiesAsHashMap() {
        return propertiesHelper.getPropertiesAsHashMap();
    }

    public static synchronized void load() {
        propertiesLoader = new PAPropertiesLazyLoader(WebProperties.REST_HOME.key, PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME, PA_WEB_PROPERTIES_RELATIVE_FILEPATH);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static synchronized void storeInSystemProperties() {
        System.setProperties(propertiesLoader.getProperties());
    }

    public static String getAbsolutePath(String userPath) {
        if (new File(userPath).isAbsolute()) {
            return userPath;
        }
        File pathName = new File(REST_HOME.getValueAsString(), userPath);
        try {
            return pathName.getCanonicalPath();
        }
        catch (IOException e) {
            return pathName.getAbsolutePath();
        }
    }

    public String getKey() {
        return this.key;
    }

    public void updateProperty(String value) {
        propertiesHelper.updateProperty(this.key, value);
    }

    public boolean isSet() {
        return propertiesHelper.isSet(this.key, this.defaultValue);
    }

    public void unSet() {
        propertiesHelper.unSet(this.key);
    }

    public String getCmdLine() {
        return propertiesHelper.getCmdLine(this.key);
    }

    public int getValueAsInt() {
        return propertiesHelper.getValueAsInt(this.key, this.type, this.defaultValue);
    }

    public long getValueAsLong() {
        return propertiesHelper.getValueAsLong(this.key, this.type, this.defaultValue);
    }

    public String getValueAsString() {
        return propertiesHelper.getValueAsString(this.key, this.defaultValue);
    }

    public String getValueAsStringOrNull() {
        return propertiesHelper.getValueAsStringOrNull(this.key);
    }

    public boolean getValueAsBoolean() {
        return propertiesHelper.getValueAsBoolean(this.key, this.type, this.defaultValue);
    }

    public List<String> getValueAsList(String separator) {
        return propertiesHelper.getValueAsList(this.key, this.type, separator, this.defaultValue);
    }

    public PropertyType getType() {
        return this.type;
    }

    public String toString() {
        return this.getValueAsString();
    }

    public String getConfigurationFilePathPropertyName() {
        return PA_WEB_PROPERTIES_FILEPATH_PROPERTY_NAME;
    }

    public String getConfigurationDefaultRelativeFilePath() {
        return PA_WEB_PROPERTIES_RELATIVE_FILEPATH;
    }

    public void loadPropertiesFromFile(String filename) {
        WebProperties.loadProperties(filename);
    }

    public void reloadConfiguration() {
        WebProperties.load();
    }

    static {
        WebProperties.load();
    }
}

