/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FileHeader;
import jdbm.recman.PageHeader;
import jdbm.recman.RecordFile;

final class PageManager {
    private RecordFile file;
    private FileHeader header;
    private BlockIo headerBuf;

    PageManager(RecordFile file) throws IOException {
        this.file = file;
        this.headerBuf = file.get(0L);
        this.header = this.headerBuf.readShort(0) == 0 ? new FileHeader(this.headerBuf, true) : new FileHeader(this.headerBuf, false);
    }

    long allocate(short type) throws IOException {
        if (type == 0) {
            throw new Error("allocate of free page?");
        }
        long retval = this.header.getFirstOf(0);
        boolean isNew = false;
        if (retval != 0L) {
            this.header.setFirstOf(0, this.getNext(retval));
        } else {
            retval = this.header.getLastOf(0);
            if (retval == 0L) {
                retval = 1L;
            }
            this.header.setLastOf(0, retval + 1L);
            isNew = true;
        }
        BlockIo buf = this.file.get(retval);
        PageHeader pageHdr = isNew ? new PageHeader(buf, type) : PageHeader.getView(buf);
        long oldLast = this.header.getLastOf(type);
        System.arraycopy(this.file.cleanData, 0, buf.getData(), 0, this.file.BLOCK_SIZE);
        pageHdr.setType(type);
        pageHdr.setPrev(oldLast);
        pageHdr.setNext(0L);
        if (oldLast == 0L) {
            this.header.setFirstOf(type, retval);
        }
        this.header.setLastOf(type, retval);
        this.file.release(retval, true);
        if (oldLast != 0L) {
            buf = this.file.get(oldLast);
            pageHdr = PageHeader.getView(buf);
            pageHdr.setNext(retval);
            this.file.release(oldLast, true);
        }
        buf.setView(null);
        return retval;
    }

    void free(short type, long recid) throws IOException {
        if (type == 0) {
            throw new Error("free free page?");
        }
        if (recid == 0L) {
            throw new Error("free header page?");
        }
        BlockIo buf = this.file.get(recid);
        PageHeader pageHdr = PageHeader.getView(buf);
        long prev = pageHdr.getPrev();
        long next = pageHdr.getNext();
        pageHdr.setType((short)0);
        pageHdr.setNext(this.header.getFirstOf(0));
        pageHdr.setPrev(0L);
        this.header.setFirstOf(0, recid);
        this.file.release(recid, true);
        if (prev != 0L) {
            buf = this.file.get(prev);
            pageHdr = PageHeader.getView(buf);
            pageHdr.setNext(next);
            this.file.release(prev, true);
        } else {
            this.header.setFirstOf(type, next);
        }
        if (next != 0L) {
            buf = this.file.get(next);
            pageHdr = PageHeader.getView(buf);
            pageHdr.setPrev(prev);
            this.file.release(next, true);
        } else {
            this.header.setLastOf(type, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNext(long block) throws IOException {
        try {
            long l = PageHeader.getView(this.file.get(block)).getNext();
            return l;
        }
        finally {
            this.file.release(block, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPrev(long block) throws IOException {
        try {
            long l = PageHeader.getView(this.file.get(block)).getPrev();
            return l;
        }
        finally {
            this.file.release(block, false);
        }
    }

    long getFirst(short type) throws IOException {
        return this.header.getFirstOf(type);
    }

    long getLast(short type) throws IOException {
        return this.header.getLastOf(type);
    }

    void commit() throws IOException {
        this.file.release(this.headerBuf);
        this.file.commit();
        this.headerBuf = this.file.get(0L);
        this.header = new FileHeader(this.headerBuf, false);
    }

    void rollback() throws IOException {
        this.file.discard(this.headerBuf);
        this.file.rollback();
        this.headerBuf = this.file.get(0L);
        this.header = this.headerBuf.readShort(0) == 0 ? new FileHeader(this.headerBuf, true) : new FileHeader(this.headerBuf, false);
    }

    void close() throws IOException {
        this.file.release(this.headerBuf);
        this.file.commit();
        this.headerBuf = null;
        this.header = null;
        this.file = null;
    }

    FileHeader getFileHeader() {
        return this.header;
    }
}

