/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.core.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CircularArrayList<E>
extends AbstractList<E>
implements List<E>,
Serializable {
    private static final int DEFAULT_SIZE = 5;
    protected E[] array;
    protected int head = 0;
    protected int tail = 0;
    protected int size = 0;
    private static final long serialVersionUID = 121L;

    public CircularArrayList() {
        this(5);
    }

    public CircularArrayList(int size) {
        this.array = new Object[size];
    }

    public CircularArrayList(Collection<E> c) {
        this.size = c.size();
        this.tail = c.size();
        this.array = new Object[c.size()];
        c.toArray(this.array);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CircularArray size=");
        sb.append(this.size);
        sb.append("\n");
        for (int i = 0; i < this.size; ++i) {
            sb.append("[");
            sb.append(this.convert(i));
            sb.append("]=>");
            sb.append(this.array[this.convert(i)]);
            sb.append(", ");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.array.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newData = new Object[newCapacity];
            this.toArray(newData);
            this.tail = this.size;
            this.head = 0;
            this.array = newData;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.array[this.convert(i)] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.array[this.convert(i)])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.array[this.convert(i)] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.array[this.convert(i)])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.size == 0) {
            return a;
        }
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (this.head < this.tail) {
            System.arraycopy(this.array, this.head, a, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.array, this.head, a, 0, this.array.length - this.head);
            System.arraycopy(this.array, 0, a, this.array.length - this.head, this.tail);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.array[this.convert(index)];
    }

    @Override
    public E set(int index, E element) {
        ++this.modCount;
        this.rangeCheck(index);
        int convertedIndex = this.convert(index);
        E oldValue = this.array[convertedIndex];
        this.array[convertedIndex] = element;
        return oldValue;
    }

    @Override
    public boolean add(E o) {
        ++this.modCount;
        this.ensureCapacity(this.size + 1 + 1);
        this.array[this.tail] = o;
        this.tail = (this.tail + 1) % this.array.length;
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        ++this.modCount;
        this.rangeCheck(index);
        int pos = this.convert(index);
        try {
            E e = this.array[pos];
            return e;
        }
        finally {
            this.array[pos] = null;
            if (pos == this.head) {
                this.head = (this.head + 1) % this.array.length;
            } else if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.array.length) % this.array.length;
            } else if (pos > this.head && pos > this.tail) {
                System.arraycopy(this.array, this.head, this.array, this.head + 1, pos - this.head);
                this.head = (this.head + 1) % this.array.length;
            } else {
                System.arraycopy(this.array, pos + 1, this.array, pos, this.tail - pos - 1);
                this.tail = (this.tail - 1 + this.array.length) % this.array.length;
            }
            --this.size;
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i != this.size; ++i) {
            this.array[this.convert((int)i)] = null;
        }
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.add(element);
            return;
        }
        ++this.modCount;
        this.rangeCheck(index);
        this.ensureCapacity(this.size + 1 + 1);
        int pos = this.convert(index);
        if (pos == this.head) {
            this.head = (this.head - 1 + this.array.length) % this.array.length;
            this.array[this.head] = element;
        } else if (pos == this.tail) {
            this.array[this.tail] = element;
            this.tail = (this.tail + 1) % this.array.length;
        } else if (pos > this.head && pos > this.tail) {
            System.arraycopy(this.array, this.head, this.array, this.head - 1, pos - this.head);
            this.array[pos - 1] = element;
            --this.head;
        } else {
            System.arraycopy(this.array, pos, this.array, pos + 1, this.tail - pos);
            this.tail = (this.tail + 1) % this.array.length;
            this.array[pos] = element;
        }
        ++this.size;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ++this.modCount;
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew + 1);
        for (int j = this.size; j >= index; --j) {
            int src = this.convert(j);
            int dst = this.convert(j + numNew);
            this.array[dst] = this.array[src];
        }
        Iterator<E> e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            this.array[this.convert((int)(index + i))] = e.next();
        }
        this.size += numNew;
        this.tail = (this.head + this.size) % this.array.length;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    private int convert(int index) {
        return (index + this.head) % this.array.length;
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

