# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SloUsageMetric(Model):
    """A Slo Usage Metric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar service_level_objective: The serviceLevelObjective for SLO usage
     metric. Possible values include: 'System', 'System0', 'System1',
     'System2', 'System3', 'System4', 'System2L', 'System3L', 'System4L',
     'Free', 'Basic', 'S0', 'S1', 'S2', 'S3', 'S4', 'S6', 'S7', 'S9', 'S12',
     'P1', 'P2', 'P3', 'P4', 'P6', 'P11', 'P15', 'PRS1', 'PRS2', 'PRS4',
     'PRS6', 'DW100', 'DW200', 'DW300', 'DW400', 'DW500', 'DW600', 'DW1000',
     'DW1200', 'DW1000c', 'DW1500', 'DW1500c', 'DW2000', 'DW2000c', 'DW3000',
     'DW2500c', 'DW3000c', 'DW6000', 'DW5000c', 'DW6000c', 'DW7500c',
     'DW10000c', 'DW15000c', 'DW30000c', 'DS100', 'DS200', 'DS300', 'DS400',
     'DS500', 'DS600', 'DS1000', 'DS1200', 'DS1500', 'DS2000', 'ElasticPool'
    :vartype service_level_objective: str or
     ~azure.mgmt.sql.models.ServiceObjectiveName
    :ivar service_level_objective_id: The serviceLevelObjectiveId for SLO
     usage metric.
    :vartype service_level_objective_id: str
    :ivar in_range_time_ratio: Gets or sets inRangeTimeRatio for SLO usage
     metric.
    :vartype in_range_time_ratio: float
    """

    _validation = {
        'service_level_objective': {'readonly': True},
        'service_level_objective_id': {'readonly': True},
        'in_range_time_ratio': {'readonly': True},
    }

    _attribute_map = {
        'service_level_objective': {'key': 'serviceLevelObjective', 'type': 'str'},
        'service_level_objective_id': {'key': 'serviceLevelObjectiveId', 'type': 'str'},
        'in_range_time_ratio': {'key': 'inRangeTimeRatio', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(SloUsageMetric, self).__init__(**kwargs)
        self.service_level_objective = None
        self.service_level_objective_id = None
        self.in_range_time_ratio = None
