# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NamespaceCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Namespace operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Namespace location.
    :type location: str
    :param sku:
    :type sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    :param tags: Namespace tags.
    :type tags: dict[str, str]
    :param status: State of the Namespace. Possible values include: 'Unknown',
     'Creating', 'Created', 'Activating', 'Enabling', 'Active', 'Disabling',
     'Disabled', 'SoftDeleting', 'SoftDeleted', 'Removing', 'Removed', 'Failed'
    :type status: str or
     ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
    :param provisioning_state: Provisioning state of the Namespace.
    :type provisioning_state: str
    :param created_at: The time the Namespace was created.
    :type created_at: datetime
    :param updated_at: The time the Namespace was updated.
    :type updated_at: datetime
    :param service_bus_endpoint: Endpoint you can use to perform Service Bus
     operations.
    :type service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics
    :vartype metric_id: str
    :param enabled: Specifies whether this instance is enabled.
    :type enabled: bool
    """

    _validation = {
        'location': {'required': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'NamespaceState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, *, location: str, sku=None, tags=None, status=None, provisioning_state: str=None, created_at=None, updated_at=None, service_bus_endpoint: str=None, enabled: bool=None, **kwargs) -> None:
        super(NamespaceCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.sku = sku
        self.tags = tags
        self.status = status
        self.provisioning_state = provisioning_state
        self.created_at = created_at
        self.updated_at = updated_at
        self.service_bus_endpoint = service_bus_endpoint
        self.metric_id = None
        self.enabled = enabled
