
# -*- coding: utf-8 -*-

u'''A Python version of part of I{Karney}'s C++ module U{GeodesicExactC4
<https://GeographicLib.SourceForge.io/C++/doc/classGeographicLib_1_1GeodesicExactC4.html>}.

Copyright (C) U{Charles Karney<mailto:Charles@Karney.com>} (2008-2022)
and licensed under the MIT/X11 License.  For more information, see the
U{GeographicLib<https://GeographicLib.SourceForge.io>} documentation.
'''
# See C{.geodesicx._C4_30.py} for a copy of comments from Karney's C{GeodesicExactC4.cpp}:

from pygeodesy.geodesicx.gxbases import _f, _f2

__all__ = ()
__version__ = '21.05.14'

_coeffs_24 = (  # GEOGRAPHICLIB_GEODESICEXACT_ORDER == 24
    # Generated by Maxima on 2017-05-27 10:17:57-04:00
    # C4[0], coeff of eps^23, polynomial in n of order 0
    2113, _f(34165005),
    # C4[0], coeff of eps^22, polynomial in n of order 1
    5189536, 1279278, _f(54629842995),
    # C4[0], coeff of eps^21, polynomial in n of order 2
    _f(19420000), -9609488, 7145551, _f(87882790905),
    # C4[0], coeff of eps^20, polynomial in n of order 3
    _f(223285780800), -_f(146003016320), _f(72167144896),
    _f(17737080900), _f(0x205dc0bcbd6d7),
    # C4[0], coeff of eps^19, polynomial in n of order 4
    _f(0x4114538e4c0), -_f(0x2f55bac3db0), _f(0x1ee26e63c60),
    -_f(0xf3f108c690), _f(777582423783), _f(0x19244124e56e27),
    # C4[0], coeff of eps^18, polynomial in n of order 5
    _f(0x303f35e1bc93a0), -_f(0x24e1f056b1d580),
    _f(0x1ab9fe0d1d4d60), -_f(0x1164c583e996c0),
    _f(0x892da1e80cb20), _f(0x2194519fdb596),
    _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^17, polynomial in n of order 6
    _f(0x4aad22c875ed20), -_f(0x3a4801a1c6bad0),
    _f(0x2c487fb318d4c0), -_f(0x1ff24d7cfd75b0),
    _f(0x14ba39245f1460), -_f(0xa32e190328e90),
    _f(0x78c93074dfcff), _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^16, polynomial in n of order 7
    _f(0x33d84b92096e100), -_f(0x286d35d824ffe00),
    _f(0x1f3d33e2e951300), -_f(0x178f58435181400),
    _f(0x10e7992a3756500), -_f(0xaed7fa8609aa00),
    _f(0x55d8ac87b09700), _f(0x14e51e43945a10),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^15, polynomial in n of order 8
    _f(0x577cdb6aaee0d80), -_f(0x4283c1e96325470),
    _f(0x32feef20b794020), -_f(0x26ea2e388de1a50),
    _f(0x1d13f6131e5d6c0), -_f(0x14b9aa66e270230),
    _f(0xd5657196ac0560), -_f(0x6880b0118a9810),
    _f(0x4d0f1755168ee7), _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^14, polynomial in n of order 9
    _f(0xa82410caed14920), -_f(0x774e0539d2de300),
    _f(0x57ddc01c62bc8e0), -_f(0x41de50dfff43e40),
    _f(0x31742450a1bdca0), -_f(0x248524531975180),
    _f(0x19d013c6e35ec60), -_f(0x1084c003a0434c0),
    _f(0x8103758ad86020), _f(0x1f2409edf5e286),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^13, polynomial in n of order 10
    _f(0x1c6d2d6120015ca0), -_f(0x104cedef383403b0),
    _f(0xab9dd58c3e3d880), -_f(0x78a4e83e5604750),
    _f(0x57aa7cf5406e460), -_f(0x4067a93ceeb2cf0),
    _f(0x2ed62190d975c40), -_f(0x20c076adcb21890),
    _f(0x14cfa9cb9e01c20), -_f(0xa1e25734956e30),
    _f(0x76afbfe4ae6c4d), _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^12, polynomial in n of order 11
    _f(0x500e39e18e75c40), -_f(0xb866fe4aaa63680),
    _f(0x4337db32e526ac0), -_f(0x264cce8c21af200),
    _f(0x18fb7ba247a4140), -_f(0x115709558576d80),
    _f(0xc5be96cd3dcfc0), -_f(0x8cdca1395db900),
    _f(0x611fe1a7e00640), -_f(0x3d26e46827e480),
    _f(0x1d93970a8fd4c0), _f(0x70bf87cc17354),
    _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^11, polynomial in n of order 12
    -_f(0x158a522ca96a9f40), _f(0x14d4e49882e048f0),
    _f(0x51a6258bc6026a0), -_f(0xc07af3677bdc6b0),
    _f(0x45ac09bc3b66080), -_f(0x275e4ef59a8b450),
    _f(0x195f928e5402a60), -_f(0x114aa7eeb31a3f0),
    _f(0xbf706c784da040), -_f(0x817ec7d97ab990),
    _f(0x508b8ca80cde20), -_f(0x26b120ea091930),
    _f(0x1c1ab3faf18ecd), _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^10, polynomial in n of order 13
    _f(0x85cd94c7a43620), _f(0x41534458719f180),
    -_f(0x1688b497e3eabf20), _f(0x15fa3ad6bcd8bd40),
    _f(0x531c27984875fa0), -_f(0xc9b33381ee39f00),
    _f(0x485a2b8a7ad1a60), -_f(0x286be979df41b40),
    _f(0x199b6e19072f920), -_f(0x10f769bc7a1af80),
    _f(0xb2b30e0b2b83e0), -_f(0x6d4c30bc0953c0),
    _f(0x3405b9397b42a0), _f(0xc1ffd0ada51be),
    _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^9, polynomial in n of order 14
    _f(0x77c3b2fb788360), _f(0x12370e8b6ebba50),
    _f(0x3ce89570a2d35c0), _f(0x1ddd463aa5801f30),
    -_f2(2652, 0xb61760f09fe0), _f2(2613, 0x24df88b461210),
    _f(0x24dea39341926e80), -_f(0x5ce704fae2f44110),
    _f(0x20ecef343dc3cce0), -_f(0x121947a4ab4bae30),
    _f(0xb2a76f84c78e740), -_f(0x70dd3a5c9a20950),
    _f(0x43604f2667d29a0), -_f(0x1fa7f2abdd82670),
    _f(0x169d55eb03244c1), _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^8, polynomial in n of order 15
    _f(0x21331eec152c80), _f(0x3c94fa87392d00),
    _f(0x7bff534019c580), _f(0x12eee208e5fe200),
    _f(0x3f965ae4945ee80), _f(0x1f56cb06e4e85700),
    -_f2(2802, 0x46e8e19f880), _f2(2796, 0xadb20bd4ec00),
    _f(0x251d0efe774e7080), -_f(0x625b74d58e27ff00),
    _f(0x224674d7e8ab8980), -_f(0x1260f3bdc69c0a00),
    _f(0xad7256a98d1b280), -_f(0x63bd65ce944d500),
    _f(0x2df89c0cd0d4b80), _f(0xa46618fc50ff08),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^7, polynomial in n of order 16
    _f(0xcb641c2517300), _f(0x1435342f6c1790),
    _f(0x2223c168d902a0), _f(0x3e90a70fac72b0),
    _f(0x80a310c4f84640), _f(0x13bcb7c20d40bd0),
    _f(0x42a5540b0e391e0), _f(0x210e40977bd376f0),
    -_f2(2980, 0x94d9def1cc680), _f2(3022, 0x503caf61c4810),
    _f(0x24d397da2b859120), -_f(0x68d822cc2f04ecd0),
    _f(0x23a043b28810ecc0), -_f(0x125159fafe6e93b0),
    _f(0x9e1bc8a31f5a060), -_f(0x46aed7b45d01890),
    _f(0x30c71f0f146542f), _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^6, polynomial in n of order 17
    _f(0x5c9c64c833ea0), _f(0x87cba49bc6200), _f(0xcee016a8ff560),
    _f(0x14a860e941a1c0), _f(0x231567934bf020),
    _f(0x40a648fc642980), _f(0x85b2123b2c36e0),
    _f(0x14a4159e5b98140), _f(0x462d226dee7d1a0),
    _f(0x2316888f6f2f3100), -_f2(3198, 0x3491a799c37a0),
    _f2(3311, 0xbf8f265e6c0c0), _f(0x2372de10575f2320),
    -_f(0x70af5543c56e4780), _f(0x24bbd6e6395ee9e0),
    -_f(0x116009bab4325fc0), _f(0x75b7dfa9c5a24a0),
    _f(0x17de90e4beab49e), _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^5, polynomial in n of order 18
    _f(0x6a525328e6e0), _f(0x93f17033fb30), _f(0xd36a04706f00),
    _f(0x137db4aaadad0), _f(0x1de17febed720), _f(0x300ece09a4c70),
    _f(0x5230537724340), _f(0x98911a7bab410), _f(0x13df6f0042d760),
    _f(0x317f809c6f75b0), _f(0xa9d28ba9acb780),
    _f(0x55d121ad9d8f550), -_f(0x1efee1555125f860),
    _f(0x21073529064696f0), _f(0x486394f46ccebc0),
    -_f(0x11777145e6374170), _f(0x54159fc268987e0),
    -_f(0x1fa4dd5835d2fd0), _f(0x13d87fc86cca643),
    _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^4, polynomial in n of order 19
    _f(0x3804d31f10c0), _f(0x4b2ec20ad280), _f(0x66f0ea418040),
    _f(0x903f2204b400), _f(0xcfad72d447c0), _f(0x134cb9fa41580),
    _f(0x1dd70e331b740), _f(0x306dd8a084700), _f(0x53a0a0b201ec0),
    _f(0x9cd7c33c89880), _f(0x14a7b599a9ce40),
    _f(0x340e256f2c5a00), _f(0xb4e7d2cf7515c0),
    _f(0x5cc8e678862db80), -_f(0x22304c48df63bac0),
    _f(0x25f7d3a888bb6d00), _f(0x3210c8a6905acc0),
    -_f(0x131873ea3222a180), _f(0x4a33217f63b9c40),
    _f(0xaa39109cb79b1c), _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^3, polynomial in n of order 20
    _f(0x1d8a60744340), _f(0x26a12f47d0f0), _f(0x3353c9ffe420),
    _f(0x4570fd193850), _f(0x5fe8194aa900), _f(0x87a7057de1b0),
    _f(0xc54ab4558de0), _f(0x12897a64b8910), _f(0x1d013b7f18ec0),
    _f(0x2fb033b96ea70), _f(0x5384f3e45a7a0), _f(0x9f10eb531c1d0),
    _f(0x154d17c994d480), _f(0x36ab828088cb30),
    _f(0xc1d47f99841160), _f(0x65b5717bb21c290),
    -_f(0x269fd1ef6edfa5c0), _f(0x2dc2d3f3f9f963f0),
    -_f(0xf46c321c1b54e0), -_f(0x14642b52c5fe94b0),
    _f(0x6b46a122c3b5c05), _f2(3071, 0xfdd7cc41833d5),
    # C4[0], coeff of eps^2, polynomial in n of order 21
    _f(0x65e46db33460), _f(0x82b39a7b3380), _f(0xa9e8c6cf36a0),
    _f(0xe0317d0fa0c0), _f(0x12cd0399df4e0), _f(0x19b576ed17600),
    _f(0x23ecb07d1c720), _f(0x33785d3e48b40), _f(0x4bedad56b0560),
    _f(0x73f4d1eccb880), _f(0xb8a5a1bdc07a0), _f(0x1359aad161d5c0),
    _f(0x22a518d96d25e0), _f(0x43a50f3643bb00),
    _f(0x95133a4d60b820), _f(0x18b02de0f4e4040),
    _f(0x5ac287501571660), _f(0x31a5fa2db58d3d80),
    -_f2(5087, 0xbd2e8f8d6760), _f2(6752, 0x2ce8487308ac0),
    -_f2(2184, 0x86ffdb3446920), -_f(0x199994ff919cd3b6),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[0], coeff of eps^1, polynomial in n of order 22
    _f(0xd0da1980ba0), _f(0x10803fb20d70), _f(0x151a70ced0c0),
    _f(0x1b569dc61a10), _f(0x23ecd2ce6de0), _f(0x2ff80cba60b0),
    _f(0x413672596700), _f(0x5a7b8b75a550), _f(0x8082f2984020),
    _f(0xbb859b75abf0), _f(0x11a6bf1637d40), _f(0x1b9a143813890),
    _f(0x2d2aacb8da260), _f(0x4e2c5253a0f30), _f(0x914a9e2ed3380),
    _f(0x128a302f4ef3d0), _f(0x2b2226f5e6b4a0),
    _f(0x7a36190e0daa70), _f(0x1e8d8643836a9c0),
    _f(0x129e3dd12414f710), -_f2(2184, 0x86ffdb3446920),
    _f2(3276, 0xca7fc8ce69db0), -_f(0x5999897e7da4e4fd),
    _f2(7167, 0xfaf78743878f1),
    # C4[0], coeff of eps^0, polynomial in n of order 23
    _f(0x71a68037fdf14), _f(0x81ebac5d53b48), _f(0x957440e8ac5fc),
    _f(0xad1ce56088670), _f(0xca0c260c189e4), _f(0xedd10e292f598),
    _f(0x11a912af9e18cc), _f(0x1534f4af92bec0),
    _f(0x19c5b078ed00b4), _f(0x1fc05a701dd7e8),
    _f(0x27bd1031afaf9c), _f(0x32a7dc61183710),
    _f(0x41fc58560eb384), _f(0x583759590a1238),
    _f(0x79bd058a3bfa6c), _f(0xaecdc650561f60),
    _f(0x108312ea2251254), _f(0x1abbd57b12fd488),
    _f(0x2fbd21c97d5693c), _f(0x634bf45b6b1a7b0),
    _f(0x11110dffb6688d24), _f(0x666653fe46734ed8),
    -_f2(5734, 0x625f9f69393f4), _f2(14335, 0xf5ef0e870f1e2),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[1], coeff of eps^23, polynomial in n of order 0
    3401, _f(512475075),
    # C4[1], coeff of eps^22, polynomial in n of order 1
    -5479232, 3837834, _f(163889528985),
    # C4[1], coeff of eps^21, polynomial in n of order 2
    -_f(1286021216), _f(571443856), _f(142575393), _f(0xef8343fb2e1),
    # C4[1], coeff of eps^20, polynomial in n of order 3
    -_f(237999188352), _f(138477414656), -_f(77042430080),
    _f(53211242700), _f(0x6119423638485),
    # C4[1], coeff of eps^19, polynomial in n of order 4
    -_f(0x2066cb6031fc0), _f(0x14c85e7394470), -_f(0xf6b8f35571e0),
    _f(0x6ad3f08040d0), _f(0x1aa3b2832565), _f(0x230f8ed873f29c63),
    # C4[1], coeff of eps^18, polynomial in n of order 5
    -_f(0x33e9644cad5b40), _f(0x22b6849ca6a500),
    -_f(0x1ce364ad2a4ec0), _f(0x104aaed8cf4680),
    -_f(0x949f0f8a89e40), _f(0x64bcf4df920c2),
    _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^17, polynomial in n of order 6
    -_f(0x50a85b2e2e4060), _f(0x36bb9aa442c6f0),
    -_f(0x3029aafbbe0440), _f(0x1dc29c0bd6ce90),
    -_f(0x16a422844d9020), _f(0x9763b8d8ca030),
    _f(0x25b8d7edff7eb), _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^16, polynomial in n of order 7
    -_f(0x3822c174e5c7e00), _f(0x25fbaf973d78c00),
    -_f(0x222a860fbdb7a00), _f(0x15dabd7a0984800),
    -_f(0x129f00215535600), _f(0xa0e9e0ae9b8400),
    -_f(0x5ee97a6d2d5200), _f(0x3eaf5acabd0e30),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^15, polynomial in n of order 8
    -_f(0x5ec1dcd7666b480), _f(0x3ed4935a3fd8cd0),
    -_f(0x38014f5e5d79960), _f(0x240af6a53256570),
    -_f(0x2049d0fb0404a40), _f(0x12efbc065d3f410),
    -_f(0xee9d804d5d8320), _f(0x5ed209adebbcb0),
    _f(0x1798ea7fdd6773), _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^14, polynomial in n of order 9
    -_f(0x19f69929deb8bc0), _f(0x1054723730b1600),
    -_f(0xdce6aeb616e040), _f(0x8c0069813d6480),
    -_f(0x7e59f70027c8c0), _f(0x4bea01551feb00),
    -_f(0x42bb28790cad40), _f(0x21dd61f97d4180),
    -_f(0x14f93d4343f5c0), _f(0xd58968a8df35e),
    _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^13, polynomial in n of order 10
    -_f(0x1ecd4a3794400de0), _f(0x101df33ec1bb0110),
    -_f(0xbc64ec7794b2980), _f(0x71d5f4e2a637ff0),
    -_f(0x625888ecafc7520), _f(0x3aa6879742ff4d0),
    -_f(0x3585f7f60d164c0), _f(0x1d18174ef21abb0),
    -_f(0x18117eb39416c60), _f(0x8df7a42ab2f090),
    _f(0x23413de9276581), _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^12, polynomial in n of order 11
    -_f(0x113775cb09582880), _f(0x5790112bb17c4700),
    -_f(0x204e01ed2b929d80), _f(0x1063af9e8d99cc00),
    -_f(0xc3ef805036ada80), _f(0x701a56aa2d31100),
    -_f(0x63910631abdcf80), _f(0x368e0c562512600),
    -_f(0x31ed34307286c80), _f(0x170e89cb9dd1b00),
    -_f(0xf5f0efdd07a180), _f(0x93fb623bde75e4),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^11, polynomial in n of order 12
    _f(0x13635f7860ae69c0), -_f(0x169d904d9d4691d0),
    -_f(0x2254277308cd9e0), _f(0xd20446e8d8a9710),
    -_f(0x4df2aedeefd1980), _f(0x25e2aff2baec9f0),
    -_f(0x1d3856fa2b08920), _f(0xf7cadc640f92d0),
    -_f(0xe3d2f6c9ad5cc0), _f(0x6e412eaf297db0),
    -_f(0x62000ef613c860), _f(0x201266fb021690),
    _f(0x7ee4c480c21e1), _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^10, polynomial in n of order 13
    -_f(0x5fe482817c4c40), -_f(0x3373730b4b79d00),
    _f(0x140f919171472640), -_f(0x17f10e5417ef9980),
    -_f(0x1b454cf244cf340), _f(0xdd42319af5c0200),
    -_f(0x530205145e450c0), _f(0x25eec00584a7d80),
    -_f(0x1e9e562555aaa40), _f(0xe85806d73b2100),
    -_f(0xde44387c5bb7c0), _f(0x581f06023d3480),
    -_f(0x421ccd71c33140), _f(0x245ff7208ef53a),
    _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^9, polynomial in n of order 14
    -_f(0x47f3709eaa4320), -_f(0xbb640bc2e1ae70),
    -_f(0x2a7854a3ead7b40), -_f(0x1701de8d91314210),
    _f2(2329, 0x5f8472b9624a0), -_f2(2855, 0xe7c1182872fb0),
    -_f(0x785bf95be998780), _f(0x66690260b30024b0),
    -_f(0x272595745774a3a0), _f(0x104f772bee315710),
    -_f(0xe11ad02f34b53c0), _f(0x5a192e055800370),
    -_f(0x58d8bfb781fbbe0), _f(0x17a156426e4c5d0),
    _f(0x5c88907e67c575), _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^8, polynomial in n of order 15
    -_f(0x1138d3e7324700), -_f(0x210a1008a4f200),
    -_f(0x47b7d2285e8500), -_f(0xbbe3dba17a1400),
    -_f(0x2aeb63e9e4cb300), -_f(0x1781d8a9c80b7600),
    _f2(2419, 0xe4212c9be8f00), -_f2(3063, 0xd7c230ad9b800),
    -_f(0x116171a56015f00), _f(0x6cc31b4079da8600),
    -_f(0x2af22cc657d11d00), _f(0xf75e4ec12d0a400),
    -_f(0xeb60cc0dd754b00), _f(0x472a49a74880200),
    -_f(0x4174f343c328900), _f(0x1ed324af4f2fd18),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^7, polynomial in n of order 16
    -_f(0xd56426d4f700), -_f(0x15fa65017d450),
    -_f(0x26ba18ad11e20), -_f(0x4a9605f1a58f0),
    -_f(0xa2b494aee2940), -_f(0x1ad07f38fd2390),
    -_f(0x62deb836d71c60), -_f(0x36d68c47bf27830),
    _f(0x167d3fa4abc50480), -_f(0x1d9b2fd161b99ad0),
    _f(0x13a59aea9293560), _f(0x10886ca52ccf3090),
    -_f(0x6e8a4c27dbf8dc0), _f(0x1f02cd8f1f8a5f0),
    -_f(0x2216230a1ac48e0), _f(0x5f13c815b08150),
    _f(0x1666b06ca8f56d), _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^6, polynomial in n of order 17
    -_f(0x2678d0ed9f140), -_f(0x39d0dbe263c00),
    -_f(0x5aa623a5216c0), -_f(0x95d2f30c44880),
    -_f(0x108ea4db631840), -_f(0x2005d27e0acd00),
    -_f(0x463ad5e0e22dc0), -_f(0xba80ab02c40180),
    -_f(0x2b67c47d5d48f40), -_f(0x186d6a49f7da1e00),
    _f2(2625, 0x9832921f08b40), -_f2(3627, 0xa72ee4675a80),
    _f(0x17be252bac67e9c0), _f(0x7a8f5366d9ba1100),
    -_f(0x38a15d77b043abc0), _f(0x9cd4e0bf35fec80),
    -_f(0xceae5004f176d40), _f(0x479bb2ae3c01dda),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^5, polynomial in n of order 18
    -_f(0x11dc9e54dea60), -_f(0x193ec5647cdf0),
    -_f(0x24bda460ceb00), -_f(0x3760182d9a010),
    -_f(0x5717ea0e54ba0), -_f(0x907095ecddc30),
    -_f(0x10063188dee040), -_f(0x1f228e862f9650),
    -_f(0x44adcde9a37ce0), -_f(0xb7cbf8f2d0e270),
    -_f(0x2b3f803c770f580), -_f(0x18c05d008644d490),
    _f2(2737, 0x3ce4b1d74e1e0), -_f2(4017, 0xdf79eceb980b0),
    _f(0x30ac41edd5123540), _f(0x7e3ade121a8e0530),
    -_f(0x45ec5d28a0fecf60), _f(0x3577aaf625fa910),
    _f(0x7292b77d2ccfc9), _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^4, polynomial in n of order 19
    -_f(0x14469ef39280), -_f(0x1b74a6d65900), -_f(0x25fc6724f380),
    -_f(0x35e25bf6c800), -_f(0x4eb76c6a3c80), -_f(0x771a92ddb700),
    -_f(0xbc1644489d80), -_f(0x13946cde25600),
    -_f(0x22eaf36054680), -_f(0x44349dbbbd500),
    -_f(0x976a625a56780), -_f(0x1989ef99e16400),
    -_f(0x6150e2c16e3080), -_f(0x38c68feccea3300),
    _f(0x1963a1a8e71b2e80), -_f(0x2849f713f5ed7200),
    _f(0xd30bac57bb18580), _f(0x105e1a36741daf00),
    -_f(0xc8c696e03b05b80), _f(0x1feab31d626d154),
    _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^3, polynomial in n of order 20
    -_f(0xa4172dfa1c0), -_f(0xd77fb109ed0), -_f(0x11fc3eda7860),
    -_f(0x1879b9235cf0), -_f(0x2209eb95db00), -_f(0x308bcfa5f110),
    -_f(0x47510fa29da0), -_f(0x6c88ffcf6f30), -_f(0xac6dd3019440),
    -_f(0x120fcca63eb50), -_f(0x206b8121592e0),
    -_f(0x3fc3a9ace7970), -_f(0x8ea4f3b556d80),
    -_f(0x18488ccc5b2d90), -_f(0x5db9d9787df820),
    -_f(0x37d6c7544511bb0), _f(0x1a02f9f8abfbf940),
    -_f(0x2d9fe91163ac57d0), _f(0x18b01234447992a0),
    _f(0x46ed1c414c80a10), -_f(0x57c56c90ceabfa7),
    _f2(9215, 0xf98764c489b7f),
    # C4[1], coeff of eps^2, polynomial in n of order 21
    -_f(0x2271f7278cc0), -_f(0x2c3f5c6ec900), -_f(0x399dc5a18140),
    -_f(0x4c2bebb96280), -_f(0x6670101499c0), -_f(0x8c75450f5400),
    -_f(0xc4e9f8733e40), -_f(0x11b3ff75a0580),
    -_f(0x1a3e7cf3fd6c0), -_f(0x2853a9e02df00),
    -_f(0x40b8bca6ccb40), -_f(0x6da2a9d234880),
    -_f(0xc6fc7477c83c0), -_f(0x18bdddb834aa00),
    -_f(0x37ff6cf7616840), -_f(0x9a5f4811c06b80),
    -_f(0x25bde21729de0c0), -_f(0x16ea24b2a28ff500),
    _f2(2841, 0x69c686bdbaac0), -_f2(5560, 0x9d73ff6dcae80),
    _f2(4369, 0xdffb6688d240), -_f(0x4cccbefeb4d67b22),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[1], coeff of eps^1, polynomial in n of order 22
    -_f(0xd0da1980ba0), -_f(0x10803fb20d70), -_f(0x151a70ced0c0),
    -_f(0x1b569dc61a10), -_f(0x23ecd2ce6de0), -_f(0x2ff80cba60b0),
    -_f(0x413672596700), -_f(0x5a7b8b75a550), -_f(0x8082f2984020),
    -_f(0xbb859b75abf0), -_f(0x11a6bf1637d40),
    -_f(0x1b9a143813890), -_f(0x2d2aacb8da260),
    -_f(0x4e2c5253a0f30), -_f(0x914a9e2ed3380),
    -_f(0x128a302f4ef3d0), -_f(0x2b2226f5e6b4a0),
    -_f(0x7a36190e0daa70), -_f(0x1e8d8643836a9c0),
    -_f(0x129e3dd12414f710), _f2(2184, 0x86ffdb3446920),
    -_f2(3276, 0xca7fc8ce69db0), _f(0x5999897e7da4e4fd),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[2], coeff of eps^23, polynomial in n of order 0
    10384, _f(854125125),
    # C4[2], coeff of eps^22, polynomial in n of order 1
    _f(61416608), 15713412, _f(0x35f1be97217),
    # C4[2], coeff of eps^21, polynomial in n of order 2
    _f(1053643008), -_f(709188480), _f(436906360), _f(0x18f301bf7f77),
    # C4[2], coeff of eps^20, polynomial in n of order 3
    _f(0x45823cb069c0), -_f(0x3dc56cd10180), _f(0x15b4532d4340),
    _f(0x5946b207ad8), _f(0xf72bf6e15a9abe5),
    # C4[2], coeff of eps^19, polynomial in n of order 4
    _f(0x1b1b08a8c6e00), -_f(0x1a1dea5249180), _f(0xc1b857255700),
    -_f(0x8a94db95d080), _f(0x5209b9749ec8),
    _f(0x3a6f4368c13f04a5),
    # C4[2], coeff of eps^18, polynomial in n of order 5
    _f(0x13c972f90d64d60), -_f(0x12d8369dbbbb080),
    _f(0xa013fa80d7c1a0), -_f(0x95d1a2bb4de840),
    _f(0x30a495fb9aa5e0), _f(0xc95efc891d64c),
    _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^17, polynomial in n of order 6
    _f(0x4b31e4eff4bc00), -_f(0x4190c8b5d5de00),
    _f(0x27770ac0842800), -_f(0x270a0d33995200),
    _f(0x10c9f01b859400), -_f(0xd056352974600),
    _f(0x74f9dc1f6f260), _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^16, polynomial in n of order 7
    _f(0x39908ef33285d00), -_f(0x2a7d467835cbe00),
    _f(0x1e0505551ade700), -_f(0x1bf3204cf26d400),
    _f(0xe195527d96f100), -_f(0xe0af5ccd52ea00),
    _f(0x41681113e87b00), _f(0x1112b429bab2a0),
    _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^15, polynomial in n of order 8
    _f(0xf8fa0142055000), -_f(0x8f8aa7832e8a00),
    _f(0x7d6f3ddfb47c00), -_f(0x62d1e182b7be00),
    _f(0x3bb149eddea800), -_f(0x3be3b3e26a7200),
    _f(0x175d0d17dad400), -_f(0x14371cfc4fa600),
    _f(0xa8f8f5855a060), _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^14, polynomial in n of order 9
    _f(0x21490cd145715e0), -_f(0xe087822f191900),
    _f(0xf91f2bb3d29820), -_f(0x949428c90dc2c0),
    _f(0x7371ad50b34a60), -_f(0x63c52e9a850c80),
    _f(0x301579a22c8ca0), -_f(0x33552a69ca1640),
    _f(0xcc2c8c733bee0), _f(0x35f5f30acfbec),
    _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^13, polynomial in n of order 10
    _f(0x29bb6acaa073ef00), -_f(0xc930d526d728e80),
    _f(0xf55c2b3103d0c00), -_f(0x63b9281a5449980),
    _f(0x6acdfd5dbb92900), -_f(0x441c8fce3be0480),
    _f(0x2be797a45cb8600), -_f(0x2aec3395f438f80),
    _f(0xec70ff5d376300), -_f(0xedc27143c9fa80),
    _f(0x7039bcd0124e68), _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^12, polynomial in n of order 11
    -_f(0x17ce935fc610ad40), -_f(0x5d5bbde81a902580),
    _f(0x2dcc12fb45c89240), -_f(0xc1c61e98a479e00),
    _f(0x10183633a5ddf1c0), -_f(0x672de318faa1680),
    _f(0x64ee85310393140), -_f(0x481cf983db0cf00),
    _f(0x2299f24f52810c0), -_f(0x271fc56086d0780),
    _f(0x79dac155045040), _f(0x20c44d35dada38),
    _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^11, polynomial in n of order 12
    -_f(0x6b8bdbaa2666e600), _f2(2706, 0x6d4e4332c7e80),
    -_f(0x201eb2939ffc7500), -_f(0x605f6d97c740b880),
    _f(0x32fb1ca66ccebc00), -_f(0xb85f2dd585e0f80),
    _f(0x10b7dbe9dec0ed00), -_f(0x6e454f6a0fd4680),
    _f(0x594f6f139205e00), -_f(0x4c204810d601d80),
    _f(0x16a875347934f00), -_f(0x1be72589c185480),
    _f(0xb5a396e2ccd788), _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^10, polynomial in n of order 13
    _f(0x332d666e095e20), _f(0x205e97ebfb32780),
    -_f(0xf80bf36cd359f20), _f(0x19615ff8d71e0640),
    -_f(0x61aef235a414c60), -_f(0xe1fda0393083b00),
    _f(0x83e2ad192fc7660), -_f(0x18ece140ef0fc40),
    _f(0x26bbb213037c920), -_f(0x11a4c9418dd9d80),
    _f(0x9ec708de66cbe0), -_f(0xaee5994e9b7ec0),
    _f(0x1626e135e59ea0), _f(0x610ef2b6b35c4),
    _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^9, polynomial in n of order 14
    _f(0x1b709db1871200), _f(0x51a2a024c26b00),
    _f(0x157c554050bb400), _f(0xddb41f944653d00),
    -_f(0x6d182f563006aa00), _f2(2991, 0xf7eb0ae304f00),
    -_f(0x387b65599c618800), -_f(0x64242336a83ddf00),
    _f(0x4282c6eaa3899a00), -_f(0xa8fc3afb1e6cd00),
    _f(0x1040dddbf0493c00), -_f(0x9184bc07b2bfb00),
    _f(0x281ea22622bde00), -_f(0x3dc59bc648ee900),
    _f(0x13fb78815b4ca90), _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^8, polynomial in n of order 15
    _f(0xacc0646b5180), _f(0x1753663f74b00), _f(0x3994d0061e480),
    _f(0xadc1fbdd72e00), _f(0x2e87a44adab780),
    _f(0x1eaeb3451821100), -_f(0xf937e414930b580),
    _f(0x1c27d8b21df37400), -_f(0xaa5908f76fee280),
    -_f(0xe1c8d327ee92900), _f(0xb2675f22d49b080),
    -_f(0x19e66cd66684600), _f(0x1f3a47aa5ea8380),
    -_f(0x18da246c74e6300), _f(0x10dd3b80dd1680),
    _f(0x3f21f272d2a30), _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^7, polynomial in n of order 16
    _f(0x2957d7da1000), _f(0x4c28ba8a3700), _f(0x9714a6610e00),
    _f(0x14a5ff52a4500), _f(0x33af2f78d8c00), _f(0x9e87298409300),
    _f(0x2b4e15dbd10a00), _f(0x1d4c6da210ea100),
    -_f(0xf6c4a6847e2f800), _f(0x1da98c51a6b5ef00),
    -_f(0xe1270d810dcfa00), -_f(0xd23a021f3080300),
    _f(0xd3b280b26948400), -_f(0x22fd890d309b500),
    _f(0x119ef453c630200), -_f(0x1959af9980da700),
    _f(0x5959078fa70870), _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^6, polynomial in n of order 17
    _f(0x511612baa2a0), _f(0x87a79de92a00), _f(0xee2dd20af160),
    _f(0x1bbcfaf32f4c0), _f(0x37ba524fb5020), _f(0x7b9b8f2a45f80),
    _f(0x13a76fcf6fdee0), _f(0x3d717a0fbe0a40),
    _f(0x112dc752f02bda0), _f(0xbfa002cc4689500),
    -_f(0x694405622017f3a0), _f2(3484, 0x979f3cbb89fc0),
    -_f2(2088, 0x4fe2045ae14e0), -_f(0x49f87439584d3580),
    _f(0x6c3e90c1455479e0), -_f(0x1afff07538f04ac0),
    -_f(0x1a0f4cdf3b62760), -_f(0x112f9b85f9ebf7c),
    _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^5, polynomial in n of order 18
    _f(0x181437e05500), _f(0x25c7b1fe6a80), _f(0x3d5ebd606800),
    _f(0x67dd27f0e580), _f(0xb8ac7d2a7b00), _f(0x15ce71e5cc080),
    _f(0x2c7c6a3654e00), _f(0x6460c05d0bb80), _f(0x1046637cd7a100),
    _f(0x340d46956b9680), _f(0xef5f1bde883400),
    _f(0xacec6aed73c1180), -_f(0x63ea680d7ea23900),
    _f2(3605, 0xecc3861a0ec80), -_f2(2759, 0xc804a6c40e600),
    -_f(0x212a787bd0571880), _f(0x70c6a0884332ed00),
    -_f(0x31a5fa2db58d3d80), _f(0x5033807138f7d98),
    _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^4, polynomial in n of order 19
    _f(0x6f3f0983c40), _f(0xa6cf9192980), _f(0x100e50e166c0),
    _f(0x197f658cec00), _f(0x29f706a6f140), _f(0x480b7a0eae80),
    _f(0x821ecd9c1bc0), _f(0xfa1d1da0b100), _f(0x2081a78802640),
    _f(0x4aefd4add3380), _f(0xc730805b650c0), _f(0x28f491e04e7600),
    _f(0xc2d07512dddb40), _f(0x92e539684c6b880),
    -_f(0x5a2096cfc695fa40), _f2(3598, 0x9cd1e91b83b00),
    -_f2(3553, 0x1d49601c5efc0), _f(0x31a5fa2db58d3d80),
    _f(0x3760835a5e313ac0), -_f(0x1bed5cb9b61f7298),
    _f2(107519, 0xb480ecf4f161f),
    # C4[2], coeff of eps^3, polynomial in n of order 20
    _f(273006835200), _f(395945493120), _f(586817304320),
    _f(891220401024), _f(0x1440886f800), _f(0x20a73015480),
    _f(0x36a4a027900), _f(0x5f8b4acad80), _f(0xb01798c3a00),
    _f(0x15a2eb8a6680), _f(0x2e235b147b00), _f(0x6d6a30f2bf80),
    _f(0x12c54474b7c00), _f(0x40129870df880), _f(0x13e41ecc817d00),
    _f(0xfcf67c8cf45180), -_f(0xa65f288fe794200),
    _f(0x1cea83a477ce0a80), -_f(0x240239aaff748100),
    _f(0x1547221396f36380), -_f(0x4e04d247d427178),
    _f2(15359, 0xf536fd4790329),
    # C4[2], coeff of eps^2, polynomial in n of order 21
    _f(317370445920), _f(448806691200), _f(646426411680),
    _f(950282020800), _f(0x14ccaecc4e0), _f(0x201acdf4e00),
    _f(0x33093819720), _f(0x53ed06eb440), _f(0x8f8eb441960),
    _f(0x1013bf0bfa80), _f(0x1e750d7baba0), _f(0x3dc4346800c0),
    _f(0x88729901ade0), _f(0x150e863aba700), _f(0x3c89c1e8d8020),
    _f(0xd9efed463cd40), _f(0x47e39644808260),
    _f(0x3d1b0c8706d5380), -_f(0x2af704cef0cdeb60),
    _f(0x7c1ef17245e119c0), -_f2(2184, 0x86ffdb3446920),
    _f(0x333329ff2339a76c), _f2(107519, 0xb480ecf4f161f),
    # C4[3], coeff of eps^23, polynomial in n of order 0
    70576, _f(29211079275),
    # C4[3], coeff of eps^22, polynomial in n of order 1
    -_f(31178752), _f(16812224), _f(0x192c8c2464f),
    # C4[3], coeff of eps^21, polynomial in n of order 2
    -_f(135977211392), _f(37023086848), _f(9903771944),
    _f(0xb98f5d0044051),
    # C4[3], coeff of eps^20, polynomial in n of order 3
    -_f(0x30f8b0f5c00), _f(0x12d79f66800), -_f(0x115c7023400),
    _f(606224480400), _f(0xa7c6f527b4f7c7),
    # C4[3], coeff of eps^19, polynomial in n of order 4
    -_f(0x3317d68847dc00), _f(0x19fc69dd236700),
    -_f(0x1c6d14df7ace00), _f(0x6cfe4fac52d00),
    _f(0x1d99f24357808), _f2(30105, 0x847604e86c8c1),
    # C4[3], coeff of eps^18, polynomial in n of order 5
    -_f(0x15b0eba45ef8000), _f(0xf79bdd24a10000),
    -_f(0xf32a8559288000), _f(0x563281b24a8000),
    -_f(0x5920796c2f8000), _f(0x29f7b73471c480),
    _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^17, polynomial in n of order 6
    -_f(0x1c02d0336ef1800), _f(0x1d91ba24525dc00),
    -_f(0x163d203e4811000), _f(0xb8e8b252aa8400),
    -_f(0xd2485de6110800), _f(0x2a40e341b4ac00),
    _f(0xbb70f2cbcf360), _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^16, polynomial in n of order 7
    -_f(0x58b4aa16ae3000), _f(0x7fa0a14380e000),
    -_f(0x429ab6e3829000), _f(0x383428ed0d4000),
    -_f(0x32e93ebd99f000), _f(0x108fe88bbda000),
    -_f(0x13ba86ffa65000), _f(0x868b4ab8e3340),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[3], coeff of eps^15, polynomial in n of order 8
    -_f(0xaedfc7febee000), _f(0xe403ca9386ec00),
    -_f(0x5568aa53f7a800), _f(0x76f3d9af940400),
    -_f(0x475f28b7bb7000), _f(0x29018461d69c00),
    -_f(0x2ed89591f13800), _f(0x74380445fb400),
    _f(0x21274712bcba0), _f2(21503, 0xf0e695ca96ad3),
    # C4[3], coeff of eps^14, polynomial in n of order 9
    -_f(0x231ca125e5c8000), _f(753027184687 << 17),
    -_f(0x97f88531f38000), _f(0xee839ade908000),
    -_f(0x572a9cdd748000), _f(0x65a05d4f5f0000),
    -_f(0x4ce11756538000), _f(0x177f524c958000),
    -_f(0x20e57338048000), _f(0xc4518e260f380),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[3], coeff of eps^13, polynomial in n of order 10
    -_f(0x44ebd4477ad4f200), _f(0x9a6a6024b320f00),
    -_f(0xe915ce102d6a800), _f(0xb28d5273bcee100),
    -_f(0x37fa968ec235e00), _f(0x68974b850671300),
    -_f(0x2a735b9bf505400), _f(0x20513dd7a7f6500),
    -_f(0x220360a9be2ca00), _f(0x36d1c1a3f49700),
    _f(0x10369a2227fd98), _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^12, polynomial in n of order 11
    _f(0x52462bb828351400), _f(0x4a4d1c14e6172800),
    -_f(0x4ced32c430d22400), _f(0xb52b1b0c2492000),
    -_f(0xd058359466b1c00), _f(0xd07709dd3bd1800),
    -_f(0x30072e56aae5400), _f(0x605c027d5629000),
    -_f(0x32e58b8ebb44c00), _f(0x108221f23a90800),
    -_f(0x1a7ac7295958400), _f(0x836be4086f28d0),
    _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^11, polynomial in n of order 12
    _f(0x48f7bc8748dd3400), -_f2(2561, 0x7f9f9673a4700),
    _f(0x601d0ed1c7f2b600), _f(0x449204e4f86d4300),
    -_f(0x56194f80f81a8800), _f(0xea108cfa6f6ed00),
    -_f(0xa7ad46bd016c600), _f(0xef32c344e507700),
    -_f(0x30a1762ff0e4400), _f(0x4a78ea25c4fa100),
    -_f(0x3c3cca9d1bd4200), _f(0x22cbd76a022b00),
    _f(0x9df3abb037278), _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^10, polynomial in n of order 13
    -_f(0x9607df2a17c000), -_f(0x739371b7f3d8000),
    _f(0x4688c366039fc000), -_f2(2611, 0x8a66cbfc04000),
    _f(0x7056fbc7b1c24000), _f(0x3af7506941670000),
    -_f(0x601cadbaecf24000), _f(0x14affbea17164000),
    -_f(0x6daccbfd0bfc000), _f(0x1036680bb42b8000),
    -_f(0x42f04a7d6e84000), _f(0x246d9b6ab84c000),
    -_f(0x37cce3b53adc000), _f(0xd43660c7def0c0),
    _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^9, polynomial in n of order 14
    -_f(0x115a7e31ff400), -_f(0x3c90c47c29600),
    -_f(0x1311ab10640800), -_f(0xf2246746703a00),
    _f(0x99b5e8c5c68e400), -_f(0x179a6d9c8ead9e00),
    _f(0x12bd250608495000), _f(0x63777cc9563be00),
    -_f(0xf1ef7972c204400), _f(0x47367775d725a00),
    -_f(0x63378c7bb15800), _f(0x22d63078c5cb600),
    -_f(0xf8707c83e76c00), -_f(0xb0e06786eae00),
    -_f(0x5e4438ea922f0), _f2(21503, 0xf0e695ca96ad3),
    # C4[3], coeff of eps^8, polynomial in n of order 15
    -_f(0x1fe011d85800), -_f(0x4f422fb05000), -_f(0xe40060fc8800),
    -_f(0x32e664e9c2000), -_f(0x1078ec0ef63800),
    -_f(0xd864902b71f000), _f(0x8fab71292d19800),
    -_f(0x179bbec0170ac000), _f(0x15c925f1e4f1e800),
    _f(0x2c36e0d96c07000), -_f(0x100d07856dfe4800),
    _f(0x6d9c3efea16a000), -_f(0x13ac4a3567f800),
    _f(0x15b22a4de1ed000), -_f(0x1452d18e2b42800),
    _f(0x32eab893d697a0), _f2(21503, 0xf0e695ca96ad3),
    # C4[3], coeff of eps^7, polynomial in n of order 16
    -_f(0x5003ad66000), -_f(0xa79ae296200), -_f(0x17d9e9f5d400),
    -_f(0x3c8762ad2600), -_f(0xb232a56ac800), -_f(0x28dbf6ee52a00),
    -_f(0xda6199e36bc00), -_f(0xba74c6aa46ee00),
    _f(0x825959cb764d000), -_f(0x17232e4c4e57f200),
    _f(0x190bf0598fc65c00), -_f(0x27c51cb844db600),
    -_f(0xf8735fc98339800), _f(0xa28217eef524600),
    -_f(0xfc87c9cb4a8c00), -_f(0x3228ffc0ed7e00),
    -_f(0x387bf611406670), _f2(21503, 0xf0e695ca96ad3),
    # C4[3], coeff of eps^6, polynomial in n of order 17
    -_f(0x62d694dc000), -_f(97716157 << 17), -_f(0x173b38f24000),
    -_f(0x319b0ca1c000), -_f(0x7361a893c000), -_f(0x12be5bef38000),
    -_f(0x38b3402cc4000), -_f(0xd6a4403694000),
    -_f(0x4a69cc1535c000), -_f(0x42816c266fd0000),
    _f(0x315cb6a39d95c000), -_f2(2449, 0xcf91c36a8c000),
    _f2(3143, 0x2391393fc4000), -_f(0x466890d45f668000),
    -_f(0x50368754849c4000), _f(0x594b313771cfc000),
    -_f(0x1cc16f4e99cdc000), _f(0x1e8d8643836a9c0),
    _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^5, polynomial in n of order 18
    -_f(0x1136c8f5600), -_f(0x1e3b013df00), -_f(0x37550c23000),
    -_f(0x6a508e10100), -_f(0xd872daf0a00), -_f(0x1d8dd6618300),
    -_f(0x468422b6a400), -_f(0xbc9d06f02500), -_f(0x24d784d09be00),
    -_f(0x90d122dffa700), -_f(0x347ca809f91800),
    -_f(0x31861ec3b2ac900), _f(0x276d051382ba8e00),
    -_f2(2163, 0x55347fa444b00), _f2(3319, 0x8d7da907400),
    -_f2(2191, 0xdbae56666ed00), -_f(0x47e396448082600),
    _f(0x3577aaf625fa9100), -_f(0x1449fb28d544cb98),
    _f2(150527, 0x964e188a1ebc5),
    # C4[3], coeff of eps^4, polynomial in n of order 19
    -_f(58538142720), -_f(97662466048), -_f(168340530176),
    -_f(301206585344), -_f(562729180160), -_f(0x1017e988800),
    -_f(0x21987b95400), -_f(0x4b78a99d000), -_f(0xb9ccd9f8c00),
    -_f(0x202de3701800), -_f(0x68b6655d0400), -_f(0x1af3df037e000),
    -_f(0xa515b5f563c00), -_f(0xa65924698da800),
    _f(0x8fc72c890104c00), -_f(0x226e597c6e0df000),
    _f(0x3ee7237bf0721400), -_f(0x3d1b0c8706d53800),
    _f(0x1e8d8643836a9c00), -_f(0x634bf45b6b1a7b0),
    _f2(50175, 0xdcc4b2d8b4e97),
    # C4[3], coeff of eps^3, polynomial in n of order 20
    -_f(16545868800), -_f(26558972160), -_f(43799006720),
    -_f(74458311424), -_f(131016159232), -_f(239806362880),
    -_f(459418505728), -_f(928488660736), -_f(0x1d19ea9f400),
    -_f(0x43b761f2900), -_f(0xad7cf6b5600), -_f(0x1f71d9841300),
    -_f(0x6bcf7c0df800), -_f(0x1d7abbebd1d00),
    -_f(0xc1b8d2e919a00), -_f(0xd3e226aef40700),
    _f(0xc94a0b2634a0400), -_f(0x3577aaf625fa9100),
    _f(0x6aef55ec4bf52200), -_f(0x634bf45b6b1a7b00),
    _f(0x22221bff6cd11a48), _f2(150527, 0x964e188a1ebc5),
    # C4[4], coeff of eps^23, polynomial in n of order 0
    567424, _f(87633237825),
    # C4[4], coeff of eps^22, polynomial in n of order 1
    _f(2135226368), _f(598833664), _f(0x1358168b64fd9),
    # C4[4], coeff of eps^21, polynomial in n of order 2
    _f(23101878272), -_f(26986989568), _f(11760203136),
    _f(0x4f869592664b5),
    # C4[4], coeff of eps^20, polynomial in n of order 3
    _f(0xa4d4b674a00), -_f(0xbdc38ed8400), _f(0x20274dfee00),
    _f(635330794560), _f(0x436914c918b5d6d),
    # C4[4], coeff of eps^19, polynomial in n of order 4
    _f(0x481bf9079c000), -_f(0x3c015f7917000), _f(0x133447522e000),
    -_f(0x195b19983d000), _f(0xa0f15f7a8700),
    _f2(3518, 0xd3a367a37a66d),
    # C4[4], coeff of eps^18, polynomial in n of order 5
    _f(0x1e9f26efa689000), -_f(0x100c94382c2c000),
    _f(0xabead3c2e1f000), -_f(0xc04c79a6f96000),
    _f(0x18fb8548735000), _f(0x76d40a3ef6c00),
    _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^17, polynomial in n of order 6
    _f(0x780536a0606000), -_f(0x28779739e97000),
    _f(0x3a9fdf130c4000), -_f(0x2860390cb81000),
    _f(0xcce73d3902000), -_f(0x1322aa5844b000),
    _f(0x6bd0a3ad69900), _f2(27647, 0xec962e4d9d27d),
    # C4[4], coeff of eps^16, polynomial in n of order 7
    _f(0x45af61c2ad1f800), -_f(0x1b140a5252fd000),
    _f(0x348e789bd7f6800), -_f(0x137ac7aed3be000),
    _f(0x11da35dc2ded800), -_f(0x12097ef153ff000),
    _f(0x186b19645c4800), _f(0x7935fe20ccb00),
    _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^15, polynomial in n of order 8
    _f(0x788485be348000), -_f(0xbf417480965000),
    _f(0xbdad05e3bd6000), -_f(0x306dcc448df000),
    _f(0x6c08266aea4000), -_f(0x364dbd52879000),
    _f(0x13468d692f2000), -_f(0x1f6575294f3000),
    _f(0x97982d7211100), _f2(27647, 0xec962e4d9d27d),
    # C4[4], coeff of eps^14, polynomial in n of order 9
    _f(0x99754be5293000), -_f(0x273b2ae73028000),
    _f(0xa610233e31d000), -_f(0x8ee7336f99e000),
    _f(0xd7a1a110827000), -_f(0x2f0d74b9c14000),
    _f(0x4f375451ab1000), -_f(0x4002b6db48a000),
    _f(0x20d804cbbb000), _f(0xa41d3b221400),
    _f2(27647, 0xec962e4d9d27d),
    # C4[4], coeff of eps^13, polynomial in n of order 10
    _f(0x6016f6408271a000), -_f(0x1e7546e7a0d1b000),
    _f(0x18e4e98f72c8000), -_f(0x113f96068e695000),
    _f(0x6af41cd57176000), -_f(0x2590480c1d6f000),
    _f(0x61253410a664000), -_f(0x1c92661c6269000),
    _f(0xfa686d5b4d2000), -_f(0x188238347643000),
    _f(0x60544135abb900), _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^12, polynomial in n of order 11
    -_f2(2096, 0xf9dac0e4d8600), -_f(0xa96847f4d191400),
    _f(0x644f115411ee9e00), -_f(0x2912ee32dfa61000),
    -_f(0x81eeabcb01be00), -_f(0xfba8345c9670c00),
    _f(0x9bbda8340726600), -_f(0x11537009b3f0800),
    _f(0x51c2ea8aa8c0a00), -_f(0x2bb89caf7310400),
    -_f(0x162bd9b163d200), -_f(0xac0895744a3c0),
    _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^11, polynomial in n of order 12
    -_f(0x296aa6e320b86000), _f(0x7d9f9f72af514800),
    -_f2(2284, 0xfefdd7e855000), _f(0x8d22edc50949800),
    _f(0x6581767b41ffc000), -_f(0x371ad32683bb1800),
    -_f(0x915b5d6cd33000), -_f(0xbce7db3a027c800),
    _f(0xd0ebaf65b57e000), -_f(0x1274db255bb7800),
    _f(0x2970a5137d6f000), -_f(0x30b8535f9002800),
    _f(0x8fa21d365c3780), _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^10, polynomial in n of order 13
    _f(0x73aaee373e800), _f(0x6d942f05126000),
    -_f(0x55d059f7fa72800), _f(0x114ee97e0f335000),
    -_f(0x16053fa9ce763800), _f(0x4d23952dbcc4000),
    _f(0xdda0de6f17eb800), -_f(0xa56bf33e63ad000),
    _f(0x90dadc83efa800), -_f(0xbf52dd8df9e000),
    _f(0x2172ab2d7549800), -_f(0x85ae20f708f000),
    -_f(0x10c904999a7800), -_f(0xae78582fbfa00),
    _f2(27647, 0xec962e4d9d27d),
    # C4[4], coeff of eps^9, polynomial in n of order 14
    _f(0x19fde85a2f000), _f(0x6b4aa2bef4800), _f(0x28c46a7eab6000),
    _f(0x2827ed076a87800), -_f(0x210a7394d5283000),
    _f(0x72396f4bbfb2a800), -_f2(2620, 0x4dc0771ddc000),
    _f(0x40dce91ee367d800), _f(0x52592d2deb84b000),
    -_f(0x5a9bf1fdd05df800), _f(0x10e48562d1f92000),
    _f(0x1d4b91258bb3800), _f(0xaa81c5529799000),
    -_f(0x6eadf18b1729800), _f(0xd0db43634fa080),
    _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^8, polynomial in n of order 15
    _f(0x45bda664400), _f(0xc8c97088800), _f(0x2a5a46b84c00),
    _f(0xb467fe915000), _f(0x471c8a3c15400), _f(0x49361b74ae1800),
    -_f(0x3fb304ab7e4a400), _f(0xedcc81cc3d0e000),
    -_f(0x1834aac92fbf9c00), _f(0xe864613c6aba800),
    _f(0x759492ec34a6c00), -_f(0xea1e49c1b0f9000),
    _f(0x5db63d617b37400), _f(0x31083890113800),
    -_f(0xa60c227ea8400), -_f(0x3b3da9a3dab180),
    _f2(27647, 0xec962e4d9d27d),
    # C4[4], coeff of eps^7, polynomial in n of order 16
    _f(469241266176), _f(0x10545cac800), _f(0x2adf04bd000),
    _f(0x7eec6985800), _f(0x1ba16d402000), _f(0x7a072d7ae800),
    _f(0x322ca20e07000), _f(0x3657aa17207800),
    -_f(0x3263434d5c54000), _f(0xcd0703e8db70800),
    -_f(0x17ea571d4aa2f000), _f(0x141161dbf7ec9800),
    -_f(0x57d62fedaaa000), -_f(0xce7cd449810d800),
    _f(0x99132fccc31b000), -_f(0x27598ad75934800),
    _f(0x18a5cd1eccf980), _f2(27647, 0xec962e4d9d27d),
    # C4[4], coeff of eps^6, polynomial in n of order 17
    _f(341540329472), _f(727668064256), _f(0x180da872800),
    _f(0x3b0b3acd000), _f(0x9f94c3e7800), _f(0x1e8177ec2000),
    _f(0x6e3ee471c800), _f(0x1fbe99a5b7000), _f(0xdb641b5c91800),
    _f(0xfc08a38932c000), -_f(0xfb6a7929bd39800),
    _f(0x466e762d282a1000), -_f2(2430, 0x8d7c552bc4800),
    _f2(2721, 0xe81cb8f96000), -_f(0x4dc0eea70f08f800),
    -_f(0x1b9eda123c275000), _f(0x2eba54dfb9ee5800),
    -_f(0xf46c321c1b54e00), _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^5, polynomial in n of order 18
    _f(31160807424), _f(61322082304), _f(3864763 << 15),
    _f(276675840000), _f(646157094912), _f(0x17cd936d800),
    _f(0x429614e2000), _f(0xd3b41886800), _f(0x31f7c0917000),
    _f(0xf21fb6ecf800), _f(0x6ee892beec000), _f(0x889688d5b28800),
    -_f(0x944ac482b6bf000), _f(0x2e4469f00aa71800),
    -_f(0x73c7760d5050a000), _f2(2642, 0x7d1cf3a18a800),
    -_f2(2185, 0x6d0b55a915000), _f(0x3d1b0c8706d53800),
    -_f(0xb7512595147fa80), _f2(193535, 0x781b441f4c16b),
    # C4[4], coeff of eps^4, polynomial in n of order 19
    _f(1806732800), _f(3354817536), _f(6474635776),
    _f(13058088960), _f(27705484800), _f(62364503040),
    _f(150565728768), _f(395569133568), _f(0x10ca075be00),
    _f(0x37f6c332400), _f(0xdf0e61c4a00), _f(0x47dfa8095000),
    _f(0x236014b495600), _f(0x2f60ae04237c00),
    -_f(0x38c125ca4a81e00), _f(0x13dd33a066e0a800),
    -_f(0x389cd322becd1200), _f(0x5ba892ca8a3fd400),
    -_f(0x4c61cfa8c88a8600), _f(0x18d2fd16dac69ec0),
    _f2(193535, 0x781b441f4c16b),
    # C4[5], coeff of eps^23, polynomial in n of order 0
    14777984, _f(0xd190230980f),
    # C4[5], coeff of eps^22, polynomial in n of order 1
    -_f(104833024), _f(39440128), _f(0x62c2748ec71),
    # C4[5], coeff of eps^21, polynomial in n of order 2
    -_f(45133008896), _f(5079242752), _f(1557031040),
    _f(0x4f869592664b5),
    # C4[5], coeff of eps^20, polynomial in n of order 3
    -_f(0xecd417f0000), _f(40869997 << 17), -_f(0x78cb3050000),
    _f(0x28d58610800), _f(0x5263fcf5c8de3f7),
    # C4[5], coeff of eps^19, polynomial in n of order 4
    -_f(0xf4977948ac000), _f(0xfebd5b2ac3000),
    -_f(0xf90c852576000), _f(0x1257a8b1e1000), _f(0x5e1a6b95fb00),
    _f2(21503, 0xf0e695ca96ad3),
    # C4[5], coeff of eps^18, polynomial in n of order 5
    -_f(0x25dd48c154000), _f(0x596953f850000),
    -_f(0x2b40cdd44c000), _f(8741106765 << 15), -_f(0x1ab27f0a04000),
    _f(0x7e701f145600), _f2(3071, 0xfdd7cc41833d5),
    # C4[5], coeff of eps^17, polynomial in n of order 6
    -_f(0x4776cd8c606000), _f(0x6d8a47bfe9f000),
    -_f(0x187da0ea944000), _f(0x2b758d37739000),
    -_f(0x22fd5e6d302000), _f(0x107133def3000), _f(0x56ef801cd100),
    _f2(33791, 0xe845c6d0a3a27),
    # C4[5], coeff of eps^16, polynomial in n of order 7
    -_f(0x6b41dfbb0208000), _f(0x3281e67a9bd0000),
    -_f(0x11e76a3ab618000), _f(0x2fa8791e0ae0000),
    -_f(0xef00faafea8000), _f(0x82642584ff0000),
    -_f(0xce6c8b206b8000), _f(0x33a2c6e1f0cc00),
    _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^15, polynomial in n of order 8
    -_f(0xd8a9f7e5e7f8000), _f(0x75ff062faeb000),
    -_f(0x57d41a79bb5a000), _f(0x470a22b15ed1000),
    -_f(0x941305430fc000), _f(0x2571b5b524d7000),
    -_f(0x15ee8622281e000), -_f(0x810fd11a43000),
    -_f(0x3b143f8fcc100), _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^14, polynomial in n of order 9
    -_f(0x11e2c065bec000), _f(597104820847 << 17),
    -_f(0x2505ead2add4000), _f(0x375d7cf9da8000),
    -_f(0x7d85d31b2fc000), _f(0xc6e2597bcf0000),
    -_f(0x1c3d1fca5e4000), _f(0x26eff911138000),
    -_f(0x32d040ac10c000), _f(0xa3358a5620200),
    _f2(33791, 0xe845c6d0a3a27),
    # C4[5], coeff of eps^13, polynomial in n of order 10
    -_f(0x4e0fa2600780a000), _f(0x4e911c6aabd6b000),
    -_f(0x693532675088000), _f(0x218ccc46e845000),
    -_f(0x117da33185e06000), _f(0x4517905378bf000),
    -_f(0x10ba1c1d3344000), _f(0x5399b73b0419000),
    -_f(0x1d57ddd62302000), -_f(0x2b67cba006d000),
    -_f(0x17851f6bed3f00), _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^12, polynomial in n of order 11
    _f2(2256, 0x5da9961330000), -_f(0x4ad304d1312a0000),
    -_f(0x4061e93f2b8f0000), _f(0xb6157e3bfe7 << 19),
    -_f(0x11e106d1afa10000), -_f(0x36aeeaeb6e60000),
    -_f(0xfcdce3949630000), _f(0x8af39fd661c0000),
    _f(0x3d8b99e8cb0000), _f(0x2f252d98fde0000),
    -_f(0x29a890537770000), _f(0x62af9738c95800),
    _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^11, polynomial in n of order 12
    _f(0x2c14f5cef5da000), -_f(0xb44f7f3a7637800),
    _f(0x144dd8529649b000), -_f(0xdf6b3f6a9dda800),
    -_f(0x611b67a2b3c4000), _f(0xe4e2f0fafbb2800),
    -_f(0x51c03e2adea3000), -_f(0xd7c7b9cb0f0800),
    -_f(0x16096a592762000), _f(0x1c9393e7a4dc800),
    -_f(0x381de14f961000), -_f(0xdc6f16ca46800),
    -_f(0xd4311572ebf80), _f2(33791, 0xe845c6d0a3a27),
    # C4[5], coeff of eps^10, polynomial in n of order 13
    -_f(0x1f7df788da000), -_f(0x249f1260a08000),
    _f(0x2485dbf6336a000), -_f(0x9fd55d1961bc000),
    _f(0x13ee6db114d4e000), -_f(0x114ab28a688b0000),
    -_f(0x1759d6f434ee000), _f(0xe5435dae775c000),
    -_f(0x883ae4654d0a000), _f(0x6d085594a8000),
    -_f(0x3b594ff4c6000), _f(0x18b250a1c574000),
    -_f(0xc2af3f725e2000), _f(0x11b5d0e5824b00),
    _f2(33791, 0xe845c6d0a3a27),
    # C4[5], coeff of eps^9, polynomial in n of order 14
    -_f(0x45be4df1f000), -_f(0x154928d5d8800),
    -_f(0x9c093f54d6000), -_f(0xbe1dac855c3800),
    _f(0xc8c35d9371b3000), -_f(0x3b27b3be7f71e800),
    _f2(2105, 0xa27ce5e51c000), -_f2(2266, 0x2251e75549800),
    _f(0x215c4ca42d605000), _f(0x52b0fbc40a45b800),
    -_f(0x52abb6acf6af2000), _f(0x14cab8bdb5a70800),
    _f(0x422bb90412d7000), _f(0xaa8f3f42195800),
    -_f(0x18c864fb5207380), _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^8, polynomial in n of order 15
    -_f(0x323b5354000), -_f(0xa77c1e58000), -_f(0x297150a3c000),
    -_f(0xd25b36ef0000), -_f(0x64c6f9d464000),
    -_f(0x816d981c288000), _f(0x91bbe6aceeb4000),
    -_f(0x2ea0d03ef98a0000), _f(0x748c356a9df8c000),
    -_f2(2463, 0x44f7c770b8000), _f(0x55038197b9ea4000),
    _f(0x24c2f502435b0000), -_f(0x557a28e333384000),
    _f(0x319d6c472db18000), -_f(0xa981b88bf66c000),
    _f(0x2452a78bb4ce00), _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^7, polynomial in n of order 16
    -_f(864347 << 15), -_f(77318326272), -_f(233990443008),
    -_f(807704598528), -_f(0x306255a2000), -_f(0x100b9fcf2800),
    -_f(0x8171cf3d7000), -_f(0xb08a440213800),
    _f(0xd5be3a4ba94000), -_f(0x4af12ff99ea4800),
    _f(0xd4237986197f000), -_f(0x15530c89262c5800),
    _f(0x12c48ba350cca000), -_f(0x590f07b7ee96800),
    -_f(0x53e376c2a7ab000), _f(0x5b3d559eedc8800),
    -_f(0x1b37127cacfe280), _f2(33791, 0xe845c6d0a3a27),
    # C4[5], coeff of eps^6, polynomial in n of order 17
    -_f(10859667456), -_f(199353 << 17), -_f(67565166592),
    -_f(190510645248), -_f(597656199168), -_f(65543051 << 15),
    -_f(0x869fe272000), -_f(0x2f027b014000), -_f(0x19275e39a6000),
    -_f(0x24c57351390000), _f(0x305c8c1f55c6000),
    -_f(0x12c56d86cea0c000), _f(0x3c958c9a69892000),
    -_f(0x75427b7d716c8000), _f2(2264, 0x2021045b7e000),
    -_f(0x686da1b1a7d04000), _f(0x2b2226f5e6b4a000),
    -_f(0x7a36190e0daa700), _f2(236543, 0x59e86fb479711),
    # C4[5], coeff of eps^5, polynomial in n of order 18
    -_f(392933376), -_f(865908736), -_f(61523 << 15), -_f(5002905600),
    -_f(13385551872), -_f(39200544768), -_f(128292691968),
    -_f(483473385472), -_f(0x1ffab8af000), -_f(0xbdf5200f800),
    -_f(0x6d0cb854c000), -_f(0xacf22c5668800),
    _f(0xfa276dd8697000), -_f(0x6c92e41ed151800),
    _f(0x18f8d3300c4da000), -_f(0x382fdb2c1baea800),
    _f(0x4f13f21826f5d000), -_f(0x3d1b0c8706d53800),
    _f(0x131873ea3222a180), _f2(236543, 0x59e86fb479711),
    # C4[6], coeff of eps^23, polynomial in n of order 0
    _f(20016128), _f(0x45dab658805),
    # C4[6], coeff of eps^22, polynomial in n of order 1
    _f(12387831808), _f(4069857792), _f(0x1b45118f2c973b),
    # C4[6], coeff of eps^21, polynomial in n of order 2
    _f(828267 << 17), -_f(2724645 << 16), _f(52104335360),
    _f(0x22cae1700cc0f3),
    # C4[6], coeff of eps^20, polynomial in n of order 3
    _f(0x94a2566a8000), -_f(0x7736ce990000), _f(0x345f5a38000),
    _f(0x11f45dc9000), _f(0x36c560e36413be89),
    # C4[6], coeff of eps^19, polynomial in n of order 4
    _f(6043548407 << 18), -_f(7867012491 << 16), _f(0xfe56696e0000),
    -_f(6798211929 << 16), _f(0x66855efe5000),
    _f2(3630, 0x89164e7bf8313),
    # C4[6], coeff of eps^18, polynomial in n of order 5
    _f(0x588efe4c176000), -_f(0xcc317e9b08000),
    _f(0x2e65271667a000), -_f(0x1cb46908f84000),
    -_f(0x7bc8d2682000), -_f(0x36524dd3a400),
    _f2(39935, 0xe3f55f53aa1d1),
    # C4[6], coeff of eps^17, polynomial in n of order 6
    _f(0x2dbd6ef2050000), -_f(0x356ee7ee5e8000),
    _f(0x65e2c9482e0000), -_f(0x1247a684858000),
    _f(84899613015 << 16), -_f(0x1b548eba6c8000),
    _f(0x5c900466be800), _f2(39935, 0xe3f55f53aa1d1),
    # C4[6], coeff of eps^16, polynomial in n of order 7
    -_f(0x3fff5b5aa54000), -_f(0x6a2cbaeaf348000),
    _f(0x2b55e8782dc4000), -_f(0x69f22faba30000),
    _f(0x26e11f54b9dc000), -_f(0x105d41b83118000),
    -_f(0x12eb1ab4e0c000), -_f(0x9530f9646a800),
    _f2(279551, 0x3bb59b49a6cb7),
    # C4[6], coeff of eps^15, polynomial in n of order 8
    _f(0xf488f4012440000), -_f(0xb16a4f02dfc8000),
    -_f(0x103bba4a90d0000), -_f(0x4da08c72a3d8000),
    _f(0x45a11acaf220000), -_f(0x25f21bc63e8000),
    _f(0x12fccd9d4510000), -_f(0x13e0eb3687f8000),
    _f(0x356c2e9517d800), _f2(279551, 0x3bb59b49a6cb7),
    # C4[6], coeff of eps^14, polynomial in n of order 9
    _f(0x28c5c3199aad2000), _f(0x80d5fb17a810000),
    _f(0x9c623a70694e000), -_f(0xf23c0600f3f4000),
    _f(0x6928769f1ca000), -_f(0x1e8f96869bf8000),
    _f(0x4f9253e0b846000), -_f(0x11e4e806cbfc000),
    -_f(0x2dad19c0f3e000), -_f(0x1f2fac1e88dc00),
    _f2(279551, 0x3bb59b49a6cb7),
    # C4[6], coeff of eps^13, polynomial in n of order 10
    -_f(0xdb139b99ca0000), -_f(0x5dbaf74a92790000),
    _f(0x76a096067df << 19), _f(0x39f346109690000),
    _f(964470918621 << 17), -_f(0x10aa5a9917350000),
    _f(0x49bc5039b7c0000), _f(0x92ae304aad0000),
    _f(0x32f3e8ddd3e0000), -_f(0x233311e51f10000),
    _f(0x4483a6a16dd000), _f2(279551, 0x3bb59b49a6cb7),
    # C4[6], coeff of eps^12, polynomial in n of order 11
    -_f(0xfbf5c5edd078000), _f(0x1202fde81d5f0000),
    -_f(0x454a07e84fa8000), -_f(0xbd470dafdb40000),
    _f(0xb3ba7d182928000), -_f(0x155dacd6cc70000),
    -_f(0xdc21a82d608000), -_f(0xe96f98256d << 17),
    _f(0x167a9a9742c8000), -_f(0x7d81f52ed0000),
    -_f(0x7ffde3fc68000), -_f(0xe287c62fa3000),
    _f2(39935, 0xe3f55f53aa1d1),
    # C4[6], coeff of eps^11, polynomial in n of order 12
    -_f(283480971297 << 18), _f(0x5885fb25bf70000),
    -_f(0xe5dec7019ee0000), _f(0x13305b31e4ed0000),
    -_f(0x9278e6008580000), -_f(0x855a0cffe9d0000),
    _f(0xd3d848f453e0000), -_f(0x4a9f485fda70000),
    -_f(0xfb7b0fc02c0000), -_f(0x691c2e87310000),
    _f(806997945397 << 17), -_f(0x9585db4a3b0000),
    _f(0xa77dc54c8f000), _f2(39935, 0xe3f55f53aa1d1),
    # C4[6], coeff of eps^10, polynomial in n of order 13
    _f(0x6d0001099000), _f(0x9a74d7ec5c000), -_f(0xc18676170e1000),
    _f(0x45ad31c7f8a2000), -_f(0xc7369375e55b000),
    _f(0x1364b97f822e8000), -_f(0xe19539447ad5000),
    -_f(0x26bf9b041ad2000), _f(0xce71cc8200b1000),
    -_f(0x8c822446468c000), _f(0x12e554ec5f37000),
    _f(0xa6c4f3e59ba000), _f(0x30bb36a52bd000),
    -_f(0x34440d2d335600), _f2(39935, 0xe3f55f53aa1d1),
    # C4[6], coeff of eps^9, polynomial in n of order 14
    _f(0x8fcb3bf8000), _f(0x33bb5d994000), _f(7630295323 << 16),
    _f(0x2a77da91fcc000), -_f(0x38ac5a4a0098000),
    _f(0x160f7571fbc04000), -_f(0x45e92df7f7ee0000),
    _f(0x7f01d3c372a3c000), -_f(0x7edcf27daed28000),
    _f(0x27dfe4585e674000), _f(0x38a548f303090000),
    -_f(0x4b87231069354000), _f(0x24d2adef05648000),
    -_f(0x6a5625dbc71c000), -_f(0x18371a5d233400),
    _f2(279551, 0x3bb59b49a6cb7),
    # C4[6], coeff of eps^8, polynomial in n of order 15
    _f(257397153792), _f(991547604992), _f(0x42cbc6ea000),
    _f(843451707 << 15), _f(0xe8a206ec6000), _f(0x170dd449e34000),
    -_f(0x2102346c3b5e000), _f(0xe0052eca6690000),
    -_f(0x318a0eacb0b82000), _f(0x690a1407d3eec000),
    -_f2(2182, 0xb601e615a6000), _f(0x61bf435eea348000),
    -_f(0xe133a8622dca000), -_f(0x2748b26bf705c000),
    _f(0x220d7d12f9812000), -_f(0x98dbd66bee38400),
    _f2(279551, 0x3bb59b49a6cb7),
    # C4[6], coeff of eps^7, polynomial in n of order 16
    _f(9867 << 18), _f(8045019136), _f(854413 << 15),
    _f(6856031 << 14), _f(8304289 << 16), _f(0x3232f0a4000),
    _f(0x1ec960fb8000), _f(0x3439f07dcc000), -_f(0x50f0148aea0000),
    _f(0x25bf6de530f4000), -_f(0x9635a567bcf8000),
    _f(0x1735ee17e1e1c000), -_f(0x25a38fef60750000),
    _f(0x2834884b55944000), -_f(0x1b3dfda8c79a8000),
    _f(0xa981b88bf66c000), -_f(0x1cc16f4e99cdc00),
    _f2(93183, 0xbe91de6de243d),
    # C4[6], coeff of eps^6, polynomial in n of order 17
    _f(169275392), _f(7007 << 16), _f(1348931584), _f(4358086656),
    _f(15819288576), _f(66522136576), _f(339738054656),
    _f(0x214230b6000), _f(0x15d36ff77000), _f(0x2803a29af8000),
    -_f(0x43d629aab87000), _f(0x232131018d3a000),
    -_f(0x9e155c86fb85000), _f(0x1c3aabf38857c000),
    -_f(0x361b1ee81aa83000), _f(0x44dcb2f8dc1be000),
    -_f(0x325282c98d281000), _f(0xf46c321c1b54e00),
    _f2(279551, 0x3bb59b49a6cb7),
    # C4[7], coeff of eps^23, polynomial in n of order 0
    _f(383798272), _f(0x7ee24536c1115),
    # C4[7], coeff of eps^22, polynomial in n of order 1
    -_f(127523 << 20), _f(34096398336), _f(0x1f771442bd4c09),
    # C4[7], coeff of eps^21, polynomial in n of order 2
    -_f(197998999 << 19), -_f(4877411 << 18), -_f(541336621056),
    _f(0x3b1ebd1165abdce9),
    # C4[7], coeff of eps^20, polynomial in n of order 3
    -_f(72076029 << 20), _f(33625235 << 21), -_f(96370351 << 20),
    _f(0x142b356fa000), _f(0x3f32837c872a7963),
    # C4[7], coeff of eps^19, polynomial in n of order 4
    -_f(2249063181 << 20), _f(51883720989 << 18), -_f(12233087197 << 19),
    -_f(1430728833 << 18), -_f(0x9e5c3c48b000),
    _f2(46079, 0xdfa4f7d6b097b),
    # C4[7], coeff of eps^18, polynomial in n of order 5
    -_f(19747083035 << 20), _f(5938781185 << 22), -_f(1899464157 << 20),
    _f(2895955713 << 21), -_f(6730130079 << 20), _f(0x490d94cd2c000),
    _f2(46079, 0xdfa4f7d6b097b),
    # C4[7], coeff of eps^17, polynomial in n of order 6
    -_f(0xf7ed31ddbc0000), _f(90436020675 << 17),
    -_f(11671406741 << 19), _f(0x58222c9a6a0000),
    -_f(28407954085 << 18), -_f(6936211449 << 17),
    -_f(0x1e088e877c800), _f2(46079, 0xdfa4f7d6b097b),
    # C4[7], coeff of eps^16, polynomial in n of order 7
    -_f(688523975841 << 19), -_f(83606333811 << 20),
    -_f(805224840035 << 19), _f(106897379463 << 21),
    _f(22163836107 << 19), _f(88997602799 << 20),
    -_f(151227539575 << 19), _f(0x28435aa5d4b000),
    _f2(322559, 0x1d82c6ded425d),
    # C4[7], coeff of eps^15, polynomial in n of order 8
    _f(557482450381 << 20), _f(0xfbb72a664ee0000),
    -_f(0xa9b81eb4ea40000), -_f(914196917515 << 17),
    -_f(409568792563 << 19), _f(0x4780d431da60000),
    -_f(0x94b9eca98c0000), -_f(82946761135 << 17),
    -_f(0x238b221440f800), _f2(322559, 0x1d82c6ded425d),
    # C4[7], coeff of eps^14, polynomial in n of order 9
    -_f(0x59ec90b7ba5 << 20), _f(233491821731 << 23),
    _f(762388756437 << 20), _f(284558585577 << 21),
    -_f(0xf0573a4eb1 << 20), _f(25275836579 << 22),
    _f(22761999561 << 20), _f(112734627747 << 21),
    -_f(126941809085 << 20), _f(0x2fd680f7c84000),
    _f2(322559, 0x1d82c6ded425d),
    # C4[7], coeff of eps^13, polynomial in n of order 10
    _f(0xaca84931355 << 19), _f(0x66fb36095ad << 18),
    -_f(0x2e7424117bf << 21), _f(0xcac2488dd23 << 18),
    _f(762738574899 << 19), -_f(579380269895 << 18),
    -_f(968587667327 << 20), _f(0x73cbed27abc0000),
    _f(75006191505 << 19), -_f(0xdb0f0aaec0000),
    -_f(0x63c3eeba719000), _f2(322559, 0x1d82c6ded425d),
    # C4[7], coeff of eps^12, polynomial in n of order 11
    _f(626455667783 << 20), -_f(567623567285 << 21),
    _f(0xf5d2e8872d << 20), -_f(13896712169 << 23),
    -_f(798923144989 << 20), _f(364556664237 << 21),
    -_f(129034049335 << 20), -_f(20826366601 << 22),
    -_f(51607570881 << 20), _f(46156477135 << 21),
    -_f(30888509275 << 20), _f(0x6042659ec2000),
    _f2(46079, 0xdfa4f7d6b097b),
    # C4[7], coeff of eps^11, polynomial in n of order 12
    _f(20777559885 << 20), -_f(569775860071 << 18),
    _f(0xe9ac41f6db << 19), -_f(0xef8ba34c8740000),
    _f(598911876783 << 21), -_f(0x7cf99a74ecc0000),
    -_f(957375911139 << 19), _f(0xc30e342965c0000),
    -_f(423483761553 << 20), _f(35714168193 << 18),
    _f(79169625311 << 19), _f(68905136075 << 18),
    -_f(0x2f872ef9963000), _f2(46079, 0xdfa4f7d6b097b),
    # C4[7], coeff of eps^10, polynomial in n of order 13
    -_f(18988489 << 20), -_f(129894471 << 22), _f(12886996881 << 20),
    -_f(47548938145 << 21), _f(367560238059 << 20),
    -_f(106884143981 << 23), _f(0x11c056e4d45 << 20),
    -_f(470740881351 << 21), _f(64061082015 << 20),
    _f(158992278163 << 22), -_f(634972709127 << 20),
    _f(135054066707 << 21), -_f(41343081645 << 20),
    -_f(0x7382e0581c000), _f2(46079, 0xdfa4f7d6b097b),
    # C4[7], coeff of eps^9, polynomial in n of order 14
    -_f(7074089 << 17), -_f(95481295 << 16), -_f(249804765 << 18),
    -_f(0x6befb7d790000), _f(0xb301172bea0000),
    -_f(0x5978c2137030000), _f(0x2fbc3e73e21 << 19),
    -_f(0x3f35c80b0f2d0000), _f(0x6ce3ff0d91260000),
    -_f(0x7761d1ce42b70000), _f(0x468057c8ed840000),
    _f(0x1bcb7dfb99f0000), -_f(0x26d98474089e0000),
    _f(0x1d375a3e49150000), -_f(0x7d9dd8c3269dc00),
    _f2(322559, 0x1d82c6ded425d),
    # C4[7], coeff of eps^8, polynomial in n of order 15
    -_f(47805 << 18), -_f(105987 << 19), -_f(1141959 << 18),
    -_f(2026311 << 20), -_f(89791009 << 18), -_f(1389164665 << 19),
    _f(79467759189 << 18), -_f(86766818957 << 21),
    _f(0xbfc5c91f6ec0000), -_f(0x487b27f822f << 19),
    _f(0x4a699e0854c40000), -_f(0x69d85e75b6d << 20),
    _f(0x66f7a9fb575c0000), -_f(0x828d4038ea5 << 19),
    _f(0x60dc69748cd << 18), -_f(0x3f90a5347c68800),
    _f2(322559, 0x1d82c6ded425d),
    # C4[7], coeff of eps^7, polynomial in n of order 16
    -_f(143 << 20), -_f(8085 << 16), -_f(16121 << 17), -_f(9810411520),
    -_f(212205 << 18), -_f(6380297 << 16), -_f(37701755 << 17),
    -_f(0x95a9db330000), _f(9764754545 << 19), -_f(0xaf0fe765fd0000),
    _f(0x3a2548493060000), -_f(0xc8bdaa520270000),
    _f(0x7871cc979b1 << 18), -_f(0x3353672f26710000),
    _f(0x3c89c1e8d8020000), -_f(0x2a606e22fd9b0000),
    _f(0xc94a0b2634a0400), _f2(322559, 0x1d82c6ded425d),
    # C4[8], coeff of eps^23, polynomial in n of order 0
    _f(7579 << 15), _f(0x4f56c0c24f87),
    # C4[8], coeff of eps^22, polynomial in n of order 1
    -_f(1660549 << 21), -_f(23648625 << 16), _f(0x38232f25bccb5275),
    # C4[8], coeff of eps^21, polynomial in n of order 2
    _f(9646043 << 20), -_f(24019457 << 19), _f(74048359 << 15),
    _f(0x99262e0aeeff091),
    # C4[8], coeff of eps^20, polynomial in n of order 3
    _f(183351957435 << 19), -_f(32827160863 << 20),
    -_f(6509093591 << 19), -_f(0x6677b4e9b0000),
    _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^19, polynomial in n of order 4
    _f(67207908275 << 21), -_f(201042891 << 19), _f(44011096899 << 20),
    -_f(85786308153 << 19), _f(0x195ba7c1ef8000),
    _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^18, polynomial in n of order 5
    -_f(13677739 << 21), -_f(1155605701 << 23), _f(11263093395 << 21),
    -_f(1170886701 << 22), -_f(422863935 << 21), -_f(9609473031 << 16),
    _f2(52223, 0xdb549059b7125),
    # C4[8], coeff of eps^17, polynomial in n of order 6
    -_f(105328611 << 20), -_f(0xe3d4e1d7080000), _f(9484526351 << 21),
    _f(4879307961 << 19), _f(13462873311 << 20), -_f(19014362253 << 19),
    _f(0x45bace6718000), _f2(52223, 0xdb549059b7125),
    # C4[8], coeff of eps^16, polynomial in n of order 7
    _f(0x4802f7e045b << 18), -_f(787109524929 << 19),
    -_f(616781829503 << 18), -_f(267630157067 << 20),
    _f(0xf57f439a67 << 18), -_f(26811748075 << 19),
    -_f(29646920051 << 18), -_f(0x25c0cef2988000),
    _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^15, polynomial in n of order 8
    _f(61397460605 << 22), _f(0x9d011c37ef80000),
    _f(907553463943 << 20), -_f(0xc0a473ee4980000),
    -_f(21778698179 << 21), -_f(22179652453 << 19),
    _f(224024408237 << 20), -_f(212571195095 << 19),
    _f(0x216a7bfadc8000), _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^14, polynomial in n of order 9
    _f(304663697949 << 21), -_f(51558232553 << 24),
    _f(126037118963 << 21), _f(28559389965 << 22), _f(12939195833 << 21),
    -_f(17167224841 << 23), _f(24466781775 << 21), _f(2302458607 << 22),
    _f(456812693 << 21), -_f(0xde9c5a4230000),
    _f2(52223, 0xdb549059b7125),
    # C4[8], coeff of eps^13, polynomial in n of order 10
    -_f(0x71eca5b57e5 << 20), _f(0x8d98ab5c54b << 19),
    _f(497026592783 << 22), -_f(0xacc7c9e1d9b << 19),
    _f(0x35a7c7b51dd << 20), -_f(81233361377 << 19),
    -_f(253988603057 << 21), -_f(954606696519 << 19),
    _f(577751554079 << 20), -_f(333997527437 << 19),
    _f(0x1689b847558000), _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^12, polynomial in n of order 11
    -_f(0x367f7beda59 << 19), _f(0x45996b8ba21 << 20),
    -_f(0xdceb5493fc3 << 19), _f(0x18843cb160d << 22),
    -_f(0x21789a51fed << 19), -_f(0x41cde5aa8b9 << 20),
    _f(0x95638f58ea9 << 19), -_f(984566251123 << 21),
    -_f(435207598721 << 19), _f(219309948781 << 20),
    _f(274765170197 << 19), -_f(0x12cf88fa6ff0000),
    _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^11, polynomial in n of order 12
    -_f(2296713447 << 21), _f(78660216877 << 19),
    -_f(180155131441 << 20), _f(0xeee01825bf << 19),
    -_f(237440161933 << 22), _f(0x2042cbdcd31 << 19),
    -_f(652079196855 << 20), -_f(325903664957 << 19),
    _f(324695717299 << 21), -_f(0xf97e21ed4b << 19),
    _f(203483994947 << 20), -_f(52367903417 << 19),
    -_f(0x8a9d0d3688000), _f2(52223, 0xdb549059b7125),
    # C4[8], coeff of eps^10, polynomial in n of order 13
    _f(1140139 << 21), _f(9315711 << 23), -_f(1126319139 << 21),
    _f(5199009105 << 22), -_f(52132384161 << 21), _f(20770352565 << 24),
    -_f(357583911087 << 21), _f(262213551639 << 22),
    -_f(498523677485 << 21), _f(60302341333 << 23),
    _f(57310064901 << 21), -_f(90954779619 << 22),
    _f(124029244935 << 21), -_f(0xf0a5fe0ce50000),
    _f2(52223, 0xdb549059b7125),
    # C4[8], coeff of eps^9, polynomial in n of order 14
    _f(54009 << 20), _f(849303 << 19), _f(2623117 << 21),
    _f(364892913 << 19), -_f(5919882885 << 20), _f(0xdd0128d3580000),
    -_f(81910832913 << 22), _f(0x2229f5f9745 << 19),
    -_f(0x2a9587ee883 << 20), _f(0x982f47b44bf << 19),
    -_f(0x30e1739ffd1 << 21), _f(0xb09887dee19 << 19),
    -_f(0x35101f0ee01 << 20), _f(0x25e6f19ce93 << 19),
    -_f(0x306e34ba4668000), _f2(365566, 0xff4ff27401803),
    # C4[8], coeff of eps^8, polynomial in n of order 15
    _f(2295 << 17), _f(5831 << 18), _f(72709 << 17), _f(151011 << 19),
    _f(7936467 << 17), _f(147906885 << 18), -_f(0x4d5c1f23e0000),
    _f(14228642337 << 20), -_f(697203474513 << 17),
    _f(0x51fe4e56b0c0000), -_f(0xeb59f3d2e860000),
    _f(0x3e0c14100a1 << 19), -_f(0x305340db42ea0000),
    _f(0xd6c75923d41 << 18), -_f(0x2452a78bb4ce0000),
    _f(0xa981b88bf66c000), _f2(365566, 0xff4ff27401803),
    # C4[9], coeff of eps^23, polynomial in n of order 0
    -_f(45613 << 15), _f(0xa0b835899f381),
    # C4[9], coeff of eps^22, polynomial in n of order 1
    -_f(4663637 << 21), _f(25498473 << 16), _f(0x8f68f0ea15ed989),
    # C4[9], coeff of eps^21, polynomial in n of order 2
    -_f(313787291 << 20), -_f(89546863 << 19), -_f(880826107 << 15),
    _f2(5306, 0x2ad1d52b570cd),
    # C4[9], coeff of eps^20, polynomial in n of order 3
    _f(1691751267 << 22), _f(5868457511 << 23), -_f(9710518895 << 22),
    _f(43389881073 << 17), _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^19, polynomial in n of order 4
    -_f(45668361181 << 21), _f(290185772373 << 19),
    -_f(19310638221 << 20), -_f(10267037529 << 19),
    -_f(0x11435a10568000), _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^18, polynomial in n of order 5
    -_f(206915608111 << 21), _f(8005795847 << 23), _f(6676372983 << 21),
    _f(24266221119 << 22), -_f(29173391667 << 21), _f(99595856143 << 16),
    _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^17, polynomial in n of order 6
    -_f(15515879355 << 20), -_f(36184750873 << 19),
    -_f(22177807609 << 21), _f(62194714929 << 19), _f(693176727 << 20),
    -_f(1189966821 << 19), -_f(0x5829503048000),
    _f2(58367, 0xd70428dcbd8cf),
    # C4[9], coeff of eps^16, polynomial in n of order 7
    _f(38512528273 << 23), _f(67772681235 << 24), -_f(74410968653 << 23),
    -_f(3984568679 << 25), -_f(6152374683 << 23), _f(13551170801 << 24),
    -_f(11115057401 << 23), _f(24916219839 << 18),
    _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^15, polynomial in n of order 8
    -_f(162298412813 << 22), _f(0xff4317f5080000),
    _f(119179074953 << 20), _f(0xf6d36e74980000),
    -_f(63634032589 << 21), _f(61952932453 << 19), _f(10785104899 << 20),
    _f(4191026519 << 19), -_f(0xd59ae9d0e8000),
    _f2(58367, 0xd70428dcbd8cf),
    # C4[9], coeff of eps^14, polynomial in n of order 9
    _f(162971496591 << 21), _f(33816350309 << 24),
    -_f(394783736543 << 21), _f(85862751303 << 22),
    _f(32462900611 << 21), -_f(6369607931 << 23), -_f(39152071083 << 21),
    _f(18189729581 << 22), -_f(9249690569 << 21), _f(6171570141 << 16),
    _f2(58367, 0xd70428dcbd8cf),
    # C4[9], coeff of eps^13, polynomial in n of order 10
    _f(0x52d38896f8b << 20), -_f(0xd3acdf03195 << 19),
    _f(0x1195b2a1cff << 22), _f(0xca9586e4a280000),
    -_f(0x486f0b6e413 << 20), _f(0x7ca2ce8a83f << 19),
    -_f(610236546241 << 21), -_f(717677267559 << 19),
    _f(159176229583 << 20), _f(291633515411 << 19),
    -_f(0x110150274e88000), _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^12, polynomial in n of order 11
    _f(143956869023 << 22), -_f(243108013001 << 23),
    _f(0x101d5eb1615 << 22), -_f(213537904349 << 25),
    _f(0x183f300cffb << 22), -_f(350529456991 << 23),
    -_f(545724783247 << 22), _f(274121340227 << 24),
    -_f(785966166377 << 22), _f(135225754699 << 23),
    -_f(28607511667 << 22), -_f(0x3ee3b308260000),
    _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^11, polynomial in n of order 12
    _f(2520290511 << 21), -_f(0xc4ddd05ba80000),
    _f(304931349961 << 20), -_f(0x21230116cd7 << 19),
    _f(735928623493 << 22), -_f(0x9d254a11d99 << 19),
    _f(0x6510e717cdf << 20), -_f(0xa95d67804fb << 19),
    _f(0x1055dd17e45 << 21), _f(0x239bcd685c3 << 19),
    -_f(0x22ba072788b << 20), _f(0x2c142a0db61 << 19),
    -_f(0x59b3a2379f58000), _f2(408574, 0xe11d1e092eda9),
    # C4[9], coeff of eps^10, polynomial in n of order 13
    -_f(29393 << 21), -_f(283917 << 23), _f(41246777 << 21),
    -_f(233407875 << 22), _f(2943398547 << 21), -_f(1525553871 << 24),
    _f(35837133917 << 21), -_f(38620600629 << 22),
    _f(123783976375 << 21), -_f(36640057007 << 23),
    _f(124599494337 << 21), -_f(35830670759 << 22),
    _f(24805848987 << 21), -_f(0x1ce0b816070000),
    _f2(19455, 0xf256b84994845),
    # C4[9], coeff of eps^9, polynomial in n of order 14
    -_f(1615 << 20), -_f(29393 << 19), -_f(106267 << 21),
    -_f(17534055 << 19), _f(342711075 << 20), -_f(8430692445 << 19),
    _f(7306600119 << 22), -_f(270344204403 << 19),
    _f(450573674005 << 20), -_f(0x20c896b3e69 << 19),
    _f(0xfa29e850f7 << 21), -_f(0x5aaf3103bff << 19),
    _f(0x3002653e387 << 20), -_f(0x3f2b92b02f5 << 19),
    _f(0x914a9e2ed338000), _f2(408574, 0xe11d1e092eda9),
    # C4[10], coeff of eps^23, polynomial in n of order 0
    _f(137 << 21), _f(0x8757c14b789b),
    # C4[10], coeff of eps^22, polynomial in n of order 1
    -_f(1152691 << 20), -_f(6743919 << 17), _f(0x9e817610332f06f),
    # C4[10], coeff of eps^21, polynomial in n of order 2
    _f(79722199 << 23), -_f(113766289 << 22), _f(225212673 << 18),
    _f2(5864, 0xb6105765cc00b),
    # C4[10], coeff of eps^20, polynomial in n of order 3
    _f(64857768639 << 21), -_f(2220489243 << 22), -_f(2012833515 << 21),
    -_f(19551629405 << 18), _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^19, polynomial in n of order 4
    _f(656353407 << 24), _f(1031809317 << 22), _f(12215335391 << 23),
    -_f(12759999497 << 22), _f(18944346729 << 18),
    _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^18, polynomial in n of order 5
    -_f(62867132873 << 20), -_f(83127481829 << 22),
    _f(173460262689 << 20), _f(8415873627 << 21), -_f(1024568181 << 20),
    -_f(82657907689 << 17), _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^17, polynomial in n of order 6
    _f(69839518785 << 24), -_f(46975322289 << 23), -_f(5175253237 << 25),
    -_f(10608265143 << 23), _f(12870275691 << 24), -_f(9303053053 << 23),
    _f(8528136981 << 19), _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^16, polynomial in n of order 7
    -_f(12671764325 << 22), _f(11821938135 << 23), _f(23903917953 << 22),
    -_f(7023725731 << 24), _f(4254825447 << 22), _f(1372261021 << 23),
    _f(755775181 << 22), -_f(6809268397 << 19),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[10], coeff of eps^15, polynomial in n of order 8
    _f(10583074157 << 26), -_f(84530118029 << 23), _f(12150058407 << 24),
    _f(12380362825 << 23), -_f(838454291 << 25), -_f(10410407457 << 23),
    _f(3974759309 << 24), -_f(1799658059 << 23), _f(156358707 << 19),
    _f2(64511, 0xd2b3c15fc4079),
    # C4[10], coeff of eps^14, polynomial in n of order 9
    -_f(922119298407 << 20), _f(52944024001 << 23),
    _f(329638564983 << 20), -_f(354979062141 << 21),
    _f(493120994773 << 20), -_f(24099541823 << 22),
    -_f(59503561293 << 20), _f(7459230081 << 21), _f(21243323153 << 20),
    -_f(75576440907 << 17), _f2(64511, 0xd2b3c15fc4079),
    # C4[10], coeff of eps^13, polynomial in n of order 10
    -_f(328595996641 << 23), _f(0x1245cb281e3 << 22),
    -_f(207527442829 << 25), _f(0x13d84cf39cd << 22),
    -_f(169653271431 << 23), -_f(705690429577 << 22),
    _f(256163704307 << 24), -_f(657414782367 << 22),
    _f(103463476179 << 23), -_f(17233182197 << 22),
    -_f(65863805931 << 18), _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^12, polynomial in n of order 11
    -_f(60530460661 << 21), _f(129708905557 << 22),
    -_f(783916037751 << 21), _f(215690023633 << 24),
    -_f(0x287cc397f79 << 21), _f(0x174d319d033 << 22),
    -_f(0x22bf2de15fb << 21), _f(172524970961 << 23),
    _f(736992166659 << 21), -_f(554058611183 << 22),
    _f(665956259969 << 21), -_f(0x4d7d212a0a40000),
    _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^11, polynomial in n of order 12
    -_f(31220211 << 24), _f(1576100141 << 22), -_f(5588687797 << 23),
    _f(52675808031 << 22), -_f(22267080913 << 25),
    _f(449824279121 << 22), -_f(432213499347 << 23),
    _f(0x1275ac4a843 << 22), -_f(351080482641 << 24),
    _f(0x10853170e75 << 22), -_f(314682628337 << 23),
    _f(212227819111 << 22), -_f(520922828727 << 18),
    _f2(451582, 0xc2ea499e5c34f),
    # C4[10], coeff of eps^10, polynomial in n of order 13
    _f(46189 << 20), _f(522291 << 22), -_f(90008149 << 20),
    _f(613691925 << 21), -_f(9499950999 << 20), _f(6182507793 << 23),
    -_f(187536069721 << 20), _f(270344204403 << 21),
    -_f(0x11a7161219b << 20), _f(533756506129 << 22),
    -_f(0x2a7db4d305d << 20), _f(0x159e458acd1 << 21),
    -_f(0x1bcb7dfb99f << 20), _f(0x7e5725605ea0000),
    _f2(451582, 0xc2ea499e5c34f),
    # C4[11], coeff of eps^23, polynomial in n of order 0
    -_f(7309 << 21), _f(0x2c95e8ad321065),
    # C4[11], coeff of eps^22, polynomial in n of order 1
    -_f(118877 << 30), _f(1675947 << 23), _f(0x7759dcb5574d50a7),
    # C4[11], coeff of eps^21, polynomial in n of order 2
    -_f(9105745 << 24), -_f(49846181 << 23), -_f(2866583251 << 18),
    _f2(70655, 0xce6359e2ca823),
    # C4[11], coeff of eps^20, polynomial in n of order 3
    -_f(239228553 << 25), _f(1509768547 << 26), -_f(1393694995 << 25),
    _f(7195205325 << 19), _f2(494590, 0xa4b77533898f5),
    # C4[11], coeff of eps^19, polynomial in n of order 4
    -_f(10520646403 << 25), _f(16651704531 << 23), _f(1510969677 << 24),
    _f(227849937 << 23), -_f(40629886913 << 18),
    _f2(494590, 0xa4b77533898f5),
    # C4[11], coeff of eps^18, polynomial in n of order 5
    -_f(737236949 << 28), -_f(83959015 << 31), -_f(449296547 << 28),
    _f(188420603 << 30), -_f(243597193 << 28), _f(1420486123 << 21),
    _f2(494590, 0xa4b77533898f5),
    # C4[11], coeff of eps^17, polynomial in n of order 6
    _f(1797306345 << 25), _f(7110272827 << 24), -_f(1494242189 << 26),
    _f(407981949 << 24), _f(324085539 << 25), _f(232922271 << 24),
    -_f(6431919403 << 19), _f2(70655, 0xce6359e2ca823),
    # C4[11], coeff of eps^16, polynomial in n of order 7
    -_f(59422002475 << 26), _f(4462082415 << 27), _f(11958968063 << 26),
    -_f(116564371 << 28), -_f(9243946887 << 26), _f(3024840805 << 27),
    -_f(1229077213 << 26), -_f(836978961 << 20),
    _f2(494590, 0xa4b77533898f5),
    # C4[11], coeff of eps^15, polynomial in n of order 8
    _f(1450234755 << 27), _f(28955596425 << 24), -_f(20916501415 << 25),
    _f(24148276875 << 24), -_f(639979965 << 26), -_f(3796939603 << 24),
    _f(257117683 << 25), _f(1321384367 << 24), -_f(17153469915 << 19),
    _f2(70655, 0xce6359e2ca823),
    # C4[11], coeff of eps^14, polynomial in n of order 9
    _f(2991071409 << 28), -_f(215656441 << 32), _f(2375561279 << 28),
    -_f(29715609 << 30), -_f(1772722171 << 28), _f(262089343 << 31),
    -_f(1227751437 << 28), _f(88909853 << 30), -_f(21460999 << 28),
    -_f(1112906091 << 21), _f2(70655, 0xce6359e2ca823),
    # C4[11], coeff of eps^13, polynomial in n of order 10
    _f(48251719021 << 24), -_f(247802667483 << 23),
    _f(59903451769 << 26), -_f(693923403733 << 23),
    _f(362458490331 << 24), -_f(482970502063 << 23),
    _f(22585671353 << 25), _f(201583163607 << 23),
    -_f(128100703031 << 24), _f(147544368125 << 23),
    -_f(0x43bae67ca340000), _f2(494590, 0xa4b77533898f5),
    # C4[11], coeff of eps^12, polynomial in n of order 11
    _f(488107587 << 25), -_f(1288790349 << 26), _f(9866997217 << 25),
    -_f(3570890001 << 28), _f(64004720367 << 25), -_f(56017267579 << 26),
    _f(152843494797 << 25), -_f(39981841137 << 27),
    _f(123894347227 << 25), -_f(33286009449 << 26),
    _f(21954601977 << 25), -_f(212227819111 << 19),
    _f2(494590, 0xa4b77533898f5),
    # C4[11], coeff of eps^11, polynomial in n of order 12
    _f(735471 << 25), -_f(44046541 << 23), _f(188198857 << 24),
    -_f(2177729631 << 23), _f(1156078693 << 26), -_f(30163144081 << 23),
    _f(38781185247 << 24), -_f(159433761571 << 23),
    _f(65649195941 << 25), -_f(342066863061 << 23),
    _f(168318615157 << 24), -_f(212227819111 << 23),
    _f(0x6f2df7ee67c0000), _f2(494590, 0xa4b77533898f5),
    # C4[12], coeff of eps^23, polynomial in n of order 0
    _f(173 << 24), _f(0x88d5e64011771),
    # C4[12], coeff of eps^22, polynomial in n of order 1
    -_f(163369 << 28), -_f(266903 << 29), _f2(14529, 0xb09bccfe817bf),
    # C4[12], coeff of eps^21, polynomial in n of order 2
    _f(26283479 << 29), -_f(21738605 << 28), _f(24285135 << 24),
    _f2(76799, 0xca12f265d0fcd),
    # C4[12], coeff of eps^20, polynomial in n of order 3
    _f(6122492151 << 24), _f(880448149 << 25), _f(269123645 << 24),
    -_f(4943792525 << 21), _f2(537598, 0x8684a0c8b6e9b),
    # C4[12], coeff of eps^19, polynomial in n of order 4
    -_f(616982441 << 28), -_f(2168310039 << 26), _f(1398586567 << 27),
    -_f(817632445 << 26), _f(450511215 << 22),
    _f2(537598, 0x8684a0c8b6e9b),
    # C4[12], coeff of eps^18, polynomial in n of order 5
    _f(1912616275 << 26), -_f(308159801 << 28), -_f(17594779 << 26),
    _f(72918855 << 27), _f(66311031 << 26), -_f(47313631 << 26),
    _f2(76799, 0xca12f265d0fcd),
    # C4[12], coeff of eps^17, polynomial in n of order 6
    _f(9134109 << 27), _f(1642561735 << 26), _f(58767343 << 28),
    -_f(1299624495 << 26), _f(374812639 << 27), -_f(137300677 << 26),
    -_f(61400001 << 22), _f2(76799, 0xca12f265d0fcd),
    # C4[12], coeff of eps^16, polynomial in n of order 7
    _f(118127909265 << 25), -_f(66457563795 << 26),
    _f(64469127555 << 25), -_f(134108625 << 27), -_f(12700511691 << 25),
    _f(295233743 << 26), _f(4531750951 << 25), -_f(13670656363 << 22),
    _f2(537598, 0x8684a0c8b6e9b),
    # C4[12], coeff of eps^15, polynomial in n of order 8
    -_f(10859744975 << 29), _f(49132517315 << 26), _f(5188275715 << 27),
    -_f(52074703975 << 26), _f(13295845745 << 28),
    -_f(28808201009 << 26), _f(3853119361 << 27), -_f(278992987 << 26),
    -_f(3626908831 << 22), _f2(537598, 0x8684a0c8b6e9b),
    # C4[12], coeff of eps^14, polynomial in n of order 9
    -_f(5262740745 << 26), _f(1142543055 << 29), -_f(12070462215 << 26),
    _f(5779723245 << 27), -_f(6878321925 << 26), _f(125534415 << 28),
    _f(3745400061 << 26), -_f(2112375473 << 27), _f(2351512319 << 26),
    -_f(573315259 << 26), _f2(76799, 0xca12f265d0fcd),
    # C4[12], coeff of eps^13, polynomial in n of order 10
    -_f(345262775 << 27), _f(2254590065 << 26), -_f(721021595 << 29),
    _f(11719656095 << 26), -_f(9489736865 << 27), _f(24346633325 << 26),
    -_f(6069982555 << 28), _f(18134544155 << 26), -_f(4742880779 << 27),
    _f(3068922857 << 26), -_f(7318200659 << 22),
    _f2(179199, 0x822c35983cf89),
    # C4[12], coeff of eps^12, polynomial in n of order 11
    -_f(58429085 << 24), _f(185910725 << 25), -_f(1747560815 << 24),
    _f(794345825 << 27), -_f(18392161025 << 24), _f(21545102915 << 25),
    -_f(82378334675 << 24), _f(32084193505 << 26),
    -_f(160420967525 << 24), _f(76723071425 << 25),
    -_f(95136608567 << 24), _f(212227819111 << 21),
    _f2(537598, 0x8684a0c8b6e9b),
    # C4[13], coeff of eps^23, polynomial in n of order 0
    -_f(34717 << 24), _f(0x4013d857859e5ad),
    # C4[13], coeff of eps^22, polynomial in n of order 1
    -_f(52837 << 30), _f(101283 << 25), _f(0x39b1009e5dec691d),
    # C4[13], coeff of eps^21, polynomial in n of order 2
    _f(58223275 << 29), _f(25058159 << 28), -_f(597584743 << 24),
    _f2(580606, 0x6851cc5de4441),
    # C4[13], coeff of eps^20, polynomial in n of order 3
    -_f(38160201 << 32), _f(20133099 << 33), -_f(10736915 << 32),
    _f(8118075 << 27), _f2(580606, 0x6851cc5de4441),
    # C4[13], coeff of eps^19, polynomial in n of order 4
    -_f(246943573 << 28), -_f(102114339 << 26), _f(63266747 << 27),
    _f(72037887 << 26), -_f(711672919 << 22),
    _f2(82943, 0xc5c28ae8d7777),
    # C4[13], coeff of eps^18, polynomial in n of order 5
    _f(362438863 << 28), _f(29917105 << 30), -_f(313139991 << 28),
    _f(81176473 << 29), -_f(26857069 << 28), -_f(40519029 << 23),
    _f2(82943, 0xc5c28ae8d7777),
    # C4[13], coeff of eps^17, polynomial in n of order 6
    -_f(4194208665 << 27), _f(3411193933 << 26), _f(92059229 << 28),
    -_f(832792389 << 26), -_f(13821619 << 27), _f(313960329 << 26),
    -_f(1784908801 << 22), _f2(82943, 0xc5c28ae8d7777),
    # C4[13], coeff of eps^16, polynomial in n of order 7
    _f(4206195495 << 29), _f(1286394165 << 30), -_f(6553065099 << 29),
    _f(1494451903 << 31), -_f(3024727629 << 29), _f(374117415 << 30),
    -_f(7540351 << 29), -_f(836978961 << 24),
    _f2(580606, 0x6851cc5de4441),
    # C4[13], coeff of eps^15, polynomial in n of order 8
    _f(8293864515 << 29), -_f(80835230175 << 26), _f(35736027705 << 27),
    -_f(37780361325 << 26), -_f(587595645 << 28), _f(26485772901 << 26),
    -_f(13655575661 << 27), _f(14786628311 << 26),
    -_f(57193562335 << 22), _f2(580606, 0x6851cc5de4441),
    # C4[13], coeff of eps^14, polynomial in n of order 9
    _f(2173316805 << 28), -_f(627936225 << 31), _f(9404910795 << 28),
    -_f(7129362555 << 29), _f(17350941825 << 28), -_f(4150093185 << 30),
    _f(12011779143 << 28), -_f(3068922857 << 29), _f(1952950909 << 28),
    -_f(9206768571 << 23), _f2(580606, 0x6851cc5de4441),
    # C4[13], coeff of eps^13, polynomial in n of order 10
    _f(79676025 << 27), -_f(638856855 << 26), _f(256634805 << 29),
    -_f(5389330905 << 26), _f(5842215855 << 27), -_f(21011478075 << 26),
    _f(7804263285 << 28), -_f(37664053245 << 26), _f(17576558181 << 27),
    -_f(21482459999 << 26), _f(95136608567 << 22),
    _f2(580606, 0x6851cc5de4441),
    # C4[14], coeff of eps^23, polynomial in n of order 0
    _f(433 << 27), _f(0x16f0fb486be35c9),
    # C4[14], coeff of eps^22, polynomial in n of order 1
    _f(938669 << 29), -_f(8460179 << 26), _f2(36683, 0x318959e11f277),
    # C4[14], coeff of eps^21, polynomial in n of order 2
    _f(1085551 << 33), -_f(531601 << 32), _f(109557 << 28),
    _f2(36683, 0x318959e11f277),
    # C4[14], coeff of eps^20, polynomial in n of order 3
    -_f(34899909 << 31), _f(11630633 << 32), _f(16602985 << 31),
    -_f(73138345 << 28), _f2(623614, 0x4a1ef7f3119e7),
    # C4[14], coeff of eps^19, polynomial in n of order 4
    _f(2603869 << 34), -_f(18588201 << 32), _f(4394077 << 33),
    -_f(1312099 << 32), -_f(1449057 << 28), _f2(89087, 0xc172236bddf21),
    # C4[14], coeff of eps^18, polynomial in n of order 5
    _f(1218191717 << 27), _f(79106081 << 29), -_f(371875421 << 27),
    -_f(20795103 << 28), _f(151229409 << 27), -_f(409250479 << 24),
    _f2(89087, 0xc172236bddf21),
    # C4[14], coeff of eps^17, polynomial in n of order 6
    _f(249532965 << 30), -_f(917899213 << 29), _f(191097911 << 31),
    -_f(363925371 << 29), _f(41606327 << 30), _f(1574359 << 29),
    -_f(54936843 << 25), _f2(89087, 0xc172236bddf21),
    # C4[14], coeff of eps^16, polynomial in n of order 7
    -_f(19067218845 << 28), _f(7820446095 << 29), -_f(7262714151 << 28),
    -_f(421931643 << 30), _f(6566089551 << 28), -_f(3155926907 << 29),
    _f(3340375493 << 28), -_f(6416838701 << 25),
    _f2(623614, 0x4a1ef7f3119e7),
    # C4[14], coeff of eps^15, polynomial in n of order 8
    -_f(353006415 << 32), _f(4931374455 << 29), -_f(3531935085 << 30),
    _f(8211223125 << 29), -_f(1894184271 << 31), _f(5332188211 << 29),
    -_f(1334642127 << 30), _f(836978961 << 29), -_f(1952950909 << 25),
    _f2(623614, 0x4a1ef7f3119e7),
    # C4[14], coeff of eps^14, polynomial in n of order 9
    -_f(436268025 << 27), _f(158349135 << 30), -_f(3064521495 << 27),
    _f(3110604525 << 28), -_f(10615555125 << 27), _f(3784676175 << 29),
    -_f(17712284499 << 27), _f(8090796623 << 28), -_f(9764754545 << 27),
    _f(21482459999 << 24), _f2(623614, 0x4a1ef7f3119e7),
    # C4[15], coeff of eps^23, polynomial in n of order 0
    -_f(11003 << 27), _f(0x6a44bb11ad2310d),
    # C4[15], coeff of eps^22, polynomial in n of order 1
    -_f(28003 << 36), _f(3549 << 30), _f2(39213, 0x11a47a8f8b3bd),
    # C4[15], coeff of eps^21, polynomial in n of order 2
    _f(1243 << 38), _f(2249 << 37), -_f(577583 << 28),
    _f2(5601, 0xddf2ecefef51b),
    # C4[15], coeff of eps^20, polynomial in n of order 3
    -_f(28101 << 40), _f(24493 << 39), -_f(1645 << 40),
    -_f(318801 << 29), _f2(39213, 0x11a47a8f8b3bd),
    # C4[15], coeff of eps^19, polynomial in n of order 4
    _f(1359187 << 38), -_f(4447191 << 36), -_f(433293 << 37),
    _f(1982883 << 36), -_f(164770109 << 28),
    _f2(666622, 0x2bec23883ef8d),
    # C4[15], coeff of eps^18, polynomial in n of order 5
    -_f(6907451 << 36), _f(1332757 << 38), -_f(2401277 << 36),
    _f(253189 << 37), _f(26273 << 36), -_f(1574359 << 30),
    _f2(95231, 0xbd21bbeee46cb),
    # C4[15], coeff of eps^17, polynomial in n of order 6
    _f(60642045 << 33), -_f(48519929 << 32), -_f(5596337 << 34),
    _f(57431697 << 32), -_f(26089089 << 33), _f(27095547 << 32),
    -_f(828361417 << 25), _f2(95231, 0xbd21bbeee46cb),
    # C4[15], coeff of eps^16, polynomial in n of order 7
    _f(53036505 << 34), -_f(36153285 << 35), _f(80745483 << 34),
    -_f(18042031 << 36), _f(49556941 << 34), -_f(12180567 << 35),
    _f(7540351 << 34), -_f(278992987 << 26),
    _f2(222207, 0x63f9612d6a52f),
    # C4[15], coeff of eps^15, polynomial in n of order 8
    _f(5892945 << 35), -_f(106383165 << 32), _f(102040995 << 33),
    -_f(332742375 << 32), _f(114463377 << 34), -_f(521444273 << 32),
    _f(233750881 << 33), -_f(278992987 << 32), _f(9764754545 << 25),
    _f2(666622, 0x2bec23883ef8d),
    # C4[16], coeff of eps^23, polynomial in n of order 0
    -_f(1 << 31), _f(0x5f43434b6401e1),
    # C4[16], coeff of eps^22, polynomial in n of order 1
    _f(4571 << 36), -_f(33945 << 32), _f2(5963, 0x471b5f51fec25),
    # C4[16], coeff of eps^21, polynomial in n of order 2
    _f(24269 << 36), -_f(5831 << 35), -_f(11703 << 31),
    _f2(5963, 0x471b5f51fec25),
    # C4[16], coeff of eps^20, polynomial in n of order 3
    -_f(224895 << 36), -_f(32277 << 37), _f(111531 << 36),
    -_f(139825 << 34), _f2(41742, 0xf1bf9b3df7503),
    # C4[16], coeff of eps^19, polynomial in n of order 4
    _f(978405 << 37), -_f(1674813 << 35), _f(162197 << 36),
    _f(29281 << 35), -_f(297087 << 31), _f2(41742, 0xf1bf9b3df7503),
    # C4[16], coeff of eps^18, polynomial in n of order 5
    -_f(15263501 << 36), -_f(3038189 << 38), _f(24413445 << 36),
    -_f(10587549 << 37), _f(10822455 << 36), -_f(41181917 << 32),
    _f2(709630, 0xdb94f1d6c533),
    # C4[16], coeff of eps^17, polynomial in n of order 6
    -_f(7565085 << 36), _f(16306961 << 35), -_f(3541967 << 37),
    _f(9518487 << 35), -_f(2301919 << 36), _f(1408637 << 35),
    -_f(3231579 << 31), _f2(101375, 0xb8d15471eae75),
    # C4[16], coeff of eps^16, polynomial in n of order 7
    -_f(57998985 << 33), _f(52955595 << 34), -_f(165927531 << 33),
    _f(55309177 << 35), -_f(246030477 << 33), _f(108465049 << 34),
    -_f(128185967 << 33), _f(278992987 << 30),
    _f2(709630, 0xdb94f1d6c533),
    # C4[17], coeff of eps^23, polynomial in n of order 0
    -_f(1121 << 31), _f(0x6ef59e61feaaea7),
    # C4[17], coeff of eps^22, polynomial in n of order 1
    -_f(59 << 37), -_f(309 << 32), _f(0x14ce0db25fc00bf5),
    # C4[17], coeff of eps^21, polynomial in n of order 2
    -_f(10703 << 36), _f(30413 << 35), -_f(148003 << 31),
    _f2(6324, 0xb043d1b40e32f),
    # C4[17], coeff of eps^20, polynomial in n of order 3
    -_f(177777 << 38), _f(15715 << 39), _f(4277 << 38),
    -_f(68103 << 33), _f2(44272, 0xd1dabbec63649),
    # C4[17], coeff of eps^19, polynomial in n of order 4
    -_f(407783 << 37), _f(2775087 << 35), -_f(1157751 << 36),
    _f(1167621 << 35), -_f(4428011 << 31), _f2(44272, 0xd1dabbec63649),
    # C4[17], coeff of eps^18, polynomial in n of order 5
    _f(1580535 << 37), -_f(334719 << 39), _f(882049 << 37),
    -_f(210231 << 38), _f(127323 << 37), -_f(580027 << 32),
    _f2(44272, 0xd1dabbec63649),
    # C4[17], coeff of eps^17, polynomial in n of order 6
    _f(801009 << 36), -_f(2422805 << 35), _f(785323 << 37),
    -_f(3419955 << 35), _f(1485435 << 36), -_f(1740081 << 35),
    _f(7540351 << 31), _f2(44272, 0xd1dabbec63649),
    # C4[18], coeff of eps^23, polynomial in n of order 0
    -_f(89 << 35), _f(0x3351994085c8a607),
    # C4[18], coeff of eps^22, polynomial in n of order 1
    _f(763 << 36), -_f(1809 << 33), _f(0x15fe66403955fe03),
    # C4[18], coeff of eps^21, polynomial in n of order 2
    _f(91 << 39), _f(35 << 38), -_f(235 << 34),
    _f(0x15fe66403955fe03),
    # C4[18], coeff of eps^20, polynomial in n of order 3
    _f(667755 << 37), -_f(269591 << 38), _f(268793 << 37),
    -_f(508305 << 34), _f2(46802, 0xb1f5dc9acf78f),
    # C4[18], coeff of eps^19, polynomial in n of order 4
    -_f(51319 << 40), _f(132867 << 38), -_f(31255 << 39),
    _f(18753 << 38), -_f(42441 << 34), _f2(15600, 0xe5fc9ede45285),
    # C4[18], coeff of eps^18, polynomial in n of order 5
    -_f(1198615 << 36), _f(378917 << 38), -_f(1619009 << 36),
    _f(693861 << 37), -_f(806379 << 36), _f(1740081 << 33),
    _f2(46802, 0xb1f5dc9acf78f),
    # C4[19], coeff of eps^23, polynomial in n of order 0
    -_f(983 << 35), _f(0x3617bd362c26857d),
    # C4[19], coeff of eps^22, polynomial in n of order 1
    _f(1 << 46), -_f(189 << 37), _f2(2596, 0x737a284739077),
    # C4[19], coeff of eps^21, polynomial in n of order 2
    -_f(473 << 40), _f(467 << 39), -_f(3525 << 34),
    _f(0x172ebece12ebf011),
    # C4[19], coeff of eps^20, polynomial in n of order 3
    _f(2379 << 41), -_f(553 << 42), _f(329 << 41), -_f(2961 << 35),
    _f2(2596, 0x737a284739077),
    # C4[19], coeff of eps^19, polynomial in n of order 4
    _f(2405 << 41), -_f(10101 << 39), _f(4277 << 40), -_f(4935 << 39),
    _f(42441 << 34), _f2(2596, 0x737a284739077),
    # C4[20], coeff of eps^23, polynomial in n of order 0
    -_f(1 << 38), _f(0x1f5feefdb1f0c4f),
    # C4[20], coeff of eps^22, polynomial in n of order 1
    _f(379 << 42), -_f(357 << 40), _f2(2729, 0x9a383778d2ed9),
    # C4[20], coeff of eps^21, polynomial in n of order 2
    -_f(249 << 43), _f(147 << 42), -_f(329 << 38),
    _f2(2729, 0x9a383778d2ed9),
    # C4[20], coeff of eps^20, polynomial in n of order 3
    -_f(4797 << 40), _f(2009 << 41), -_f(2303 << 40), _f(4935 << 37),
    _f2(2729, 0x9a383778d2ed9),
    # C4[21], coeff of eps^23, polynomial in n of order 0
    -_f(1327 << 38), _f2(2862, 0xc0f646aa6cd3b),
    # C4[21], coeff of eps^22, polynomial in n of order 1
    _f(11 << 44), -_f(49 << 39), _f(0x3ba4052178e24469),
    # C4[21], coeff of eps^21, polynomial in n of order 2
    _f(473 << 43), -_f(539 << 42), _f(2303 << 38),
    _f2(2862, 0xc0f646aa6cd3b),
    # C4[22], coeff of eps^23, polynomial in n of order 0
    -_f(1 << 41), _f(0x5ac8f5f3162ebfd),
    # C4[22], coeff of eps^22, polynomial in n of order 1
    -_f(23 << 43), _f(49 << 40), _f(0x1105ae1d9428c3f7),
    # C4[23], coeff of eps^23, polynomial in n of order 0
    _f(1 << 41), _f(0xc5e28ed2c935ab),  # PYCHOK exported
)  # 2900

# **) MIT License
#
# Copyright (C) 2016-2022 -- mrJean1 at Gmail -- All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
