/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.objectweb.proactive.utils.StackTraceUtil;
import org.ow2.proactive.scheduler.common.util.Object2ByteConverter;

public class AllObjects2BytesConverterHandler {
    private static final Logger logger = Logger.getLogger(AllObjects2BytesConverterHandler.class);
    private static final String TIMEOUT_JAVA_PROPERTY = "pa.max.deserialization.seconds";
    private static final String DESERIALIZATION_THRESHOLD = "pa.max.deserialization.threshold";
    private static final Long secondsToWait = Long.getLong("pa.max.deserialization.seconds", 120L);
    private static final Long deserializationThreshold = Long.getLong("pa.max.deserialization.threshold", 1000000L);
    private static final String ERROR_MESSAGE = " was stuck for more than " + secondsToWait + " seconds and the thread analysis detected a jython deadlock (see https://bugs.jython.org/issue2624). Killing the Java process as the deadlock cannot be recovered (You can control this timeout with the java property -D" + "pa.max.deserialization.seconds" + "= when starting nodes and/or when starting the scheduler).";

    private AllObjects2BytesConverterHandler() {
    }

    public static Map<String, Serializable> convertAllBytes2Objects(Map<String, byte[]> target, ClassLoader cl) {
        long totalBytes = target != null ? (long)target.values().stream().mapToInt(value -> value != null ? ((byte[])value).length : 0).sum() : 0L;
        return AllObjects2BytesConverterHandler.convert("Deserialization of variables", AllObjects2BytesConverterHandler.createDeserializeCollable(target, cl), totalBytes);
    }

    public static Map<String, byte[]> convertAllObjects2Bytes(Map<String, Serializable> variableMap) {
        return AllObjects2BytesConverterHandler.convert("Serialization of variables", AllObjects2BytesConverterHandler.createSerializableCallable(variableMap), Long.MAX_VALUE);
    }

    public static byte[] convertObject2Byte(String key, Serializable value) {
        return AllObjects2BytesConverterHandler.convertSingle("Serialization of single value", AllObjects2BytesConverterHandler.createSerializeSingleValueCollable(key, value), Long.MAX_VALUE);
    }

    public static Serializable convertByte2Object(byte[] value) {
        return AllObjects2BytesConverterHandler.convertSingle("Deserialization of single value", AllObjects2BytesConverterHandler.createDeserializeSingleValueCollable(value), value != null ? (long)value.length : 0L);
    }

    private static <K, V> Map<K, V> convert(String action, Callable<Map<K, V>> callable, long totalSize) {
        Map resultMap;
        block10: {
            resultMap = new HashMap();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Map<K, V>> future = executor.submit(callable);
            try {
                try {
                    if (totalSize < deserializationThreshold) {
                        resultMap = future.get(secondsToWait, TimeUnit.SECONDS);
                        break block10;
                    }
                    resultMap = future.get();
                }
                catch (TimeoutException e) {
                    if (StackTraceUtil.getAllStackTraces().contains("org.python.core")) {
                        logger.fatal((Object)(action + ERROR_MESSAGE));
                        System.exit(1);
                    }
                    resultMap = future.get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                executor.shutdownNow();
            }
        }
        return resultMap;
    }

    private static <V> V convertSingle(String action, Callable<V> callable, long totalSize) {
        V result = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<V> future = executor.submit(callable);
        try {
            result = totalSize < deserializationThreshold ? (V)future.get(secondsToWait, TimeUnit.SECONDS) : (V)future.get();
        }
        catch (TimeoutException e) {
            logger.fatal((Object)(action + ERROR_MESSAGE));
            System.exit(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdownNow();
        }
        return result;
    }

    private static Callable<Map<String, byte[]>> createSerializableCallable(final Map<String, Serializable> variableMap) {
        return new Callable<Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> call() throws ClassNotFoundException, IOException {
                HashMap<String, byte[]> serializedMap = new HashMap<String, byte[]>();
                for (String key : variableMap.keySet()) {
                    Serializable value = (Serializable)variableMap.get(key);
                    byte[] serialized = AllObjects2BytesConverterHandler.serialiseValue(key, value);
                    serializedMap.put(key, serialized);
                }
                return serializedMap;
            }
        };
    }

    private static Callable<Map<String, Serializable>> createDeserializeCollable(final Map<String, byte[]> target, final ClassLoader cl) {
        return new Callable<Map<String, Serializable>>(){

            @Override
            public Map<String, Serializable> call() throws ClassNotFoundException, IOException {
                HashMap<String, Serializable> deserializedMap = new HashMap<String, Serializable>(target.size());
                for (Map.Entry e : target.entrySet()) {
                    deserializedMap.put((String)e.getKey(), (Serializable)Object2ByteConverter.convertByte2Object((byte[])e.getValue(), cl));
                }
                return deserializedMap;
            }
        };
    }

    private static Callable<byte[]> createSerializeSingleValueCollable(final String key, final Serializable value) {
        return new Callable<byte[]>(){

            @Override
            public byte[] call() throws ClassNotFoundException, IOException {
                return AllObjects2BytesConverterHandler.serialiseValue(key, value);
            }
        };
    }

    private static Callable<Serializable> createDeserializeSingleValueCollable(final byte[] value) {
        return new Callable<Serializable>(){

            @Override
            public Serializable call() throws ClassNotFoundException, IOException {
                return (Serializable)Object2ByteConverter.convertByte2Object(value);
            }
        };
    }

    private static byte[] serialiseValue(String key, Serializable value) {
        if (key != null && key.length() > 255) {
            throw new IllegalArgumentException("Key is too long, it must have 255 chars length max : " + key);
        }
        try {
            return Object2ByteConverter.convertObject2Byte(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot add argument " + key, e);
        }
    }
}

