/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.ModelValidator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.common.util.VariableSubstitutor;

public class DefaultModelJobValidatorServiceProvider
implements JobValidatorService {
    @Override
    public void validateJob(InputStream jobInputStream) throws JobValidationException {
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job) throws JobValidationException {
        return this.validateJob(job, null, null, null);
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) throws JobValidationException {
        ModelValidatorContext context = new ModelValidatorContext(job, scheduler, space, sessionId);
        for (JobVariable jobVariable : job.getVariables().values()) {
            this.checkVariableFormat(null, jobVariable, context);
            context.updateJobWithContext(job);
        }
        for (Task task : job.getTasks()) {
            context = new ModelValidatorContext(task, scheduler, space, sessionId);
            for (TaskVariable taskVariable : task.getVariables().values()) {
                this.checkVariableFormat(task, taskVariable, context);
                context.updateTaskWithContext(task);
            }
        }
        return job;
    }

    public void validateVariables(List<JobVariable> variableList, Map<String, Serializable> userValues, Scheduler scheduler, SchedulerSpaceInterface space) throws JobValidationException {
        if (variableList == null || variableList.isEmpty() || userValues == null || userValues.isEmpty()) {
            return;
        }
        Map<String, String> models = variableList.stream().collect(Collectors.toMap(JobVariable::getName, JobVariable::getModel));
        LinkedHashSet<String> groupNames = new LinkedHashSet<String>();
        variableList.forEach(e -> {
            if (!Strings.isNullOrEmpty((String)e.getGroup())) {
                groupNames.add(e.getGroup());
            }
        });
        LinkedHashMap variableReplacement = new LinkedHashMap();
        LinkedHashMap<String, Serializable> updatedVariables = new LinkedHashMap<String, Serializable>();
        variableList.forEach(jobVariable -> {
            if (userValues.containsKey(jobVariable.getName())) {
                variableReplacement.put(jobVariable.getName(), userValues.get(jobVariable.getName()));
            } else {
                variableReplacement.put(jobVariable.getName(), jobVariable.getValue());
            }
        });
        variableList.forEach(jobVariable -> {
            jobVariable.setValue(userValues.containsKey(jobVariable.getName()) ? VariableSubstitutor.filterAndUpdate((String)userValues.get(jobVariable.getName()), (Map<? extends Serializable, ? extends Serializable>)variableReplacement) : VariableSubstitutor.filterAndUpdate(jobVariable.getValue(), (Map<? extends Serializable, ? extends Serializable>)variableReplacement));
            updatedVariables.put(jobVariable.getName(), (Serializable)((Object)jobVariable.getValue()));
        });
        ModelValidatorContext context = new ModelValidatorContext(updatedVariables, models, groupNames, scheduler, space, null);
        for (JobVariable jobVariable2 : variableList) {
            this.checkVariableFormat(null, jobVariable2, context);
        }
        context.updateJobVariablesWithContext(variableList);
    }

    protected void checkVariableFormat(Task task, JobVariable variable, ModelValidatorContext context) throws JobValidationException {
        if (variable.getModel() != null && !variable.getModel().trim().isEmpty()) {
            String model = variable.getModel().trim();
            context.setVariableName(variable.getName());
            try {
                new ModelValidator(model).validate(variable.getValue(), context, variable.isHidden());
            }
            catch (Exception e) {
                throw new JobValidationException((task != null ? "Task '" + task.getName() + "': " : "") + "Variable '" + variable.getName() + "': Model " + variable.getModel() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

