/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.utils;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.node.ObjectNode;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.eventing.EventNotification;

public class EventCodecUtil {
    private static final ObjectMapper mapper;

    private EventCodecUtil() {
    }

    public static <T> T fromJsonString(String jsonString, Class<T> valueType) {
        try {
            return (T)mapper.readValue(jsonString, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException("Parser error for jsonString : " + jsonString, e);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Parser error.", e);
        }
    }

    static {
        SimpleModule module = new SimpleModule("JsonUtilsMapper", new Version(1, 0, 0, null));
        EventNotificationDeserializer deserializer = new EventNotificationDeserializer();
        module.addDeserializer(EventNotification.class, (JsonDeserializer)deserializer);
        mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static class EventNotificationDeserializer
    extends StdDeserializer<EventNotification> {
        protected EventNotificationDeserializer() {
            super(EventNotification.class);
        }

        public EventNotification deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            EventNotification notification = new EventNotification();
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            ObjectNode root = (ObjectNode)mapper.readTree(jp);
            String actionString = root.get("action").getTextValue();
            notification.setAction(EventNotification.Action.valueOf((String)actionString));
            JsonNode data = root.get("data");
            switch (notification.getAction()) {
                case JOB_SUBMITTED: {
                    notification.setData(mapper.readValue(data, JobStateData.class));
                    break;
                }
                case JOB_STATE_UPDATED: {
                    notification.setData(mapper.readValue(data, JobInfoData.class));
                    break;
                }
                case JOB_FULL_DATA_UPDATED: {
                    notification.setData(mapper.readValue(data, JobStateData.class));
                    break;
                }
                case TASK_STATE_UPDATED: {
                    notification.setData(mapper.readValue(data, TaskInfoData.class));
                    break;
                }
                case USERS_UPDATED: {
                    notification.setData(mapper.readValue(data, SchedulerUserData.class));
                    break;
                }
            }
            notification.setSchedulerEvent(root.get("schedulerEvent").asText());
            return notification;
        }
    }
}

