/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.common.event;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.resourcemanager.common.event.RMEventType;
import org.ow2.proactive.resourcemanager.common.event.SortedUniqueSet;

@PublicAPI
public class RMEvent
implements Serializable,
Cloneable,
Comparable<RMEvent>,
SortedUniqueSet.Unique {
    private String RMUrl = null;
    protected RMEventType type;
    protected String initiator;
    protected long timeStamp;
    protected long counter;
    protected long firstCounter = 0L;
    private static final long serialVersionUID = 130L;

    public RMEvent() {
    }

    public RMEvent(long counter) {
        this.counter = counter;
    }

    public RMEvent(RMEventType type) {
        this.type = type;
        this.timeStamp = System.currentTimeMillis();
    }

    void updateFirstCounter(RMEvent another) {
        this.firstCounter = Math.min(this.firstCounter, another.firstCounter);
    }

    public long getFirstCounter() {
        return this.firstCounter;
    }

    public String getRMUrl() {
        return this.RMUrl;
    }

    public void setRMUrl(String RMURL) {
        this.RMUrl = RMURL;
    }

    public RMEventType getEventType() {
        return this.type;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getTimeStampFormatted() {
        return new SimpleDateFormat().format(new Date(this.timeStamp));
    }

    @Override
    public String getKey() {
        return Long.toString(this.getCounter());
    }

    @Override
    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
        this.firstCounter = counter;
    }

    public String toString() {
        return (Object)((Object)this.type) + (this.counter > 0L ? " counter: " + this.counter + " " : "") + "[" + this.RMUrl + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RMEvent rmEvent = (RMEvent)o;
        return this.counter == rmEvent.counter;
    }

    public int hashCode() {
        return (int)(this.counter ^ this.counter >>> 32);
    }

    @Override
    public int compareTo(RMEvent event) {
        return Long.compare(this.counter, event.counter);
    }
}

