/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.util.Base64;
import java.net.ConnectException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HostnameVerifierListener
implements SSLBaseFilter.HandshakeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostnameVerifierListener.class);
    private static final Attribute<HostnameVerifierTask> VERIFIER_TASK_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HostnameVerifierTask.class.getName());

    public void onStart(Connection connection) {
        LOGGER.debug("SSL Handshake onStart: ");
    }

    public void onFailure(Connection connection, Throwable t) {
        HostnameVerifierTask task = (HostnameVerifierTask)VERIFIER_TASK_ATTR.remove((AttributeStorage)connection);
        if (task != null) {
            task.delegate.failed(t);
        }
    }

    public void onComplete(Connection connection) {
        HostnameVerifierTask task = (HostnameVerifierTask)VERIFIER_TASK_ATTR.remove((AttributeStorage)connection);
        if (task != null) {
            task.verify();
        }
    }

    static CompletionHandler<Connection> wrapWithHostnameVerifierHandler(final CompletionHandler<Connection> completionHandler, final HostnameVerifier verifier, final String host) {
        return new CompletionHandler<Connection>(){

            public void cancelled() {
                if (completionHandler != null) {
                    completionHandler.cancelled();
                }
            }

            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
            }

            public void completed(Connection connection) {
                HostnameVerifierListener.assignHostnameVerifyTask(connection, verifier, host, (CompletionHandler<Connection>)completionHandler);
                if (completionHandler != null) {
                    completionHandler.completed((Object)connection);
                }
            }

            public void updated(Connection connection) {
                if (completionHandler != null) {
                    completionHandler.updated((Object)connection);
                }
            }
        };
    }

    private static void assignHostnameVerifyTask(Connection connection, HostnameVerifier verifier, String host, CompletionHandler<Connection> delegate) {
        HostnameVerifierTask task = new HostnameVerifierTask(verifier, connection, host, delegate);
        VERIFIER_TASK_ATTR.set((AttributeStorage)connection, (Object)task);
    }

    private static class HostnameVerifierTask {
        private final HostnameVerifier verifier;
        private final Connection connection;
        private final String host;
        private final CompletionHandler<Connection> delegate;

        public HostnameVerifierTask(HostnameVerifier verifier, Connection connection, String host, CompletionHandler<Connection> delegate) {
            this.verifier = verifier;
            this.connection = connection;
            this.host = host;
            this.delegate = delegate;
        }

        public void verify() {
            SSLSession session = SSLUtils.getSSLEngine((Connection)this.connection).getSession();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SSL Handshake onComplete: session = {}, id = {}, isValid = {}, host = {}", new Object[]{session.toString(), Base64.encode(session.getId()), session.isValid(), this.host});
            }
            if (!this.verifier.verify(this.host, session)) {
                this.connection.terminateSilently();
                ConnectException e = new ConnectException("Host name verification failed for host " + this.host);
                this.delegate.failed((Throwable)e);
            }
        }
    }
}

