# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AadAuthenticationParameters(_serialization.Model):
    """AAD Vpn authentication type related parameters.

    :ivar aad_tenant: AAD Vpn authentication parameter AAD tenant.
    :vartype aad_tenant: str
    :ivar aad_audience: AAD Vpn authentication parameter AAD audience.
    :vartype aad_audience: str
    :ivar aad_issuer: AAD Vpn authentication parameter AAD issuer.
    :vartype aad_issuer: str
    """

    _attribute_map = {
        "aad_tenant": {"key": "aadTenant", "type": "str"},
        "aad_audience": {"key": "aadAudience", "type": "str"},
        "aad_issuer": {"key": "aadIssuer", "type": "str"},
    }

    def __init__(
        self,
        *,
        aad_tenant: Optional[str] = None,
        aad_audience: Optional[str] = None,
        aad_issuer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword aad_tenant: AAD Vpn authentication parameter AAD tenant.
        :paramtype aad_tenant: str
        :keyword aad_audience: AAD Vpn authentication parameter AAD audience.
        :paramtype aad_audience: str
        :keyword aad_issuer: AAD Vpn authentication parameter AAD issuer.
        :paramtype aad_issuer: str
        """
        super().__init__(**kwargs)
        self.aad_tenant = aad_tenant
        self.aad_audience = aad_audience
        self.aad_issuer = aad_issuer


class AddressSpace(_serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :ivar address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :vartype address_prefixes: list[str]
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
    }

    def __init__(self, *, address_prefixes: Optional[List[str]] = None, **kwargs):
        """
        :keyword address_prefixes: A list of address blocks reserved for this virtual network in CIDR
         notation.
        :paramtype address_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes


class Resource(_serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar identity: The identity of the application gateway, if configured.
    :vartype identity: ~azure.mgmt.network.v2019_08_01.models.ManagedServiceIdentity
    :ivar sku: SKU of the application gateway resource.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySku
    :ivar ssl_policy: SSL policy of the application gateway resource.
    :vartype ssl_policy: ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway resource. Known values
     are: "Stopped", "Starting", "Running", and "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayOperationalState
    :ivar gateway_ip_configurations: Subnets of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype gateway_ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayIPConfiguration]
    :ivar authentication_certificates: Authentication certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype authentication_certificates:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayAuthenticationCertificate]
    :ivar trusted_root_certificates: Trusted Root certificates of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype trusted_root_certificates:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayTrustedRootCertificate]
    :ivar ssl_certificates: SSL certificates of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype ssl_certificates:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCertificate]
    :ivar frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFrontendIPConfiguration]
    :ivar frontend_ports: Frontend ports of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype frontend_ports:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFrontendPort]
    :ivar probes: Probes of the application gateway resource.
    :vartype probes: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProbe]
    :ivar backend_address_pools: Backend address pool of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool]
    :ivar backend_http_settings_collection: Backend http settings of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHttpSettings]
    :ivar http_listeners: Http listeners of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype http_listeners:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayHttpListener]
    :ivar url_path_maps: URL path map of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype url_path_maps:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayUrlPathMap]
    :ivar request_routing_rules: Request routing rules of the application gateway resource.
    :vartype request_routing_rules:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRequestRoutingRule]
    :ivar rewrite_rule_sets: Rewrite rules for the application gateway resource.
    :vartype rewrite_rule_sets:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRuleSet]
    :ivar redirect_configurations: Redirect configurations of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype redirect_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRedirectConfiguration]
    :ivar web_application_firewall_configuration: Web application firewall configuration.
    :vartype web_application_firewall_configuration:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :ivar firewall_policy: Reference of the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar enable_http2: Whether HTTP2 is enabled on the application gateway resource.
    :vartype enable_http2: bool
    :ivar enable_fips: Whether FIPS is enabled on the application gateway resource.
    :vartype enable_fips: bool
    :ivar autoscale_configuration: Autoscale Configuration.
    :vartype autoscale_configuration:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayAutoscaleConfiguration
    :ivar resource_guid: The resource GUID property of the application gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar custom_error_configurations: Custom error configurations of the application gateway
     resource.
    :vartype custom_error_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCustomError]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operational_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "sku": {"key": "properties.sku", "type": "ApplicationGatewaySku"},
        "ssl_policy": {"key": "properties.sslPolicy", "type": "ApplicationGatewaySslPolicy"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "gateway_ip_configurations": {
            "key": "properties.gatewayIPConfigurations",
            "type": "[ApplicationGatewayIPConfiguration]",
        },
        "authentication_certificates": {
            "key": "properties.authenticationCertificates",
            "type": "[ApplicationGatewayAuthenticationCertificate]",
        },
        "trusted_root_certificates": {
            "key": "properties.trustedRootCertificates",
            "type": "[ApplicationGatewayTrustedRootCertificate]",
        },
        "ssl_certificates": {"key": "properties.sslCertificates", "type": "[ApplicationGatewaySslCertificate]"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[ApplicationGatewayFrontendIPConfiguration]",
        },
        "frontend_ports": {"key": "properties.frontendPorts", "type": "[ApplicationGatewayFrontendPort]"},
        "probes": {"key": "properties.probes", "type": "[ApplicationGatewayProbe]"},
        "backend_address_pools": {
            "key": "properties.backendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "backend_http_settings_collection": {
            "key": "properties.backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHttpSettings]",
        },
        "http_listeners": {"key": "properties.httpListeners", "type": "[ApplicationGatewayHttpListener]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[ApplicationGatewayUrlPathMap]"},
        "request_routing_rules": {
            "key": "properties.requestRoutingRules",
            "type": "[ApplicationGatewayRequestRoutingRule]",
        },
        "rewrite_rule_sets": {"key": "properties.rewriteRuleSets", "type": "[ApplicationGatewayRewriteRuleSet]"},
        "redirect_configurations": {
            "key": "properties.redirectConfigurations",
            "type": "[ApplicationGatewayRedirectConfiguration]",
        },
        "web_application_firewall_configuration": {
            "key": "properties.webApplicationFirewallConfiguration",
            "type": "ApplicationGatewayWebApplicationFirewallConfiguration",
        },
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "enable_http2": {"key": "properties.enableHttp2", "type": "bool"},
        "enable_fips": {"key": "properties.enableFips", "type": "bool"},
        "autoscale_configuration": {
            "key": "properties.autoscaleConfiguration",
            "type": "ApplicationGatewayAutoscaleConfiguration",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "custom_error_configurations": {
            "key": "properties.customErrorConfigurations",
            "type": "[ApplicationGatewayCustomError]",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.ApplicationGatewaySku"] = None,
        ssl_policy: Optional["_models.ApplicationGatewaySslPolicy"] = None,
        gateway_ip_configurations: Optional[List["_models.ApplicationGatewayIPConfiguration"]] = None,
        authentication_certificates: Optional[List["_models.ApplicationGatewayAuthenticationCertificate"]] = None,
        trusted_root_certificates: Optional[List["_models.ApplicationGatewayTrustedRootCertificate"]] = None,
        ssl_certificates: Optional[List["_models.ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[List["_models.ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[List["_models.ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[List["_models.ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[List["_models.ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHttpSettings"]] = None,
        http_listeners: Optional[List["_models.ApplicationGatewayHttpListener"]] = None,
        url_path_maps: Optional[List["_models.ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[List["_models.ApplicationGatewayRequestRoutingRule"]] = None,
        rewrite_rule_sets: Optional[List["_models.ApplicationGatewayRewriteRuleSet"]] = None,
        redirect_configurations: Optional[List["_models.ApplicationGatewayRedirectConfiguration"]] = None,
        web_application_firewall_configuration: Optional[
            "_models.ApplicationGatewayWebApplicationFirewallConfiguration"
        ] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        enable_http2: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        autoscale_configuration: Optional["_models.ApplicationGatewayAutoscaleConfiguration"] = None,
        resource_guid: Optional[str] = None,
        custom_error_configurations: Optional[List["_models.ApplicationGatewayCustomError"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword identity: The identity of the application gateway, if configured.
        :paramtype identity: ~azure.mgmt.network.v2019_08_01.models.ManagedServiceIdentity
        :keyword sku: SKU of the application gateway resource.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySku
        :keyword ssl_policy: SSL policy of the application gateway resource.
        :paramtype ssl_policy: ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicy
        :keyword gateway_ip_configurations: Subnets of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype gateway_ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayIPConfiguration]
        :keyword authentication_certificates: Authentication certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayAuthenticationCertificate]
        :keyword trusted_root_certificates: Trusted Root certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype trusted_root_certificates:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayTrustedRootCertificate]
        :keyword ssl_certificates: SSL certificates of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype ssl_certificates:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCertificate]
        :keyword frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
         For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFrontendIPConfiguration]
        :keyword frontend_ports: Frontend ports of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype frontend_ports:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFrontendPort]
        :keyword probes: Probes of the application gateway resource.
        :paramtype probes: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProbe]
        :keyword backend_address_pools: Backend address pool of the application gateway resource. For
         default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool]
        :keyword backend_http_settings_collection: Backend http settings of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHttpSettings]
        :keyword http_listeners: Http listeners of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype http_listeners:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayHttpListener]
        :keyword url_path_maps: URL path map of the application gateway resource. For default limits,
         see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype url_path_maps:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayUrlPathMap]
        :keyword request_routing_rules: Request routing rules of the application gateway resource.
        :paramtype request_routing_rules:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRequestRoutingRule]
        :keyword rewrite_rule_sets: Rewrite rules for the application gateway resource.
        :paramtype rewrite_rule_sets:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRuleSet]
        :keyword redirect_configurations: Redirect configurations of the application gateway resource.
         For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype redirect_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRedirectConfiguration]
        :keyword web_application_firewall_configuration: Web application firewall configuration.
        :paramtype web_application_firewall_configuration:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
        :keyword firewall_policy: Reference of the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword enable_http2: Whether HTTP2 is enabled on the application gateway resource.
        :paramtype enable_http2: bool
        :keyword enable_fips: Whether FIPS is enabled on the application gateway resource.
        :paramtype enable_fips: bool
        :keyword autoscale_configuration: Autoscale Configuration.
        :paramtype autoscale_configuration:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayAutoscaleConfiguration
        :keyword resource_guid: The resource GUID property of the application gateway resource.
        :paramtype resource_guid: str
        :keyword custom_error_configurations: Custom error configurations of the application gateway
         resource.
        :paramtype custom_error_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCustomError]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.zones = zones
        self.identity = identity
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.rewrite_rule_sets = rewrite_rule_sets
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.firewall_policy = firewall_policy
        self.enable_http2 = enable_http2
        self.enable_fips = enable_fips
        self.autoscale_configuration = autoscale_configuration
        self.resource_guid = resource_guid
        self.provisioning_state = None
        self.custom_error_configurations = custom_error_configurations


class SubResource(_serialization.Model):
    """Reference to another subresource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApplicationGatewayAuthenticationCertificate(SubResource):
    """Authentication certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the authentication certificate that is unique within an Application
     Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar provisioning_state: The provisioning state of the authentication certificate resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the authentication certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword data: Certificate public data.
        :paramtype data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.provisioning_state = None


class ApplicationGatewayAutoscaleConfiguration(_serialization.Model):
    """Application Gateway autoscale configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar min_capacity: Lower bound on number of Application Gateway capacity. Required.
    :vartype min_capacity: int
    :ivar max_capacity: Upper bound on number of Application Gateway capacity.
    :vartype max_capacity: int
    """

    _validation = {
        "min_capacity": {"required": True, "minimum": 0},
        "max_capacity": {"minimum": 2},
    }

    _attribute_map = {
        "min_capacity": {"key": "minCapacity", "type": "int"},
        "max_capacity": {"key": "maxCapacity", "type": "int"},
    }

    def __init__(self, *, min_capacity: int, max_capacity: Optional[int] = None, **kwargs):
        """
        :keyword min_capacity: Lower bound on number of Application Gateway capacity. Required.
        :paramtype min_capacity: int
        :keyword max_capacity: Upper bound on number of Application Gateway capacity.
        :paramtype max_capacity: int
        """
        super().__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar predefined_policies: List of available Ssl predefined policy.
    :vartype predefined_policies: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar default_policy: Name of the Ssl predefined policy applied by default to application
     gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", and
     "AppGwSslPolicy20170401S".
    :vartype default_policy: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicyName
    :ivar available_cipher_suites: List of available Ssl cipher suites.
    :vartype available_cipher_suites: list[str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCipherSuite]
    :ivar available_protocols: List of available Ssl protocols.
    :vartype available_protocols: list[str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "predefined_policies": {"key": "properties.predefinedPolicies", "type": "[SubResource]"},
        "default_policy": {"key": "properties.defaultPolicy", "type": "str"},
        "available_cipher_suites": {"key": "properties.availableCipherSuites", "type": "[str]"},
        "available_protocols": {"key": "properties.availableProtocols", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        predefined_policies: Optional[List["_models.SubResource"]] = None,
        default_policy: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        available_cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        available_protocols: Optional[List[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword predefined_policies: List of available Ssl predefined policy.
        :paramtype predefined_policies: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword default_policy: Name of the Ssl predefined policy applied by default to application
         gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", and
         "AppGwSslPolicy20170401S".
        :paramtype default_policy: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicyName
        :keyword available_cipher_suites: List of available Ssl cipher suites.
        :paramtype available_cipher_suites: list[str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCipherSuite]
        :keyword available_protocols: List of available Ssl protocols.
        :paramtype available_protocols: list[str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.predefined_policies = predefined_policies
        self.default_policy = default_policy
        self.available_cipher_suites = available_cipher_suites
        self.available_protocols = available_protocols


class ApplicationGatewayAvailableSslPredefinedPolicies(_serialization.Model):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    :ivar value: List of available Ssl predefined policy.
    :vartype value:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPredefinedPolicy]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewaySslPredefinedPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationGatewaySslPredefinedPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of available Ssl predefined policy.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPredefinedPolicy]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayAvailableWafRuleSetsResult(_serialization.Model):
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :ivar value: The list of application gateway rule sets.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayFirewallRuleSet]"},
    }

    def __init__(self, *, value: Optional[List["_models.ApplicationGatewayFirewallRuleSet"]] = None, **kwargs):
        """
        :keyword value: The list of application gateway rule sets.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallRuleSet]
        """
        super().__init__(**kwargs)
        self.value = value


class ApplicationGatewayBackendAddress(_serialization.Model):
    """Backend address of an application gateway.

    :ivar fqdn: Fully qualified domain name (FQDN).
    :vartype fqdn: str
    :ivar ip_address: IP address.
    :vartype ip_address: str
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, fqdn: Optional[str] = None, ip_address: Optional[str] = None, **kwargs):
        """
        :keyword fqdn: Fully qualified domain name (FQDN).
        :paramtype fqdn: str
        :keyword ip_address: IP address.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend address pool that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: Collection of references to IPs defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
    :ivar backend_addresses: Backend addresses.
    :vartype backend_addresses:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "backend_addresses": {"key": "properties.backendAddresses", "type": "[ApplicationGatewayBackendAddress]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        backend_ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        backend_addresses: Optional[List["_models.ApplicationGatewayBackendAddress"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend address pool that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword backend_ip_configurations: Collection of references to IPs defined in network
         interfaces.
        :paramtype backend_ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
        :keyword backend_addresses: Backend addresses.
        :paramtype backend_addresses:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddress]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.backend_ip_configurations = backend_ip_configurations
        self.backend_addresses = backend_addresses
        self.provisioning_state = None


class ApplicationGatewayBackendHealth(_serialization.Model):
    """Response for ApplicationGatewayBackendHealth API service call.

    :ivar backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        "backend_address_pools": {"key": "backendAddressPools", "type": "[ApplicationGatewayBackendHealthPool]"},
    }

    def __init__(
        self, *, backend_address_pools: Optional[List["_models.ApplicationGatewayBackendHealthPool"]] = None, **kwargs
    ):
        """
        :keyword backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthPool]
        """
        super().__init__(**kwargs)
        self.backend_address_pools = backend_address_pools


class ApplicationGatewayBackendHealthHttpSettings(_serialization.Model):
    """Application gateway BackendHealthHttp settings.

    :ivar backend_http_settings: Reference of an ApplicationGatewayBackendHttpSettings resource.
    :vartype backend_http_settings:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHttpSettings
    :ivar servers: List of ApplicationGatewayBackendHealthServer resources.
    :vartype servers:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        "backend_http_settings": {"key": "backendHttpSettings", "type": "ApplicationGatewayBackendHttpSettings"},
        "servers": {"key": "servers", "type": "[ApplicationGatewayBackendHealthServer]"},
    }

    def __init__(
        self,
        *,
        backend_http_settings: Optional["_models.ApplicationGatewayBackendHttpSettings"] = None,
        servers: Optional[List["_models.ApplicationGatewayBackendHealthServer"]] = None,
        **kwargs
    ):
        """
        :keyword backend_http_settings: Reference of an ApplicationGatewayBackendHttpSettings resource.
        :paramtype backend_http_settings:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHttpSettings
        :keyword servers: List of ApplicationGatewayBackendHealthServer resources.
        :paramtype servers:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthServer]
        """
        super().__init__(**kwargs)
        self.backend_http_settings = backend_http_settings
        self.servers = servers


class ApplicationGatewayBackendHealthOnDemand(_serialization.Model):
    """Result of on demand test probe.

    :ivar backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
    :vartype backend_address_pool:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool
    :ivar backend_health_http_settings: Application gateway BackendHealthHttp settings.
    :vartype backend_health_http_settings:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthHttpSettings
    """

    _attribute_map = {
        "backend_address_pool": {"key": "backendAddressPool", "type": "ApplicationGatewayBackendAddressPool"},
        "backend_health_http_settings": {
            "key": "backendHealthHttpSettings",
            "type": "ApplicationGatewayBackendHealthHttpSettings",
        },
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["_models.ApplicationGatewayBackendAddressPool"] = None,
        backend_health_http_settings: Optional["_models.ApplicationGatewayBackendHealthHttpSettings"] = None,
        **kwargs
    ):
        """
        :keyword backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
        :paramtype backend_address_pool:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool
        :keyword backend_health_http_settings: Application gateway BackendHealthHttp settings.
        :paramtype backend_health_http_settings:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthHttpSettings
        """
        super().__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_health_http_settings = backend_health_http_settings


class ApplicationGatewayBackendHealthPool(_serialization.Model):
    """Application gateway BackendHealth pool.

    :ivar backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
    :vartype backend_address_pool:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool
    :ivar backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
     resources.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        "backend_address_pool": {"key": "backendAddressPool", "type": "ApplicationGatewayBackendAddressPool"},
        "backend_http_settings_collection": {
            "key": "backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHealthHttpSettings]",
        },
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["_models.ApplicationGatewayBackendAddressPool"] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHealthHttpSettings"]] = None,
        **kwargs
    ):
        """
        :keyword backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
        :paramtype backend_address_pool:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool
        :keyword backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
         resources.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthHttpSettings]
        """
        super().__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings_collection = backend_http_settings_collection


class ApplicationGatewayBackendHealthServer(_serialization.Model):
    """Application gateway backendhealth http settings.

    :ivar address: IP address or FQDN of backend server.
    :vartype address: str
    :ivar ip_configuration: Reference of IP configuration of backend server.
    :vartype ip_configuration:
     ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration
    :ivar health: Health of backend server. Known values are: "Unknown", "Up", "Down", "Partial",
     and "Draining".
    :vartype health: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthServerHealth
    :ivar health_probe_log: Health Probe Log.
    :vartype health_probe_log: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "ip_configuration": {"key": "ipConfiguration", "type": "NetworkInterfaceIPConfiguration"},
        "health": {"key": "health", "type": "str"},
        "health_probe_log": {"key": "healthProbeLog", "type": "str"},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None,
        health: Optional[Union[str, "_models.ApplicationGatewayBackendHealthServerHealth"]] = None,
        health_probe_log: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address: IP address or FQDN of backend server.
        :paramtype address: str
        :keyword ip_configuration: Reference of IP configuration of backend server.
        :paramtype ip_configuration:
         ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration
        :keyword health: Health of backend server. Known values are: "Unknown", "Up", "Down",
         "Partial", and "Draining".
        :paramtype health: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendHealthServerHealth
        :keyword health_probe_log: Health Probe Log.
        :paramtype health_probe_log: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.ip_configuration = ip_configuration
        self.health = health
        self.health_probe_log = health_probe_log


class ApplicationGatewayBackendHttpSettings(SubResource):  # pylint: disable=too-many-instance-attributes
    """Backend address pool settings of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend http settings that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: The destination port on the backend.
    :vartype port: int
    :ivar protocol: The protocol used to communicate with the backend. Known values are: "Http" and
     "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
    :ivar cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and "Disabled".
    :vartype cookie_based_affinity: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCookieBasedAffinity
    :ivar request_timeout: Request timeout in seconds. Application Gateway will fail the request if
     response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :vartype request_timeout: int
    :ivar probe: Probe resource of an application gateway.
    :vartype probe: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar authentication_certificates: Array of references to application gateway authentication
     certificates.
    :vartype authentication_certificates: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar trusted_root_certificates: Array of references to application gateway trusted root
     certificates.
    :vartype trusted_root_certificates: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar connection_draining: Connection draining of the backend http settings resource.
    :vartype connection_draining:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayConnectionDraining
    :ivar host_name: Host header to be sent to the backend servers.
    :vartype host_name: str
    :ivar pick_host_name_from_backend_address: Whether to pick host header should be picked from
     the host name of the backend server. Default value is false.
    :vartype pick_host_name_from_backend_address: bool
    :ivar affinity_cookie_name: Cookie name to use for the affinity cookie.
    :vartype affinity_cookie_name: str
    :ivar probe_enabled: Whether the probe is enabled. Default value is false.
    :vartype probe_enabled: bool
    :ivar path: Path which should be used as a prefix for all HTTP requests. Null means no path
     will be prefixed. Default value is null.
    :vartype path: str
    :ivar provisioning_state: The provisioning state of the backend HTTP settings resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "cookie_based_affinity": {"key": "properties.cookieBasedAffinity", "type": "str"},
        "request_timeout": {"key": "properties.requestTimeout", "type": "int"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "authentication_certificates": {"key": "properties.authenticationCertificates", "type": "[SubResource]"},
        "trusted_root_certificates": {"key": "properties.trustedRootCertificates", "type": "[SubResource]"},
        "connection_draining": {"key": "properties.connectionDraining", "type": "ApplicationGatewayConnectionDraining"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "pick_host_name_from_backend_address": {"key": "properties.pickHostNameFromBackendAddress", "type": "bool"},
        "affinity_cookie_name": {"key": "properties.affinityCookieName", "type": "str"},
        "probe_enabled": {"key": "properties.probeEnabled", "type": "bool"},
        "path": {"key": "properties.path", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "_models.ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["_models.SubResource"] = None,
        authentication_certificates: Optional[List["_models.SubResource"]] = None,
        trusted_root_certificates: Optional[List["_models.SubResource"]] = None,
        connection_draining: Optional["_models.ApplicationGatewayConnectionDraining"] = None,
        host_name: Optional[str] = None,
        pick_host_name_from_backend_address: Optional[bool] = None,
        affinity_cookie_name: Optional[str] = None,
        probe_enabled: Optional[bool] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend http settings that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword port: The destination port on the backend.
        :paramtype port: int
        :keyword protocol: The protocol used to communicate with the backend. Known values are: "Http"
         and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
        :keyword cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and
         "Disabled".
        :paramtype cookie_based_affinity: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCookieBasedAffinity
        :keyword request_timeout: Request timeout in seconds. Application Gateway will fail the request
         if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
         seconds.
        :paramtype request_timeout: int
        :keyword probe: Probe resource of an application gateway.
        :paramtype probe: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword authentication_certificates: Array of references to application gateway authentication
         certificates.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword trusted_root_certificates: Array of references to application gateway trusted root
         certificates.
        :paramtype trusted_root_certificates: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword connection_draining: Connection draining of the backend http settings resource.
        :paramtype connection_draining:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayConnectionDraining
        :keyword host_name: Host header to be sent to the backend servers.
        :paramtype host_name: str
        :keyword pick_host_name_from_backend_address: Whether to pick host header should be picked from
         the host name of the backend server. Default value is false.
        :paramtype pick_host_name_from_backend_address: bool
        :keyword affinity_cookie_name: Cookie name to use for the affinity cookie.
        :paramtype affinity_cookie_name: str
        :keyword probe_enabled: Whether the probe is enabled. Default value is false.
        :paramtype probe_enabled: bool
        :keyword path: Path which should be used as a prefix for all HTTP requests. Null means no path
         will be prefixed. Default value is null.
        :paramtype path: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.connection_draining = connection_draining
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.affinity_cookie_name = affinity_cookie_name
        self.probe_enabled = probe_enabled
        self.path = path
        self.provisioning_state = None


class ApplicationGatewayConnectionDraining(_serialization.Model):
    """Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Whether connection draining is enabled or not. Required.
    :vartype enabled: bool
    :ivar drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
     values are from 1 second to 3600 seconds. Required.
    :vartype drain_timeout_in_sec: int
    """

    _validation = {
        "enabled": {"required": True},
        "drain_timeout_in_sec": {"required": True, "maximum": 3600, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "drain_timeout_in_sec": {"key": "drainTimeoutInSec", "type": "int"},
    }

    def __init__(self, *, enabled: bool, drain_timeout_in_sec: int, **kwargs):
        """
        :keyword enabled: Whether connection draining is enabled or not. Required.
        :paramtype enabled: bool
        :keyword drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
         values are from 1 second to 3600 seconds. Required.
        :paramtype drain_timeout_in_sec: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec


class ApplicationGatewayCustomError(_serialization.Model):
    """Customer error of an application gateway.

    :ivar status_code: Status code of the application gateway customer error. Known values are:
     "HttpStatus403" and "HttpStatus502".
    :vartype status_code: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCustomErrorStatusCode
    :ivar custom_error_page_url: Error page URL of the application gateway customer error.
    :vartype custom_error_page_url: str
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "custom_error_page_url": {"key": "customErrorPageUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "_models.ApplicationGatewayCustomErrorStatusCode"]] = None,
        custom_error_page_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status_code: Status code of the application gateway customer error. Known values are:
         "HttpStatus403" and "HttpStatus502".
        :paramtype status_code: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCustomErrorStatusCode
        :keyword custom_error_page_url: Error page URL of the application gateway customer error.
        :paramtype custom_error_page_url: str
        """
        super().__init__(**kwargs)
        self.status_code = status_code
        self.custom_error_page_url = custom_error_page_url


class ApplicationGatewayFirewallDisabledRuleGroup(_serialization.Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: The name of the rule group that will be disabled. Required.
    :vartype rule_group_name: str
    :ivar rules: The list of rules that will be disabled. If null, all rules of the rule group will
     be disabled.
    :vartype rules: list[int]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[int]"},
    }

    def __init__(self, *, rule_group_name: str, rules: Optional[List[int]] = None, **kwargs):
        """
        :keyword rule_group_name: The name of the rule group that will be disabled. Required.
        :paramtype rule_group_name: str
        :keyword rules: The list of rules that will be disabled. If null, all rules of the rule group
         will be disabled.
        :paramtype rules: list[int]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ApplicationGatewayFirewallExclusion(_serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :ivar match_variable: The variable to be excluded. Required.
    :vartype match_variable: str
    :ivar selector_match_operator: When matchVariable is a collection, operate on the selector to
     specify which elements in the collection this exclusion applies to. Required.
    :vartype selector_match_operator: str
    :ivar selector: When matchVariable is a collection, operator used to specify which elements in
     the collection this exclusion applies to. Required.
    :vartype selector: str
    """

    _validation = {
        "match_variable": {"required": True},
        "selector_match_operator": {"required": True},
        "selector": {"required": True},
    }

    _attribute_map = {
        "match_variable": {"key": "matchVariable", "type": "str"},
        "selector_match_operator": {"key": "selectorMatchOperator", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
    }

    def __init__(self, *, match_variable: str, selector_match_operator: str, selector: str, **kwargs):
        """
        :keyword match_variable: The variable to be excluded. Required.
        :paramtype match_variable: str
        :keyword selector_match_operator: When matchVariable is a collection, operate on the selector
         to specify which elements in the collection this exclusion applies to. Required.
        :paramtype selector_match_operator: str
        :keyword selector: When matchVariable is a collection, operator used to specify which elements
         in the collection this exclusion applies to. Required.
        :paramtype selector: str
        """
        super().__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector


class ApplicationGatewayFirewallRule(_serialization.Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_id: The identifier of the web application firewall rule. Required.
    :vartype rule_id: int
    :ivar description: The description of the web application firewall rule.
    :vartype description: str
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "int"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, rule_id: int, description: Optional[str] = None, **kwargs):
        """
        :keyword rule_id: The identifier of the web application firewall rule. Required.
        :paramtype rule_id: int
        :keyword description: The description of the web application firewall rule.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.description = description


class ApplicationGatewayFirewallRuleGroup(_serialization.Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: The name of the web application firewall rule group. Required.
    :vartype rule_group_name: str
    :ivar description: The description of the web application firewall rule group.
    :vartype description: str
    :ivar rules: The rules of the web application firewall rule group. Required.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        "rule_group_name": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rules": {"key": "rules", "type": "[ApplicationGatewayFirewallRule]"},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: List["_models.ApplicationGatewayFirewallRule"],
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword rule_group_name: The name of the web application firewall rule group. Required.
        :paramtype rule_group_name: str
        :keyword description: The description of the web application firewall rule group.
        :paramtype description: str
        :keyword rules: The rules of the web application firewall rule group. Required.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallRule]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.description = description
        self.rules = rules


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the web application firewall rule set.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar rule_set_type: The type of the web application firewall rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the web application firewall rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: The rule groups of the web application firewall rule set.
    :vartype rule_groups:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rule_set_type": {"key": "properties.ruleSetType", "type": "str"},
        "rule_set_version": {"key": "properties.ruleSetVersion", "type": "str"},
        "rule_groups": {"key": "properties.ruleGroups", "type": "[ApplicationGatewayFirewallRuleGroup]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rule_set_type: Optional[str] = None,
        rule_set_version: Optional[str] = None,
        rule_groups: Optional[List["_models.ApplicationGatewayFirewallRuleGroup"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rule_set_type: The type of the web application firewall rule set.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the web application firewall rule set type.
        :paramtype rule_set_version: str
        :keyword rule_groups: The rule groups of the web application firewall rule set.
        :paramtype rule_groups:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallRuleGroup]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the frontend IP configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar subnet: Reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar public_ip_address: Reference of the PublicIP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the frontend IP configuration that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword subnet: Reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword public_ip_address: Reference of the PublicIP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the frontend port that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: Frontend port.
    :vartype port: int
    :ivar provisioning_state: The provisioning state of the frontend port resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the frontend port that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword port: Frontend port.
        :paramtype port: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.port = port
        self.provisioning_state = None


class ApplicationGatewayHeaderConfiguration(_serialization.Model):
    """Header configuration of the Actions set in Application Gateway.

    :ivar header_name: Header name of the header configuration.
    :vartype header_name: str
    :ivar header_value: Header value of the header configuration.
    :vartype header_value: str
    """

    _attribute_map = {
        "header_name": {"key": "headerName", "type": "str"},
        "header_value": {"key": "headerValue", "type": "str"},
    }

    def __init__(self, *, header_name: Optional[str] = None, header_value: Optional[str] = None, **kwargs):
        """
        :keyword header_name: Header name of the header configuration.
        :paramtype header_name: str
        :keyword header_value: Header value of the header configuration.
        :paramtype header_value: str
        """
        super().__init__(**kwargs)
        self.header_name = header_name
        self.header_value = header_value


class ApplicationGatewayHttpListener(SubResource):  # pylint: disable=too-many-instance-attributes
    """Http listener of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the HTTP listener that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar frontend_port: Frontend port resource of an application gateway.
    :vartype frontend_port: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar protocol: Protocol of the HTTP listener. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
    :ivar host_name: Host name of HTTP listener.
    :vartype host_name: str
    :ivar ssl_certificate: SSL certificate resource of an application gateway.
    :vartype ssl_certificate: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :vartype require_server_name_indication: bool
    :ivar provisioning_state: The provisioning state of the HTTP listener resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar custom_error_configurations: Custom error configurations of the HTTP listener.
    :vartype custom_error_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCustomError]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "frontend_port": {"key": "properties.frontendPort", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "ssl_certificate": {"key": "properties.sslCertificate", "type": "SubResource"},
        "require_server_name_indication": {"key": "properties.requireServerNameIndication", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "custom_error_configurations": {
            "key": "properties.customErrorConfigurations",
            "type": "[ApplicationGatewayCustomError]",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        frontend_port: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["_models.SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        custom_error_configurations: Optional[List["_models.ApplicationGatewayCustomError"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the HTTP listener that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword frontend_ip_configuration: Frontend IP configuration resource of an application
         gateway.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword frontend_port: Frontend port resource of an application gateway.
        :paramtype frontend_port: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword protocol: Protocol of the HTTP listener. Known values are: "Http" and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
        :keyword host_name: Host name of HTTP listener.
        :paramtype host_name: str
        :keyword ssl_certificate: SSL certificate resource of an application gateway.
        :paramtype ssl_certificate: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword require_server_name_indication: Applicable only if protocol is https. Enables SNI for
         multi-hosting.
        :paramtype require_server_name_indication: bool
        :keyword custom_error_configurations: Custom error configurations of the HTTP listener.
        :paramtype custom_error_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayCustomError]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = None
        self.custom_error_configurations = custom_error_configurations


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the IP configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar subnet: Reference of the subnet resource. A subnet from where application gateway gets
     its private address.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the application gateway IP configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the IP configuration that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword subnet: Reference of the subnet resource. A subnet from where application gateway gets
         its private address.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.subnet = subnet
        self.provisioning_state = None


class ApplicationGatewayListResult(_serialization.Model):
    """Response for ListApplicationGateways API service call.

    :ivar value: List of an application gateways in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGateway]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ApplicationGateway"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of an application gateways in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGateway]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayOnDemandProbe(_serialization.Model):
    """Details of on demand test probe request.

    :ivar protocol: The protocol used for the probe. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :vartype path: str
    :ivar timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :vartype pick_host_name_from_backend_http_settings: bool
    :ivar match: Criterion for classifying a healthy probe response.
    :vartype match:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar backend_address_pool: Reference of backend pool of application gateway to which probe
     request will be sent.
    :vartype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar backend_http_settings: Reference of backend http setting of application gateway to be
     used for test probe.
    :vartype backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "host": {"key": "host", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "timeout": {"key": "timeout", "type": "int"},
        "pick_host_name_from_backend_http_settings": {"key": "pickHostNameFromBackendHttpSettings", "type": "bool"},
        "match": {"key": "match", "type": "ApplicationGatewayProbeHealthResponseMatch"},
        "backend_address_pool": {"key": "backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "backendHttpSettings", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        timeout: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        match: Optional["_models.ApplicationGatewayProbeHealthResponseMatch"] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword protocol: The protocol used for the probe. Known values are: "Http" and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
        :paramtype path: str
        :keyword timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword pick_host_name_from_backend_http_settings: Whether the host header should be picked
         from the backend http settings. Default value is false.
        :paramtype pick_host_name_from_backend_http_settings: bool
        :keyword match: Criterion for classifying a healthy probe response.
        :paramtype match:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProbeHealthResponseMatch
        :keyword backend_address_pool: Reference of backend pool of application gateway to which probe
         request will be sent.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword backend_http_settings: Reference of backend http setting of application gateway to be
         used for test probe.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.host = host
        self.path = path
        self.timeout = timeout
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.match = match
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the path rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar paths: Path rules of URL path map.
    :vartype paths: list[str]
    :ivar backend_address_pool: Backend address pool resource of URL path map path rule.
    :vartype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of URL path map path rule.
    :vartype backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of URL path map path rule.
    :vartype redirect_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
    :vartype rewrite_rule_set: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the path rule resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "paths": {"key": "properties.paths", "type": "[str]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "rewrite_rule_set": {"key": "properties.rewriteRuleSet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        paths: Optional[List[str]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        rewrite_rule_set: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the path rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword paths: Path rules of URL path map.
        :paramtype paths: list[str]
        :keyword backend_address_pool: Backend address pool resource of URL path map path rule.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of URL path map path rule.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of URL path map path rule.
        :paramtype redirect_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
        :paramtype rewrite_rule_set: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.redirect_configuration = redirect_configuration
        self.rewrite_rule_set = rewrite_rule_set
        self.provisioning_state = None


class ApplicationGatewayProbe(SubResource):  # pylint: disable=too-many-instance-attributes
    """Probe of the application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the probe that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar protocol: The protocol used for the probe. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :vartype path: str
    :ivar interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :vartype interval: int
    :ivar timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :vartype unhealthy_threshold: int
    :ivar pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :vartype pick_host_name_from_backend_http_settings: bool
    :ivar min_servers: Minimum number of servers that are always marked healthy. Default value is
     0.
    :vartype min_servers: int
    :ivar match: Criterion for classifying a healthy probe response.
    :vartype match:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar provisioning_state: The provisioning state of the probe resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar port: Custom port which will be used for probing the backend servers. The valid value
     ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
     valid for Standard_v2 and WAF_v2 only.
    :vartype port: int
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "port": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host": {"key": "properties.host", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
        "interval": {"key": "properties.interval", "type": "int"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "unhealthy_threshold": {"key": "properties.unhealthyThreshold", "type": "int"},
        "pick_host_name_from_backend_http_settings": {
            "key": "properties.pickHostNameFromBackendHttpSettings",
            "type": "bool",
        },
        "min_servers": {"key": "properties.minServers", "type": "int"},
        "match": {"key": "properties.match", "type": "ApplicationGatewayProbeHealthResponseMatch"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        min_servers: Optional[int] = None,
        match: Optional["_models.ApplicationGatewayProbeHealthResponseMatch"] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the probe that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword protocol: The protocol used for the probe. Known values are: "Http" and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
        :paramtype path: str
        :keyword interval: The probing interval in seconds. This is the time interval between two
         consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :paramtype interval: int
        :keyword timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword unhealthy_threshold: The probe retry count. Backend server is marked down after
         consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
         to 20.
        :paramtype unhealthy_threshold: int
        :keyword pick_host_name_from_backend_http_settings: Whether the host header should be picked
         from the backend http settings. Default value is false.
        :paramtype pick_host_name_from_backend_http_settings: bool
        :keyword min_servers: Minimum number of servers that are always marked healthy. Default value
         is 0.
        :paramtype min_servers: int
        :keyword match: Criterion for classifying a healthy probe response.
        :paramtype match:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayProbeHealthResponseMatch
        :keyword port: Custom port which will be used for probing the backend servers. The valid value
         ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
         valid for Standard_v2 and WAF_v2 only.
        :paramtype port: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.min_servers = min_servers
        self.match = match
        self.provisioning_state = None
        self.port = port


class ApplicationGatewayProbeHealthResponseMatch(_serialization.Model):
    """Application gateway probe health response match.

    :ivar body: Body that must be contained in the health response. Default value is empty.
    :vartype body: str
    :ivar status_codes: Allowed ranges of healthy status codes. Default range of healthy status
     codes is 200-399.
    :vartype status_codes: list[str]
    """

    _attribute_map = {
        "body": {"key": "body", "type": "str"},
        "status_codes": {"key": "statusCodes", "type": "[str]"},
    }

    def __init__(self, *, body: Optional[str] = None, status_codes: Optional[List[str]] = None, **kwargs):
        """
        :keyword body: Body that must be contained in the health response. Default value is empty.
        :paramtype body: str
        :keyword status_codes: Allowed ranges of healthy status codes. Default range of healthy status
         codes is 200-399.
        :paramtype status_codes: list[str]
        """
        super().__init__(**kwargs)
        self.body = body
        self.status_codes = status_codes


class ApplicationGatewayRedirectConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Redirect configuration of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the redirect configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar redirect_type: HTTP redirection type. Known values are: "Permanent", "Found", "SeeOther",
     and "Temporary".
    :vartype redirect_type: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRedirectType
    :ivar target_listener: Reference to a listener to redirect the request to.
    :vartype target_listener: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar target_url: Url to redirect the request to.
    :vartype target_url: str
    :ivar include_path: Include path in the redirected url.
    :vartype include_path: bool
    :ivar include_query_string: Include query string in the redirected url.
    :vartype include_query_string: bool
    :ivar request_routing_rules: Request routing specifying redirect configuration.
    :vartype request_routing_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar url_path_maps: Url path maps specifying default redirect configuration.
    :vartype url_path_maps: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar path_rules: Path rules specifying redirect configuration.
    :vartype path_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "redirect_type": {"key": "properties.redirectType", "type": "str"},
        "target_listener": {"key": "properties.targetListener", "type": "SubResource"},
        "target_url": {"key": "properties.targetUrl", "type": "str"},
        "include_path": {"key": "properties.includePath", "type": "bool"},
        "include_query_string": {"key": "properties.includeQueryString", "type": "bool"},
        "request_routing_rules": {"key": "properties.requestRoutingRules", "type": "[SubResource]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[SubResource]"},
        "path_rules": {"key": "properties.pathRules", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        redirect_type: Optional[Union[str, "_models.ApplicationGatewayRedirectType"]] = None,
        target_listener: Optional["_models.SubResource"] = None,
        target_url: Optional[str] = None,
        include_path: Optional[bool] = None,
        include_query_string: Optional[bool] = None,
        request_routing_rules: Optional[List["_models.SubResource"]] = None,
        url_path_maps: Optional[List["_models.SubResource"]] = None,
        path_rules: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the redirect configuration that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword redirect_type: HTTP redirection type. Known values are: "Permanent", "Found",
         "SeeOther", and "Temporary".
        :paramtype redirect_type: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRedirectType
        :keyword target_listener: Reference to a listener to redirect the request to.
        :paramtype target_listener: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword target_url: Url to redirect the request to.
        :paramtype target_url: str
        :keyword include_path: Include path in the redirected url.
        :paramtype include_path: bool
        :keyword include_query_string: Include query string in the redirected url.
        :paramtype include_query_string: bool
        :keyword request_routing_rules: Request routing specifying redirect configuration.
        :paramtype request_routing_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword url_path_maps: Url path maps specifying default redirect configuration.
        :paramtype url_path_maps: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword path_rules: Path rules specifying redirect configuration.
        :paramtype path_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.redirect_type = redirect_type
        self.target_listener = target_listener
        self.target_url = target_url
        self.include_path = include_path
        self.include_query_string = include_query_string
        self.request_routing_rules = request_routing_rules
        self.url_path_maps = url_path_maps
        self.path_rules = path_rules


class ApplicationGatewayRequestRoutingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Request routing rule of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the request routing rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
    :vartype rule_type: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRequestRoutingRuleType
    :ivar priority: Priority of the request routing rule.
    :vartype priority: int
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of the application gateway.
    :vartype backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar http_listener: Http listener resource of the application gateway.
    :vartype http_listener: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar url_path_map: URL path map resource of the application gateway.
    :vartype url_path_map: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
    :vartype rewrite_rule_set: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of the application gateway.
    :vartype redirect_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the request routing rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "priority": {"maximum": 20000, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "http_listener": {"key": "properties.httpListener", "type": "SubResource"},
        "url_path_map": {"key": "properties.urlPathMap", "type": "SubResource"},
        "rewrite_rule_set": {"key": "properties.rewriteRuleSet", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.ApplicationGatewayRequestRoutingRuleType"]] = None,
        priority: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        http_listener: Optional["_models.SubResource"] = None,
        url_path_map: Optional["_models.SubResource"] = None,
        rewrite_rule_set: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the request routing rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
        :paramtype rule_type: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRequestRoutingRuleType
        :keyword priority: Priority of the request routing rule.
        :paramtype priority: int
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of the application gateway.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword http_listener: Http listener resource of the application gateway.
        :paramtype http_listener: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword url_path_map: URL path map resource of the application gateway.
        :paramtype url_path_map: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
        :paramtype rewrite_rule_set: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of the application gateway.
        :paramtype redirect_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.rule_type = rule_type
        self.priority = priority
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.rewrite_rule_set = rewrite_rule_set
        self.redirect_configuration = redirect_configuration
        self.provisioning_state = None


class ApplicationGatewayRewriteRule(_serialization.Model):
    """Rewrite rule of an application gateway.

    :ivar name: Name of the rewrite rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar rule_sequence: Rule Sequence of the rewrite rule that determines the order of execution
     of a particular rule in a RewriteRuleSet.
    :vartype rule_sequence: int
    :ivar conditions: Conditions based on which the action set execution will be evaluated.
    :vartype conditions:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRuleCondition]
    :ivar action_set: Set of actions to be done as part of the rewrite Rule.
    :vartype action_set:
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRuleActionSet
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "rule_sequence": {"key": "ruleSequence", "type": "int"},
        "conditions": {"key": "conditions", "type": "[ApplicationGatewayRewriteRuleCondition]"},
        "action_set": {"key": "actionSet", "type": "ApplicationGatewayRewriteRuleActionSet"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        rule_sequence: Optional[int] = None,
        conditions: Optional[List["_models.ApplicationGatewayRewriteRuleCondition"]] = None,
        action_set: Optional["_models.ApplicationGatewayRewriteRuleActionSet"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the rewrite rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rule_sequence: Rule Sequence of the rewrite rule that determines the order of
         execution of a particular rule in a RewriteRuleSet.
        :paramtype rule_sequence: int
        :keyword conditions: Conditions based on which the action set execution will be evaluated.
        :paramtype conditions:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRuleCondition]
        :keyword action_set: Set of actions to be done as part of the rewrite Rule.
        :paramtype action_set:
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRuleActionSet
        """
        super().__init__(**kwargs)
        self.name = name
        self.rule_sequence = rule_sequence
        self.conditions = conditions
        self.action_set = action_set


class ApplicationGatewayRewriteRuleActionSet(_serialization.Model):
    """Set of actions in the Rewrite Rule in Application Gateway.

    :ivar request_header_configurations: Request Header Actions in the Action Set.
    :vartype request_header_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayHeaderConfiguration]
    :ivar response_header_configurations: Response Header Actions in the Action Set.
    :vartype response_header_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayHeaderConfiguration]
    """

    _attribute_map = {
        "request_header_configurations": {
            "key": "requestHeaderConfigurations",
            "type": "[ApplicationGatewayHeaderConfiguration]",
        },
        "response_header_configurations": {
            "key": "responseHeaderConfigurations",
            "type": "[ApplicationGatewayHeaderConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        request_header_configurations: Optional[List["_models.ApplicationGatewayHeaderConfiguration"]] = None,
        response_header_configurations: Optional[List["_models.ApplicationGatewayHeaderConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword request_header_configurations: Request Header Actions in the Action Set.
        :paramtype request_header_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayHeaderConfiguration]
        :keyword response_header_configurations: Response Header Actions in the Action Set.
        :paramtype response_header_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayHeaderConfiguration]
        """
        super().__init__(**kwargs)
        self.request_header_configurations = request_header_configurations
        self.response_header_configurations = response_header_configurations


class ApplicationGatewayRewriteRuleCondition(_serialization.Model):
    """Set of conditions in the Rewrite Rule in Application Gateway.

    :ivar variable: The condition parameter of the RewriteRuleCondition.
    :vartype variable: str
    :ivar pattern: The pattern, either fixed string or regular expression, that evaluates the
     truthfulness of the condition.
    :vartype pattern: str
    :ivar ignore_case: Setting this parameter to truth value with force the pattern to do a case
     in-sensitive comparison.
    :vartype ignore_case: bool
    :ivar negate: Setting this value as truth will force to check the negation of the condition
     given by the user.
    :vartype negate: bool
    """

    _attribute_map = {
        "variable": {"key": "variable", "type": "str"},
        "pattern": {"key": "pattern", "type": "str"},
        "ignore_case": {"key": "ignoreCase", "type": "bool"},
        "negate": {"key": "negate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        variable: Optional[str] = None,
        pattern: Optional[str] = None,
        ignore_case: Optional[bool] = None,
        negate: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword variable: The condition parameter of the RewriteRuleCondition.
        :paramtype variable: str
        :keyword pattern: The pattern, either fixed string or regular expression, that evaluates the
         truthfulness of the condition.
        :paramtype pattern: str
        :keyword ignore_case: Setting this parameter to truth value with force the pattern to do a case
         in-sensitive comparison.
        :paramtype ignore_case: bool
        :keyword negate: Setting this value as truth will force to check the negation of the condition
         given by the user.
        :paramtype negate: bool
        """
        super().__init__(**kwargs)
        self.variable = variable
        self.pattern = pattern
        self.ignore_case = ignore_case
        self.negate = negate


class ApplicationGatewayRewriteRuleSet(SubResource):
    """Rewrite rule set of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the rewrite rule set that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rewrite_rules: Rewrite rules in the rewrite rule set.
    :vartype rewrite_rules:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRule]
    :ivar provisioning_state: The provisioning state of the rewrite rule set resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "rewrite_rules": {"key": "properties.rewriteRules", "type": "[ApplicationGatewayRewriteRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rewrite_rules: Optional[List["_models.ApplicationGatewayRewriteRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the rewrite rule set that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rewrite_rules: Rewrite rules in the rewrite rule set.
        :paramtype rewrite_rules:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayRewriteRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.rewrite_rules = rewrite_rules
        self.provisioning_state = None


class ApplicationGatewaySku(_serialization.Model):
    """SKU of an application gateway.

    :ivar name: Name of an application gateway SKU. Known values are: "Standard_Small",
     "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", and "WAF_v2".
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. Known values are: "Standard", "WAF", "Standard_v2",
     and "WAF_v2".
    :vartype tier: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayTier
    :ivar capacity: Capacity (instance count) of an application gateway.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ApplicationGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.ApplicationGatewayTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Name of an application gateway SKU. Known values are: "Standard_Small",
         "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", and "WAF_v2".
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySkuName
        :keyword tier: Tier of an application gateway. Known values are: "Standard", "WAF",
         "Standard_v2", and "WAF_v2".
        :paramtype tier: str or ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayTier
        :keyword capacity: Capacity (instance count) of an application gateway.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the SSL certificate that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :vartype data: str
    :ivar password: Password for the pfx file specified in data. Only applicable in PUT request.
    :vartype password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :vartype public_cert_data: str
    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the SSL certificate resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "key_vault_secret_id": {"key": "properties.keyVaultSecretId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the SSL certificate that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :paramtype data: str
        :keyword password: Password for the pfx file specified in data. Only applicable in PUT request.
        :paramtype password: str
        :keyword public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
         data. Only applicable in GET request.
        :paramtype public_cert_data: str
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.password = password
        self.public_cert_data = public_cert_data
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state = None


class ApplicationGatewaySslPolicy(_serialization.Model):
    """Application Gateway Ssl policy.

    :ivar disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
    :vartype disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol]
    :ivar policy_type: Type of Ssl Policy. Known values are: "Predefined" and "Custom".
    :vartype policy_type: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicyType
    :ivar policy_name: Name of Ssl predefined policy. Known values are: "AppGwSslPolicy20150501",
     "AppGwSslPolicy20170401", and "AppGwSslPolicy20170401S".
    :vartype policy_name: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicyName
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order to application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
    :vartype min_protocol_version: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "disabled_ssl_protocols": {"key": "disabledSslProtocols", "type": "[str]"},
        "policy_type": {"key": "policyType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "cipher_suites": {"key": "cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        disabled_ssl_protocols: Optional[List[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        policy_type: Optional[Union[str, "_models.ApplicationGatewaySslPolicyType"]] = None,
        policy_name: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :paramtype disabled_ssl_protocols: list[str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol]
        :keyword policy_type: Type of Ssl Policy. Known values are: "Predefined" and "Custom".
        :paramtype policy_type: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicyType
        :keyword policy_name: Name of Ssl predefined policy. Known values are:
         "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", and "AppGwSslPolicy20170401S".
        :paramtype policy_name: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslPolicyName
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order to application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol
        """
        super().__init__(**kwargs)
        self.disabled_ssl_protocols = disabled_ssl_protocols
        self.policy_type = policy_type
        self.policy_name = policy_name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the Ssl predefined policy.
    :vartype name: str
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order for application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
    :vartype min_protocol_version: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "cipher_suites": {"key": "properties.cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "properties.minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the Ssl predefined policy.
        :paramtype name: str
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order for application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewaySslProtocol
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewayTrustedRootCertificate(SubResource):
    """Trusted Root certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the trusted root certificate that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the trusted root certificate resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "key_vault_secret_id": {"key": "properties.keyVaultSecretId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the trusted root certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword data: Certificate public data.
        :paramtype data: str
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state = None


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the URL path map that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar default_backend_address_pool: Default backend address pool resource of URL path map.
    :vartype default_backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar default_backend_http_settings: Default backend http settings resource of URL path map.
    :vartype default_backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
    :vartype default_rewrite_rule_set: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar default_redirect_configuration: Default redirect configuration resource of URL path map.
    :vartype default_redirect_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar path_rules: Path rule of URL path map resource.
    :vartype path_rules: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: The provisioning state of the URL path map resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_backend_address_pool": {"key": "properties.defaultBackendAddressPool", "type": "SubResource"},
        "default_backend_http_settings": {"key": "properties.defaultBackendHttpSettings", "type": "SubResource"},
        "default_rewrite_rule_set": {"key": "properties.defaultRewriteRuleSet", "type": "SubResource"},
        "default_redirect_configuration": {"key": "properties.defaultRedirectConfiguration", "type": "SubResource"},
        "path_rules": {"key": "properties.pathRules", "type": "[ApplicationGatewayPathRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        default_backend_address_pool: Optional["_models.SubResource"] = None,
        default_backend_http_settings: Optional["_models.SubResource"] = None,
        default_rewrite_rule_set: Optional["_models.SubResource"] = None,
        default_redirect_configuration: Optional["_models.SubResource"] = None,
        path_rules: Optional[List["_models.ApplicationGatewayPathRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the URL path map that is unique within an Application Gateway.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword default_backend_address_pool: Default backend address pool resource of URL path map.
        :paramtype default_backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword default_backend_http_settings: Default backend http settings resource of URL path map.
        :paramtype default_backend_http_settings: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
        :paramtype default_rewrite_rule_set: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword default_redirect_configuration: Default redirect configuration resource of URL path
         map.
        :paramtype default_redirect_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword path_rules: Path rule of URL path map resource.
        :paramtype path_rules: list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayPathRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.default_rewrite_rule_set = default_rewrite_rule_set
        self.default_redirect_configuration = default_redirect_configuration
        self.path_rules = path_rules
        self.provisioning_state = None


class ApplicationGatewayWebApplicationFirewallConfiguration(_serialization.Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Whether the web application firewall is enabled or not. Required.
    :vartype enabled: bool
    :ivar firewall_mode: Web application firewall mode. Required. Known values are: "Detection" and
     "Prevention".
    :vartype firewall_mode: str or
     ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallMode
    :ivar rule_set_type: The type of the web application firewall rule set. Possible values are:
     'OWASP'. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the rule set type. Required.
    :vartype rule_set_version: str
    :ivar disabled_rule_groups: The disabled rule groups.
    :vartype disabled_rule_groups:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
    :ivar request_body_check: Whether allow WAF to check request Body.
    :vartype request_body_check: bool
    :ivar max_request_body_size: Maximum request body size for WAF.
    :vartype max_request_body_size: int
    :ivar max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
    :vartype max_request_body_size_in_kb: int
    :ivar file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :vartype file_upload_limit_in_mb: int
    :ivar exclusions: The exclusion list.
    :vartype exclusions:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallExclusion]
    """

    _validation = {
        "enabled": {"required": True},
        "firewall_mode": {"required": True},
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
        "max_request_body_size": {"maximum": 128, "minimum": 8},
        "max_request_body_size_in_kb": {"maximum": 128, "minimum": 8},
        "file_upload_limit_in_mb": {"minimum": 0},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "firewall_mode": {"key": "firewallMode", "type": "str"},
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "disabled_rule_groups": {"key": "disabledRuleGroups", "type": "[ApplicationGatewayFirewallDisabledRuleGroup]"},
        "request_body_check": {"key": "requestBodyCheck", "type": "bool"},
        "max_request_body_size": {"key": "maxRequestBodySize", "type": "int"},
        "max_request_body_size_in_kb": {"key": "maxRequestBodySizeInKb", "type": "int"},
        "file_upload_limit_in_mb": {"key": "fileUploadLimitInMb", "type": "int"},
        "exclusions": {"key": "exclusions", "type": "[ApplicationGatewayFirewallExclusion]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        firewall_mode: Union[str, "_models.ApplicationGatewayFirewallMode"],
        rule_set_type: str,
        rule_set_version: str,
        disabled_rule_groups: Optional[List["_models.ApplicationGatewayFirewallDisabledRuleGroup"]] = None,
        request_body_check: Optional[bool] = None,
        max_request_body_size: Optional[int] = None,
        max_request_body_size_in_kb: Optional[int] = None,
        file_upload_limit_in_mb: Optional[int] = None,
        exclusions: Optional[List["_models.ApplicationGatewayFirewallExclusion"]] = None,
        **kwargs
    ):
        """
        :keyword enabled: Whether the web application firewall is enabled or not. Required.
        :paramtype enabled: bool
        :keyword firewall_mode: Web application firewall mode. Required. Known values are: "Detection"
         and "Prevention".
        :paramtype firewall_mode: str or
         ~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallMode
        :keyword rule_set_type: The type of the web application firewall rule set. Possible values are:
         'OWASP'. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the rule set type. Required.
        :paramtype rule_set_version: str
        :keyword disabled_rule_groups: The disabled rule groups.
        :paramtype disabled_rule_groups:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
        :keyword request_body_check: Whether allow WAF to check request Body.
        :paramtype request_body_check: bool
        :keyword max_request_body_size: Maximum request body size for WAF.
        :paramtype max_request_body_size: int
        :keyword max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :paramtype max_request_body_size_in_kb: int
        :keyword file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :paramtype file_upload_limit_in_mb: int
        :keyword exclusions: The exclusion list.
        :paramtype exclusions:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayFirewallExclusion]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.firewall_mode = firewall_mode
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.disabled_rule_groups = disabled_rule_groups
        self.request_body_check = request_body_check
        self.max_request_body_size = max_request_body_size
        self.max_request_body_size_in_kb = max_request_body_size_in_kb
        self.file_upload_limit_in_mb = file_upload_limit_in_mb
        self.exclusions = exclusions


class FirewallPolicyRuleCondition(_serialization.Model):
    """Properties of a rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ApplicationRuleCondition, NetworkRuleCondition

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the rule condition.
    :vartype name: str
    :ivar description: Description of the rule condition.
    :vartype description: str
    :ivar rule_condition_type: Rule Condition Type. Required. Known values are:
     "ApplicationRuleCondition" and "NetworkRuleCondition".
    :vartype rule_condition_type: str or
     ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionType
    """

    _validation = {
        "rule_condition_type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rule_condition_type": {"key": "ruleConditionType", "type": "str"},
    }

    _subtype_map = {
        "rule_condition_type": {
            "ApplicationRuleCondition": "ApplicationRuleCondition",
            "NetworkRuleCondition": "NetworkRuleCondition",
        }
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the rule condition.
        :paramtype name: str
        :keyword description: Description of the rule condition.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.rule_condition_type = None  # type: Optional[str]


class ApplicationRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type application.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the rule condition.
    :vartype name: str
    :ivar description: Description of the rule condition.
    :vartype description: str
    :ivar rule_condition_type: Rule Condition Type. Required. Known values are:
     "ApplicationRuleCondition" and "NetworkRuleCondition".
    :vartype rule_condition_type: str or
     ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionType
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses or Service Tags.
    :vartype destination_addresses: list[str]
    :ivar protocols: Array of Application Protocols.
    :vartype protocols:
     list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionApplicationProtocol]
    :ivar target_fqdns: List of FQDNs for this rule condition.
    :vartype target_fqdns: list[str]
    :ivar fqdn_tags: List of FQDN Tags for this rule condition.
    :vartype fqdn_tags: list[str]
    """

    _validation = {
        "rule_condition_type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rule_condition_type": {"key": "ruleConditionType", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[FirewallPolicyRuleConditionApplicationProtocol]"},
        "target_fqdns": {"key": "targetFqdns", "type": "[str]"},
        "fqdn_tags": {"key": "fqdnTags", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[List[str]] = None,
        destination_addresses: Optional[List[str]] = None,
        protocols: Optional[List["_models.FirewallPolicyRuleConditionApplicationProtocol"]] = None,
        target_fqdns: Optional[List[str]] = None,
        fqdn_tags: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the rule condition.
        :paramtype name: str
        :keyword description: Description of the rule condition.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses or Service Tags.
        :paramtype destination_addresses: list[str]
        :keyword protocols: Array of Application Protocols.
        :paramtype protocols:
         list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionApplicationProtocol]
        :keyword target_fqdns: List of FQDNs for this rule condition.
        :paramtype target_fqdns: list[str]
        :keyword fqdn_tags: List of FQDN Tags for this rule condition.
        :paramtype fqdn_tags: list[str]
        """
        super().__init__(name=name, description=description, **kwargs)
        self.rule_condition_type = "ApplicationRuleCondition"  # type: str
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.fqdn_tags = fqdn_tags


class ApplicationSecurityGroup(Resource):
    """An application security group in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the application security group resource. It
     uniquely identifies a resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application security group resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None


class ApplicationSecurityGroupListResult(_serialization.Model):
    """A list of application security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of application security groups.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ApplicationSecurityGroup"]] = None, **kwargs):
        """
        :keyword value: A list of application security groups.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AuthorizationListResult(_serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit.

    :ivar value: The authorizations in an ExpressRoute Circuit.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitAuthorization]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The authorizations in an ExpressRoute Circuit.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitAuthorization]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutoApprovedPrivateLinkService(_serialization.Model):
    """The information of an AutoApprovedPrivateLinkService.

    :ivar private_link_service: The id of the private link service resource.
    :vartype private_link_service: str
    """

    _attribute_map = {
        "private_link_service": {"key": "privateLinkService", "type": "str"},
    }

    def __init__(self, *, private_link_service: Optional[str] = None, **kwargs):
        """
        :keyword private_link_service: The id of the private link service resource.
        :paramtype private_link_service: str
        """
        super().__init__(**kwargs)
        self.private_link_service = private_link_service


class AutoApprovedPrivateLinkServicesResult(_serialization.Model):
    """An array of private link service id that can be linked to a private end point with auto approved.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of auto approved private link service.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.AutoApprovedPrivateLinkService]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutoApprovedPrivateLinkService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AutoApprovedPrivateLinkService"]] = None, **kwargs):
        """
        :keyword value: An array of auto approved private link service.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.AutoApprovedPrivateLinkService]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Availability(_serialization.Model):
    """Availability of the metric.

    :ivar time_grain: The time grain of the availability.
    :vartype time_grain: str
    :ivar retention: The retention of the availability.
    :vartype retention: str
    :ivar blob_duration: Duration of the availability blob.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        retention: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_grain: The time grain of the availability.
        :paramtype time_grain: str
        :keyword retention: The retention of the availability.
        :paramtype retention: str
        :keyword blob_duration: Duration of the availability blob.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention
        self.blob_duration = blob_duration


class AvailableDelegation(_serialization.Model):
    """The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.

    :ivar name: The name of the AvailableDelegation resource.
    :vartype name: str
    :ivar id: A unique identifier of the AvailableDelegation resource.
    :vartype id: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_name: The name of the service and resource.
    :vartype service_name: str
    :ivar actions: Describes the actions permitted to the service upon delegation.
    :vartype actions: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_name": {"key": "serviceName", "type": "str"},
        "actions": {"key": "actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        service_name: Optional[str] = None,
        actions: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the AvailableDelegation resource.
        :paramtype name: str
        :keyword id: A unique identifier of the AvailableDelegation resource.
        :paramtype id: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword service_name: The name of the service and resource.
        :paramtype service_name: str
        :keyword actions: Describes the actions permitted to the service upon delegation.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.service_name = service_name
        self.actions = actions


class AvailableDelegationsResult(_serialization.Model):
    """An array of available delegations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available delegations.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.AvailableDelegation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableDelegation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailableDelegation"]] = None, **kwargs):
        """
        :keyword value: An array of available delegations.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.AvailableDelegation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AvailablePrivateEndpointType(_serialization.Model):
    """The information of an AvailablePrivateEndpointType.

    :ivar name: The name of the service and resource.
    :vartype name: str
    :ivar id: A unique identifier of the AvailablePrivateEndpoint Type resource.
    :vartype id: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_name: The name of the service and resource.
    :vartype resource_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the service and resource.
        :paramtype name: str
        :keyword id: A unique identifier of the AvailablePrivateEndpoint Type resource.
        :paramtype id: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword resource_name: The name of the service and resource.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.resource_name = resource_name


class AvailablePrivateEndpointTypesResult(_serialization.Model):
    """An array of available PrivateEndpoint types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available privateEndpoint type.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.AvailablePrivateEndpointType]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailablePrivateEndpointType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailablePrivateEndpointType"]] = None, **kwargs):
        """
        :keyword value: An array of available privateEndpoint type.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.AvailablePrivateEndpointType]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AvailableProvidersList(_serialization.Model):
    """List of available countries with details.

    All required parameters must be populated in order to send to Azure.

    :ivar countries: List of available countries. Required.
    :vartype countries: list[~azure.mgmt.network.v2019_08_01.models.AvailableProvidersListCountry]
    """

    _validation = {
        "countries": {"required": True},
    }

    _attribute_map = {
        "countries": {"key": "countries", "type": "[AvailableProvidersListCountry]"},
    }

    def __init__(self, *, countries: List["_models.AvailableProvidersListCountry"], **kwargs):
        """
        :keyword countries: List of available countries. Required.
        :paramtype countries:
         list[~azure.mgmt.network.v2019_08_01.models.AvailableProvidersListCountry]
        """
        super().__init__(**kwargs)
        self.countries = countries


class AvailableProvidersListCity(_serialization.Model):
    """City or town details.

    :ivar city_name: The city or town name.
    :vartype city_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    """

    _attribute_map = {
        "city_name": {"key": "cityName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
    }

    def __init__(self, *, city_name: Optional[str] = None, providers: Optional[List[str]] = None, **kwargs):
        """
        :keyword city_name: The city or town name.
        :paramtype city_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        """
        super().__init__(**kwargs)
        self.city_name = city_name
        self.providers = providers


class AvailableProvidersListCountry(_serialization.Model):
    """Country details.

    :ivar country_name: The country name.
    :vartype country_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    :ivar states: List of available states in the country.
    :vartype states: list[~azure.mgmt.network.v2019_08_01.models.AvailableProvidersListState]
    """

    _attribute_map = {
        "country_name": {"key": "countryName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
        "states": {"key": "states", "type": "[AvailableProvidersListState]"},
    }

    def __init__(
        self,
        *,
        country_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        states: Optional[List["_models.AvailableProvidersListState"]] = None,
        **kwargs
    ):
        """
        :keyword country_name: The country name.
        :paramtype country_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        :keyword states: List of available states in the country.
        :paramtype states: list[~azure.mgmt.network.v2019_08_01.models.AvailableProvidersListState]
        """
        super().__init__(**kwargs)
        self.country_name = country_name
        self.providers = providers
        self.states = states


class AvailableProvidersListParameters(_serialization.Model):
    """Constraints that determine the list of available Internet service providers.

    :ivar azure_locations: A list of Azure regions.
    :vartype azure_locations: list[str]
    :ivar country: The country for available providers list.
    :vartype country: str
    :ivar state: The state for available providers list.
    :vartype state: str
    :ivar city: The city or town for available providers list.
    :vartype city: str
    """

    _attribute_map = {
        "azure_locations": {"key": "azureLocations", "type": "[str]"},
        "country": {"key": "country", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_locations: Optional[List[str]] = None,
        country: Optional[str] = None,
        state: Optional[str] = None,
        city: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword azure_locations: A list of Azure regions.
        :paramtype azure_locations: list[str]
        :keyword country: The country for available providers list.
        :paramtype country: str
        :keyword state: The state for available providers list.
        :paramtype state: str
        :keyword city: The city or town for available providers list.
        :paramtype city: str
        """
        super().__init__(**kwargs)
        self.azure_locations = azure_locations
        self.country = country
        self.state = state
        self.city = city


class AvailableProvidersListState(_serialization.Model):
    """State details.

    :ivar state_name: The state name.
    :vartype state_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    :ivar cities: List of available cities or towns in the state.
    :vartype cities: list[~azure.mgmt.network.v2019_08_01.models.AvailableProvidersListCity]
    """

    _attribute_map = {
        "state_name": {"key": "stateName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
        "cities": {"key": "cities", "type": "[AvailableProvidersListCity]"},
    }

    def __init__(
        self,
        *,
        state_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        cities: Optional[List["_models.AvailableProvidersListCity"]] = None,
        **kwargs
    ):
        """
        :keyword state_name: The state name.
        :paramtype state_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        :keyword cities: List of available cities or towns in the state.
        :paramtype cities: list[~azure.mgmt.network.v2019_08_01.models.AvailableProvidersListCity]
        """
        super().__init__(**kwargs)
        self.state_name = state_name
        self.providers = providers
        self.cities = cities


class AvailableServiceAlias(_serialization.Model):
    """The available service alias.

    :ivar name: The name of the service alias.
    :vartype name: str
    :ivar id: The ID of the service alias.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar resource_name: The resource name of the service alias.
    :vartype resource_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the service alias.
        :paramtype name: str
        :keyword id: The ID of the service alias.
        :paramtype id: str
        :keyword type: The type of the resource.
        :paramtype type: str
        :keyword resource_name: The resource name of the service alias.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.resource_name = resource_name


class AvailableServiceAliasesResult(_serialization.Model):
    """An array of available service aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available service aliases.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.AvailableServiceAlias]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableServiceAlias]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailableServiceAlias"]] = None, **kwargs):
        """
        :keyword value: An array of available service aliases.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.AvailableServiceAlias]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AzureAsyncOperationResult(_serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :ivar status: Status of the Azure async operation. Known values are: "InProgress", "Succeeded",
     and "Failed".
    :vartype status: str or ~azure.mgmt.network.v2019_08_01.models.NetworkOperationStatus
    :ivar error: Details of the error occurred during specified asynchronous operation.
    :vartype error: ~azure.mgmt.network.v2019_08_01.models.Error
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.NetworkOperationStatus"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs
    ):
        """
        :keyword status: Status of the Azure async operation. Known values are: "InProgress",
         "Succeeded", and "Failed".
        :paramtype status: str or ~azure.mgmt.network.v2019_08_01.models.NetworkOperationStatus
        :keyword error: Details of the error occurred during specified asynchronous operation.
        :paramtype error: ~azure.mgmt.network.v2019_08_01.models.Error
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class AzureFirewall(Resource):  # pylint: disable=too-many-instance-attributes
    """Azure Firewall resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar application_rule_collections: Collection of application rule collections used by Azure
     Firewall.
    :vartype application_rule_collections:
     list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRuleCollection]
    :ivar nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
    :vartype nat_rule_collections:
     list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRuleCollection]
    :ivar network_rule_collections: Collection of network rule collections used by Azure Firewall.
    :vartype network_rule_collections:
     list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRuleCollection]
    :ivar ip_configurations: IP configuration of the Azure Firewall resource.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallIPConfiguration]
    :ivar provisioning_state: The provisioning state of the Azure firewall resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar threat_intel_mode: The operation mode for Threat Intelligence. Known values are: "Alert",
     "Deny", and "Off".
    :vartype threat_intel_mode: str or
     ~azure.mgmt.network.v2019_08_01.models.AzureFirewallThreatIntelMode
    :ivar virtual_hub: The virtualHub to which the firewall belongs.
    :vartype virtual_hub: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar firewall_policy: The firewallPolicy associated with this azure firewall.
    :vartype firewall_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar hub_ip_addresses: IP addresses associated with AzureFirewall.
    :vartype hub_ip_addresses: ~azure.mgmt.network.v2019_08_01.models.HubIPAddresses
    :ivar sku: The Azure Firewall Resource SKU.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallSku
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "hub_ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "etag": {"key": "etag", "type": "str"},
        "application_rule_collections": {
            "key": "properties.applicationRuleCollections",
            "type": "[AzureFirewallApplicationRuleCollection]",
        },
        "nat_rule_collections": {"key": "properties.natRuleCollections", "type": "[AzureFirewallNatRuleCollection]"},
        "network_rule_collections": {
            "key": "properties.networkRuleCollections",
            "type": "[AzureFirewallNetworkRuleCollection]",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[AzureFirewallIPConfiguration]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "threat_intel_mode": {"key": "properties.threatIntelMode", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "SubResource"},
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "hub_ip_addresses": {"key": "properties.hubIpAddresses", "type": "HubIPAddresses"},
        "sku": {"key": "properties.sku", "type": "AzureFirewallSku"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        application_rule_collections: Optional[List["_models.AzureFirewallApplicationRuleCollection"]] = None,
        nat_rule_collections: Optional[List["_models.AzureFirewallNatRuleCollection"]] = None,
        network_rule_collections: Optional[List["_models.AzureFirewallNetworkRuleCollection"]] = None,
        ip_configurations: Optional[List["_models.AzureFirewallIPConfiguration"]] = None,
        threat_intel_mode: Optional[Union[str, "_models.AzureFirewallThreatIntelMode"]] = None,
        virtual_hub: Optional["_models.SubResource"] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        sku: Optional["_models.AzureFirewallSku"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword application_rule_collections: Collection of application rule collections used by Azure
         Firewall.
        :paramtype application_rule_collections:
         list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRuleCollection]
        :keyword nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
        :paramtype nat_rule_collections:
         list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRuleCollection]
        :keyword network_rule_collections: Collection of network rule collections used by Azure
         Firewall.
        :paramtype network_rule_collections:
         list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRuleCollection]
        :keyword ip_configurations: IP configuration of the Azure Firewall resource.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallIPConfiguration]
        :keyword threat_intel_mode: The operation mode for Threat Intelligence. Known values are:
         "Alert", "Deny", and "Off".
        :paramtype threat_intel_mode: str or
         ~azure.mgmt.network.v2019_08_01.models.AzureFirewallThreatIntelMode
        :keyword virtual_hub: The virtualHub to which the firewall belongs.
        :paramtype virtual_hub: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword firewall_policy: The firewallPolicy associated with this azure firewall.
        :paramtype firewall_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword sku: The Azure Firewall Resource SKU.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallSku
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.zones = zones
        self.etag = None
        self.application_rule_collections = application_rule_collections
        self.nat_rule_collections = nat_rule_collections
        self.network_rule_collections = network_rule_collections
        self.ip_configurations = ip_configurations
        self.provisioning_state = None
        self.threat_intel_mode = threat_intel_mode
        self.virtual_hub = virtual_hub
        self.firewall_policy = firewall_policy
        self.hub_ip_addresses = None
        self.sku = sku


class AzureFirewallApplicationRule(_serialization.Model):
    """Properties of an application rule.

    :ivar name: Name of the application rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar protocols: Array of ApplicationRuleProtocols.
    :vartype protocols:
     list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRuleProtocol]
    :ivar target_fqdns: List of FQDNs for this rule.
    :vartype target_fqdns: list[str]
    :ivar fqdn_tags: List of FQDN Tags for this rule.
    :vartype fqdn_tags: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[AzureFirewallApplicationRuleProtocol]"},
        "target_fqdns": {"key": "targetFqdns", "type": "[str]"},
        "fqdn_tags": {"key": "fqdnTags", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[List[str]] = None,
        protocols: Optional[List["_models.AzureFirewallApplicationRuleProtocol"]] = None,
        target_fqdns: Optional[List[str]] = None,
        fqdn_tags: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the application rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword protocols: Array of ApplicationRuleProtocols.
        :paramtype protocols:
         list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRuleProtocol]
        :keyword target_fqdns: List of FQDNs for this rule.
        :paramtype target_fqdns: list[str]
        :keyword fqdn_tags: List of FQDN Tags for this rule.
        :paramtype fqdn_tags: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.fqdn_tags = fqdn_tags


class AzureFirewallApplicationRuleCollection(SubResource):
    """Application rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the application rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a rule collection.
    :vartype action: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallRCAction
    :ivar rules: Collection of rules used by a application rule collection.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRule]
    :ivar provisioning_state: The provisioning state of the application rule collection resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallApplicationRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallRCAction"] = None,
        rules: Optional[List["_models.AzureFirewallApplicationRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the application rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a rule collection.
        :paramtype action: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallRCAction
        :keyword rules: Collection of rules used by a application rule collection.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None


class AzureFirewallApplicationRuleProtocol(_serialization.Model):
    """Properties of the application rule protocol.

    :ivar protocol_type: Protocol type. Known values are: "Http", "Https", and "Mssql".
    :vartype protocol_type: str or
     ~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRuleProtocolType
    :ivar port: Port number for the protocol, cannot be greater than 64000. This field is optional.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 64000, "minimum": 0},
    }

    _attribute_map = {
        "protocol_type": {"key": "protocolType", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.AzureFirewallApplicationRuleProtocolType"]] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Protocol type. Known values are: "Http", "Https", and "Mssql".
        :paramtype protocol_type: str or
         ~azure.mgmt.network.v2019_08_01.models.AzureFirewallApplicationRuleProtocolType
        :keyword port: Port number for the protocol, cannot be greater than 64000. This field is
         optional.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port


class AzureFirewallFqdnTag(Resource):
    """Azure Firewall FQDN Tag Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the Azure firewall FQDN tag resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar fqdn_tag_name: The name of this FQDN Tag.
    :vartype fqdn_tag_name: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "fqdn_tag_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "fqdn_tag_name": {"key": "properties.fqdnTagName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.provisioning_state = None
        self.fqdn_tag_name = None


class AzureFirewallFqdnTagListResult(_serialization.Model):
    """Response for ListAzureFirewallFqdnTags API service call.

    :ivar value: List of Azure Firewall FQDN Tags in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallFqdnTag]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureFirewallFqdnTag]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureFirewallFqdnTag"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Azure Firewall FQDN Tags in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallFqdnTag]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureFirewallIPConfiguration(SubResource):
    """IP configuration of an Azure Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: The Firewall Internal Load Balancer IP to be used as the next hop in
     User Defined Routes.
    :vartype private_ip_address: str
    :ivar subnet: Reference of the subnet resource. This resource must be named
     'AzureFirewallSubnet'.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar public_ip_address: Reference of the PublicIP resource. This field is a mandatory input if
     subnet is not null.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the Azure firewall IP configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "private_ip_address": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword subnet: Reference of the subnet resource. This resource must be named
         'AzureFirewallSubnet'.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword public_ip_address: Reference of the PublicIP resource. This field is a mandatory input
         if subnet is not null.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.private_ip_address = None
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None


class AzureFirewallListResult(_serialization.Model):
    """Response for ListAzureFirewalls API service call.

    :ivar value: List of Azure Firewalls in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewall]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureFirewall]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureFirewall"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Azure Firewalls in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewall]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureFirewallNatRCAction(_serialization.Model):
    """AzureFirewall NAT Rule Collection Action.

    :ivar type: The type of action. Known values are: "Snat" and "Dnat".
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRCActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.AzureFirewallNatRCActionType"]] = None, **kwargs):
        """
        :keyword type: The type of action. Known values are: "Snat" and "Dnat".
        :paramtype type: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRCActionType
        """
        super().__init__(**kwargs)
        self.type = type


class AzureFirewallNatRule(_serialization.Model):
    """Properties of a NAT rule.

    :ivar name: Name of the NAT rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses for this rule. Supports IP
     ranges, prefixes, and service tags.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    :ivar protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
    :vartype protocols: list[str or
     ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRuleProtocol]
    :ivar translated_address: The translated address for this NAT rule.
    :vartype translated_address: str
    :ivar translated_port: The translated port for this NAT rule.
    :vartype translated_port: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "translated_address": {"key": "translatedAddress", "type": "str"},
        "translated_port": {"key": "translatedPort", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[List[str]] = None,
        destination_addresses: Optional[List[str]] = None,
        destination_ports: Optional[List[str]] = None,
        protocols: Optional[List[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]]] = None,
        translated_address: Optional[str] = None,
        translated_port: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the NAT rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses for this rule. Supports IP
         ranges, prefixes, and service tags.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        :keyword protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        :paramtype protocols: list[str or
         ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRuleProtocol]
        :keyword translated_address: The translated address for this NAT rule.
        :paramtype translated_address: str
        :keyword translated_port: The translated port for this NAT rule.
        :paramtype translated_port: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.protocols = protocols
        self.translated_address = translated_address
        self.translated_port = translated_port


class AzureFirewallNatRuleCollection(SubResource):
    """NAT rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the NAT rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a NAT rule collection.
    :vartype action: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRCAction
    :ivar rules: Collection of rules used by a NAT rule collection.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRule]
    :ivar provisioning_state: The provisioning state of the NAT rule collection resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallNatRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallNatRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallNatRCAction"] = None,
        rules: Optional[List["_models.AzureFirewallNatRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the NAT rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a NAT rule collection.
        :paramtype action: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRCAction
        :keyword rules: Collection of rules used by a NAT rule collection.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNatRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None


class AzureFirewallNetworkRule(_serialization.Model):
    """Properties of the network rule.

    :ivar name: Name of the network rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar protocols: Array of AzureFirewallNetworkRuleProtocols.
    :vartype protocols: list[str or
     ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRuleProtocol]
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        protocols: Optional[List[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]]] = None,
        source_addresses: Optional[List[str]] = None,
        destination_addresses: Optional[List[str]] = None,
        destination_ports: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the network rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword protocols: Array of AzureFirewallNetworkRuleProtocols.
        :paramtype protocols: list[str or
         ~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRuleProtocol]
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocols = protocols
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports


class AzureFirewallNetworkRuleCollection(SubResource):
    """Network rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the network rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a rule collection.
    :vartype action: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallRCAction
    :ivar rules: Collection of rules used by a network rule collection.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRule]
    :ivar provisioning_state: The provisioning state of the network rule collection resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallNetworkRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallRCAction"] = None,
        rules: Optional[List["_models.AzureFirewallNetworkRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the network rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a rule collection.
        :paramtype action: ~azure.mgmt.network.v2019_08_01.models.AzureFirewallRCAction
        :keyword rules: Collection of rules used by a network rule collection.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallNetworkRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None


class AzureFirewallPublicIPAddress(_serialization.Model):
    """Public IP Address associated with azure firewall.

    :ivar address: Public IP Address value.
    :vartype address: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
    }

    def __init__(self, *, address: Optional[str] = None, **kwargs):
        """
        :keyword address: Public IP Address value.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.address = address


class AzureFirewallRCAction(_serialization.Model):
    """Properties of the AzureFirewallRCAction.

    :ivar type: The type of action. Known values are: "Allow" and "Deny".
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallRCActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.AzureFirewallRCActionType"]] = None, **kwargs):
        """
        :keyword type: The type of action. Known values are: "Allow" and "Deny".
        :paramtype type: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallRCActionType
        """
        super().__init__(**kwargs)
        self.type = type


class AzureFirewallSku(_serialization.Model):
    """SKU of an Azure Firewall.

    :ivar name: Name of an Azure Firewall SKU. Known values are: "AZFW_VNet" and "AZFW_Hub".
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallSkuName
    :ivar tier: Tier of an Azure Firewall. "Standard"
    :vartype tier: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallSkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.AzureFirewallSkuName"]] = None,
        tier: Optional[Union[str, "_models.AzureFirewallSkuTier"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of an Azure Firewall SKU. Known values are: "AZFW_VNet" and "AZFW_Hub".
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallSkuName
        :keyword tier: Tier of an Azure Firewall. "Standard"
        :paramtype tier: str or ~azure.mgmt.network.v2019_08_01.models.AzureFirewallSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class AzureReachabilityReport(_serialization.Model):
    """Azure reachability report details.

    All required parameters must be populated in order to send to Azure.

    :ivar aggregation_level: The aggregation level of Azure reachability report. Can be Country,
     State or City. Required.
    :vartype aggregation_level: str
    :ivar provider_location: Parameters that define a geographic location. Required.
    :vartype provider_location:
     ~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportLocation
    :ivar reachability_report: List of Azure reachability report items. Required.
    :vartype reachability_report:
     list[~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportItem]
    """

    _validation = {
        "aggregation_level": {"required": True},
        "provider_location": {"required": True},
        "reachability_report": {"required": True},
    }

    _attribute_map = {
        "aggregation_level": {"key": "aggregationLevel", "type": "str"},
        "provider_location": {"key": "providerLocation", "type": "AzureReachabilityReportLocation"},
        "reachability_report": {"key": "reachabilityReport", "type": "[AzureReachabilityReportItem]"},
    }

    def __init__(
        self,
        *,
        aggregation_level: str,
        provider_location: "_models.AzureReachabilityReportLocation",
        reachability_report: List["_models.AzureReachabilityReportItem"],
        **kwargs
    ):
        """
        :keyword aggregation_level: The aggregation level of Azure reachability report. Can be Country,
         State or City. Required.
        :paramtype aggregation_level: str
        :keyword provider_location: Parameters that define a geographic location. Required.
        :paramtype provider_location:
         ~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportLocation
        :keyword reachability_report: List of Azure reachability report items. Required.
        :paramtype reachability_report:
         list[~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportItem]
        """
        super().__init__(**kwargs)
        self.aggregation_level = aggregation_level
        self.provider_location = provider_location
        self.reachability_report = reachability_report


class AzureReachabilityReportItem(_serialization.Model):
    """Azure reachability report details for a given provider location.

    :ivar provider: The Internet service provider.
    :vartype provider: str
    :ivar azure_location: The Azure region.
    :vartype azure_location: str
    :ivar latencies: List of latency details for each of the time series.
    :vartype latencies:
     list[~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportLatencyInfo]
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "azure_location": {"key": "azureLocation", "type": "str"},
        "latencies": {"key": "latencies", "type": "[AzureReachabilityReportLatencyInfo]"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        azure_location: Optional[str] = None,
        latencies: Optional[List["_models.AzureReachabilityReportLatencyInfo"]] = None,
        **kwargs
    ):
        """
        :keyword provider: The Internet service provider.
        :paramtype provider: str
        :keyword azure_location: The Azure region.
        :paramtype azure_location: str
        :keyword latencies: List of latency details for each of the time series.
        :paramtype latencies:
         list[~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportLatencyInfo]
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.azure_location = azure_location
        self.latencies = latencies


class AzureReachabilityReportLatencyInfo(_serialization.Model):
    """Details on latency for a time series.

    :ivar time_stamp: The time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar score: The relative latency score between 1 and 100, higher values indicating a faster
     connection.
    :vartype score: int
    """

    _validation = {
        "score": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "score": {"key": "score", "type": "int"},
    }

    def __init__(self, *, time_stamp: Optional[datetime.datetime] = None, score: Optional[int] = None, **kwargs):
        """
        :keyword time_stamp: The time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword score: The relative latency score between 1 and 100, higher values indicating a faster
         connection.
        :paramtype score: int
        """
        super().__init__(**kwargs)
        self.time_stamp = time_stamp
        self.score = score


class AzureReachabilityReportLocation(_serialization.Model):
    """Parameters that define a geographic location.

    All required parameters must be populated in order to send to Azure.

    :ivar country: The name of the country. Required.
    :vartype country: str
    :ivar state: The name of the state.
    :vartype state: str
    :ivar city: The name of the city or town.
    :vartype city: str
    """

    _validation = {
        "country": {"required": True},
    }

    _attribute_map = {
        "country": {"key": "country", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(self, *, country: str, state: Optional[str] = None, city: Optional[str] = None, **kwargs):
        """
        :keyword country: The name of the country. Required.
        :paramtype country: str
        :keyword state: The name of the state.
        :paramtype state: str
        :keyword city: The name of the city or town.
        :paramtype city: str
        """
        super().__init__(**kwargs)
        self.country = country
        self.state = state
        self.city = city


class AzureReachabilityReportParameters(_serialization.Model):
    """Geographic and time constraints for Azure reachability report.

    All required parameters must be populated in order to send to Azure.

    :ivar provider_location: Parameters that define a geographic location. Required.
    :vartype provider_location:
     ~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportLocation
    :ivar providers: List of Internet service providers.
    :vartype providers: list[str]
    :ivar azure_locations: Optional Azure regions to scope the query to.
    :vartype azure_locations: list[str]
    :ivar start_time: The start time for the Azure reachability report. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the Azure reachability report. Required.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "provider_location": {"required": True},
        "start_time": {"required": True},
        "end_time": {"required": True},
    }

    _attribute_map = {
        "provider_location": {"key": "providerLocation", "type": "AzureReachabilityReportLocation"},
        "providers": {"key": "providers", "type": "[str]"},
        "azure_locations": {"key": "azureLocations", "type": "[str]"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        provider_location: "_models.AzureReachabilityReportLocation",
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        providers: Optional[List[str]] = None,
        azure_locations: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword provider_location: Parameters that define a geographic location. Required.
        :paramtype provider_location:
         ~azure.mgmt.network.v2019_08_01.models.AzureReachabilityReportLocation
        :keyword providers: List of Internet service providers.
        :paramtype providers: list[str]
        :keyword azure_locations: Optional Azure regions to scope the query to.
        :paramtype azure_locations: list[str]
        :keyword start_time: The start time for the Azure reachability report. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time for the Azure reachability report. Required.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.provider_location = provider_location
        self.providers = providers
        self.azure_locations = azure_locations
        self.start_time = start_time
        self.end_time = end_time


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of backend address pools
     used by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: An array of references to IP addresses defined in network
     interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar outbound_rule: A reference to an outbound rule that uses this backend address pool.
    :vartype outbound_rule: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar outbound_rules: An array of references to outbound rules that use this backend address
     pool.
    :vartype outbound_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "backend_ip_configurations": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "outbound_rule": {"readonly": True},
        "outbound_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "outbound_rule": {"key": "properties.outboundRule", "type": "SubResource"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of backend address pools
         used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_rule = None
        self.outbound_rules = None
        self.provisioning_state = None


class BastionHost(Resource):
    """Bastion Host resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: IP configuration of the Bastion Host resource.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.BastionHostIPConfiguration]
    :ivar dns_name: FQDN for the endpoint on which bastion host is accessible.
    :vartype dns_name: str
    :ivar provisioning_state: The provisioning state of the bastion host resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[BastionHostIPConfiguration]"},
        "dns_name": {"key": "properties.dnsName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        ip_configurations: Optional[List["_models.BastionHostIPConfiguration"]] = None,
        dns_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword ip_configurations: IP configuration of the Bastion Host resource.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.BastionHostIPConfiguration]
        :keyword dns_name: FQDN for the endpoint on which bastion host is accessible.
        :paramtype dns_name: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.ip_configurations = ip_configurations
        self.dns_name = dns_name
        self.provisioning_state = None


class BastionHostIPConfiguration(SubResource):
    """IP configuration of an Bastion Host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Ip configuration type.
    :vartype type: str
    :ivar subnet: Reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar public_ip_address: Reference of the PublicIP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the bastion host IP configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_ip_allocation_method: Private IP allocation method. Known values are: "Static"
     and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword subnet: Reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword public_ip_address: Reference of the PublicIP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword private_ip_allocation_method: Private IP allocation method. Known values are: "Static"
         and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None
        self.private_ip_allocation_method = private_ip_allocation_method


class BastionHostListResult(_serialization.Model):
    """Response for ListBastionHosts API service call.

    :ivar value: List of Bastion Hosts in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.BastionHost]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BastionHost]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BastionHost"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Bastion Hosts in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.BastionHost]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BGPCommunity(_serialization.Model):
    """Contains bgp community information offered in Service Community resources.

    :ivar service_supported_region: The region which the service support. e.g. For O365, region is
     Global.
    :vartype service_supported_region: str
    :ivar community_name: The name of the bgp community. e.g. Skype.
    :vartype community_name: str
    :ivar community_value: The value of the bgp community. For more information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :vartype community_value: str
    :ivar community_prefixes: The prefixes that the bgp community contains.
    :vartype community_prefixes: list[str]
    :ivar is_authorized_to_use: Customer is authorized to use bgp community or not.
    :vartype is_authorized_to_use: bool
    :ivar service_group: The service group of the bgp community contains.
    :vartype service_group: str
    """

    _attribute_map = {
        "service_supported_region": {"key": "serviceSupportedRegion", "type": "str"},
        "community_name": {"key": "communityName", "type": "str"},
        "community_value": {"key": "communityValue", "type": "str"},
        "community_prefixes": {"key": "communityPrefixes", "type": "[str]"},
        "is_authorized_to_use": {"key": "isAuthorizedToUse", "type": "bool"},
        "service_group": {"key": "serviceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_supported_region: Optional[str] = None,
        community_name: Optional[str] = None,
        community_value: Optional[str] = None,
        community_prefixes: Optional[List[str]] = None,
        is_authorized_to_use: Optional[bool] = None,
        service_group: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword service_supported_region: The region which the service support. e.g. For O365, region
         is Global.
        :paramtype service_supported_region: str
        :keyword community_name: The name of the bgp community. e.g. Skype.
        :paramtype community_name: str
        :keyword community_value: The value of the bgp community. For more information:
         https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
        :paramtype community_value: str
        :keyword community_prefixes: The prefixes that the bgp community contains.
        :paramtype community_prefixes: list[str]
        :keyword is_authorized_to_use: Customer is authorized to use bgp community or not.
        :paramtype is_authorized_to_use: bool
        :keyword service_group: The service group of the bgp community contains.
        :paramtype service_group: str
        """
        super().__init__(**kwargs)
        self.service_supported_region = service_supported_region
        self.community_name = community_name
        self.community_value = community_value
        self.community_prefixes = community_prefixes
        self.is_authorized_to_use = is_authorized_to_use
        self.service_group = service_group


class BgpPeerStatus(_serialization.Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Known values are: "Unknown", "Stopped", "Idle", "Connecting",
     and "Connected".
    :vartype state: str or ~azure.mgmt.network.v2019_08_01.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: int
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: int
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "neighbor": {"readonly": True},
        "asn": {"readonly": True},
        "state": {"readonly": True},
        "connected_duration": {"readonly": True},
        "routes_received": {"readonly": True},
        "messages_sent": {"readonly": True},
        "messages_received": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "connected_duration": {"key": "connectedDuration", "type": "str"},
        "routes_received": {"key": "routesReceived", "type": "int"},
        "messages_sent": {"key": "messagesSent", "type": "int"},
        "messages_received": {"key": "messagesReceived", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None


class BgpPeerStatusListResult(_serialization.Model):
    """Response for list BGP peer status API service call.

    :ivar value: List of BGP peers.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.BgpPeerStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpPeerStatus]"},
    }

    def __init__(self, *, value: Optional[List["_models.BgpPeerStatus"]] = None, **kwargs):
        """
        :keyword value: List of BGP peers.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.BgpPeerStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar service_name: The name of the bgp community. e.g. Skype.
    :vartype service_name: str
    :ivar bgp_communities: A list of bgp communities.
    :vartype bgp_communities: list[~azure.mgmt.network.v2019_08_01.models.BGPCommunity]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "bgp_communities": {"key": "properties.bgpCommunities", "type": "[BGPCommunity]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        service_name: Optional[str] = None,
        bgp_communities: Optional[List["_models.BGPCommunity"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword service_name: The name of the bgp community. e.g. Skype.
        :paramtype service_name: str
        :keyword bgp_communities: A list of bgp communities.
        :paramtype bgp_communities: list[~azure.mgmt.network.v2019_08_01.models.BGPCommunity]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_name = service_name
        self.bgp_communities = bgp_communities


class BgpServiceCommunityListResult(_serialization.Model):
    """Response for the ListServiceCommunity API service call.

    :ivar value: A list of service community resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.BgpServiceCommunity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpServiceCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BgpServiceCommunity"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of service community resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.BgpServiceCommunity]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BgpSettings(_serialization.Model):
    """BGP settings details.

    :ivar asn: The BGP speaker's ASN.
    :vartype asn: int
    :ivar bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :vartype bgp_peering_address: str
    :ivar peer_weight: The weight added to routes learned from this BGP speaker.
    :vartype peer_weight: int
    """

    _attribute_map = {
        "asn": {"key": "asn", "type": "int"},
        "bgp_peering_address": {"key": "bgpPeeringAddress", "type": "str"},
        "peer_weight": {"key": "peerWeight", "type": "int"},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword asn: The BGP speaker's ASN.
        :paramtype asn: int
        :keyword bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :paramtype bgp_peering_address: str
        :keyword peer_weight: The weight added to routes learned from this BGP speaker.
        :paramtype peer_weight: int
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight


class CheckPrivateLinkServiceVisibilityRequest(_serialization.Model):
    """Request body of the CheckPrivateLinkServiceVisibility API service call.

    :ivar private_link_service_alias: The alias of the private link service.
    :vartype private_link_service_alias: str
    """

    _attribute_map = {
        "private_link_service_alias": {"key": "privateLinkServiceAlias", "type": "str"},
    }

    def __init__(self, *, private_link_service_alias: Optional[str] = None, **kwargs):
        """
        :keyword private_link_service_alias: The alias of the private link service.
        :paramtype private_link_service_alias: str
        """
        super().__init__(**kwargs)
        self.private_link_service_alias = private_link_service_alias


class CloudErrorBody(_serialization.Model):
    """An error response from the Batch service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.network.v2019_08_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.network.v2019_08_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(
    _serialization.Model
):
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ConnectionMonitor(_serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Connection monitor location.
    :vartype location: str
    :ivar tags: Connection monitor tags.
    :vartype tags: dict[str, str]
    :ivar source: Describes the source of connection monitor. Required.
    :vartype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor. Required.
    :vartype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "properties.destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "properties.autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "properties.monitoringIntervalInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        source: "_models.ConnectionMonitorSource",
        destination: "_models.ConnectionMonitorDestination",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        **kwargs
    ):
        """
        :keyword location: Connection monitor location.
        :paramtype location: str
        :keyword tags: Connection monitor tags.
        :paramtype tags: dict[str, str]
        :keyword source: Describes the source of connection monitor. Required.
        :paramtype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor. Required.
        :paramtype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds


class ConnectionMonitorDestination(_serialization.Model):
    """Describes the destination of connection monitor.

    :ivar resource_id: The ID of the resource used as the destination by connection monitor.
    :vartype resource_id: str
    :ivar address: Address of the connection monitor destination (IP or domain name).
    :vartype address: str
    :ivar port: The destination port used by connection monitor.
    :vartype port: int
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, address: Optional[str] = None, port: Optional[int] = None, **kwargs
    ):
        """
        :keyword resource_id: The ID of the resource used as the destination by connection monitor.
        :paramtype resource_id: str
        :keyword address: Address of the connection monitor destination (IP or domain name).
        :paramtype address: str
        :keyword port: The destination port used by connection monitor.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectionMonitorListResult(_serialization.Model):
    """List of connection monitors.

    :ivar value: Information about connection monitors.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectionMonitorResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.ConnectionMonitorResult"]] = None, **kwargs):
        """
        :keyword value: Information about connection monitors.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorResult]
        """
        super().__init__(**kwargs)
        self.value = value


class ConnectionMonitorParameters(_serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Describes the source of connection monitor. Required.
    :vartype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor. Required.
    :vartype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "monitoringIntervalInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        source: "_models.ConnectionMonitorSource",
        destination: "_models.ConnectionMonitorDestination",
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        **kwargs
    ):
        """
        :keyword source: Describes the source of connection monitor. Required.
        :paramtype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor. Required.
        :paramtype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds


class ConnectionMonitorQueryResult(_serialization.Model):
    """List of connection states snapshots.

    :ivar source_status: Status of connection monitor source. Known values are: "Unknown",
     "Active", and "Inactive".
    :vartype source_status: str or
     ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSourceStatus
    :ivar states: Information about connection states.
    :vartype states: list[~azure.mgmt.network.v2019_08_01.models.ConnectionStateSnapshot]
    """

    _attribute_map = {
        "source_status": {"key": "sourceStatus", "type": "str"},
        "states": {"key": "states", "type": "[ConnectionStateSnapshot]"},
    }

    def __init__(
        self,
        *,
        source_status: Optional[Union[str, "_models.ConnectionMonitorSourceStatus"]] = None,
        states: Optional[List["_models.ConnectionStateSnapshot"]] = None,
        **kwargs
    ):
        """
        :keyword source_status: Status of connection monitor source. Known values are: "Unknown",
         "Active", and "Inactive".
        :paramtype source_status: str or
         ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSourceStatus
        :keyword states: Information about connection states.
        :paramtype states: list[~azure.mgmt.network.v2019_08_01.models.ConnectionStateSnapshot]
        """
        super().__init__(**kwargs)
        self.source_status = source_status
        self.states = states


class ConnectionMonitorResult(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information about the connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the connection monitor.
    :vartype name: str
    :ivar id: ID of the connection monitor.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Connection monitor type.
    :vartype type: str
    :ivar location: Connection monitor location.
    :vartype location: str
    :ivar tags: Connection monitor tags.
    :vartype tags: dict[str, str]
    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar provisioning_state: The provisioning state of the connection monitor. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "properties.destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "properties.autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "properties.monitoringIntervalInSeconds", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "monitoring_status": {"key": "properties.monitoringStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: str = "A unique read-only string that changes whenever the resource is updated.",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        start_time: Optional[datetime.datetime] = None,
        monitoring_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword location: Connection monitor location.
        :paramtype location: str
        :keyword tags: Connection monitor tags.
        :paramtype tags: dict[str, str]
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword start_time: The date and time when the connection monitor was started.
        :paramtype start_time: ~datetime.datetime
        :keyword monitoring_status: The monitoring status of the connection monitor.
        :paramtype monitoring_status: str
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = etag
        self.type = None
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.provisioning_state = None
        self.start_time = start_time
        self.monitoring_status = monitoring_status


class ConnectionMonitorResultProperties(ConnectionMonitorParameters):
    """Describes the properties of a connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Describes the source of connection monitor. Required.
    :vartype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor. Required.
    :vartype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar provisioning_state: The provisioning state of the connection monitor. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "monitoringIntervalInSeconds", "type": "int"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "monitoring_status": {"key": "monitoringStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: "_models.ConnectionMonitorSource",
        destination: "_models.ConnectionMonitorDestination",
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        start_time: Optional[datetime.datetime] = None,
        monitoring_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source: Describes the source of connection monitor. Required.
        :paramtype source: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor. Required.
        :paramtype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword start_time: The date and time when the connection monitor was started.
        :paramtype start_time: ~datetime.datetime
        :keyword monitoring_status: The monitoring status of the connection monitor.
        :paramtype monitoring_status: str
        """
        super().__init__(
            source=source,
            destination=destination,
            auto_start=auto_start,
            monitoring_interval_in_seconds=monitoring_interval_in_seconds,
            **kwargs
        )
        self.provisioning_state = None
        self.start_time = start_time
        self.monitoring_status = monitoring_status


class ConnectionMonitorSource(_serialization.Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The ID of the resource used as the source by connection monitor. Required.
    :vartype resource_id: str
    :ivar port: The source port used by connection monitor.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs):
        """
        :keyword resource_id: The ID of the resource used as the source by connection monitor.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port used by connection monitor.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class ConnectionResetSharedKey(_serialization.Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_length: The virtual network connection reset shared key length, should between 1 and
     128. Required.
    :vartype key_length: int
    """

    _validation = {
        "key_length": {"required": True, "maximum": 128, "minimum": 1},
    }

    _attribute_map = {
        "key_length": {"key": "keyLength", "type": "int"},
    }

    def __init__(self, *, key_length: int, **kwargs):
        """
        :keyword key_length: The virtual network connection reset shared key length, should between 1
         and 128. Required.
        :paramtype key_length: int
        """
        super().__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(SubResource):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar value: The virtual network connection shared key value. Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword value: The virtual network connection shared key value. Required.
        :paramtype value: str
        """
        super().__init__(id=id, **kwargs)
        self.value = value


class ConnectionStateSnapshot(_serialization.Model):
    """Connection state snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connection_state: The connection state. Known values are: "Reachable", "Unreachable", and
     "Unknown".
    :vartype connection_state: str or ~azure.mgmt.network.v2019_08_01.models.ConnectionState
    :ivar start_time: The start time of the connection snapshot.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the connection snapshot.
    :vartype end_time: ~datetime.datetime
    :ivar evaluation_state: Connectivity analysis evaluation state. Known values are: "NotStarted",
     "InProgress", and "Completed".
    :vartype evaluation_state: str or ~azure.mgmt.network.v2019_08_01.models.EvaluationState
    :ivar avg_latency_in_ms: Average latency in ms.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in ms.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in ms.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: The number of sent probes.
    :vartype probes_sent: int
    :ivar probes_failed: The number of failed probes.
    :vartype probes_failed: int
    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2019_08_01.models.ConnectivityHop]
    """

    _validation = {
        "hops": {"readonly": True},
    }

    _attribute_map = {
        "connection_state": {"key": "connectionState", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "evaluation_state": {"key": "evaluationState", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
    }

    def __init__(
        self,
        *,
        connection_state: Optional[Union[str, "_models.ConnectionState"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        evaluation_state: Optional[Union[str, "_models.EvaluationState"]] = None,
        avg_latency_in_ms: Optional[int] = None,
        min_latency_in_ms: Optional[int] = None,
        max_latency_in_ms: Optional[int] = None,
        probes_sent: Optional[int] = None,
        probes_failed: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword connection_state: The connection state. Known values are: "Reachable", "Unreachable",
         and "Unknown".
        :paramtype connection_state: str or ~azure.mgmt.network.v2019_08_01.models.ConnectionState
        :keyword start_time: The start time of the connection snapshot.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the connection snapshot.
        :paramtype end_time: ~datetime.datetime
        :keyword evaluation_state: Connectivity analysis evaluation state. Known values are:
         "NotStarted", "InProgress", and "Completed".
        :paramtype evaluation_state: str or ~azure.mgmt.network.v2019_08_01.models.EvaluationState
        :keyword avg_latency_in_ms: Average latency in ms.
        :paramtype avg_latency_in_ms: int
        :keyword min_latency_in_ms: Minimum latency in ms.
        :paramtype min_latency_in_ms: int
        :keyword max_latency_in_ms: Maximum latency in ms.
        :paramtype max_latency_in_ms: int
        :keyword probes_sent: The number of sent probes.
        :paramtype probes_sent: int
        :keyword probes_failed: The number of failed probes.
        :paramtype probes_failed: int
        """
        super().__init__(**kwargs)
        self.connection_state = connection_state
        self.start_time = start_time
        self.end_time = end_time
        self.evaluation_state = evaluation_state
        self.avg_latency_in_ms = avg_latency_in_ms
        self.min_latency_in_ms = min_latency_in_ms
        self.max_latency_in_ms = max_latency_in_ms
        self.probes_sent = probes_sent
        self.probes_failed = probes_failed
        self.hops = None


class ConnectivityDestination(_serialization.Model):
    """Parameters that define destination of connection.

    :ivar resource_id: The ID of the resource to which a connection attempt will be made.
    :vartype resource_id: str
    :ivar address: The IP address or URI the resource to which a connection attempt will be made.
    :vartype address: str
    :ivar port: Port on which check connectivity will be performed.
    :vartype port: int
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, address: Optional[str] = None, port: Optional[int] = None, **kwargs
    ):
        """
        :keyword resource_id: The ID of the resource to which a connection attempt will be made.
        :paramtype resource_id: str
        :keyword address: The IP address or URI the resource to which a connection attempt will be
         made.
        :paramtype address: str
        :keyword port: Port on which check connectivity will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectivityHop(_serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.v2019_08_01.models.ConnectivityIssue]
    """

    _validation = {
        "type": {"readonly": True},
        "id": {"readonly": True},
        "address": {"readonly": True},
        "resource_id": {"readonly": True},
        "next_hop_ids": {"readonly": True},
        "issues": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "next_hop_ids": {"key": "nextHopIds", "type": "[str]"},
        "issues": {"key": "issues", "type": "[ConnectivityIssue]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityInformation(_serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2019_08_01.models.ConnectivityHop]
    :ivar connection_status: The connection status. Known values are: "Unknown", "Connected",
     "Disconnected", and "Degraded".
    :vartype connection_status: str or ~azure.mgmt.network.v2019_08_01.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        "hops": {"readonly": True},
        "connection_status": {"readonly": True},
        "avg_latency_in_ms": {"readonly": True},
        "min_latency_in_ms": {"readonly": True},
        "max_latency_in_ms": {"readonly": True},
        "probes_sent": {"readonly": True},
        "probes_failed": {"readonly": True},
    }

    _attribute_map = {
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityIssue(_serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Known values are: "Local", "Inbound", and "Outbound".
    :vartype origin: str or ~azure.mgmt.network.v2019_08_01.models.Origin
    :ivar severity: The severity of the issue. Known values are: "Error" and "Warning".
    :vartype severity: str or ~azure.mgmt.network.v2019_08_01.models.Severity
    :ivar type: The type of issue. Known values are: "Unknown", "AgentStopped", "GuestFirewall",
     "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute", "PortThrottled", and
     "Platform".
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        "origin": {"readonly": True},
        "severity": {"readonly": True},
        "type": {"readonly": True},
        "context": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "context": {"key": "context", "type": "[{str}]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityParameters(_serialization.Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Describes the source of the connection. Required.
    :vartype source: ~azure.mgmt.network.v2019_08_01.models.ConnectivitySource
    :ivar destination: Describes the destination of connection. Required.
    :vartype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectivityDestination
    :ivar protocol: Network protocol. Known values are: "Tcp", "Http", "Https", and "Icmp".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.Protocol
    :ivar protocol_configuration: Configuration of the protocol.
    :vartype protocol_configuration: ~azure.mgmt.network.v2019_08_01.models.ProtocolConfiguration
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectivitySource"},
        "destination": {"key": "destination", "type": "ConnectivityDestination"},
        "protocol": {"key": "protocol", "type": "str"},
        "protocol_configuration": {"key": "protocolConfiguration", "type": "ProtocolConfiguration"},
    }

    def __init__(
        self,
        *,
        source: "_models.ConnectivitySource",
        destination: "_models.ConnectivityDestination",
        protocol: Optional[Union[str, "_models.Protocol"]] = None,
        protocol_configuration: Optional["_models.ProtocolConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword source: Describes the source of the connection. Required.
        :paramtype source: ~azure.mgmt.network.v2019_08_01.models.ConnectivitySource
        :keyword destination: Describes the destination of connection. Required.
        :paramtype destination: ~azure.mgmt.network.v2019_08_01.models.ConnectivityDestination
        :keyword protocol: Network protocol. Known values are: "Tcp", "Http", "Https", and "Icmp".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.Protocol
        :keyword protocol_configuration: Configuration of the protocol.
        :paramtype protocol_configuration: ~azure.mgmt.network.v2019_08_01.models.ProtocolConfiguration
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.protocol = protocol
        self.protocol_configuration = protocol_configuration


class ConnectivitySource(_serialization.Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The ID of the resource from which a connectivity check will be initiated.
     Required.
    :vartype resource_id: str
    :ivar port: The source port from which a connectivity check will be performed.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs):
        """
        :keyword resource_id: The ID of the resource from which a connectivity check will be initiated.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port from which a connectivity check will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class Container(SubResource):
    """Reference to container resource in remote resource provider.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)


class ContainerNetworkInterface(SubResource):
    """Container network interface child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interface_configuration: Container network interface configuration from
     which this container network interface is created.
    :vartype container_network_interface_configuration:
     ~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterfaceConfiguration
    :ivar container: Reference to the container to which this container network interface is
     attached.
    :vartype container: ~azure.mgmt.network.v2019_08_01.models.Container
    :ivar ip_configurations: Reference to the ip configuration on this container nic.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterfaceIpConfiguration]
    :ivar provisioning_state: The provisioning state of the container network interface resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "container_network_interface_configuration": {
            "key": "properties.containerNetworkInterfaceConfiguration",
            "type": "ContainerNetworkInterfaceConfiguration",
        },
        "container": {"key": "properties.container", "type": "Container"},
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[ContainerNetworkInterfaceIpConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        container_network_interface_configuration: Optional["_models.ContainerNetworkInterfaceConfiguration"] = None,
        container: Optional["_models.Container"] = None,
        ip_configurations: Optional[List["_models.ContainerNetworkInterfaceIpConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword container_network_interface_configuration: Container network interface configuration
         from which this container network interface is created.
        :paramtype container_network_interface_configuration:
         ~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterfaceConfiguration
        :keyword container: Reference to the container to which this container network interface is
         attached.
        :paramtype container: ~azure.mgmt.network.v2019_08_01.models.Container
        :keyword ip_configurations: Reference to the ip configuration on this container nic.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterfaceIpConfiguration]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = etag
        self.container_network_interface_configuration = container_network_interface_configuration
        self.container = container
        self.ip_configurations = ip_configurations
        self.provisioning_state = None


class ContainerNetworkInterfaceConfiguration(SubResource):
    """Container network interface configuration child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: A list of ip configurations of the container network interface
     configuration.
    :vartype ip_configurations: list[~azure.mgmt.network.v2019_08_01.models.IPConfigurationProfile]
    :ivar container_network_interfaces: A list of container network interfaces created from this
     container network interface configuration.
    :vartype container_network_interfaces: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the container network interface
     configuration resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfigurationProfile]"},
        "container_network_interfaces": {"key": "properties.containerNetworkInterfaces", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        ip_configurations: Optional[List["_models.IPConfigurationProfile"]] = None,
        container_network_interfaces: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword ip_configurations: A list of ip configurations of the container network interface
         configuration.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.IPConfigurationProfile]
        :keyword container_network_interfaces: A list of container network interfaces created from this
         container network interface configuration.
        :paramtype container_network_interfaces:
         list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = etag
        self.ip_configurations = ip_configurations
        self.container_network_interfaces = container_network_interfaces
        self.provisioning_state = None


class ContainerNetworkInterfaceIpConfiguration(_serialization.Model):
    """The ip configuration for a container network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the container network interface IP
     configuration resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, etag: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = None
        self.etag = etag
        self.provisioning_state = None


class DdosCustomPolicy(Resource):
    """A DDoS custom policy in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS custom policy resource. It uniquely
     identifies the resource, even if the user changes its name or migrate the resource across
     subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS custom policy resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar public_ip_addresses: The list of public IPs associated with the DDoS custom policy
     resource. This list is read-only.
    :vartype public_ip_addresses: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar protocol_custom_settings: The protocol-specific DDoS policy customization parameters.
    :vartype protocol_custom_settings:
     list[~azure.mgmt.network.v2019_08_01.models.ProtocolCustomSettingsFormat]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "public_ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "public_ip_addresses": {"key": "properties.publicIPAddresses", "type": "[SubResource]"},
        "protocol_custom_settings": {
            "key": "properties.protocolCustomSettings",
            "type": "[ProtocolCustomSettingsFormat]",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        protocol_custom_settings: Optional[List["_models.ProtocolCustomSettingsFormat"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword protocol_custom_settings: The protocol-specific DDoS policy customization parameters.
        :paramtype protocol_custom_settings:
         list[~azure.mgmt.network.v2019_08_01.models.ProtocolCustomSettingsFormat]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None
        self.public_ip_addresses = None
        self.protocol_custom_settings = protocol_custom_settings


class DdosProtectionPlan(_serialization.Model):
    """A DDoS protection plan in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS protection plan resource. It
     uniquely identifies the resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS protection plan resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar virtual_networks: The list of virtual networks associated with the DDoS protection plan
     resource. This list is read-only.
    :vartype virtual_networks: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "virtual_networks": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_networks": {"key": "properties.virtualNetworks", "type": "[SubResource]"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None
        self.virtual_networks = None


class DdosProtectionPlanListResult(_serialization.Model):
    """A list of DDoS protection plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of DDoS protection plans.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.DdosProtectionPlan]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DdosProtectionPlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DdosProtectionPlan"]] = None, **kwargs):
        """
        :keyword value: A list of DDoS protection plans.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.DdosProtectionPlan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DdosSettings(_serialization.Model):
    """Contains the DDoS protection settings of the public IP.

    :ivar ddos_custom_policy: The DDoS custom policy associated with the public IP.
    :vartype ddos_custom_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar protection_coverage: The DDoS protection policy customizability of the public IP. Only
     standard coverage will have the ability to be customized. Known values are: "Basic" and
     "Standard".
    :vartype protection_coverage: str or
     ~azure.mgmt.network.v2019_08_01.models.DdosSettingsProtectionCoverage
    """

    _attribute_map = {
        "ddos_custom_policy": {"key": "ddosCustomPolicy", "type": "SubResource"},
        "protection_coverage": {"key": "protectionCoverage", "type": "str"},
    }

    def __init__(
        self,
        *,
        ddos_custom_policy: Optional["_models.SubResource"] = None,
        protection_coverage: Optional[Union[str, "_models.DdosSettingsProtectionCoverage"]] = None,
        **kwargs
    ):
        """
        :keyword ddos_custom_policy: The DDoS custom policy associated with the public IP.
        :paramtype ddos_custom_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword protection_coverage: The DDoS protection policy customizability of the public IP. Only
         standard coverage will have the ability to be customized. Known values are: "Basic" and
         "Standard".
        :paramtype protection_coverage: str or
         ~azure.mgmt.network.v2019_08_01.models.DdosSettingsProtectionCoverage
        """
        super().__init__(**kwargs)
        self.ddos_custom_policy = ddos_custom_policy
        self.protection_coverage = protection_coverage


class Delegation(SubResource):
    """Details the service to which the subnet is delegated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a subnet. This name can be used to
     access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar service_name: The name of the service to whom the subnet should be delegated (e.g.
     Microsoft.Sql/servers).
    :vartype service_name: str
    :ivar actions: Describes the actions permitted to the service upon delegation.
    :vartype actions: list[str]
    :ivar provisioning_state: The provisioning state of the service delegation resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        service_name: Optional[str] = None,
        actions: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a subnet. This name can be used
         to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword service_name: The name of the service to whom the subnet should be delegated (e.g.
         Microsoft.Sql/servers).
        :paramtype service_name: str
        :keyword actions: Describes the actions permitted to the service upon delegation.
        :paramtype actions: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.service_name = service_name
        self.actions = actions
        self.provisioning_state = None


class DeviceProperties(_serialization.Model):
    """List of properties of the device.

    :ivar device_vendor: Name of the device Vendor.
    :vartype device_vendor: str
    :ivar device_model: Model of the device.
    :vartype device_model: str
    :ivar link_speed_in_mbps: Link speed.
    :vartype link_speed_in_mbps: int
    """

    _attribute_map = {
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_model": {"key": "deviceModel", "type": "str"},
        "link_speed_in_mbps": {"key": "linkSpeedInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        device_vendor: Optional[str] = None,
        device_model: Optional[str] = None,
        link_speed_in_mbps: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword device_vendor: Name of the device Vendor.
        :paramtype device_vendor: str
        :keyword device_model: Model of the device.
        :paramtype device_model: str
        :keyword link_speed_in_mbps: Link speed.
        :paramtype link_speed_in_mbps: int
        """
        super().__init__(**kwargs)
        self.device_vendor = device_vendor
        self.device_model = device_model
        self.link_speed_in_mbps = link_speed_in_mbps


class DhcpOptions(_serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs):
        """
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class Dimension(_serialization.Model):
    """Dimension of the metric.

    :ivar name: The name of the dimension.
    :vartype name: str
    :ivar display_name: The display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: The internal name of the dimension.
    :vartype internal_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the dimension.
        :paramtype name: str
        :keyword display_name: The display name of the dimension.
        :paramtype display_name: str
        :keyword internal_name: The internal name of the dimension.
        :paramtype internal_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class DnsNameAvailabilityResult(_serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :ivar available: Domain availability (True/False).
    :vartype available: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
    }

    def __init__(self, *, available: Optional[bool] = None, **kwargs):
        """
        :keyword available: Domain availability (True/False).
        :paramtype available: bool
        """
        super().__init__(**kwargs)
        self.available = available


class EffectiveNetworkSecurityGroup(_serialization.Model):
    """Effective network security group.

    :ivar network_security_group: The ID of network security group that is applied.
    :vartype network_security_group: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar association: Associated resources.
    :vartype association:
     ~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityGroupAssociation
    :ivar effective_security_rules: A collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityRule]
    :ivar tag_map: Mapping of tags to list of IP Addresses included within the tag.
    :vartype tag_map: str
    """

    _attribute_map = {
        "network_security_group": {"key": "networkSecurityGroup", "type": "SubResource"},
        "association": {"key": "association", "type": "EffectiveNetworkSecurityGroupAssociation"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
        "tag_map": {"key": "tagMap", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_security_group: Optional["_models.SubResource"] = None,
        association: Optional["_models.EffectiveNetworkSecurityGroupAssociation"] = None,
        effective_security_rules: Optional[List["_models.EffectiveNetworkSecurityRule"]] = None,
        tag_map: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword network_security_group: The ID of network security group that is applied.
        :paramtype network_security_group: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword association: Associated resources.
        :paramtype association:
         ~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityGroupAssociation
        :keyword effective_security_rules: A collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityRule]
        :keyword tag_map: Mapping of tags to list of IP Addresses included within the tag.
        :paramtype tag_map: str
        """
        super().__init__(**kwargs)
        self.network_security_group = network_security_group
        self.association = association
        self.effective_security_rules = effective_security_rules
        self.tag_map = tag_map


class EffectiveNetworkSecurityGroupAssociation(_serialization.Model):
    """The effective network security group association.

    :ivar subnet: The ID of the subnet if assigned.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar network_interface: The ID of the network interface if assigned.
    :vartype network_interface: ~azure.mgmt.network.v2019_08_01.models.SubResource
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "SubResource"},
        "network_interface": {"key": "networkInterface", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        subnet: Optional["_models.SubResource"] = None,
        network_interface: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword subnet: The ID of the subnet if assigned.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword network_interface: The ID of the network interface if assigned.
        :paramtype network_interface: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.network_interface = network_interface


class EffectiveNetworkSecurityGroupListResult(_serialization.Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective network security groups.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveNetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EffectiveNetworkSecurityGroup"]] = None, **kwargs):
        """
        :keyword value: A list of effective network security groups.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EffectiveNetworkSecurityRule(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Effective network security rules.

    :ivar name: The name of the security rule specified by the user (if created by the user).
    :vartype name: str
    :ivar protocol: The network protocol this rule applies to. Known values are: "Tcp", "Udp", and
     "All".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.EffectiveSecurityRuleProtocol
    :ivar source_port_range: The source port or range.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range.
    :vartype destination_port_range: str
    :ivar source_port_ranges: The source port ranges. Expected values include a single integer
     between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges. Expected values include a single
     integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype destination_port_ranges: list[str]
    :ivar source_address_prefix: The source address prefix.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix.
    :vartype destination_address_prefix: str
    :ivar source_address_prefixes: The source address prefixes. Expected values include CIDR IP
     ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
     asterisk (*).
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. Expected values include
     CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and
     the asterisk (*).
    :vartype destination_address_prefixes: list[str]
    :ivar expanded_source_address_prefix: The expanded source address prefix.
    :vartype expanded_source_address_prefix: list[str]
    :ivar expanded_destination_address_prefix: Expanded destination address prefix.
    :vartype expanded_destination_address_prefix: list[str]
    :ivar access: Whether network traffic is allowed or denied. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAccess
    :ivar priority: The priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleDirection
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source_port_range": {"key": "sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "destinationPortRange", "type": "str"},
        "source_port_ranges": {"key": "sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "destinationPortRanges", "type": "[str]"},
        "source_address_prefix": {"key": "sourceAddressPrefix", "type": "str"},
        "destination_address_prefix": {"key": "destinationAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "sourceAddressPrefixes", "type": "[str]"},
        "destination_address_prefixes": {"key": "destinationAddressPrefixes", "type": "[str]"},
        "expanded_source_address_prefix": {"key": "expandedSourceAddressPrefix", "type": "[str]"},
        "expanded_destination_address_prefix": {"key": "expandedDestinationAddressPrefix", "type": "[str]"},
        "access": {"key": "access", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.EffectiveSecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        expanded_source_address_prefix: Optional[List[str]] = None,
        expanded_destination_address_prefix: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the security rule specified by the user (if created by the user).
        :paramtype name: str
        :keyword protocol: The network protocol this rule applies to. Known values are: "Tcp", "Udp",
         and "All".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2019_08_01.models.EffectiveSecurityRuleProtocol
        :keyword source_port_range: The source port or range.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range.
        :paramtype destination_port_range: str
        :keyword source_port_ranges: The source port ranges. Expected values include a single integer
         between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges. Expected values include a single
         integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype destination_port_ranges: list[str]
        :keyword source_address_prefix: The source address prefix.
        :paramtype source_address_prefix: str
        :keyword destination_address_prefix: The destination address prefix.
        :paramtype destination_address_prefix: str
        :keyword source_address_prefixes: The source address prefixes. Expected values include CIDR IP
         ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
         asterisk (*).
        :paramtype source_address_prefixes: list[str]
        :keyword destination_address_prefixes: The destination address prefixes. Expected values
         include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System
         Tags, and the asterisk (*).
        :paramtype destination_address_prefixes: list[str]
        :keyword expanded_source_address_prefix: The expanded source address prefix.
        :paramtype expanded_source_address_prefix: list[str]
        :keyword expanded_destination_address_prefix: Expanded destination address prefix.
        :paramtype expanded_destination_address_prefix: list[str]
        :keyword access: Whether network traffic is allowed or denied. Known values are: "Allow" and
         "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAccess
        :keyword priority: The priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleDirection
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.expanded_source_address_prefix = expanded_source_address_prefix
        self.expanded_destination_address_prefix = expanded_destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction


class EffectiveRoute(_serialization.Model):
    """Effective Route.

    :ivar name: The name of the user defined route. This is optional.
    :vartype name: str
    :ivar disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
     network interfaces in the subnet.
    :vartype disable_bgp_route_propagation: bool
    :ivar source: Who created the route. Known values are: "Unknown", "User",
     "VirtualNetworkGateway", and "Default".
    :vartype source: str or ~azure.mgmt.network.v2019_08_01.models.EffectiveRouteSource
    :ivar state: The value of effective route. Known values are: "Active" and "Invalid".
    :vartype state: str or ~azure.mgmt.network.v2019_08_01.models.EffectiveRouteState
    :ivar address_prefix: The address prefixes of the effective routes in CIDR notation.
    :vartype address_prefix: list[str]
    :ivar next_hop_ip_address: The IP address of the next hop of the effective route.
    :vartype next_hop_ip_address: list[str]
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2019_08_01.models.RouteNextHopType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disable_bgp_route_propagation": {"key": "disableBgpRoutePropagation", "type": "bool"},
        "source": {"key": "source", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "address_prefix": {"key": "addressPrefix", "type": "[str]"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "[str]"},
        "next_hop_type": {"key": "nextHopType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disable_bgp_route_propagation: Optional[bool] = None,
        source: Optional[Union[str, "_models.EffectiveRouteSource"]] = None,
        state: Optional[Union[str, "_models.EffectiveRouteState"]] = None,
        address_prefix: Optional[List[str]] = None,
        next_hop_ip_address: Optional[List[str]] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the user defined route. This is optional.
        :paramtype name: str
        :keyword disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
         network interfaces in the subnet.
        :paramtype disable_bgp_route_propagation: bool
        :keyword source: Who created the route. Known values are: "Unknown", "User",
         "VirtualNetworkGateway", and "Default".
        :paramtype source: str or ~azure.mgmt.network.v2019_08_01.models.EffectiveRouteSource
        :keyword state: The value of effective route. Known values are: "Active" and "Invalid".
        :paramtype state: str or ~azure.mgmt.network.v2019_08_01.models.EffectiveRouteState
        :keyword address_prefix: The address prefixes of the effective routes in CIDR notation.
        :paramtype address_prefix: list[str]
        :keyword next_hop_ip_address: The IP address of the next hop of the effective route.
        :paramtype next_hop_ip_address: list[str]
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
         "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2019_08_01.models.RouteNextHopType
        """
        super().__init__(**kwargs)
        self.name = name
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.source = source
        self.state = state
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address
        self.next_hop_type = next_hop_type


class EffectiveRouteListResult(_serialization.Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective routes.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveRoute]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EffectiveRoute"]] = None, **kwargs):
        """
        :keyword value: A list of effective routes.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.EffectiveRoute]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.type = None


class EndpointServicesListResult(_serialization.Model):
    """Response for the ListAvailableEndpointServices API service call.

    :ivar value: List of available endpoint services in a region.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.EndpointServiceResult]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EndpointServiceResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EndpointServiceResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of available endpoint services in a region.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.EndpointServiceResult]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Error(_serialization.Model):
    """Common error representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.network.v2019_08_01.models.ErrorDetails]
    :ivar inner_error: Inner error message.
    :vartype inner_error: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
        "inner_error": {"key": "innerError", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.network.v2019_08_01.models.ErrorDetails]
        :keyword inner_error: Inner error message.
        :paramtype inner_error: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorDetails(_serialization.Model):
    """Common error details representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar target: Error target.
    :vartype target: str
    :ivar message: Error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword message: Error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ErrorResponse(_serialization.Model):
    """The error object.

    :ivar error: The error details object.
    :vartype error: ~azure.mgmt.network.v2019_08_01.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs):
        """
        :keyword error: The error details object.
        :paramtype error: ~azure.mgmt.network.v2019_08_01.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class EvaluatedNetworkSecurityGroup(_serialization.Model):
    """Results of network security group evaluation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_security_group_id: Network security group ID.
    :vartype network_security_group_id: str
    :ivar applied_to: Resource ID of nic or subnet to which network security group is applied.
    :vartype applied_to: str
    :ivar matched_rule: Matched network security rule.
    :vartype matched_rule: ~azure.mgmt.network.v2019_08_01.models.MatchedRule
    :ivar rules_evaluation_result: List of network security rules evaluation results.
    :vartype rules_evaluation_result:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkSecurityRulesEvaluationResult]
    """

    _validation = {
        "rules_evaluation_result": {"readonly": True},
    }

    _attribute_map = {
        "network_security_group_id": {"key": "networkSecurityGroupId", "type": "str"},
        "applied_to": {"key": "appliedTo", "type": "str"},
        "matched_rule": {"key": "matchedRule", "type": "MatchedRule"},
        "rules_evaluation_result": {"key": "rulesEvaluationResult", "type": "[NetworkSecurityRulesEvaluationResult]"},
    }

    def __init__(
        self,
        *,
        network_security_group_id: Optional[str] = None,
        applied_to: Optional[str] = None,
        matched_rule: Optional["_models.MatchedRule"] = None,
        **kwargs
    ):
        """
        :keyword network_security_group_id: Network security group ID.
        :paramtype network_security_group_id: str
        :keyword applied_to: Resource ID of nic or subnet to which network security group is applied.
        :paramtype applied_to: str
        :keyword matched_rule: Matched network security rule.
        :paramtype matched_rule: ~azure.mgmt.network.v2019_08_01.models.MatchedRule
        """
        super().__init__(**kwargs)
        self.network_security_group_id = network_security_group_id
        self.applied_to = applied_to
        self.matched_rule = matched_rule
        self.rules_evaluation_result = None


class ExpressRouteCircuit(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allow_classic_operations: Allow classic operations.
    :vartype allow_classic_operations: bool
    :ivar circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :vartype circuit_provisioning_state: str
    :ivar service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
     "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2019_08_01.models.ServiceProviderProvisioningState
    :ivar authorizations: The list of authorizations.
    :vartype authorizations:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitAuthorization]
    :ivar peerings: The list of peerings.
    :vartype peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
    :ivar service_key: The ServiceKey.
    :vartype service_key: str
    :ivar service_provider_notes: The ServiceProviderNotes.
    :vartype service_provider_notes: str
    :ivar service_provider_properties: The ServiceProviderProperties.
    :vartype service_provider_properties:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitServiceProviderProperties
    :ivar express_route_port: The reference to the ExpressRoutePort resource when the circuit is
     provisioned on an ExpressRoutePort resource.
    :vartype express_route_port: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
     ExpressRoutePort resource.
    :vartype bandwidth_in_gbps: float
    :ivar stag: The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
    :vartype stag: int
    :ivar provisioning_state: The provisioning state of the express route circuit resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar global_reach_enabled: Flag denoting Global reach status.
    :vartype global_reach_enabled: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "stag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ExpressRouteCircuitSku"},
        "etag": {"key": "etag", "type": "str"},
        "allow_classic_operations": {"key": "properties.allowClassicOperations", "type": "bool"},
        "circuit_provisioning_state": {"key": "properties.circuitProvisioningState", "type": "str"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ExpressRouteCircuitAuthorization]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "service_key": {"key": "properties.serviceKey", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "service_provider_properties": {
            "key": "properties.serviceProviderProperties",
            "type": "ExpressRouteCircuitServiceProviderProperties",
        },
        "express_route_port": {"key": "properties.expressRoutePort", "type": "SubResource"},
        "bandwidth_in_gbps": {"key": "properties.bandwidthInGbps", "type": "float"},
        "stag": {"key": "properties.stag", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "global_reach_enabled": {"key": "properties.globalReachEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ExpressRouteCircuitSku"] = None,
        allow_classic_operations: Optional[bool] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["_models.ExpressRouteCircuitServiceProviderProperties"] = None,
        express_route_port: Optional["_models.SubResource"] = None,
        bandwidth_in_gbps: Optional[float] = None,
        gateway_manager_etag: Optional[str] = None,
        global_reach_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitSku
        :keyword allow_classic_operations: Allow classic operations.
        :paramtype allow_classic_operations: bool
        :keyword circuit_provisioning_state: The CircuitProvisioningState state of the resource.
        :paramtype circuit_provisioning_state: str
        :keyword service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
         resource. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
         "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.v2019_08_01.models.ServiceProviderProvisioningState
        :keyword authorizations: The list of authorizations.
        :paramtype authorizations:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitAuthorization]
        :keyword peerings: The list of peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
        :keyword service_key: The ServiceKey.
        :paramtype service_key: str
        :keyword service_provider_notes: The ServiceProviderNotes.
        :paramtype service_provider_notes: str
        :keyword service_provider_properties: The ServiceProviderProperties.
        :paramtype service_provider_properties:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitServiceProviderProperties
        :keyword express_route_port: The reference to the ExpressRoutePort resource when the circuit is
         provisioned on an ExpressRoutePort resource.
        :paramtype express_route_port: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
         ExpressRoutePort resource.
        :paramtype bandwidth_in_gbps: float
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword global_reach_enabled: Flag denoting Global reach status.
        :paramtype global_reach_enabled: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = None
        self.allow_classic_operations = allow_classic_operations
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.express_route_port = express_route_port
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.stag = None
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.global_reach_enabled = global_reach_enabled


class ExpressRouteCircuitArpTable(_serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :ivar age: Entry age in minutes.
    :vartype age: int
    :ivar interface: Interface address.
    :vartype interface: str
    :ivar ip_address: The IP address.
    :vartype ip_address: str
    :ivar mac_address: The MAC address.
    :vartype mac_address: str
    """

    _attribute_map = {
        "age": {"key": "age", "type": "int"},
        "interface": {"key": "interface", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        age: Optional[int] = None,
        interface: Optional[str] = None,
        ip_address: Optional[str] = None,
        mac_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword age: Entry age in minutes.
        :paramtype age: int
        :keyword interface: Interface address.
        :paramtype interface: str
        :keyword ip_address: The IP address.
        :paramtype ip_address: str
        :keyword mac_address: The MAC address.
        :paramtype mac_address: str
        """
        super().__init__(**kwargs)
        self.age = age
        self.interface = interface
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: The authorization use status. Known values are: "Available" and
     "InUse".
    :vartype authorization_use_status: str or
     ~azure.mgmt.network.v2019_08_01.models.AuthorizationUseStatus
    :ivar provisioning_state: The provisioning state of the authorization resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_use_status": {"key": "properties.authorizationUseStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "_models.AuthorizationUseStatus"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword authorization_use_status: The authorization use status. Known values are: "Available"
         and "InUse".
        :paramtype authorization_use_status: str or
         ~azure.mgmt.network.v2019_08_01.models.AuthorizationUseStatus
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.provisioning_state = None


class ExpressRouteCircuitConnection(SubResource):
    """Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the circuit initiating connection.
    :vartype express_route_circuit_peering: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the peered circuit.
    :vartype peer_express_route_circuit_peering: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
    :vartype address_prefix: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar circuit_connection_status: Express Route Circuit connection state. Known values are:
     "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.v2019_08_01.models.CircuitConnectionStatus
    :ivar provisioning_state: The provisioning state of the express route circuit connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "circuit_connection_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "express_route_circuit_peering": {"key": "properties.expressRouteCircuitPeering", "type": "SubResource"},
        "peer_express_route_circuit_peering": {
            "key": "properties.peerExpressRouteCircuitPeering",
            "type": "SubResource",
        },
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "circuit_connection_status": {"key": "properties.circuitConnectionStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        express_route_circuit_peering: Optional["_models.SubResource"] = None,
        peer_express_route_circuit_peering: Optional["_models.SubResource"] = None,
        address_prefix: Optional[str] = None,
        authorization_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the circuit initiating connection.
        :paramtype express_route_circuit_peering: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the peered circuit.
        :paramtype peer_express_route_circuit_peering:
         ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :paramtype address_prefix: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.peer_express_route_circuit_peering = peer_express_route_circuit_peering
        self.address_prefix = address_prefix
        self.authorization_key = authorization_key
        self.circuit_connection_status = None
        self.provisioning_state = None


class ExpressRouteCircuitConnectionListResult(_serialization.Model):
    """Response for ListConnections API service call retrieves all global reach connections that belongs to a Private Peering for an ExpressRouteCircuit.

    :ivar value: The global reach connection associated with Private Peering in an ExpressRoute
     Circuit.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The global reach connection associated with Private Peering in an ExpressRoute
         Circuit.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitConnection]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitListResult(_serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :ivar value: A list of ExpressRouteCircuits in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuit]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuit]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRouteCircuit"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of ExpressRouteCircuits in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuit]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar peering_type: The peering type. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringType
    :ivar state: The peering state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringConfig
    :ivar stats: The peering stats of express route circuit.
    :vartype stats: ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitStats
    :ivar provisioning_state: The provisioning state of the express route circuit peering resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :ivar route_filter: The reference of the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config:
     ~azure.mgmt.network.v2019_08_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    :ivar express_route_connection: The ExpressRoute connection.
    :vartype express_route_connection:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteConnectionId
    :ivar connections: The list of circuit connections associated with Azure Private Peering for
     this circuit.
    :vartype connections:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitConnection]
    :ivar peered_connections: The list of peered circuit connections associated with Azure Private
     Peering for this circuit.
    :vartype peered_connections:
     list[~azure.mgmt.network.v2019_08_01.models.PeerExpressRouteCircuitConnection]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "peered_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "stats": {"key": "properties.stats", "type": "ExpressRouteCircuitStats"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "route_filter": {"key": "properties.routeFilter", "type": "SubResource"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
        "express_route_connection": {"key": "properties.expressRouteConnection", "type": "ExpressRouteConnectionId"},
        "connections": {"key": "properties.connections", "type": "[ExpressRouteCircuitConnection]"},
        "peered_connections": {"key": "properties.peeredConnections", "type": "[PeerExpressRouteCircuitConnection]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRoutePeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRoutePeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["_models.ExpressRouteCircuitStats"] = None,
        gateway_manager_etag: Optional[str] = None,
        last_modified_by: Optional[str] = None,
        route_filter: Optional["_models.SubResource"] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        express_route_connection: Optional["_models.ExpressRouteConnectionId"] = None,
        connections: Optional[List["_models.ExpressRouteCircuitConnection"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The peering type. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringType
        :keyword state: The peering state. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringState
        :keyword azure_asn: The Azure ASN.
        :paramtype azure_asn: int
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword primary_azure_port: The primary port.
        :paramtype primary_azure_port: str
        :keyword secondary_azure_port: The secondary port.
        :paramtype secondary_azure_port: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringConfig
        :keyword stats: The peering stats of express route circuit.
        :paramtype stats: ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitStats
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword last_modified_by: Who was the last to modify the peering.
        :paramtype last_modified_by: str
        :keyword route_filter: The reference of the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config:
         ~azure.mgmt.network.v2019_08_01.models.Ipv6ExpressRouteCircuitPeeringConfig
        :keyword express_route_connection: The ExpressRoute connection.
        :paramtype express_route_connection:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteConnectionId
        :keyword connections: The list of circuit connections associated with Azure Private Peering for
         this circuit.
        :paramtype connections:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitConnection]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = last_modified_by
        self.route_filter = route_filter
        self.ipv6_peering_config = ipv6_peering_config
        self.express_route_connection = express_route_connection
        self.connections = connections
        self.peered_connections = None


class ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Specifies the peering configuration.

    :ivar advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
    :vartype advertised_public_prefixes: list[str]
    :ivar advertised_communities: The communities of bgp peering. Specified for microsoft peering.
    :vartype advertised_communities: list[str]
    :ivar advertised_public_prefixes_state: The advertised public prefix state of the Peering
     resource. Known values are: "NotConfigured", "Configuring", "Configured", and
     "ValidationNeeded".
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :ivar legacy_mode: The legacy mode of the peering.
    :vartype legacy_mode: int
    :ivar customer_asn: The CustomerASN of the peering.
    :vartype customer_asn: int
    :ivar routing_registry_name: The RoutingRegistryName of the configuration.
    :vartype routing_registry_name: str
    """

    _attribute_map = {
        "advertised_public_prefixes": {"key": "advertisedPublicPrefixes", "type": "[str]"},
        "advertised_communities": {"key": "advertisedCommunities", "type": "[str]"},
        "advertised_public_prefixes_state": {"key": "advertisedPublicPrefixesState", "type": "str"},
        "legacy_mode": {"key": "legacyMode", "type": "int"},
        "customer_asn": {"key": "customerASN", "type": "int"},
        "routing_registry_name": {"key": "routingRegistryName", "type": "str"},
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[List[str]] = None,
        advertised_communities: Optional[List[str]] = None,
        advertised_public_prefixes_state: Optional[
            Union[str, "_models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"]
        ] = None,
        legacy_mode: Optional[int] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
        :paramtype advertised_public_prefixes: list[str]
        :keyword advertised_communities: The communities of bgp peering. Specified for microsoft
         peering.
        :paramtype advertised_communities: list[str]
        :keyword advertised_public_prefixes_state: The advertised public prefix state of the Peering
         resource. Known values are: "NotConfigured", "Configuring", "Configured", and
         "ValidationNeeded".
        :paramtype advertised_public_prefixes_state: str or
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
        :keyword legacy_mode: The legacy mode of the peering.
        :paramtype legacy_mode: int
        :keyword customer_asn: The CustomerASN of the peering.
        :paramtype customer_asn: int
        :keyword routing_registry_name: The RoutingRegistryName of the configuration.
        :paramtype routing_registry_name: str
        """
        super().__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_communities = advertised_communities
        self.advertised_public_prefixes_state = advertised_public_prefixes_state
        self.legacy_mode = legacy_mode
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name


class ExpressRouteCircuitPeeringId(_serialization.Model):
    """ExpressRoute circuit peering identifier.

    :ivar id: The ID of the ExpressRoute circuit peering.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of the ExpressRoute circuit peering.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ExpressRouteCircuitPeeringListResult(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.

    :ivar value: The peerings in an express route circuit.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The peerings in an express route circuit.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitReference(_serialization.Model):
    """Reference to an express route circuit.

    :ivar id: Corresponding Express Route Circuit Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Corresponding Express Route Circuit Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ExpressRouteCircuitRoutesTable(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar network: IP address of a network entity.
    :vartype network: str
    :ivar next_hop: NextHop address.
    :vartype next_hop: str
    :ivar loc_prf: Local preference value as set with the set local-preference route-map
     configuration command.
    :vartype loc_prf: str
    :ivar weight: Route Weight.
    :vartype weight: int
    :ivar path: Autonomous system paths to the destination network.
    :vartype path: str
    """

    _attribute_map = {
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "loc_prf": {"key": "locPrf", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        network: Optional[str] = None,
        next_hop: Optional[str] = None,
        loc_prf: Optional[str] = None,
        weight: Optional[int] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword network: IP address of a network entity.
        :paramtype network: str
        :keyword next_hop: NextHop address.
        :paramtype next_hop: str
        :keyword loc_prf: Local preference value as set with the set local-preference route-map
         configuration command.
        :paramtype loc_prf: str
        :keyword weight: Route Weight.
        :paramtype weight: int
        :keyword path: Autonomous system paths to the destination network.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.network = network
        self.next_hop = next_hop
        self.loc_prf = loc_prf
        self.weight = weight
        self.path = path


class ExpressRouteCircuitRoutesTableSummary(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: IP address of the neighbor.
    :vartype neighbor: str
    :ivar v: BGP version number spoken to the neighbor.
    :vartype v: int
    :ivar as_property: Autonomous system number.
    :vartype as_property: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
     been received from a neighbor or peer group.
    :vartype state_pfx_rcd: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "v": {"key": "v", "type": "int"},
        "as_property": {"key": "as", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_pfx_rcd": {"key": "statePfxRcd", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        v: Optional[int] = None,
        as_property: Optional[int] = None,
        up_down: Optional[str] = None,
        state_pfx_rcd: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword neighbor: IP address of the neighbor.
        :paramtype neighbor: str
        :keyword v: BGP version number spoken to the neighbor.
        :paramtype v: int
        :keyword as_property: Autonomous system number.
        :paramtype as_property: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
         been received from a neighbor or peer group.
        :paramtype state_pfx_rcd: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.v = v
        self.as_property = as_property
        self.up_down = up_down
        self.state_pfx_rcd = state_pfx_rcd


class ExpressRouteCircuitsArpTableListResult(_serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :ivar value: A list of the ARP tables.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitArpTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitArpTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of the ARP tables.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitArpTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(_serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :ivar service_provider_name: The serviceProviderName.
    :vartype service_provider_name: str
    :ivar peering_location: The peering location.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The BandwidthInMbps.
    :vartype bandwidth_in_mbps: int
    """

    _attribute_map = {
        "service_provider_name": {"key": "serviceProviderName", "type": "str"},
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword service_provider_name: The serviceProviderName.
        :paramtype service_provider_name: str
        :keyword peering_location: The peering location.
        :paramtype peering_location: str
        :keyword bandwidth_in_mbps: The BandwidthInMbps.
        :paramtype bandwidth_in_mbps: int
        """
        super().__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(_serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU. Known values are: "Standard", "Premium", "Basic", and "Local".
    :vartype tier: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitSkuTier
    :ivar family: The family of the SKU. Known values are: "UnlimitedData" and "MeteredData".
    :vartype family: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "_models.ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the SKU.
        :paramtype name: str
        :keyword tier: The tier of the SKU. Known values are: "Standard", "Premium", "Basic", and
         "Local".
        :paramtype tier: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitSkuTier
        :keyword family: The family of the SKU. Known values are: "UnlimitedData" and "MeteredData".
        :paramtype family: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitSkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(_serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: The list of routes table.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitRoutesTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of routes table.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitRoutesTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsRoutesTableSummaryListResult(_serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: A list of the routes table.
    :vartype value:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTableSummary"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of the routes table.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitRoutesTableSummary]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(_serialization.Model):
    """Contains stats associated with the peering.

    :ivar primarybytes_in: The Primary BytesIn of the peering.
    :vartype primarybytes_in: int
    :ivar primarybytes_out: The primary BytesOut of the peering.
    :vartype primarybytes_out: int
    :ivar secondarybytes_in: The secondary BytesIn of the peering.
    :vartype secondarybytes_in: int
    :ivar secondarybytes_out: The secondary BytesOut of the peering.
    :vartype secondarybytes_out: int
    """

    _attribute_map = {
        "primarybytes_in": {"key": "primarybytesIn", "type": "int"},
        "primarybytes_out": {"key": "primarybytesOut", "type": "int"},
        "secondarybytes_in": {"key": "secondarybytesIn", "type": "int"},
        "secondarybytes_out": {"key": "secondarybytesOut", "type": "int"},
    }

    def __init__(
        self,
        *,
        primarybytes_in: Optional[int] = None,
        primarybytes_out: Optional[int] = None,
        secondarybytes_in: Optional[int] = None,
        secondarybytes_out: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword primarybytes_in: The Primary BytesIn of the peering.
        :paramtype primarybytes_in: int
        :keyword primarybytes_out: The primary BytesOut of the peering.
        :paramtype primarybytes_out: int
        :keyword secondarybytes_in: The secondary BytesIn of the peering.
        :paramtype secondarybytes_in: int
        :keyword secondarybytes_out: The secondary BytesOut of the peering.
        :paramtype secondarybytes_out: int
        """
        super().__init__(**kwargs)
        self.primarybytes_in = primarybytes_in
        self.primarybytes_out = primarybytes_out
        self.secondarybytes_in = secondarybytes_in
        self.secondarybytes_out = secondarybytes_out


class ExpressRouteConnection(SubResource):
    """ExpressRouteConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar provisioning_state: The provisioning state of the express route connection resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar express_route_circuit_peering: The ExpressRoute circuit peering.
    :vartype express_route_circuit_peering:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringId
    :ivar authorization_key: Authorization key to establish the connection.
    :vartype authorization_key: str
    :ivar routing_weight: The routing weight associated to the connection.
    :vartype routing_weight: int
    """

    _validation = {
        "name": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_circuit_peering": {
            "key": "properties.expressRouteCircuitPeering",
            "type": "ExpressRouteCircuitPeeringId",
        },
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        express_route_circuit_peering: Optional["_models.ExpressRouteCircuitPeeringId"] = None,
        authorization_key: Optional[str] = None,
        routing_weight: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword express_route_circuit_peering: The ExpressRoute circuit peering.
        :paramtype express_route_circuit_peering:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringId
        :keyword authorization_key: Authorization key to establish the connection.
        :paramtype authorization_key: str
        :keyword routing_weight: The routing weight associated to the connection.
        :paramtype routing_weight: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.provisioning_state = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.authorization_key = authorization_key
        self.routing_weight = routing_weight


class ExpressRouteConnectionId(_serialization.Model):
    """The ID of the ExpressRouteConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the ExpressRouteConnection.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class ExpressRouteConnectionList(_serialization.Model):
    """ExpressRouteConnection list.

    :ivar value: The list of ExpressRoute connections.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteConnection"]] = None, **kwargs):
        """
        :keyword value: The list of ExpressRoute connections.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class ExpressRouteCrossConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteCrossConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar primary_azure_port: The name of the primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The name of the secondary port.
    :vartype secondary_azure_port: str
    :ivar s_tag: The identifier of the circuit traffic.
    :vartype s_tag: int
    :ivar peering_location: The peering location of the ExpressRoute circuit.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The circuit bandwidth In Mbps.
    :vartype bandwidth_in_mbps: int
    :ivar express_route_circuit: The ExpressRouteCircuit.
    :vartype express_route_circuit:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitReference
    :ivar service_provider_provisioning_state: The provisioning state of the circuit in the
     connectivity provider system. Known values are: "NotProvisioned", "Provisioning",
     "Provisioned", and "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2019_08_01.models.ServiceProviderProvisioningState
    :ivar service_provider_notes: Additional read only notes set by the connectivity provider.
    :vartype service_provider_notes: str
    :ivar provisioning_state: The provisioning state of the express route cross connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar peerings: The list of peerings.
    :vartype peerings:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnectionPeering]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
        "s_tag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "s_tag": {"key": "properties.sTag", "type": "int"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "properties.bandwidthInMbps", "type": "int"},
        "express_route_circuit": {"key": "properties.expressRouteCircuit", "type": "ExpressRouteCircuitReference"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCrossConnectionPeering]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        express_route_circuit: Optional["_models.ExpressRouteCircuitReference"] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        service_provider_notes: Optional[str] = None,
        peerings: Optional[List["_models.ExpressRouteCrossConnectionPeering"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_location: The peering location of the ExpressRoute circuit.
        :paramtype peering_location: str
        :keyword bandwidth_in_mbps: The circuit bandwidth In Mbps.
        :paramtype bandwidth_in_mbps: int
        :keyword express_route_circuit: The ExpressRouteCircuit.
        :paramtype express_route_circuit:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitReference
        :keyword service_provider_provisioning_state: The provisioning state of the circuit in the
         connectivity provider system. Known values are: "NotProvisioned", "Provisioning",
         "Provisioned", and "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.v2019_08_01.models.ServiceProviderProvisioningState
        :keyword service_provider_notes: Additional read only notes set by the connectivity provider.
        :paramtype service_provider_notes: str
        :keyword peerings: The list of peerings.
        :paramtype peerings:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnectionPeering]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.s_tag = None
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps
        self.express_route_circuit = express_route_circuit
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.service_provider_notes = service_provider_notes
        self.provisioning_state = None
        self.peerings = peerings


class ExpressRouteCrossConnectionListResult(_serialization.Model):
    """Response for ListExpressRouteCrossConnection API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ExpressRouteCrossConnection resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteCrossConnection"]] = None, **kwargs):
        """
        :keyword value: A list of ExpressRouteCrossConnection resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ExpressRouteCrossConnectionPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peering in an ExpressRoute Cross Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar peering_type: The peering type. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringType
    :ivar state: The peering state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringConfig
    :ivar provisioning_state: The provisioning state of the express route cross connection peering
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config:
     ~azure.mgmt.network.v2019_08_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    """

    _validation = {
        "etag": {"readonly": True},
        "azure_asn": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRoutePeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRoutePeeringState"]] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        gateway_manager_etag: Optional[str] = None,
        last_modified_by: Optional[str] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The peering type. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringType
        :keyword state: The peering state. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePeeringState
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringConfig
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword last_modified_by: Who was the last to modify the peering.
        :paramtype last_modified_by: str
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config:
         ~azure.mgmt.network.v2019_08_01.models.Ipv6ExpressRouteCircuitPeeringConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = None
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = last_modified_by
        self.ipv6_peering_config = ipv6_peering_config


class ExpressRouteCrossConnectionPeeringList(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCrossConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The peerings in an express route cross connection.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnectionPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnectionPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteCrossConnectionPeering"]] = None, **kwargs):
        """
        :keyword value: The peerings in an express route cross connection.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnectionPeering]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ExpressRouteCrossConnectionRoutesTableSummary(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: IP address of Neighbor router.
    :vartype neighbor: str
    :ivar asn: Autonomous system number.
    :vartype asn: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_or_prefixes_received: Current state of the BGP session, and the number of prefixes
     that have been received from a neighbor or peer group.
    :vartype state_or_prefixes_received: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_or_prefixes_received": {"key": "stateOrPrefixesReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        asn: Optional[int] = None,
        up_down: Optional[str] = None,
        state_or_prefixes_received: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword neighbor: IP address of Neighbor router.
        :paramtype neighbor: str
        :keyword asn: Autonomous system number.
        :paramtype asn: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_or_prefixes_received: Current state of the BGP session, and the number of
         prefixes that have been received from a neighbor or peer group.
        :paramtype state_or_prefixes_received: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.asn = asn
        self.up_down = up_down
        self.state_or_prefixes_received = state_or_prefixes_received


class ExpressRouteCrossConnectionsRoutesTableSummaryListResult(_serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Cross Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of the routes table.
    :vartype value:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnectionRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnectionRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRouteCrossConnectionRoutesTableSummary"]] = None, **kwargs
    ):
        """
        :keyword value: A list of the routes table.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCrossConnectionRoutesTableSummary]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ExpressRouteGateway(Resource):
    """ExpressRoute gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar auto_scale_configuration: Configuration for auto scaling.
    :vartype auto_scale_configuration:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
    :ivar express_route_connections: List of ExpressRoute connections to the ExpressRoute gateway.
    :vartype express_route_connections:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteConnection]
    :ivar provisioning_state: The provisioning state of the express route gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
    :vartype virtual_hub: ~azure.mgmt.network.v2019_08_01.models.VirtualHubId
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "express_route_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "auto_scale_configuration": {
            "key": "properties.autoScaleConfiguration",
            "type": "ExpressRouteGatewayPropertiesAutoScaleConfiguration",
        },
        "express_route_connections": {"key": "properties.expressRouteConnections", "type": "[ExpressRouteConnection]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "VirtualHubId"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_scale_configuration: Optional["_models.ExpressRouteGatewayPropertiesAutoScaleConfiguration"] = None,
        virtual_hub: Optional["_models.VirtualHubId"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword auto_scale_configuration: Configuration for auto scaling.
        :paramtype auto_scale_configuration:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
        :keyword virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
        :paramtype virtual_hub: ~azure.mgmt.network.v2019_08_01.models.VirtualHubId
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.auto_scale_configuration = auto_scale_configuration
        self.express_route_connections = None
        self.provisioning_state = None
        self.virtual_hub = virtual_hub


class ExpressRouteGatewayList(_serialization.Model):
    """List of ExpressRoute gateways.

    :ivar value: List of ExpressRoute gateways.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteGateway]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteGateway]"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteGateway"]] = None, **kwargs):
        """
        :keyword value: List of ExpressRoute gateways.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteGateway]
        """
        super().__init__(**kwargs)
        self.value = value


class ExpressRouteGatewayPropertiesAutoScaleConfiguration(_serialization.Model):
    """Configuration for auto scaling.

    :ivar bounds: Minimum and maximum number of scale units to deploy.
    :vartype bounds:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    """

    _attribute_map = {
        "bounds": {"key": "bounds", "type": "ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds"},
    }

    def __init__(
        self, *, bounds: Optional["_models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds"] = None, **kwargs
    ):
        """
        :keyword bounds: Minimum and maximum number of scale units to deploy.
        :paramtype bounds:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
        """
        super().__init__(**kwargs)
        self.bounds = bounds


class ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds(_serialization.Model):
    """Minimum and maximum number of scale units to deploy.

    :ivar min: Minimum number of scale units deployed for ExpressRoute gateway.
    :vartype min: int
    :ivar max: Maximum number of scale units deployed for ExpressRoute gateway.
    :vartype max: int
    """

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
        **kwargs
    ):
        """
        :keyword min: Minimum number of scale units deployed for ExpressRoute gateway.
        :paramtype min: int
        :keyword max: Maximum number of scale units deployed for ExpressRoute gateway.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class ExpressRouteLink(SubResource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteLink child resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of child port resource that is unique among child port resources of the
     parent.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar router_name: Name of Azure router associated with physical port.
    :vartype router_name: str
    :ivar interface_name: Name of Azure router interface.
    :vartype interface_name: str
    :ivar patch_panel_id: Mapping between physical port to patch panel port.
    :vartype patch_panel_id: str
    :ivar rack_id: Mapping of physical patch panel to rack.
    :vartype rack_id: str
    :ivar connector_type: Physical fiber port type. Known values are: "LC" and "SC".
    :vartype connector_type: str or
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkConnectorType
    :ivar admin_state: Administrative state of the physical port. Known values are: "Enabled" and
     "Disabled".
    :vartype admin_state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkAdminState
    :ivar provisioning_state: The provisioning state of the express route link resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar mac_sec_config: MacSec configuration.
    :vartype mac_sec_config: ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkMacSecConfig
    """

    _validation = {
        "etag": {"readonly": True},
        "router_name": {"readonly": True},
        "interface_name": {"readonly": True},
        "patch_panel_id": {"readonly": True},
        "rack_id": {"readonly": True},
        "connector_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "router_name": {"key": "properties.routerName", "type": "str"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "patch_panel_id": {"key": "properties.patchPanelId", "type": "str"},
        "rack_id": {"key": "properties.rackId", "type": "str"},
        "connector_type": {"key": "properties.connectorType", "type": "str"},
        "admin_state": {"key": "properties.adminState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "mac_sec_config": {"key": "properties.macSecConfig", "type": "ExpressRouteLinkMacSecConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        admin_state: Optional[Union[str, "_models.ExpressRouteLinkAdminState"]] = None,
        mac_sec_config: Optional["_models.ExpressRouteLinkMacSecConfig"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of child port resource that is unique among child port resources of the
         parent.
        :paramtype name: str
        :keyword admin_state: Administrative state of the physical port. Known values are: "Enabled"
         and "Disabled".
        :paramtype admin_state: str or
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkAdminState
        :keyword mac_sec_config: MacSec configuration.
        :paramtype mac_sec_config: ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkMacSecConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.router_name = None
        self.interface_name = None
        self.patch_panel_id = None
        self.rack_id = None
        self.connector_type = None
        self.admin_state = admin_state
        self.provisioning_state = None
        self.mac_sec_config = mac_sec_config


class ExpressRouteLinkListResult(_serialization.Model):
    """Response for ListExpressRouteLinks API service call.

    :ivar value: The list of ExpressRouteLink sub-resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRouteLink"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of ExpressRouteLink sub-resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteLink]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteLinkMacSecConfig(_serialization.Model):
    """ExpressRouteLink Mac Security Configuration.

    :ivar ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
    :vartype ckn_secret_identifier: str
    :ivar cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
    :vartype cak_secret_identifier: str
    :ivar cipher: Mac security cipher. Known values are: "gcm-aes-128" and "gcm-aes-256".
    :vartype cipher: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkMacSecCipher
    """

    _attribute_map = {
        "ckn_secret_identifier": {"key": "cknSecretIdentifier", "type": "str"},
        "cak_secret_identifier": {"key": "cakSecretIdentifier", "type": "str"},
        "cipher": {"key": "cipher", "type": "str"},
    }

    def __init__(
        self,
        *,
        ckn_secret_identifier: Optional[str] = None,
        cak_secret_identifier: Optional[str] = None,
        cipher: Optional[Union[str, "_models.ExpressRouteLinkMacSecCipher"]] = None,
        **kwargs
    ):
        """
        :keyword ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
        :paramtype ckn_secret_identifier: str
        :keyword cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
        :paramtype cak_secret_identifier: str
        :keyword cipher: Mac security cipher. Known values are: "gcm-aes-128" and "gcm-aes-256".
        :paramtype cipher: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteLinkMacSecCipher
        """
        super().__init__(**kwargs)
        self.ckn_secret_identifier = ckn_secret_identifier
        self.cak_secret_identifier = cak_secret_identifier
        self.cipher = cipher


class ExpressRoutePort(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRoutePort resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar identity: The identity of ExpressRoutePort, if configured.
    :vartype identity: ~azure.mgmt.network.v2019_08_01.models.ManagedServiceIdentity
    :ivar peering_location: The name of the peering location that the ExpressRoutePort is mapped to
     physically.
    :vartype peering_location: str
    :ivar bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
    :vartype bandwidth_in_gbps: int
    :ivar provisioned_bandwidth_in_gbps: Aggregate Gbps of associated circuit bandwidths.
    :vartype provisioned_bandwidth_in_gbps: float
    :ivar mtu: Maximum transmission unit of the physical port pair(s).
    :vartype mtu: str
    :ivar encapsulation: Encapsulation method on physical ports. Known values are: "Dot1Q" and
     "QinQ".
    :vartype encapsulation: str or
     ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePortsEncapsulation
    :ivar ether_type: Ether type of the physical port.
    :vartype ether_type: str
    :ivar allocation_date: Date of the physical port allocation to be used in Letter of
     Authorization.
    :vartype allocation_date: str
    :ivar links: The set of physical links of the ExpressRoutePort resource.
    :vartype links: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteLink]
    :ivar circuits: Reference the ExpressRoute circuit(s) that are provisioned on this
     ExpressRoutePort resource.
    :vartype circuits: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the express route port resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar resource_guid: The resource GUID property of the express route port resource.
    :vartype resource_guid: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioned_bandwidth_in_gbps": {"readonly": True},
        "mtu": {"readonly": True},
        "ether_type": {"readonly": True},
        "allocation_date": {"readonly": True},
        "circuits": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "bandwidth_in_gbps": {"key": "properties.bandwidthInGbps", "type": "int"},
        "provisioned_bandwidth_in_gbps": {"key": "properties.provisionedBandwidthInGbps", "type": "float"},
        "mtu": {"key": "properties.mtu", "type": "str"},
        "encapsulation": {"key": "properties.encapsulation", "type": "str"},
        "ether_type": {"key": "properties.etherType", "type": "str"},
        "allocation_date": {"key": "properties.allocationDate", "type": "str"},
        "links": {"key": "properties.links", "type": "[ExpressRouteLink]"},
        "circuits": {"key": "properties.circuits", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_gbps: Optional[int] = None,
        encapsulation: Optional[Union[str, "_models.ExpressRoutePortsEncapsulation"]] = None,
        links: Optional[List["_models.ExpressRouteLink"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of ExpressRoutePort, if configured.
        :paramtype identity: ~azure.mgmt.network.v2019_08_01.models.ManagedServiceIdentity
        :keyword peering_location: The name of the peering location that the ExpressRoutePort is mapped
         to physically.
        :paramtype peering_location: str
        :keyword bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
        :paramtype bandwidth_in_gbps: int
        :keyword encapsulation: Encapsulation method on physical ports. Known values are: "Dot1Q" and
         "QinQ".
        :paramtype encapsulation: str or
         ~azure.mgmt.network.v2019_08_01.models.ExpressRoutePortsEncapsulation
        :keyword links: The set of physical links of the ExpressRoutePort resource.
        :paramtype links: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteLink]
        :keyword resource_guid: The resource GUID property of the express route port resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.identity = identity
        self.peering_location = peering_location
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.provisioned_bandwidth_in_gbps = None
        self.mtu = None
        self.encapsulation = encapsulation
        self.ether_type = None
        self.allocation_date = None
        self.links = links
        self.circuits = None
        self.provisioning_state = None
        self.resource_guid = resource_guid


class ExpressRoutePortListResult(_serialization.Model):
    """Response for ListExpressRoutePorts API service call.

    :ivar value: A list of ExpressRoutePort resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRoutePort]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePort]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRoutePort"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of ExpressRoutePort resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRoutePort]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRoutePortsLocation(Resource):
    """Definition of the ExpressRoutePorts peering location resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar address: Address of peering location.
    :vartype address: str
    :ivar contact: Contact details of peering locations.
    :vartype contact: str
    :ivar available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
    :vartype available_bandwidths:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRoutePortsLocationBandwidths]
    :ivar provisioning_state: The provisioning state of the express route port location resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "address": {"readonly": True},
        "contact": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "address": {"key": "properties.address", "type": "str"},
        "contact": {"key": "properties.contact", "type": "str"},
        "available_bandwidths": {
            "key": "properties.availableBandwidths",
            "type": "[ExpressRoutePortsLocationBandwidths]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        available_bandwidths: Optional[List["_models.ExpressRoutePortsLocationBandwidths"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
        :paramtype available_bandwidths:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRoutePortsLocationBandwidths]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.address = None
        self.contact = None
        self.available_bandwidths = available_bandwidths
        self.provisioning_state = None


class ExpressRoutePortsLocationBandwidths(_serialization.Model):
    """Real-time inventory of available ExpressRoute port bandwidths.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar offer_name: Bandwidth descriptive name.
    :vartype offer_name: str
    :ivar value_in_gbps: Bandwidth value in Gbps.
    :vartype value_in_gbps: int
    """

    _validation = {
        "offer_name": {"readonly": True},
        "value_in_gbps": {"readonly": True},
    }

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_gbps": {"key": "valueInGbps", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.offer_name = None
        self.value_in_gbps = None


class ExpressRoutePortsLocationListResult(_serialization.Model):
    """Response for ListExpressRoutePortsLocations API service call.

    :ivar value: The list of all ExpressRoutePort peering locations.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRoutePortsLocation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePortsLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRoutePortsLocation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of all ExpressRoutePort peering locations.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRoutePortsLocation]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar peering_locations: A list of peering locations.
    :vartype peering_locations: list[str]
    :ivar bandwidths_offered: A list of bandwidths offered.
    :vartype bandwidths_offered:
     list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: The provisioning state of the express route service provider
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "peering_locations": {"key": "properties.peeringLocations", "type": "[str]"},
        "bandwidths_offered": {
            "key": "properties.bandwidthsOffered",
            "type": "[ExpressRouteServiceProviderBandwidthsOffered]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_locations: Optional[List[str]] = None,
        bandwidths_offered: Optional[List["_models.ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_locations: A list of peering locations.
        :paramtype peering_locations: list[str]
        :keyword bandwidths_offered: A list of bandwidths offered.
        :paramtype bandwidths_offered:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteServiceProviderBandwidthsOffered]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = None


class ExpressRouteServiceProviderBandwidthsOffered(_serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :ivar offer_name: The OfferName.
    :vartype offer_name: str
    :ivar value_in_mbps: The ValueInMbps.
    :vartype value_in_mbps: int
    """

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_mbps": {"key": "valueInMbps", "type": "int"},
    }

    def __init__(self, *, offer_name: Optional[str] = None, value_in_mbps: Optional[int] = None, **kwargs):
        """
        :keyword offer_name: The OfferName.
        :paramtype offer_name: str
        :keyword value_in_mbps: The ValueInMbps.
        :paramtype value_in_mbps: int
        """
        super().__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class ExpressRouteServiceProviderListResult(_serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :ivar value: A list of ExpressRouteResourceProvider resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteServiceProvider]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteServiceProvider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of ExpressRouteResourceProvider resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteServiceProvider]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FirewallPolicy(Resource):  # pylint: disable=too-many-instance-attributes
    """FirewallPolicy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rule_groups: List of references to FirewallPolicyRuleGroups.
    :vartype rule_groups: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the firewall policy resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar base_policy: The parent firewall policy from which rules are inherited.
    :vartype base_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar firewalls: List of references to Azure Firewalls that this Firewall Policy is associated
     with.
    :vartype firewalls: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar child_policies: List of references to Child Firewall Policies.
    :vartype child_policies: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar threat_intel_mode: The operation mode for Threat Intelligence. Known values are: "Alert",
     "Deny", and "Off".
    :vartype threat_intel_mode: str or
     ~azure.mgmt.network.v2019_08_01.models.AzureFirewallThreatIntelMode
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "rule_groups": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "firewalls": {"readonly": True},
        "child_policies": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "rule_groups": {"key": "properties.ruleGroups", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "base_policy": {"key": "properties.basePolicy", "type": "SubResource"},
        "firewalls": {"key": "properties.firewalls", "type": "[SubResource]"},
        "child_policies": {"key": "properties.childPolicies", "type": "[SubResource]"},
        "threat_intel_mode": {"key": "properties.threatIntelMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        base_policy: Optional["_models.SubResource"] = None,
        threat_intel_mode: Optional[Union[str, "_models.AzureFirewallThreatIntelMode"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword base_policy: The parent firewall policy from which rules are inherited.
        :paramtype base_policy: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword threat_intel_mode: The operation mode for Threat Intelligence. Known values are:
         "Alert", "Deny", and "Off".
        :paramtype threat_intel_mode: str or
         ~azure.mgmt.network.v2019_08_01.models.AzureFirewallThreatIntelMode
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.rule_groups = None
        self.provisioning_state = None
        self.base_policy = base_policy
        self.firewalls = None
        self.child_policies = None
        self.threat_intel_mode = threat_intel_mode


class FirewallPolicyRule(_serialization.Model):
    """Properties of the rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FirewallPolicyFilterRule, FirewallPolicyNatRule

    All required parameters must be populated in order to send to Azure.

    :ivar rule_type: The type of the rule. Required. Known values are: "FirewallPolicyNatRule" and
     "FirewallPolicyFilterRule".
    :vartype rule_type: str or ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleType
    :ivar name: The name of the rule.
    :vartype name: str
    :ivar priority: Priority of the Firewall Policy Rule resource.
    :vartype priority: int
    """

    _validation = {
        "rule_type": {"required": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "rule_type": {"key": "ruleType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
    }

    _subtype_map = {
        "rule_type": {
            "FirewallPolicyFilterRule": "FirewallPolicyFilterRule",
            "FirewallPolicyNatRule": "FirewallPolicyNatRule",
        }
    }

    def __init__(self, *, name: Optional[str] = None, priority: Optional[int] = None, **kwargs):
        """
        :keyword name: The name of the rule.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule resource.
        :paramtype priority: int
        """
        super().__init__(**kwargs)
        self.rule_type = None  # type: Optional[str]
        self.name = name
        self.priority = priority


class FirewallPolicyFilterRule(FirewallPolicyRule):
    """Firewall Policy Filter Rule.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_type: The type of the rule. Required. Known values are: "FirewallPolicyNatRule" and
     "FirewallPolicyFilterRule".
    :vartype rule_type: str or ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleType
    :ivar name: The name of the rule.
    :vartype name: str
    :ivar priority: Priority of the Firewall Policy Rule resource.
    :vartype priority: int
    :ivar action: The action type of a Filter rule.
    :vartype action: ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyFilterRuleAction
    :ivar rule_conditions: Collection of rule conditions used by a rule.
    :vartype rule_conditions:
     list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleCondition]
    """

    _validation = {
        "rule_type": {"required": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "rule_type": {"key": "ruleType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "action": {"key": "action", "type": "FirewallPolicyFilterRuleAction"},
        "rule_conditions": {"key": "ruleConditions", "type": "[FirewallPolicyRuleCondition]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.FirewallPolicyFilterRuleAction"] = None,
        rule_conditions: Optional[List["_models.FirewallPolicyRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the rule.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule resource.
        :paramtype priority: int
        :keyword action: The action type of a Filter rule.
        :paramtype action: ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyFilterRuleAction
        :keyword rule_conditions: Collection of rule conditions used by a rule.
        :paramtype rule_conditions:
         list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleCondition]
        """
        super().__init__(name=name, priority=priority, **kwargs)
        self.rule_type = "FirewallPolicyFilterRule"  # type: str
        self.action = action
        self.rule_conditions = rule_conditions


class FirewallPolicyFilterRuleAction(_serialization.Model):
    """Properties of the FirewallPolicyFilterRuleAction.

    :ivar type: The type of action. Known values are: "Allow" and "Deny".
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyFilterRuleActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.FirewallPolicyFilterRuleActionType"]] = None, **kwargs):
        """
        :keyword type: The type of action. Known values are: "Allow" and "Deny".
        :paramtype type: str or
         ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyFilterRuleActionType
        """
        super().__init__(**kwargs)
        self.type = type


class FirewallPolicyListResult(_serialization.Model):
    """Response for ListFirewallPolicies API service call.

    :ivar value: List of Firewall Policies in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicy]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.FirewallPolicy"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Firewall Policies in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicy]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FirewallPolicyNatRule(FirewallPolicyRule):
    """Firewall Policy NAT Rule.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_type: The type of the rule. Required. Known values are: "FirewallPolicyNatRule" and
     "FirewallPolicyFilterRule".
    :vartype rule_type: str or ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleType
    :ivar name: The name of the rule.
    :vartype name: str
    :ivar priority: Priority of the Firewall Policy Rule resource.
    :vartype priority: int
    :ivar action: The action type of a Nat rule.
    :vartype action: ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyNatRuleAction
    :ivar translated_address: The translated address for this NAT rule.
    :vartype translated_address: str
    :ivar translated_port: The translated port for this NAT rule.
    :vartype translated_port: str
    :ivar rule_condition: The match conditions for incoming traffic.
    :vartype rule_condition: ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleCondition
    """

    _validation = {
        "rule_type": {"required": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "rule_type": {"key": "ruleType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "action": {"key": "action", "type": "FirewallPolicyNatRuleAction"},
        "translated_address": {"key": "translatedAddress", "type": "str"},
        "translated_port": {"key": "translatedPort", "type": "str"},
        "rule_condition": {"key": "ruleCondition", "type": "FirewallPolicyRuleCondition"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.FirewallPolicyNatRuleAction"] = None,
        translated_address: Optional[str] = None,
        translated_port: Optional[str] = None,
        rule_condition: Optional["_models.FirewallPolicyRuleCondition"] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the rule.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule resource.
        :paramtype priority: int
        :keyword action: The action type of a Nat rule.
        :paramtype action: ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyNatRuleAction
        :keyword translated_address: The translated address for this NAT rule.
        :paramtype translated_address: str
        :keyword translated_port: The translated port for this NAT rule.
        :paramtype translated_port: str
        :keyword rule_condition: The match conditions for incoming traffic.
        :paramtype rule_condition: ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleCondition
        """
        super().__init__(name=name, priority=priority, **kwargs)
        self.rule_type = "FirewallPolicyNatRule"  # type: str
        self.action = action
        self.translated_address = translated_address
        self.translated_port = translated_port
        self.rule_condition = rule_condition


class FirewallPolicyNatRuleAction(_serialization.Model):
    """Properties of the FirewallPolicyNatRuleAction.

    :ivar type: The type of action. "DNAT"
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyNatRuleActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.FirewallPolicyNatRuleActionType"]] = None, **kwargs):
        """
        :keyword type: The type of action. "DNAT"
        :paramtype type: str or ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyNatRuleActionType
        """
        super().__init__(**kwargs)
        self.type = type


class FirewallPolicyRuleConditionApplicationProtocol(_serialization.Model):
    """Properties of the application rule protocol.

    :ivar protocol_type: Protocol type. Known values are: "Http" and "Https".
    :vartype protocol_type: str or
     ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionApplicationProtocolType
    :ivar port: Port number for the protocol, cannot be greater than 64000.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 64000, "minimum": 0},
    }

    _attribute_map = {
        "protocol_type": {"key": "protocolType", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.FirewallPolicyRuleConditionApplicationProtocolType"]] = None,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Protocol type. Known values are: "Http" and "Https".
        :paramtype protocol_type: str or
         ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionApplicationProtocolType
        :keyword port: Port number for the protocol, cannot be greater than 64000.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port


class FirewallPolicyRuleGroup(SubResource):
    """Rule Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Rule Group type.
    :vartype type: str
    :ivar priority: Priority of the Firewall Policy Rule Group resource.
    :vartype priority: int
    :ivar rules: Group of Firewall Policy rules.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRule]
    :ivar provisioning_state: The provisioning state of the firewall policy rule group resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "rules": {"key": "properties.rules", "type": "[FirewallPolicyRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        rules: Optional[List["_models.FirewallPolicyRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule Group resource.
        :paramtype priority: int
        :keyword rules: Group of Firewall Policy rules.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.priority = priority
        self.rules = rules
        self.provisioning_state = None


class FirewallPolicyRuleGroupListResult(_serialization.Model):
    """Response for ListFirewallPolicyRuleGroups API service call.

    :ivar value: List of FirewallPolicyRuleGroups in a FirewallPolicy.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleGroup]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallPolicyRuleGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.FirewallPolicyRuleGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of FirewallPolicyRuleGroups in a FirewallPolicy.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleGroup]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FlowLogFormatParameters(_serialization.Model):
    """Parameters that define the flow log format.

    :ivar type: The file type of flow log. "JSON"
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.FlowLogFormatType
    :ivar version: The version (revision) of the flow log.
    :vartype version: int
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "int"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.FlowLogFormatType"]] = None, version: int = 0, **kwargs):
        """
        :keyword type: The file type of flow log. "JSON"
        :paramtype type: str or ~azure.mgmt.network.v2019_08_01.models.FlowLogFormatType
        :keyword version: The version (revision) of the flow log.
        :paramtype version: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.version = version


class FlowLogInformation(_serialization.Model):
    """Information on the configuration of flow log and traffic analytics (optional) .

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The ID of the resource to configure for flow log and traffic
     analytics (optional) . Required.
    :vartype target_resource_id: str
    :ivar flow_analytics_configuration: Parameters that define the configuration of traffic
     analytics.
    :vartype flow_analytics_configuration:
     ~azure.mgmt.network.v2019_08_01.models.TrafficAnalyticsProperties
    :ivar storage_id: ID of the storage account which is used to store the flow log. Required.
    :vartype storage_id: str
    :ivar enabled: Flag to enable/disable flow logging. Required.
    :vartype enabled: bool
    :ivar retention_policy: Parameters that define the retention policy for flow log.
    :vartype retention_policy: ~azure.mgmt.network.v2019_08_01.models.RetentionPolicyParameters
    :ivar format: Parameters that define the flow log format.
    :vartype format: ~azure.mgmt.network.v2019_08_01.models.FlowLogFormatParameters
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "flow_analytics_configuration": {"key": "flowAnalyticsConfiguration", "type": "TrafficAnalyticsProperties"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicyParameters"},
        "format": {"key": "properties.format", "type": "FlowLogFormatParameters"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        storage_id: str,
        enabled: bool,
        flow_analytics_configuration: Optional["_models.TrafficAnalyticsProperties"] = None,
        retention_policy: Optional["_models.RetentionPolicyParameters"] = None,
        format: Optional["_models.FlowLogFormatParameters"] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The ID of the resource to configure for flow log and traffic
         analytics (optional) . Required.
        :paramtype target_resource_id: str
        :keyword flow_analytics_configuration: Parameters that define the configuration of traffic
         analytics.
        :paramtype flow_analytics_configuration:
         ~azure.mgmt.network.v2019_08_01.models.TrafficAnalyticsProperties
        :keyword storage_id: ID of the storage account which is used to store the flow log. Required.
        :paramtype storage_id: str
        :keyword enabled: Flag to enable/disable flow logging. Required.
        :paramtype enabled: bool
        :keyword retention_policy: Parameters that define the retention policy for flow log.
        :paramtype retention_policy: ~azure.mgmt.network.v2019_08_01.models.RetentionPolicyParameters
        :keyword format: Parameters that define the flow log format.
        :paramtype format: ~azure.mgmt.network.v2019_08_01.models.FlowLogFormatParameters
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.flow_analytics_configuration = flow_analytics_configuration
        self.storage_id = storage_id
        self.enabled = enabled
        self.retention_policy = retention_policy
        self.format = format


class FlowLogStatusParameters(_serialization.Model):
    """Parameters that define a resource to query flow log and traffic analytics (optional) status.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The target resource where getting the flow log and traffic analytics
     (optional) status. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs):
        """
        :keyword target_resource_id: The target resource where getting the flow log and traffic
         analytics (optional) status. Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class FrontendIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar inbound_nat_rules: An array of references to inbound rules that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar inbound_nat_pools: An array of references to inbound pools that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar outbound_rules: An array of references to outbound rules that use this frontend IP.
    :vartype outbound_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The Private IP allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6. Default
     is taken as IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
    :ivar public_ip_address: The reference of the Public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddress
    :ivar public_ip_prefix: The reference of the Public IP Prefix resource.
    :vartype public_ip_prefix: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "inbound_nat_rules": {"readonly": True},
        "inbound_nat_pools": {"readonly": True},
        "outbound_rules": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[SubResource]"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[SubResource]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of frontend IP
         configurations used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The Private IP allocation method. Known values are:
         "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6.
         Default is taken as IPv4. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
        :keyword public_ip_address: The reference of the Public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddress
        :keyword public_ip_prefix: The reference of the Public IP Prefix resource.
        :paramtype public_ip_prefix: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.zones = zones
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.public_ip_prefix = public_ip_prefix
        self.provisioning_state = None


class GatewayRoute(_serialization.Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "network": {"readonly": True},
        "next_hop": {"readonly": True},
        "source_peer": {"readonly": True},
        "origin": {"readonly": True},
        "as_path": {"readonly": True},
        "weight": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "source_peer": {"key": "sourcePeer", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None


class GatewayRouteListResult(_serialization.Model):
    """List of virtual network gateway routes.

    :ivar value: List of gateway routes.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.GatewayRoute]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayRoute]"},
    }

    def __init__(self, *, value: Optional[List["_models.GatewayRoute"]] = None, **kwargs):
        """
        :keyword value: List of gateway routes.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.GatewayRoute]
        """
        super().__init__(**kwargs)
        self.value = value


class GetVpnSitesConfigurationRequest(_serialization.Model):
    """List of Vpn-Sites.

    All required parameters must be populated in order to send to Azure.

    :ivar vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
    :vartype vpn_sites: list[str]
    :ivar output_blob_sas_url: The sas-url to download the configurations for vpn-sites. Required.
    :vartype output_blob_sas_url: str
    """

    _validation = {
        "output_blob_sas_url": {"required": True},
    }

    _attribute_map = {
        "vpn_sites": {"key": "vpnSites", "type": "[str]"},
        "output_blob_sas_url": {"key": "outputBlobSasUrl", "type": "str"},
    }

    def __init__(self, *, output_blob_sas_url: str, vpn_sites: Optional[List[str]] = None, **kwargs):
        """
        :keyword vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
        :paramtype vpn_sites: list[str]
        :keyword output_blob_sas_url: The sas-url to download the configurations for vpn-sites.
         Required.
        :paramtype output_blob_sas_url: str
        """
        super().__init__(**kwargs)
        self.vpn_sites = vpn_sites
        self.output_blob_sas_url = output_blob_sas_url


class HTTPConfiguration(_serialization.Model):
    """HTTP configuration of the connectivity check.

    :ivar method: HTTP method. "Get"
    :vartype method: str or ~azure.mgmt.network.v2019_08_01.models.HTTPMethod
    :ivar headers: List of HTTP headers.
    :vartype headers: list[~azure.mgmt.network.v2019_08_01.models.HTTPHeader]
    :ivar valid_status_codes: Valid status codes.
    :vartype valid_status_codes: list[int]
    """

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "headers": {"key": "headers", "type": "[HTTPHeader]"},
        "valid_status_codes": {"key": "validStatusCodes", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        method: Optional[Union[str, "_models.HTTPMethod"]] = None,
        headers: Optional[List["_models.HTTPHeader"]] = None,
        valid_status_codes: Optional[List[int]] = None,
        **kwargs
    ):
        """
        :keyword method: HTTP method. "Get"
        :paramtype method: str or ~azure.mgmt.network.v2019_08_01.models.HTTPMethod
        :keyword headers: List of HTTP headers.
        :paramtype headers: list[~azure.mgmt.network.v2019_08_01.models.HTTPHeader]
        :keyword valid_status_codes: Valid status codes.
        :paramtype valid_status_codes: list[int]
        """
        super().__init__(**kwargs)
        self.method = method
        self.headers = headers
        self.valid_status_codes = valid_status_codes


class HTTPHeader(_serialization.Model):
    """Describes the HTTP header.

    :ivar name: The name in HTTP header.
    :vartype name: str
    :ivar value: The value in HTTP header.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword name: The name in HTTP header.
        :paramtype name: str
        :keyword value: The value in HTTP header.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class HubIPAddresses(_serialization.Model):
    """IP addresses associated with azure firewall.

    :ivar public_ip_addresses: List of Public IP addresses associated with azure firewall.
    :vartype public_ip_addresses:
     list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallPublicIPAddress]
    :ivar private_ip_address: Private IP Address associated with azure firewall.
    :vartype private_ip_address: str
    """

    _attribute_map = {
        "public_ip_addresses": {"key": "publicIPAddresses", "type": "[AzureFirewallPublicIPAddress]"},
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_ip_addresses: Optional[List["_models.AzureFirewallPublicIPAddress"]] = None,
        private_ip_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword public_ip_addresses: List of Public IP addresses associated with azure firewall.
        :paramtype public_ip_addresses:
         list[~azure.mgmt.network.v2019_08_01.models.AzureFirewallPublicIPAddress]
        :keyword private_ip_address: Private IP Address associated with azure firewall.
        :paramtype private_ip_address: str
        """
        super().__init__(**kwargs)
        self.public_ip_addresses = public_ip_addresses
        self.private_ip_address = private_ip_address


class HubVirtualNetworkConnection(SubResource):
    """HubVirtualNetworkConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar remote_virtual_network: Reference to the remote virtual network.
    :vartype remote_virtual_network: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar allow_hub_to_remote_vnet_transit: VirtualHub to RemoteVnet transit to enabled or not.
    :vartype allow_hub_to_remote_vnet_transit: bool
    :ivar allow_remote_vnet_to_use_hub_vnet_gateways: Allow RemoteVnet to use Virtual Hub's
     gateways.
    :vartype allow_remote_vnet_to_use_hub_vnet_gateways: bool
    :ivar enable_internet_security: Enable internet security.
    :vartype enable_internet_security: bool
    :ivar provisioning_state: The provisioning state of the hub virtual network connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "remote_virtual_network": {"key": "properties.remoteVirtualNetwork", "type": "SubResource"},
        "allow_hub_to_remote_vnet_transit": {"key": "properties.allowHubToRemoteVnetTransit", "type": "bool"},
        "allow_remote_vnet_to_use_hub_vnet_gateways": {
            "key": "properties.allowRemoteVnetToUseHubVnetGateways",
            "type": "bool",
        },
        "enable_internet_security": {"key": "properties.enableInternetSecurity", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        remote_virtual_network: Optional["_models.SubResource"] = None,
        allow_hub_to_remote_vnet_transit: Optional[bool] = None,
        allow_remote_vnet_to_use_hub_vnet_gateways: Optional[bool] = None,
        enable_internet_security: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword remote_virtual_network: Reference to the remote virtual network.
        :paramtype remote_virtual_network: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword allow_hub_to_remote_vnet_transit: VirtualHub to RemoteVnet transit to enabled or not.
        :paramtype allow_hub_to_remote_vnet_transit: bool
        :keyword allow_remote_vnet_to_use_hub_vnet_gateways: Allow RemoteVnet to use Virtual Hub's
         gateways.
        :paramtype allow_remote_vnet_to_use_hub_vnet_gateways: bool
        :keyword enable_internet_security: Enable internet security.
        :paramtype enable_internet_security: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.remote_virtual_network = remote_virtual_network
        self.allow_hub_to_remote_vnet_transit = allow_hub_to_remote_vnet_transit
        self.allow_remote_vnet_to_use_hub_vnet_gateways = allow_remote_vnet_to_use_hub_vnet_gateways
        self.enable_internet_security = enable_internet_security
        self.provisioning_state = None


class InboundNatPool(SubResource):  # pylint: disable=too-many-instance-attributes
    """Inbound NAT pool of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of inbound NAT pools used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar protocol: The reference to the transport protocol used by the inbound NAT pool. Known
     values are: "Udp", "Tcp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.TransportProtocol
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :vartype frontend_port_range_end: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT pool resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of inbound NAT pools used
         by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the inbound NAT pool. Known
         values are: "Udp", "Tcp", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.TransportProtocol
        :keyword frontend_port_range_start: The first port number in the range of external ports that
         will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
         range between 1 and 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The last port number in the range of external ports that will
         be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
         between 1 and 65535.
        :paramtype frontend_port_range_end: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.provisioning_state = None


class InboundNatRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of inbound NAT rules used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration
    :ivar protocol: The reference to the transport protocol used by the load balancing rule. Known
     values are: "Udp", "Tcp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.TransportProtocol
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT rule resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "backend_ip_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_ip_configuration": {
            "key": "properties.backendIPConfiguration",
            "type": "NetworkInterfaceIPConfiguration",
        },
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of inbound NAT rules used
         by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the load balancing rule.
         Known values are: "Udp", "Tcp", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.TransportProtocol
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for the internal endpoint. Acceptable values range from 1
         to 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = None
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.provisioning_state = None


class InboundNatRuleListResult(_serialization.Model):
    """Response for ListInboundNatRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of inbound nat rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.InboundNatRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InboundNatRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.InboundNatRule"]] = None, **kwargs):
        """
        :keyword value: A list of inbound nat rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.InboundNatRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IPAddressAvailabilityResult(_serialization.Model):
    """Response for CheckIPAddressAvailability API service call.

    :ivar available: Private IP address availability.
    :vartype available: bool
    :ivar available_ip_addresses: Contains other available private IP addresses if the asked for
     address is taken.
    :vartype available_ip_addresses: list[str]
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
        "available_ip_addresses": {"key": "availableIPAddresses", "type": "[str]"},
    }

    def __init__(
        self, *, available: Optional[bool] = None, available_ip_addresses: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword available: Private IP address availability.
        :paramtype available: bool
        :keyword available_ip_addresses: Contains other available private IP addresses if the asked for
         address is taken.
        :paramtype available_ip_addresses: list[str]
        """
        super().__init__(**kwargs)
        self.available = available
        self.available_ip_addresses = available_ip_addresses


class IPConfiguration(SubResource):
    """IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
    :ivar public_ip_address: The reference of the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the IP configuration resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
        :keyword public_ip_address: The reference of the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddress
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None


class IPConfigurationProfile(SubResource):
    """IP configuration profile child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: The reference of the subnet resource to create a container network interface ip
     configuration.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
    :ivar provisioning_state: The provisioning state of the IP configuration profile resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        subnet: Optional["_models.Subnet"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword subnet: The reference of the subnet resource to create a container network interface
         ip configuration.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = etag
        self.subnet = subnet
        self.provisioning_state = None


class IpsecPolicy(_serialization.Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :ivar sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) lifetime in seconds for a site to site VPN tunnel. Required.
    :vartype sa_life_time_seconds: int
    :ivar sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) payload size in KB for a site to site VPN tunnel. Required.
    :vartype sa_data_size_kilobytes: int
    :ivar ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
     are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
     "GCMAES256".
    :vartype ipsec_encryption: str or ~azure.mgmt.network.v2019_08_01.models.IpsecEncryption
    :ivar ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values are:
     "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
    :vartype ipsec_integrity: str or ~azure.mgmt.network.v2019_08_01.models.IpsecIntegrity
    :ivar ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values are:
     "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
    :vartype ike_encryption: str or ~azure.mgmt.network.v2019_08_01.models.IkeEncryption
    :ivar ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
     "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
    :vartype ike_integrity: str or ~azure.mgmt.network.v2019_08_01.models.IkeIntegrity
    :ivar dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
     "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
     "DHGroup24".
    :vartype dh_group: str or ~azure.mgmt.network.v2019_08_01.models.DhGroup
    :ivar pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
     are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
    :vartype pfs_group: str or ~azure.mgmt.network.v2019_08_01.models.PfsGroup
    """

    _validation = {
        "sa_life_time_seconds": {"required": True},
        "sa_data_size_kilobytes": {"required": True},
        "ipsec_encryption": {"required": True},
        "ipsec_integrity": {"required": True},
        "ike_encryption": {"required": True},
        "ike_integrity": {"required": True},
        "dh_group": {"required": True},
        "pfs_group": {"required": True},
    }

    _attribute_map = {
        "sa_life_time_seconds": {"key": "saLifeTimeSeconds", "type": "int"},
        "sa_data_size_kilobytes": {"key": "saDataSizeKilobytes", "type": "int"},
        "ipsec_encryption": {"key": "ipsecEncryption", "type": "str"},
        "ipsec_integrity": {"key": "ipsecIntegrity", "type": "str"},
        "ike_encryption": {"key": "ikeEncryption", "type": "str"},
        "ike_integrity": {"key": "ikeIntegrity", "type": "str"},
        "dh_group": {"key": "dhGroup", "type": "str"},
        "pfs_group": {"key": "pfsGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        sa_life_time_seconds: int,
        sa_data_size_kilobytes: int,
        ipsec_encryption: Union[str, "_models.IpsecEncryption"],
        ipsec_integrity: Union[str, "_models.IpsecIntegrity"],
        ike_encryption: Union[str, "_models.IkeEncryption"],
        ike_integrity: Union[str, "_models.IkeIntegrity"],
        dh_group: Union[str, "_models.DhGroup"],
        pfs_group: Union[str, "_models.PfsGroup"],
        **kwargs
    ):
        """
        :keyword sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase
         2 SA) lifetime in seconds for a site to site VPN tunnel. Required.
        :paramtype sa_life_time_seconds: int
        :keyword sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or
         Phase 2 SA) payload size in KB for a site to site VPN tunnel. Required.
        :paramtype sa_data_size_kilobytes: int
        :keyword ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
         are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
         "GCMAES256".
        :paramtype ipsec_encryption: str or ~azure.mgmt.network.v2019_08_01.models.IpsecEncryption
        :keyword ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values
         are: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
        :paramtype ipsec_integrity: str or ~azure.mgmt.network.v2019_08_01.models.IpsecIntegrity
        :keyword ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values
         are: "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
        :paramtype ike_encryption: str or ~azure.mgmt.network.v2019_08_01.models.IkeEncryption
        :keyword ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
         "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
        :paramtype ike_integrity: str or ~azure.mgmt.network.v2019_08_01.models.IkeIntegrity
        :keyword dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
         "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
         "DHGroup24".
        :paramtype dh_group: str or ~azure.mgmt.network.v2019_08_01.models.DhGroup
        :keyword pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
         are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
        :paramtype pfs_group: str or ~azure.mgmt.network.v2019_08_01.models.PfsGroup
        """
        super().__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group


class IpTag(_serialization.Model):
    """Contains the IpTag associated with the object.

    :ivar ip_tag_type: The IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: The value of the IP tag associated with the public IP. Example: SQL.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs):
        """
        :keyword ip_tag_type: The IP tag type. Example: FirstPartyUsage.
        :paramtype ip_tag_type: str
        :keyword tag: The value of the IP tag associated with the public IP. Example: SQL.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class Ipv6ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Contains IPv6 peering config.

    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringConfig
    :ivar route_filter: The reference of the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar state: The state of peering. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        "primary_peer_address_prefix": {"key": "primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "secondaryPeerAddressPrefix", "type": "str"},
        "microsoft_peering_config": {"key": "microsoftPeeringConfig", "type": "ExpressRouteCircuitPeeringConfig"},
        "route_filter": {"key": "routeFilter", "type": "SubResource"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        route_filter: Optional["_models.SubResource"] = None,
        state: Optional[Union[str, "_models.ExpressRouteCircuitPeeringState"]] = None,
        **kwargs
    ):
        """
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringConfig
        :keyword route_filter: The reference of the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword state: The state of peering. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeeringState
        """
        super().__init__(**kwargs)
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.microsoft_peering_config = microsoft_peering_config
        self.route_filter = route_filter
        self.state = state


class ListHubVirtualNetworkConnectionsResult(_serialization.Model):
    """List of HubVirtualNetworkConnections and a URL nextLink to get the next set of results.

    :ivar value: List of HubVirtualNetworkConnections.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.HubVirtualNetworkConnection]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[HubVirtualNetworkConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.HubVirtualNetworkConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of HubVirtualNetworkConnections.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.HubVirtualNetworkConnection]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListP2SVpnGatewaysResult(_serialization.Model):
    """Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL nextLink to get the next set of results.

    :ivar value: List of P2SVpnGateways.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.P2SVpnGateway]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[P2SVpnGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.P2SVpnGateway"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of P2SVpnGateways.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.P2SVpnGateway]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVirtualHubsResult(_serialization.Model):
    """Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink to get the next set of results.

    :ivar value: List of VirtualHubs.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualHub]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualHub]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualHub"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VirtualHubs.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualHub]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVirtualWANsResult(_serialization.Model):
    """Result of the request to list VirtualWANs. It contains a list of VirtualWANs and a URL nextLink to get the next set of results.

    :ivar value: List of VirtualWANs.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualWAN]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualWAN]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualWAN"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VirtualWANs.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualWAN]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVpnConnectionsResult(_serialization.Model):
    """Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results.

    :ivar value: List of Vpn Connections.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VpnConnection]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VpnConnection"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Vpn Connections.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VpnConnection]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVpnGatewaysResult(_serialization.Model):
    """Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink to get the next set of results.

    :ivar value: List of VpnGateways.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VpnGateway]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VpnGateway"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VpnGateways.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VpnGateway]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVpnServerConfigurationsResult(_serialization.Model):
    """Result of the request to list all VpnServerConfigurations. It contains a list of VpnServerConfigurations and a URL nextLink to get the next set of results.

    :ivar value: List of VpnServerConfigurations.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VpnServerConfiguration]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnServerConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VpnServerConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of VpnServerConfigurations.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VpnServerConfiguration]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVpnSiteLinkConnectionsResult(_serialization.Model):
    """Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a list of Vpn Connections and a URL nextLink to get the next set of results.

    :ivar value: List of VpnSiteLinkConnections.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VpnSiteLinkConnection]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnSiteLinkConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VpnSiteLinkConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of VpnSiteLinkConnections.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VpnSiteLinkConnection]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVpnSiteLinksResult(_serialization.Model):
    """Result of the request to list VpnSiteLinks. It contains a list of VpnSiteLinks and a URL nextLink to get the next set of results.

    :ivar value: List of VpnSitesLinks.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VpnSiteLink]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnSiteLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VpnSiteLink"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VpnSitesLinks.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VpnSiteLink]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListVpnSitesResult(_serialization.Model):
    """Result of the request to list VpnSites. It contains a list of VpnSites and a URL nextLink to get the next set of results.

    :ivar value: List of VpnSites.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VpnSite]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnSite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VpnSite"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of VpnSites.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VpnSite]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LoadBalancer(Resource):  # pylint: disable=too-many-instance-attributes
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The load balancer SKU.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.LoadBalancerSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration]
    :ivar backend_address_pools: Collection of backend address pools used by a load balancer.
    :vartype backend_address_pools: list[~azure.mgmt.network.v2019_08_01.models.BackendAddressPool]
    :ivar load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancingRule]
    :ivar probes: Collection of probe objects used in the load balancer.
    :vartype probes: list[~azure.mgmt.network.v2019_08_01.models.Probe]
    :ivar inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2019_08_01.models.InboundNatRule]
    :ivar inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2019_08_01.models.InboundNatPool]
    :ivar outbound_rules: The outbound rules.
    :vartype outbound_rules: list[~azure.mgmt.network.v2019_08_01.models.OutboundRule]
    :ivar resource_guid: The resource GUID property of the load balancer resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the load balancer resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "LoadBalancerSku"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[FrontendIPConfiguration]",
        },
        "backend_address_pools": {"key": "properties.backendAddressPools", "type": "[BackendAddressPool]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[LoadBalancingRule]"},
        "probes": {"key": "properties.probes", "type": "[Probe]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[InboundNatRule]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[InboundNatPool]"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[OutboundRule]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.LoadBalancerSku"] = None,
        etag: Optional[str] = None,
        frontend_ip_configurations: Optional[List["_models.FrontendIPConfiguration"]] = None,
        backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancing_rules: Optional[List["_models.LoadBalancingRule"]] = None,
        probes: Optional[List["_models.Probe"]] = None,
        inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        inbound_nat_pools: Optional[List["_models.InboundNatPool"]] = None,
        outbound_rules: Optional[List["_models.OutboundRule"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The load balancer SKU.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.LoadBalancerSku
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configurations: Object representing the frontend IPs to be used for the
         load balancer.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration]
        :keyword backend_address_pools: Collection of backend address pools used by a load balancer.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2019_08_01.models.BackendAddressPool]
        :keyword load_balancing_rules: Object collection representing the load balancing rules Gets the
         provisioning.
        :paramtype load_balancing_rules: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancingRule]
        :keyword probes: Collection of probe objects used in the load balancer.
        :paramtype probes: list[~azure.mgmt.network.v2019_08_01.models.Probe]
        :keyword inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
         inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
         pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
         associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
         reference individual inbound NAT rules.
        :paramtype inbound_nat_rules: list[~azure.mgmt.network.v2019_08_01.models.InboundNatRule]
        :keyword inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
         port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
         each NIC associated with the Load Balancer using an external port from this range. Defining an
         Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
         Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
         individual virtual machines cannot reference an inbound NAT pool. They have to reference
         individual inbound NAT rules.
        :paramtype inbound_nat_pools: list[~azure.mgmt.network.v2019_08_01.models.InboundNatPool]
        :keyword outbound_rules: The outbound rules.
        :paramtype outbound_rules: list[~azure.mgmt.network.v2019_08_01.models.OutboundRule]
        :keyword resource_guid: The resource GUID property of the load balancer resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_rules = outbound_rules
        self.resource_guid = resource_guid
        self.provisioning_state = None


class LoadBalancerBackendAddressPoolListResult(_serialization.Model):
    """Response for ListBackendAddressPool API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of backend address pools in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.BackendAddressPool]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BackendAddressPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.BackendAddressPool"]] = None, **kwargs):
        """
        :keyword value: A list of backend address pools in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.BackendAddressPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerFrontendIPConfigurationListResult(_serialization.Model):
    """Response for ListFrontendIPConfiguration API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of frontend IP configurations in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FrontendIPConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FrontendIPConfiguration"]] = None, **kwargs):
        """
        :keyword value: A list of frontend IP configurations in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerListResult(_serialization.Model):
    """Response for ListLoadBalancers API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancers in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancer"]] = None, **kwargs):
        """
        :keyword value: A list of load balancers in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerLoadBalancingRuleListResult(_serialization.Model):
    """Response for ListLoadBalancingRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancing rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancingRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancingRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancingRule"]] = None, **kwargs):
        """
        :keyword value: A list of load balancing rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancingRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerOutboundRuleListResult(_serialization.Model):
    """Response for ListOutboundRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of outbound rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.OutboundRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.OutboundRule"]] = None, **kwargs):
        """
        :keyword value: A list of outbound rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.OutboundRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerProbeListResult(_serialization.Model):
    """Response for ListProbe API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of probes in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.Probe]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Probe]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Probe"]] = None, **kwargs):
        """
        :keyword value: A list of probes in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.Probe]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerSku(_serialization.Model):
    """SKU of a load balancer.

    :ivar name: Name of a load balancer SKU. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.LoadBalancerSkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.LoadBalancerSkuName"]] = None, **kwargs):
        """
        :keyword name: Name of a load balancer SKU. Known values are: "Basic" and "Standard".
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.LoadBalancerSkuName
        """
        super().__init__(**kwargs)
        self.name = name


class LoadBalancingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """A load balancing rule for a load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of load balancing rules used
     by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar probe: The reference of the load balancer probe used by the load balancing rule.
    :vartype probe: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar protocol: The reference to the transport protocol used by the load balancing rule. Known
     values are: "Udp", "Tcp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.TransportProtocol
    :ivar load_distribution: The load distribution policy for this rule. Known values are:
     "Default", "SourceIP", and "SourceIPProtocol".
    :vartype load_distribution: str or ~azure.mgmt.network.v2019_08_01.models.LoadDistribution
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0
     enables "Any Port".
    :vartype frontend_port: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 0 and 65535. Note that value 0 enables "Any Port".
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the
     publicIP address specified in the frontend of the load balancing rule.
    :vartype disable_outbound_snat: bool
    :ivar provisioning_state: The provisioning state of the load balancing rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "load_distribution": {"key": "properties.loadDistribution", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "disable_outbound_snat": {"key": "properties.disableOutboundSnat", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        probe: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        load_distribution: Optional[Union[str, "_models.LoadDistribution"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        disable_outbound_snat: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of load balancing rules
         used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword probe: The reference of the load balancer probe used by the load balancing rule.
        :paramtype probe: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the load balancing rule.
         Known values are: "Udp", "Tcp", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.TransportProtocol
        :keyword load_distribution: The load distribution policy for this rule. Known values are:
         "Default", "SourceIP", and "SourceIPProtocol".
        :paramtype load_distribution: str or ~azure.mgmt.network.v2019_08_01.models.LoadDistribution
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0
         enables "Any Port".
        :paramtype frontend_port: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 0 and 65535. Note that value 0 enables "Any Port".
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        :keyword disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the
         publicIP address specified in the frontend of the load balancing rule.
        :paramtype disable_outbound_snat: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.disable_outbound_snat = disable_outbound_snat
        self.provisioning_state = None


class LocalNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar local_network_address_space: Local network site address space.
    :vartype local_network_address_space: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
    :ivar gateway_ip_address: IP address of local network gateway.
    :vartype gateway_ip_address: str
    :ivar bgp_settings: Local network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.v2019_08_01.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the local network gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the local network gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "local_network_address_space": {"key": "properties.localNetworkAddressSpace", "type": "AddressSpace"},
        "gateway_ip_address": {"key": "properties.gatewayIpAddress", "type": "str"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        local_network_address_space: Optional["_models.AddressSpace"] = None,
        gateway_ip_address: Optional[str] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword local_network_address_space: Local network site address space.
        :paramtype local_network_address_space: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
        :keyword gateway_ip_address: IP address of local network gateway.
        :paramtype gateway_ip_address: str
        :keyword bgp_settings: Local network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.v2019_08_01.models.BgpSettings
        :keyword resource_guid: The resource GUID property of the local network gateway resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = None


class LocalNetworkGatewayListResult(_serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of local network gateways that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.LocalNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LocalNetworkGateway"]] = None, **kwargs):
        """
        :keyword value: A list of local network gateways that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.LocalNetworkGateway]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LogSpecification(_serialization.Model):
    """Description of logging specification.

    :ivar name: The name of the specification.
    :vartype name: str
    :ivar display_name: The display name of the specification.
    :vartype display_name: str
    :ivar blob_duration: Duration of the blob.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the specification.
        :paramtype name: str
        :keyword display_name: The display name of the specification.
        :paramtype display_name: str
        :keyword blob_duration: Duration of the blob.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedRuleGroupOverride(_serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: Describes the managed rule group to override. Required.
    :vartype rule_group_name: str
    :ivar rules: List of rules that will be disabled. If none specified, all rules in the group
     will be disabled.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.ManagedRuleOverride]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[ManagedRuleOverride]"},
    }

    def __init__(self, *, rule_group_name: str, rules: Optional[List["_models.ManagedRuleOverride"]] = None, **kwargs):
        """
        :keyword rule_group_name: Describes the managed rule group to override. Required.
        :paramtype rule_group_name: str
        :keyword rules: List of rules that will be disabled. If none specified, all rules in the group
         will be disabled.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.ManagedRuleOverride]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ManagedRuleOverride(_serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_id: Identifier for the managed rule. Required.
    :vartype rule_id: str
    :ivar state: Describes the state of the managed rule. Defaults to Disabled if not specified.
     "Disabled"
    :vartype state: str or ~azure.mgmt.network.v2019_08_01.models.ManagedRuleEnabledState
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self, *, rule_id: str, state: Optional[Union[str, "_models.ManagedRuleEnabledState"]] = None, **kwargs
    ):
        """
        :keyword rule_id: Identifier for the managed rule. Required.
        :paramtype rule_id: str
        :keyword state: Describes the state of the managed rule. Defaults to Disabled if not specified.
         "Disabled"
        :paramtype state: str or ~azure.mgmt.network.v2019_08_01.models.ManagedRuleEnabledState
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.state = state


class ManagedRulesDefinition(_serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :ivar exclusions: Describes the Exclusions that are applied on the policy.
    :vartype exclusions: list[~azure.mgmt.network.v2019_08_01.models.OwaspCrsExclusionEntry]
    :ivar managed_rule_sets: Describes the ruleSets that are associated with the policy. Required.
    :vartype managed_rule_sets: list[~azure.mgmt.network.v2019_08_01.models.ManagedRuleSet]
    """

    _validation = {
        "managed_rule_sets": {"required": True},
    }

    _attribute_map = {
        "exclusions": {"key": "exclusions", "type": "[OwaspCrsExclusionEntry]"},
        "managed_rule_sets": {"key": "managedRuleSets", "type": "[ManagedRuleSet]"},
    }

    def __init__(
        self,
        *,
        managed_rule_sets: List["_models.ManagedRuleSet"],
        exclusions: Optional[List["_models.OwaspCrsExclusionEntry"]] = None,
        **kwargs
    ):
        """
        :keyword exclusions: Describes the Exclusions that are applied on the policy.
        :paramtype exclusions: list[~azure.mgmt.network.v2019_08_01.models.OwaspCrsExclusionEntry]
        :keyword managed_rule_sets: Describes the ruleSets that are associated with the policy.
         Required.
        :paramtype managed_rule_sets: list[~azure.mgmt.network.v2019_08_01.models.ManagedRuleSet]
        """
        super().__init__(**kwargs)
        self.exclusions = exclusions
        self.managed_rule_sets = managed_rule_sets


class ManagedRuleSet(_serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_set_type: Defines the rule set type to use. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: Defines the version of the rule set to use. Required.
    :vartype rule_set_version: str
    :ivar rule_group_overrides: Defines the rule group overrides to apply to the rule set.
    :vartype rule_group_overrides:
     list[~azure.mgmt.network.v2019_08_01.models.ManagedRuleGroupOverride]
    """

    _validation = {
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
    }

    _attribute_map = {
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "rule_group_overrides": {"key": "ruleGroupOverrides", "type": "[ManagedRuleGroupOverride]"},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        rule_group_overrides: Optional[List["_models.ManagedRuleGroupOverride"]] = None,
        **kwargs
    ):
        """
        :keyword rule_set_type: Defines the rule set type to use. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: Defines the version of the rule set to use. Required.
        :paramtype rule_set_version: str
        :keyword rule_group_overrides: Defines the rule group overrides to apply to the rule set.
        :paramtype rule_group_overrides:
         list[~azure.mgmt.network.v2019_08_01.models.ManagedRuleGroupOverride]
        """
        super().__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_group_overrides = rule_group_overrides


class ManagedServiceIdentity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity. This property will only
     be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     includes both an implicitly created identity and a set of user assigned identities. The type
     'None' will remove any identities from the virtual machine. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with resource. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.network.v2019_08_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[
            Dict[
                str,
                "_models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties",
            ]
        ] = None,
        **kwargs
    ):
        """
        :keyword type: The type of identity used for the resource. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove any identities from the virtual machine. Known values
         are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.network.v2019_08_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with resource. The
         user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.network.v2019_08_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MatchCondition(_serialization.Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar match_variables: List of match variables. Required.
    :vartype match_variables: list[~azure.mgmt.network.v2019_08_01.models.MatchVariable]
    :ivar operator: Describes operator to be matched. Required. Known values are: "IPMatch",
     "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual",
     "BeginsWith", "EndsWith", and "Regex".
    :vartype operator: str or ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallOperator
    :ivar negation_conditon: Describes if this is negate condition or not.
    :vartype negation_conditon: bool
    :ivar match_values: Match value. Required.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or
     ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallTransform]
    """

    _validation = {
        "match_variables": {"required": True},
        "operator": {"required": True},
        "match_values": {"required": True},
    }

    _attribute_map = {
        "match_variables": {"key": "matchVariables", "type": "[MatchVariable]"},
        "operator": {"key": "operator", "type": "str"},
        "negation_conditon": {"key": "negationConditon", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        match_variables: List["_models.MatchVariable"],
        operator: Union[str, "_models.WebApplicationFirewallOperator"],
        match_values: List[str],
        negation_conditon: Optional[bool] = None,
        transforms: Optional[List[Union[str, "_models.WebApplicationFirewallTransform"]]] = None,
        **kwargs
    ):
        """
        :keyword match_variables: List of match variables. Required.
        :paramtype match_variables: list[~azure.mgmt.network.v2019_08_01.models.MatchVariable]
        :keyword operator: Describes operator to be matched. Required. Known values are: "IPMatch",
         "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual",
         "BeginsWith", "EndsWith", and "Regex".
        :paramtype operator: str or
         ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallOperator
        :keyword negation_conditon: Describes if this is negate condition or not.
        :paramtype negation_conditon: bool
        :keyword match_values: Match value. Required.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or
         ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallTransform]
        """
        super().__init__(**kwargs)
        self.match_variables = match_variables
        self.operator = operator
        self.negation_conditon = negation_conditon
        self.match_values = match_values
        self.transforms = transforms


class MatchedRule(_serialization.Model):
    """Matched rule.

    :ivar rule_name: Name of the matched network security rule.
    :vartype rule_name: str
    :ivar action: The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'.
    :vartype action: str
    """

    _attribute_map = {
        "rule_name": {"key": "ruleName", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(self, *, rule_name: Optional[str] = None, action: Optional[str] = None, **kwargs):
        """
        :keyword rule_name: Name of the matched network security rule.
        :paramtype rule_name: str
        :keyword action: The network traffic is allowed or denied. Possible values are 'Allow' and
         'Deny'.
        :paramtype action: str
        """
        super().__init__(**kwargs)
        self.rule_name = rule_name
        self.action = action


class MatchVariable(_serialization.Model):
    """Define match variables.

    All required parameters must be populated in order to send to Azure.

    :ivar variable_name: Match Variable. Required. Known values are: "RemoteAddr", "RequestMethod",
     "QueryString", "PostArgs", "RequestUri", "RequestHeaders", "RequestBody", and "RequestCookies".
    :vartype variable_name: str or
     ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallMatchVariable
    :ivar selector: Describes field of the matchVariable collection.
    :vartype selector: str
    """

    _validation = {
        "variable_name": {"required": True},
    }

    _attribute_map = {
        "variable_name": {"key": "variableName", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
    }

    def __init__(
        self,
        *,
        variable_name: Union[str, "_models.WebApplicationFirewallMatchVariable"],
        selector: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword variable_name: Match Variable. Required. Known values are: "RemoteAddr",
         "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeaders", "RequestBody", and
         "RequestCookies".
        :paramtype variable_name: str or
         ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallMatchVariable
        :keyword selector: Describes field of the matchVariable collection.
        :paramtype selector: str
        """
        super().__init__(**kwargs)
        self.variable_name = variable_name
        self.selector = selector


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Description of metrics specification.

    :ivar name: The name of the metric.
    :vartype name: str
    :ivar display_name: The display name of the metric.
    :vartype display_name: str
    :ivar display_description: The description of the metric.
    :vartype display_description: str
    :ivar unit: Units the metric to be displayed in.
    :vartype unit: str
    :ivar aggregation_type: The aggregation type.
    :vartype aggregation_type: str
    :ivar availabilities: List of availability.
    :vartype availabilities: list[~azure.mgmt.network.v2019_08_01.models.Availability]
    :ivar enable_regional_mdm_account: Whether regional MDM account enabled.
    :vartype enable_regional_mdm_account: bool
    :ivar fill_gap_with_zero: Whether gaps would be filled with zeros.
    :vartype fill_gap_with_zero: bool
    :ivar metric_filter_pattern: Pattern for the filter of the metric.
    :vartype metric_filter_pattern: str
    :ivar dimensions: List of dimensions.
    :vartype dimensions: list[~azure.mgmt.network.v2019_08_01.models.Dimension]
    :ivar is_internal: Whether the metric is internal.
    :vartype is_internal: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar resource_id_dimension_name_override: The resource Id dimension name override.
    :vartype resource_id_dimension_name_override: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[Availability]"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        availabilities: Optional[List["_models.Availability"]] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        fill_gap_with_zero: Optional[bool] = None,
        metric_filter_pattern: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        is_internal: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the metric.
        :paramtype name: str
        :keyword display_name: The display name of the metric.
        :paramtype display_name: str
        :keyword display_description: The description of the metric.
        :paramtype display_description: str
        :keyword unit: Units the metric to be displayed in.
        :paramtype unit: str
        :keyword aggregation_type: The aggregation type.
        :paramtype aggregation_type: str
        :keyword availabilities: List of availability.
        :paramtype availabilities: list[~azure.mgmt.network.v2019_08_01.models.Availability]
        :keyword enable_regional_mdm_account: Whether regional MDM account enabled.
        :paramtype enable_regional_mdm_account: bool
        :keyword fill_gap_with_zero: Whether gaps would be filled with zeros.
        :paramtype fill_gap_with_zero: bool
        :keyword metric_filter_pattern: Pattern for the filter of the metric.
        :paramtype metric_filter_pattern: str
        :keyword dimensions: List of dimensions.
        :paramtype dimensions: list[~azure.mgmt.network.v2019_08_01.models.Dimension]
        :keyword is_internal: Whether the metric is internal.
        :paramtype is_internal: bool
        :keyword source_mdm_account: The source MDM account.
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace: The source MDM namespace.
        :paramtype source_mdm_namespace: str
        :keyword resource_id_dimension_name_override: The resource Id dimension name override.
        :paramtype resource_id_dimension_name_override: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.fill_gap_with_zero = fill_gap_with_zero
        self.metric_filter_pattern = metric_filter_pattern
        self.dimensions = dimensions
        self.is_internal = is_internal
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NatGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """Nat Gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The nat gateway SKU.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.NatGatewaySku
    :ivar zones: A list of availability zones denoting the zone in which Nat Gateway should be
     deployed.
    :vartype zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar idle_timeout_in_minutes: The idle timeout of the nat gateway.
    :vartype idle_timeout_in_minutes: int
    :ivar public_ip_addresses: An array of public ip addresses associated with the nat gateway
     resource.
    :vartype public_ip_addresses: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar public_ip_prefixes: An array of public ip prefixes associated with the nat gateway
     resource.
    :vartype public_ip_prefixes: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar subnets: An array of references to the subnets using this nat gateway resource.
    :vartype subnets: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar resource_guid: The resource GUID property of the NAT gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the NAT gateway resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "subnets": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "NatGatewaySku"},
        "zones": {"key": "zones", "type": "[str]"},
        "etag": {"key": "etag", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "public_ip_addresses": {"key": "properties.publicIpAddresses", "type": "[SubResource]"},
        "public_ip_prefixes": {"key": "properties.publicIpPrefixes", "type": "[SubResource]"},
        "subnets": {"key": "properties.subnets", "type": "[SubResource]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.NatGatewaySku"] = None,
        zones: Optional[List[str]] = None,
        etag: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        public_ip_addresses: Optional[List["_models.SubResource"]] = None,
        public_ip_prefixes: Optional[List["_models.SubResource"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The nat gateway SKU.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.NatGatewaySku
        :keyword zones: A list of availability zones denoting the zone in which Nat Gateway should be
         deployed.
        :paramtype zones: list[str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword idle_timeout_in_minutes: The idle timeout of the nat gateway.
        :paramtype idle_timeout_in_minutes: int
        :keyword public_ip_addresses: An array of public ip addresses associated with the nat gateway
         resource.
        :paramtype public_ip_addresses: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword public_ip_prefixes: An array of public ip prefixes associated with the nat gateway
         resource.
        :paramtype public_ip_prefixes: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword resource_guid: The resource GUID property of the NAT gateway resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.zones = zones
        self.etag = etag
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.public_ip_addresses = public_ip_addresses
        self.public_ip_prefixes = public_ip_prefixes
        self.subnets = None
        self.resource_guid = resource_guid
        self.provisioning_state = None


class NatGatewayListResult(_serialization.Model):
    """Response for ListNatGateways API service call.

    :ivar value: A list of Nat Gateways that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NatGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NatGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NatGateway"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of Nat Gateways that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NatGateway]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NatGatewaySku(_serialization.Model):
    """SKU of nat gateway.

    :ivar name: Name of Nat Gateway SKU. "Standard"
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.NatGatewaySkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.NatGatewaySkuName"]] = None, **kwargs):
        """
        :keyword name: Name of Nat Gateway SKU. "Standard"
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.NatGatewaySkuName
        """
        super().__init__(**kwargs)
        self.name = name


class NetworkConfigurationDiagnosticParameters(_serialization.Model):
    """Parameters to get network configuration diagnostic.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The ID of the target resource to perform network configuration
     diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application
     Gateway. Required.
    :vartype target_resource_id: str
    :ivar verbosity_level: Verbosity level. Known values are: "Normal", "Minimum", and "Full".
    :vartype verbosity_level: str or ~azure.mgmt.network.v2019_08_01.models.VerbosityLevel
    :ivar profiles: List of network configuration diagnostic profiles. Required.
    :vartype profiles:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkConfigurationDiagnosticProfile]
    """

    _validation = {
        "target_resource_id": {"required": True},
        "profiles": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "verbosity_level": {"key": "verbosityLevel", "type": "str"},
        "profiles": {"key": "profiles", "type": "[NetworkConfigurationDiagnosticProfile]"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        profiles: List["_models.NetworkConfigurationDiagnosticProfile"],
        verbosity_level: Optional[Union[str, "_models.VerbosityLevel"]] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The ID of the target resource to perform network configuration
         diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application
         Gateway. Required.
        :paramtype target_resource_id: str
        :keyword verbosity_level: Verbosity level. Known values are: "Normal", "Minimum", and "Full".
        :paramtype verbosity_level: str or ~azure.mgmt.network.v2019_08_01.models.VerbosityLevel
        :keyword profiles: List of network configuration diagnostic profiles. Required.
        :paramtype profiles:
         list[~azure.mgmt.network.v2019_08_01.models.NetworkConfigurationDiagnosticProfile]
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.verbosity_level = verbosity_level
        self.profiles = profiles


class NetworkConfigurationDiagnosticProfile(_serialization.Model):
    """Parameters to compare with network configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar direction: The direction of the traffic. Required. Known values are: "Inbound" and
     "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2019_08_01.models.Direction
    :ivar protocol: Protocol to be verified on. Accepted values are '*', TCP, UDP. Required.
    :vartype protocol: str
    :ivar source: Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag. Required.
    :vartype source: str
    :ivar destination: Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag.
     Required.
    :vartype destination: str
    :ivar destination_port: Traffic destination port. Accepted values are '*', port (for example,
     3389) and port range (for example, 80-100). Required.
    :vartype destination_port: str
    """

    _validation = {
        "direction": {"required": True},
        "protocol": {"required": True},
        "source": {"required": True},
        "destination": {"required": True},
        "destination_port": {"required": True},
    }

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "destination": {"key": "destination", "type": "str"},
        "destination_port": {"key": "destinationPort", "type": "str"},
    }

    def __init__(
        self,
        *,
        direction: Union[str, "_models.Direction"],
        protocol: str,
        source: str,
        destination: str,
        destination_port: str,
        **kwargs
    ):
        """
        :keyword direction: The direction of the traffic. Required. Known values are: "Inbound" and
         "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2019_08_01.models.Direction
        :keyword protocol: Protocol to be verified on. Accepted values are '*', TCP, UDP. Required.
        :paramtype protocol: str
        :keyword source: Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
         Required.
        :paramtype source: str
        :keyword destination: Traffic destination. Accepted values are: '*', IP Address/CIDR, Service
         Tag. Required.
        :paramtype destination: str
        :keyword destination_port: Traffic destination port. Accepted values are '*', port (for
         example, 3389) and port range (for example, 80-100). Required.
        :paramtype destination_port: str
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.protocol = protocol
        self.source = source
        self.destination = destination
        self.destination_port = destination_port


class NetworkConfigurationDiagnosticResponse(_serialization.Model):
    """Results of network configuration diagnostic on the target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar results: List of network configuration diagnostic results.
    :vartype results:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkConfigurationDiagnosticResult]
    """

    _validation = {
        "results": {"readonly": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[NetworkConfigurationDiagnosticResult]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.results = None


class NetworkConfigurationDiagnosticResult(_serialization.Model):
    """Network configuration diagnostic result corresponded to provided traffic query.

    :ivar profile: Network configuration diagnostic profile.
    :vartype profile: ~azure.mgmt.network.v2019_08_01.models.NetworkConfigurationDiagnosticProfile
    :ivar network_security_group_result: Network security group result.
    :vartype network_security_group_result:
     ~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroupResult
    """

    _attribute_map = {
        "profile": {"key": "profile", "type": "NetworkConfigurationDiagnosticProfile"},
        "network_security_group_result": {"key": "networkSecurityGroupResult", "type": "NetworkSecurityGroupResult"},
    }

    def __init__(
        self,
        *,
        profile: Optional["_models.NetworkConfigurationDiagnosticProfile"] = None,
        network_security_group_result: Optional["_models.NetworkSecurityGroupResult"] = None,
        **kwargs
    ):
        """
        :keyword profile: Network configuration diagnostic profile.
        :paramtype profile:
         ~azure.mgmt.network.v2019_08_01.models.NetworkConfigurationDiagnosticProfile
        :keyword network_security_group_result: Network security group result.
        :paramtype network_security_group_result:
         ~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroupResult
        """
        super().__init__(**kwargs)
        self.profile = profile
        self.network_security_group_result = network_security_group_result


class NetworkIntentPolicy(Resource):
    """Network Intent Policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag


class NetworkIntentPolicyConfiguration(_serialization.Model):
    """Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.

    :ivar network_intent_policy_name: The name of the Network Intent Policy for storing in target
     subscription.
    :vartype network_intent_policy_name: str
    :ivar source_network_intent_policy: Source network intent policy.
    :vartype source_network_intent_policy:
     ~azure.mgmt.network.v2019_08_01.models.NetworkIntentPolicy
    """

    _attribute_map = {
        "network_intent_policy_name": {"key": "networkIntentPolicyName", "type": "str"},
        "source_network_intent_policy": {"key": "sourceNetworkIntentPolicy", "type": "NetworkIntentPolicy"},
    }

    def __init__(
        self,
        *,
        network_intent_policy_name: Optional[str] = None,
        source_network_intent_policy: Optional["_models.NetworkIntentPolicy"] = None,
        **kwargs
    ):
        """
        :keyword network_intent_policy_name: The name of the Network Intent Policy for storing in
         target subscription.
        :paramtype network_intent_policy_name: str
        :keyword source_network_intent_policy: Source network intent policy.
        :paramtype source_network_intent_policy:
         ~azure.mgmt.network.v2019_08_01.models.NetworkIntentPolicy
        """
        super().__init__(**kwargs)
        self.network_intent_policy_name = network_intent_policy_name
        self.source_network_intent_policy = source_network_intent_policy


class NetworkInterface(Resource):  # pylint: disable=too-many-instance-attributes
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_machine: The reference of a virtual machine.
    :vartype virtual_machine: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar network_security_group: The reference of the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroup
    :ivar private_endpoint: A reference to the private endpoint to which the network interface is
     linked.
    :vartype private_endpoint: ~azure.mgmt.network.v2019_08_01.models.PrivateEndpoint
    :ivar ip_configurations: A list of IPConfigurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
    :ivar tap_configurations: A list of TapConfigurations of the network interface.
    :vartype tap_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceTapConfiguration]
    :ivar dns_settings: The DNS settings in network interface.
    :vartype dns_settings: ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceDnsSettings
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar primary: Whether this is a primary network interface on a virtual machine.
    :vartype primary: bool
    :ivar enable_accelerated_networking: If the network interface is accelerated networking
     enabled.
    :vartype enable_accelerated_networking: bool
    :ivar enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :vartype enable_ip_forwarding: bool
    :ivar hosted_workloads: A list of references to linked BareMetal resources.
    :vartype hosted_workloads: list[str]
    :ivar resource_guid: The resource GUID property of the network interface resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network interface resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_machine": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "hosted_workloads": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_machine": {"key": "properties.virtualMachine", "type": "SubResource"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[NetworkInterfaceIPConfiguration]"},
        "tap_configurations": {"key": "properties.tapConfigurations", "type": "[NetworkInterfaceTapConfiguration]"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "NetworkInterfaceDnsSettings"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "hosted_workloads": {"key": "properties.hostedWorkloads", "type": "[str]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        tap_configurations: Optional[List["_models.NetworkInterfaceTapConfiguration"]] = None,
        dns_settings: Optional["_models.NetworkInterfaceDnsSettings"] = None,
        mac_address: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword network_security_group: The reference of the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroup
        :keyword ip_configurations: A list of IPConfigurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
        :keyword tap_configurations: A list of TapConfigurations of the network interface.
        :paramtype tap_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceTapConfiguration]
        :keyword dns_settings: The DNS settings in network interface.
        :paramtype dns_settings: ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceDnsSettings
        :keyword mac_address: The MAC address of the network interface.
        :paramtype mac_address: str
        :keyword primary: Whether this is a primary network interface on a virtual machine.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: If the network interface is accelerated networking
         enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
         interface.
        :paramtype enable_ip_forwarding: bool
        :keyword resource_guid: The resource GUID property of the network interface resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.virtual_machine = None
        self.network_security_group = network_security_group
        self.private_endpoint = None
        self.ip_configurations = ip_configurations
        self.tap_configurations = tap_configurations
        self.dns_settings = dns_settings
        self.mac_address = mac_address
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_ip_forwarding = enable_ip_forwarding
        self.hosted_workloads = None
        self.resource_guid = resource_guid
        self.provisioning_state = None


class NetworkInterfaceAssociation(_serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :ivar security_rules: Collection of custom security rules.
    :vartype security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rules": {"key": "securityRules", "type": "[SecurityRule]"},
    }

    def __init__(self, *, security_rules: Optional[List["_models.SecurityRule"]] = None, **kwargs):
        """
        :keyword security_rules: Collection of custom security rules.
        :paramtype security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class NetworkInterfaceDnsSettings(_serialization.Model):
    """DNS settings of a network interface.

    :ivar dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :vartype dns_servers: list[str]
    :ivar applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :vartype applied_dns_servers: list[str]
    :ivar internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :vartype internal_dns_name_label: str
    :ivar internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in
     the same virtual network.
    :vartype internal_fqdn: str
    :ivar internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry
     is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the
     VM name with the value of internalDomainNameSuffix.
    :vartype internal_domain_name_suffix: str
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "applied_dns_servers": {"key": "appliedDnsServers", "type": "[str]"},
        "internal_dns_name_label": {"key": "internalDnsNameLabel", "type": "str"},
        "internal_fqdn": {"key": "internalFqdn", "type": "str"},
        "internal_domain_name_suffix": {"key": "internalDomainNameSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        applied_dns_servers: Optional[List[str]] = None,
        internal_dns_name_label: Optional[str] = None,
        internal_fqdn: Optional[str] = None,
        internal_domain_name_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to
         azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it
         must be the only value in dnsServers collection.
        :paramtype dns_servers: list[str]
        :keyword applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
         this list will have the union of all DNS servers from all NICs that are part of the
         Availability Set. This property is what is configured on each of those VMs.
        :paramtype applied_dns_servers: list[str]
        :keyword internal_dns_name_label: Relative DNS name for this NIC used for internal
         communications between VMs in the same virtual network.
        :paramtype internal_dns_name_label: str
        :keyword internal_fqdn: Fully qualified DNS name supporting internal communications between VMs
         in the same virtual network.
        :paramtype internal_fqdn: str
        :keyword internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS
         entry is created for the primary NIC of the VM. This DNS name can be constructed by
         concatenating the VM name with the value of internalDomainNameSuffix.
        :paramtype internal_domain_name_suffix: str
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = applied_dns_servers
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = internal_fqdn
        self.internal_domain_name_suffix = internal_domain_name_suffix


class NetworkInterfaceIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """IPConfiguration in a network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_network_taps: The reference to Virtual Network Taps.
    :vartype virtual_network_taps: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkTap]
    :ivar application_gateway_backend_address_pools: The reference of
     ApplicationGatewayBackendAddressPool resource.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool]
    :ivar load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
     resource.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2019_08_01.models.BackendAddressPool]
    :ivar load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :vartype load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2019_08_01.models.InboundNatRule]
    :ivar private_ip_address: Private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
     Default is IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
    :ivar subnet: Subnet bound to the IP configuration.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
    :ivar primary: Whether this is a primary customer address on the network interface.
    :vartype primary: bool
    :ivar public_ip_address: Public IP address bound to the IP configuration.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddress
    :ivar application_security_groups: Application security groups in which the IP configuration is
     included.
    :vartype application_security_groups:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
    :ivar provisioning_state: The provisioning state of the network interface IP configuration.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_link_connection_properties: PrivateLinkConnection properties for the network
     interface.
    :vartype private_link_connection_properties:
     ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "private_link_connection_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_network_taps": {"key": "properties.virtualNetworkTaps", "type": "[VirtualNetworkTap]"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[BackendAddressPool]",
        },
        "load_balancer_inbound_nat_rules": {
            "key": "properties.loadBalancerInboundNatRules",
            "type": "[InboundNatRule]",
        },
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "application_security_groups": {
            "key": "properties.applicationSecurityGroups",
            "type": "[ApplicationSecurityGroup]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_connection_properties": {
            "key": "properties.privateLinkConnectionProperties",
            "type": "NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        virtual_network_taps: Optional[List["_models.VirtualNetworkTap"]] = None,
        application_gateway_backend_address_pools: Optional[
            List["_models.ApplicationGatewayBackendAddressPool"]
        ] = None,
        load_balancer_backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancer_inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        primary: Optional[bool] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        application_security_groups: Optional[List["_models.ApplicationSecurityGroup"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword virtual_network_taps: The reference to Virtual Network Taps.
        :paramtype virtual_network_taps: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkTap]
        :keyword application_gateway_backend_address_pools: The reference of
         ApplicationGatewayBackendAddressPool resource.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationGatewayBackendAddressPool]
        :keyword load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
         resource.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.network.v2019_08_01.models.BackendAddressPool]
        :keyword load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :paramtype load_balancer_inbound_nat_rules:
         list[~azure.mgmt.network.v2019_08_01.models.InboundNatRule]
        :keyword private_ip_address: Private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
         Default is IPv4. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
        :keyword subnet: Subnet bound to the IP configuration.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
        :keyword primary: Whether this is a primary customer address on the network interface.
        :paramtype primary: bool
        :keyword public_ip_address: Public IP address bound to the IP configuration.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddress
        :keyword application_security_groups: Application security groups in which the IP configuration
         is included.
        :paramtype application_security_groups:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.virtual_network_taps = virtual_network_taps
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.application_security_groups = application_security_groups
        self.provisioning_state = None
        self.private_link_connection_properties = None


class NetworkInterfaceIPConfigurationListResult(_serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ip configurations.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterfaceIPConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None, **kwargs):
        """
        :keyword value: A list of ip configurations.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties(_serialization.Model):
    """PrivateLinkConnection properties for the network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The group ID for current private link connection.
    :vartype group_id: str
    :ivar required_member_name: The required member name for current private link connection.
    :vartype required_member_name: str
    :ivar fqdns: List of FQDNs for current private link connection.
    :vartype fqdns: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_member_name": {"readonly": True},
        "fqdns": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_member_name": {"key": "requiredMemberName", "type": "str"},
        "fqdns": {"key": "fqdns", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_member_name = None
        self.fqdns = None


class NetworkInterfaceListResult(_serialization.Model):
    """Response for the ListNetworkInterface API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of network interfaces in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterface]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterface]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkInterface"]] = None, **kwargs):
        """
        :keyword value: A list of network interfaces in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceLoadBalancerListResult(_serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancers.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancer"]] = None, **kwargs):
        """
        :keyword value: A list of load balancers.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.LoadBalancer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceTapConfiguration(SubResource):
    """Tap configuration in a Network Interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar virtual_network_tap: The reference of the Virtual Network Tap resource.
    :vartype virtual_network_tap: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkTap
    :ivar provisioning_state: The provisioning state of the network interface tap configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_network_tap": {"key": "properties.virtualNetworkTap", "type": "VirtualNetworkTap"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        virtual_network_tap: Optional["_models.VirtualNetworkTap"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword virtual_network_tap: The reference of the Virtual Network Tap resource.
        :paramtype virtual_network_tap: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkTap
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.virtual_network_tap = virtual_network_tap
        self.provisioning_state = None


class NetworkInterfaceTapConfigurationListResult(_serialization.Model):
    """Response for list tap configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of tap configurations.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceTapConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterfaceTapConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkInterfaceTapConfiguration"]] = None, **kwargs):
        """
        :keyword value: A list of tap configurations.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceTapConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkProfile(Resource):
    """Network profile resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interfaces: List of child container network interfaces.
    :vartype container_network_interfaces:
     list[~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterface]
    :ivar container_network_interface_configurations: List of chid container network interface
     configurations.
    :vartype container_network_interface_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterfaceConfiguration]
    :ivar resource_guid: The resource GUID property of the network profile resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network profile resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "container_network_interfaces": {
            "key": "properties.containerNetworkInterfaces",
            "type": "[ContainerNetworkInterface]",
        },
        "container_network_interface_configurations": {
            "key": "properties.containerNetworkInterfaceConfigurations",
            "type": "[ContainerNetworkInterfaceConfiguration]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        container_network_interfaces: Optional[List["_models.ContainerNetworkInterface"]] = None,
        container_network_interface_configurations: Optional[
            List["_models.ContainerNetworkInterfaceConfiguration"]
        ] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword container_network_interfaces: List of child container network interfaces.
        :paramtype container_network_interfaces:
         list[~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterface]
        :keyword container_network_interface_configurations: List of chid container network interface
         configurations.
        :paramtype container_network_interface_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.ContainerNetworkInterfaceConfiguration]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.container_network_interfaces = container_network_interfaces
        self.container_network_interface_configurations = container_network_interface_configurations
        self.resource_guid = None
        self.provisioning_state = None


class NetworkProfileListResult(_serialization.Model):
    """Response for ListNetworkProfiles API service call.

    :ivar value: A list of network profiles that exist in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkProfile]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkProfile"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of network profiles that exist in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkProfile]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type network.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the rule condition.
    :vartype name: str
    :ivar description: Description of the rule condition.
    :vartype description: str
    :ivar rule_condition_type: Rule Condition Type. Required. Known values are:
     "ApplicationRuleCondition" and "NetworkRuleCondition".
    :vartype rule_condition_type: str or
     ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionType
    :ivar ip_protocols: Array of FirewallPolicyRuleConditionNetworkProtocols.
    :vartype ip_protocols: list[str or
     ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionNetworkProtocol]
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses or Service Tags.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    """

    _validation = {
        "rule_condition_type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rule_condition_type": {"key": "ruleConditionType", "type": "str"},
        "ip_protocols": {"key": "ipProtocols", "type": "[str]"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        ip_protocols: Optional[List[Union[str, "_models.FirewallPolicyRuleConditionNetworkProtocol"]]] = None,
        source_addresses: Optional[List[str]] = None,
        destination_addresses: Optional[List[str]] = None,
        destination_ports: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the rule condition.
        :paramtype name: str
        :keyword description: Description of the rule condition.
        :paramtype description: str
        :keyword ip_protocols: Array of FirewallPolicyRuleConditionNetworkProtocols.
        :paramtype ip_protocols: list[str or
         ~azure.mgmt.network.v2019_08_01.models.FirewallPolicyRuleConditionNetworkProtocol]
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses or Service Tags.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        """
        super().__init__(name=name, description=description, **kwargs)
        self.rule_condition_type = "NetworkRuleCondition"  # type: str
        self.ip_protocols = ip_protocols
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports


class NetworkSecurityGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar security_rules: A collection of security rules of the network security group.
    :vartype security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
    :ivar default_security_rules: The default security rules of network security group.
    :vartype default_security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
    :ivar resource_guid: The resource GUID property of the network security group resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network security group resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "subnets": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "security_rules": {"key": "properties.securityRules", "type": "[SecurityRule]"},
        "default_security_rules": {"key": "properties.defaultSecurityRules", "type": "[SecurityRule]"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        security_rules: Optional[List["_models.SecurityRule"]] = None,
        default_security_rules: Optional[List["_models.SecurityRule"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword security_rules: A collection of security rules of the network security group.
        :paramtype security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
        :keyword default_security_rules: The default security rules of network security group.
        :paramtype default_security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
        :keyword resource_guid: The resource GUID property of the network security group resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = None
        self.subnets = None
        self.resource_guid = resource_guid
        self.provisioning_state = None


class NetworkSecurityGroupListResult(_serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :ivar value: A list of NetworkSecurityGroup resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkSecurityGroup"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of NetworkSecurityGroup resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroup]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkSecurityGroupResult(_serialization.Model):
    """Network configuration diagnostic result corresponded provided traffic query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar security_rule_access_result: The network traffic is allowed or denied. Known values are:
     "Allow" and "Deny".
    :vartype security_rule_access_result: str or
     ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAccess
    :ivar evaluated_network_security_groups: List of results network security groups diagnostic.
    :vartype evaluated_network_security_groups:
     list[~azure.mgmt.network.v2019_08_01.models.EvaluatedNetworkSecurityGroup]
    """

    _validation = {
        "evaluated_network_security_groups": {"readonly": True},
    }

    _attribute_map = {
        "security_rule_access_result": {"key": "securityRuleAccessResult", "type": "str"},
        "evaluated_network_security_groups": {
            "key": "evaluatedNetworkSecurityGroups",
            "type": "[EvaluatedNetworkSecurityGroup]",
        },
    }

    def __init__(
        self, *, security_rule_access_result: Optional[Union[str, "_models.SecurityRuleAccess"]] = None, **kwargs
    ):
        """
        :keyword security_rule_access_result: The network traffic is allowed or denied. Known values
         are: "Allow" and "Deny".
        :paramtype security_rule_access_result: str or
         ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAccess
        """
        super().__init__(**kwargs)
        self.security_rule_access_result = security_rule_access_result
        self.evaluated_network_security_groups = None


class NetworkSecurityRulesEvaluationResult(_serialization.Model):
    """Network security rules evaluation result.

    :ivar name: Name of the network security rule.
    :vartype name: str
    :ivar protocol_matched: Value indicating whether protocol is matched.
    :vartype protocol_matched: bool
    :ivar source_matched: Value indicating whether source is matched.
    :vartype source_matched: bool
    :ivar source_port_matched: Value indicating whether source port is matched.
    :vartype source_port_matched: bool
    :ivar destination_matched: Value indicating whether destination is matched.
    :vartype destination_matched: bool
    :ivar destination_port_matched: Value indicating whether destination port is matched.
    :vartype destination_port_matched: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol_matched": {"key": "protocolMatched", "type": "bool"},
        "source_matched": {"key": "sourceMatched", "type": "bool"},
        "source_port_matched": {"key": "sourcePortMatched", "type": "bool"},
        "destination_matched": {"key": "destinationMatched", "type": "bool"},
        "destination_port_matched": {"key": "destinationPortMatched", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol_matched: Optional[bool] = None,
        source_matched: Optional[bool] = None,
        source_port_matched: Optional[bool] = None,
        destination_matched: Optional[bool] = None,
        destination_port_matched: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the network security rule.
        :paramtype name: str
        :keyword protocol_matched: Value indicating whether protocol is matched.
        :paramtype protocol_matched: bool
        :keyword source_matched: Value indicating whether source is matched.
        :paramtype source_matched: bool
        :keyword source_port_matched: Value indicating whether source port is matched.
        :paramtype source_port_matched: bool
        :keyword destination_matched: Value indicating whether destination is matched.
        :paramtype destination_matched: bool
        :keyword destination_port_matched: Value indicating whether destination port is matched.
        :paramtype destination_port_matched: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol_matched = protocol_matched
        self.source_matched = source_matched
        self.source_port_matched = source_port_matched
        self.destination_matched = destination_matched
        self.destination_port_matched = destination_port_matched


class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the network watcher resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.provisioning_state = None


class NetworkWatcherListResult(_serialization.Model):
    """Response for ListNetworkWatchers API service call.

    :ivar value: List of network watcher resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkWatcher]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkWatcher]"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkWatcher"]] = None, **kwargs):
        """
        :keyword value: List of network watcher resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.NetworkWatcher]
        """
        super().__init__(**kwargs)
        self.value = value


class NextHopParameters(_serialization.Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The resource identifier of the target resource against which the
     action is to be performed. Required.
    :vartype target_resource_id: str
    :ivar source_ip_address: The source IP address. Required.
    :vartype source_ip_address: str
    :ivar destination_ip_address: The destination IP address. Required.
    :vartype destination_ip_address: str
    :ivar target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled
     on any of the nics, then this parameter must be specified. Otherwise optional).
    :vartype target_nic_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "source_ip_address": {"required": True},
        "destination_ip_address": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "source_ip_address": {"key": "sourceIPAddress", "type": "str"},
        "destination_ip_address": {"key": "destinationIPAddress", "type": "str"},
        "target_nic_resource_id": {"key": "targetNicResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        source_ip_address: str,
        destination_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The resource identifier of the target resource against which the
         action is to be performed. Required.
        :paramtype target_resource_id: str
        :keyword source_ip_address: The source IP address. Required.
        :paramtype source_ip_address: str
        :keyword destination_ip_address: The destination IP address. Required.
        :paramtype destination_ip_address: str
        :keyword target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
         enabled on any of the nics, then this parameter must be specified. Otherwise optional).
        :paramtype target_nic_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.source_ip_address = source_ip_address
        self.destination_ip_address = destination_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class NextHopResult(_serialization.Model):
    """The information about next hop from the specified VM.

    :ivar next_hop_type: Next hop type. Known values are: "Internet", "VirtualAppliance",
     "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2019_08_01.models.NextHopType
    :ivar next_hop_ip_address: Next hop IP Address.
    :vartype next_hop_ip_address: str
    :ivar route_table_id: The resource identifier for the route table associated with the route
     being returned. If the route being returned does not correspond to any user created routes then
     this field will be the string 'System Route'.
    :vartype route_table_id: str
    """

    _attribute_map = {
        "next_hop_type": {"key": "nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "str"},
        "route_table_id": {"key": "routeTableId", "type": "str"},
    }

    def __init__(
        self,
        *,
        next_hop_type: Optional[Union[str, "_models.NextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        route_table_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_hop_type: Next hop type. Known values are: "Internet", "VirtualAppliance",
         "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2019_08_01.models.NextHopType
        :keyword next_hop_ip_address: Next hop IP Address.
        :paramtype next_hop_ip_address: str
        :keyword route_table_id: The resource identifier for the route table associated with the route
         being returned. If the route being returned does not correspond to any user created routes then
         this field will be the string 'System Route'.
        :paramtype route_table_id: str
        """
        super().__init__(**kwargs)
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.route_table_id = route_table_id


class Operation(_serialization.Model):
    """Network REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.network.v2019_08_01.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar service_specification: Specification of the service.
    :vartype service_specification:
     ~azure.mgmt.network.v2019_08_01.models.OperationPropertiesFormatServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {
            "key": "properties.serviceSpecification",
            "type": "OperationPropertiesFormatServiceSpecification",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.OperationPropertiesFormatServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.network.v2019_08_01.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword service_specification: Specification of the service.
        :paramtype service_specification:
         ~azure.mgmt.network.v2019_08_01.models.OperationPropertiesFormatServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Network.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of the operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft Network.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of the operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Network operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Network operations supported by the Network resource provider.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of Network operations supported by the Network resource provider.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationPropertiesFormatServiceSpecification(_serialization.Model):
    """Specification of the service.

    :ivar metric_specifications: Operation service specification.
    :vartype metric_specifications:
     list[~azure.mgmt.network.v2019_08_01.models.MetricSpecification]
    :ivar log_specifications: Operation log specification.
    :vartype log_specifications: list[~azure.mgmt.network.v2019_08_01.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications: Operation service specification.
        :paramtype metric_specifications:
         list[~azure.mgmt.network.v2019_08_01.models.MetricSpecification]
        :keyword log_specifications: Operation log specification.
        :paramtype log_specifications: list[~azure.mgmt.network.v2019_08_01.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class OutboundRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Outbound rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of outbound rules used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :vartype allocated_outbound_ports: int
    :ivar frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :vartype frontend_ip_configurations: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the outbound rule resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar protocol: The protocol for the outbound rule in load balancer. Known values are: "Tcp",
     "Udp", and "All".
    :vartype protocol: str or
     ~azure.mgmt.network.v2019_08_01.models.LoadBalancerOutboundRuleProtocol
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection.
    :vartype idle_timeout_in_minutes: int
    """

    _validation = {
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allocated_outbound_ports": {"key": "properties.allocatedOutboundPorts", "type": "int"},
        "frontend_ip_configurations": {"key": "properties.frontendIPConfigurations", "type": "[SubResource]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["_models.SubResource"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.LoadBalancerOutboundRuleProtocol"]] = None,
        enable_tcp_reset: Optional[bool] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of outbound rules used by
         the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :paramtype allocated_outbound_ports: int
        :keyword frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :paramtype frontend_ip_configurations: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
        :keyword backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword protocol: The protocol for the outbound rule in load balancer. Known values are:
         "Tcp", "Udp", and "All".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2019_08_01.models.LoadBalancerOutboundRuleProtocol
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection.
        :paramtype idle_timeout_in_minutes: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = None
        self.protocol = protocol
        self.enable_tcp_reset = enable_tcp_reset
        self.idle_timeout_in_minutes = idle_timeout_in_minutes


class OwaspCrsExclusionEntry(_serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :ivar match_variable: The variable to be excluded. Required. Known values are:
     "RequestHeaderNames", "RequestCookieNames", and "RequestArgNames".
    :vartype match_variable: str or
     ~azure.mgmt.network.v2019_08_01.models.OwaspCrsExclusionEntryMatchVariable
    :ivar selector_match_operator: When matchVariable is a collection, operate on the selector to
     specify which elements in the collection this exclusion applies to. Required. Known values are:
     "Equals", "Contains", "StartsWith", "EndsWith", and "EqualsAny".
    :vartype selector_match_operator: str or
     ~azure.mgmt.network.v2019_08_01.models.OwaspCrsExclusionEntrySelectorMatchOperator
    :ivar selector: When matchVariable is a collection, operator used to specify which elements in
     the collection this exclusion applies to. Required.
    :vartype selector: str
    """

    _validation = {
        "match_variable": {"required": True},
        "selector_match_operator": {"required": True},
        "selector": {"required": True},
    }

    _attribute_map = {
        "match_variable": {"key": "matchVariable", "type": "str"},
        "selector_match_operator": {"key": "selectorMatchOperator", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
    }

    def __init__(
        self,
        *,
        match_variable: Union[str, "_models.OwaspCrsExclusionEntryMatchVariable"],
        selector_match_operator: Union[str, "_models.OwaspCrsExclusionEntrySelectorMatchOperator"],
        selector: str,
        **kwargs
    ):
        """
        :keyword match_variable: The variable to be excluded. Required. Known values are:
         "RequestHeaderNames", "RequestCookieNames", and "RequestArgNames".
        :paramtype match_variable: str or
         ~azure.mgmt.network.v2019_08_01.models.OwaspCrsExclusionEntryMatchVariable
        :keyword selector_match_operator: When matchVariable is a collection, operate on the selector
         to specify which elements in the collection this exclusion applies to. Required. Known values
         are: "Equals", "Contains", "StartsWith", "EndsWith", and "EqualsAny".
        :paramtype selector_match_operator: str or
         ~azure.mgmt.network.v2019_08_01.models.OwaspCrsExclusionEntrySelectorMatchOperator
        :keyword selector: When matchVariable is a collection, operator used to specify which elements
         in the collection this exclusion applies to. Required.
        :paramtype selector: str
        """
        super().__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector


class P2SConnectionConfiguration(SubResource):
    """P2SConnectionConfiguration Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar vpn_client_address_pool: The reference of the address space resource which represents
     Address space for P2S VpnClient.
    :vartype vpn_client_address_pool: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
    :ivar provisioning_state: The provisioning state of the P2SConnectionConfiguration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "vpn_client_address_pool": {"key": "properties.vpnClientAddressPool", "type": "AddressSpace"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        vpn_client_address_pool: Optional["_models.AddressSpace"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword vpn_client_address_pool: The reference of the address space resource which represents
         Address space for P2S VpnClient.
        :paramtype vpn_client_address_pool: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.vpn_client_address_pool = vpn_client_address_pool
        self.provisioning_state = None


class P2SVpnConnectionHealth(_serialization.Model):
    """P2S Vpn connection detailed health written to sas url.

    :ivar sas_url: Returned sas url of the blob to which the p2s vpn connection detailed health
     will be written.
    :vartype sas_url: str
    """

    _attribute_map = {
        "sas_url": {"key": "sasUrl", "type": "str"},
    }

    def __init__(self, *, sas_url: Optional[str] = None, **kwargs):
        """
        :keyword sas_url: Returned sas url of the blob to which the p2s vpn connection detailed health
         will be written.
        :paramtype sas_url: str
        """
        super().__init__(**kwargs)
        self.sas_url = sas_url


class P2SVpnConnectionHealthRequest(_serialization.Model):
    """List of P2S Vpn connection health request.

    :ivar vpn_user_names_filter: The list of p2s vpn user names whose p2s vpn connection detailed
     health to retrieve for.
    :vartype vpn_user_names_filter: list[str]
    :ivar output_blob_sas_url: The sas-url to download the P2S Vpn connection health detail.
    :vartype output_blob_sas_url: str
    """

    _attribute_map = {
        "vpn_user_names_filter": {"key": "vpnUserNamesFilter", "type": "[str]"},
        "output_blob_sas_url": {"key": "outputBlobSasUrl", "type": "str"},
    }

    def __init__(
        self, *, vpn_user_names_filter: Optional[List[str]] = None, output_blob_sas_url: Optional[str] = None, **kwargs
    ):
        """
        :keyword vpn_user_names_filter: The list of p2s vpn user names whose p2s vpn connection
         detailed health to retrieve for.
        :paramtype vpn_user_names_filter: list[str]
        :keyword output_blob_sas_url: The sas-url to download the P2S Vpn connection health detail.
        :paramtype output_blob_sas_url: str
        """
        super().__init__(**kwargs)
        self.vpn_user_names_filter = vpn_user_names_filter
        self.output_blob_sas_url = output_blob_sas_url


class P2SVpnGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """P2SVpnGateway Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_hub: The VirtualHub to which the gateway belongs.
    :vartype virtual_hub: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar p2_s_connection_configurations: List of all p2s connection configurations of the gateway.
    :vartype p2_s_connection_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.P2SConnectionConfiguration]
    :ivar provisioning_state: The provisioning state of the P2S VPN gateway resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
    :vartype vpn_gateway_scale_unit: int
    :ivar vpn_server_configuration: The VpnServerConfiguration to which the p2sVpnGateway is
     attached to.
    :vartype vpn_server_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar vpn_client_connection_health: All P2S VPN clients' connection health status.
    :vartype vpn_client_connection_health:
     ~azure.mgmt.network.v2019_08_01.models.VpnClientConnectionHealth
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "vpn_client_connection_health": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "SubResource"},
        "p2_s_connection_configurations": {
            "key": "properties.p2SConnectionConfigurations",
            "type": "[P2SConnectionConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vpn_gateway_scale_unit": {"key": "properties.vpnGatewayScaleUnit", "type": "int"},
        "vpn_server_configuration": {"key": "properties.vpnServerConfiguration", "type": "SubResource"},
        "vpn_client_connection_health": {
            "key": "properties.vpnClientConnectionHealth",
            "type": "VpnClientConnectionHealth",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_hub: Optional["_models.SubResource"] = None,
        p2_s_connection_configurations: Optional[List["_models.P2SConnectionConfiguration"]] = None,
        vpn_gateway_scale_unit: Optional[int] = None,
        vpn_server_configuration: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_hub: The VirtualHub to which the gateway belongs.
        :paramtype virtual_hub: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword p2_s_connection_configurations: List of all p2s connection configurations of the
         gateway.
        :paramtype p2_s_connection_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.P2SConnectionConfiguration]
        :keyword vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
        :paramtype vpn_gateway_scale_unit: int
        :keyword vpn_server_configuration: The VpnServerConfiguration to which the p2sVpnGateway is
         attached to.
        :paramtype vpn_server_configuration: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.virtual_hub = virtual_hub
        self.p2_s_connection_configurations = p2_s_connection_configurations
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = vpn_gateway_scale_unit
        self.vpn_server_configuration = vpn_server_configuration
        self.vpn_client_connection_health = None


class P2SVpnProfileParameters(_serialization.Model):
    """Vpn Client Parameters for package generation.

    :ivar authentication_method: VPN client authentication method. Known values are: "EAPTLS" and
     "EAPMSCHAPv2".
    :vartype authentication_method: str or
     ~azure.mgmt.network.v2019_08_01.models.AuthenticationMethod
    """

    _attribute_map = {
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
    }

    def __init__(self, *, authentication_method: Optional[Union[str, "_models.AuthenticationMethod"]] = None, **kwargs):
        """
        :keyword authentication_method: VPN client authentication method. Known values are: "EAPTLS"
         and "EAPMSCHAPv2".
        :paramtype authentication_method: str or
         ~azure.mgmt.network.v2019_08_01.models.AuthenticationMethod
        """
        super().__init__(**kwargs)
        self.authentication_method = authentication_method


class PacketCapture(_serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :ivar target: The ID of the targeted resource, only VM is currently supported. Required.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
    """

    _validation = {
        "target": {"required": True},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "properties.target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "properties.storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "properties.filters", "type": "[PacketCaptureFilter]"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        **kwargs
    ):
        """
        :keyword target: The ID of the targeted resource, only VM is currently supported. Required.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
         Required.
        :paramtype storage_location:
         ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
        """
        super().__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureFilter(_serialization.Model):
    """Filter that is applied to packet capture request. Multiple filters can be applied.

    :ivar protocol: Protocol to be filtered on. Known values are: "TCP", "UDP", and "Any".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.PcProtocol
    :ivar local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :vartype local_ip_address: str
    :ivar remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :vartype remote_ip_address: str
    :ivar local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :vartype local_port: str
    :ivar remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :vartype remote_port: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "local_ip_address": {"key": "localIPAddress", "type": "str"},
        "remote_ip_address": {"key": "remoteIPAddress", "type": "str"},
        "local_port": {"key": "localPort", "type": "str"},
        "remote_port": {"key": "remotePort", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Union[str, "_models.PcProtocol"] = "Any",
        local_ip_address: Optional[str] = None,
        remote_ip_address: Optional[str] = None,
        local_port: Optional[str] = None,
        remote_port: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protocol: Protocol to be filtered on. Known values are: "TCP", "UDP", and "Any".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.PcProtocol
        :keyword local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
         address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
         Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
         supported. Default = null.
        :paramtype local_ip_address: str
        :keyword remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for
         single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple
         entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not
         currently supported. Default = null.
        :paramtype remote_ip_address: str
        :keyword local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
         for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
         ranges with multiple entries not currently supported. Default = null.
        :paramtype local_port: str
        :keyword remote_port: Remote port to be filtered on. Notation: "80" for single port
         entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently
         supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :paramtype remote_port: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.local_port = local_port
        self.remote_port = remote_port


class PacketCaptureListResult(_serialization.Model):
    """List of packet capture sessions.

    :ivar value: Information about packet capture sessions.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCaptureResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCaptureResult"]] = None, **kwargs):
        """
        :keyword value: Information about packet capture sessions.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureResult]
        """
        super().__init__(**kwargs)
        self.value = value


class PacketCaptureParameters(_serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :ivar target: The ID of the targeted resource, only VM is currently supported. Required.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
    """

    _validation = {
        "target": {"required": True},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "filters", "type": "[PacketCaptureFilter]"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        **kwargs
    ):
        """
        :keyword target: The ID of the targeted resource, only VM is currently supported. Required.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
         Required.
        :paramtype storage_location:
         ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
        """
        super().__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureQueryStatusResult(_serialization.Model):
    """Status of packet capture session.

    :ivar name: The name of the packet capture resource.
    :vartype name: str
    :ivar id: The ID of the packet capture resource.
    :vartype id: str
    :ivar capture_start_time: The start time of the packet capture session.
    :vartype capture_start_time: ~datetime.datetime
    :ivar packet_capture_status: The status of the packet capture session. Known values are:
     "NotStarted", "Running", "Stopped", "Error", and "Unknown".
    :vartype packet_capture_status: str or ~azure.mgmt.network.v2019_08_01.models.PcStatus
    :ivar stop_reason: The reason the current packet capture session was stopped.
    :vartype stop_reason: str
    :ivar packet_capture_error: List of errors of packet capture session.
    :vartype packet_capture_error: list[str or ~azure.mgmt.network.v2019_08_01.models.PcError]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "capture_start_time": {"key": "captureStartTime", "type": "iso-8601"},
        "packet_capture_status": {"key": "packetCaptureStatus", "type": "str"},
        "stop_reason": {"key": "stopReason", "type": "str"},
        "packet_capture_error": {"key": "packetCaptureError", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        capture_start_time: Optional[datetime.datetime] = None,
        packet_capture_status: Optional[Union[str, "_models.PcStatus"]] = None,
        stop_reason: Optional[str] = None,
        packet_capture_error: Optional[List[Union[str, "_models.PcError"]]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the packet capture resource.
        :paramtype name: str
        :keyword id: The ID of the packet capture resource.
        :paramtype id: str
        :keyword capture_start_time: The start time of the packet capture session.
        :paramtype capture_start_time: ~datetime.datetime
        :keyword packet_capture_status: The status of the packet capture session. Known values are:
         "NotStarted", "Running", "Stopped", "Error", and "Unknown".
        :paramtype packet_capture_status: str or ~azure.mgmt.network.v2019_08_01.models.PcStatus
        :keyword stop_reason: The reason the current packet capture session was stopped.
        :paramtype stop_reason: str
        :keyword packet_capture_error: List of errors of packet capture session.
        :paramtype packet_capture_error: list[str or ~azure.mgmt.network.v2019_08_01.models.PcError]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.capture_start_time = capture_start_time
        self.packet_capture_status = packet_capture_status
        self.stop_reason = stop_reason
        self.packet_capture_error = packet_capture_error


class PacketCaptureResult(_serialization.Model):
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the packet capture session.
    :vartype name: str
    :ivar id: ID of the packet capture operation.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar target: The ID of the targeted resource, only VM is currently supported.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session.
    :vartype storage_location: ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture session. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "target": {"key": "properties.target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "properties.storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "properties.filters", "type": "[PacketCaptureFilter]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: str = "A unique read-only string that changes whenever the resource is updated.",
        target: Optional[str] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        storage_location: Optional["_models.PacketCaptureStorageLocation"] = None,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        **kwargs
    ):
        """
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword target: The ID of the targeted resource, only VM is currently supported.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
        :paramtype storage_location:
         ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = etag
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.provisioning_state = None


class PacketCaptureResultProperties(PacketCaptureParameters):
    """Describes the properties of a packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target: The ID of the targeted resource, only VM is currently supported. Required.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture session. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "target": {"required": True},
        "storage_location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "filters", "type": "[PacketCaptureFilter]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        **kwargs
    ):
        """
        :keyword target: The ID of the targeted resource, only VM is currently supported. Required.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
         Required.
        :paramtype storage_location:
         ~azure.mgmt.network.v2019_08_01.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.v2019_08_01.models.PacketCaptureFilter]
        """
        super().__init__(
            target=target,
            bytes_to_capture_per_packet=bytes_to_capture_per_packet,
            total_bytes_per_session=total_bytes_per_session,
            time_limit_in_seconds=time_limit_in_seconds,
            storage_location=storage_location,
            filters=filters,
            **kwargs
        )
        self.provisioning_state = None


class PacketCaptureStorageLocation(_serialization.Model):
    """Describes the storage location for a packet capture session.

    :ivar storage_id: The ID of the storage account to save the packet capture session. Required if
     no local file path is provided.
    :vartype storage_id: str
    :ivar storage_path: The URI of the storage path to save the packet capture. Must be a
     well-formed URI describing the location to save the packet capture.
    :vartype storage_path: str
    :ivar file_path: A valid local path on the targeting VM. Must include the name of the capture
     file (*.cap). For linux virtual machine it must start with /var/captures. Required if no
     storage ID is provided, otherwise optional.
    :vartype file_path: str
    """

    _attribute_map = {
        "storage_id": {"key": "storageId", "type": "str"},
        "storage_path": {"key": "storagePath", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_id: Optional[str] = None,
        storage_path: Optional[str] = None,
        file_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword storage_id: The ID of the storage account to save the packet capture session. Required
         if no local file path is provided.
        :paramtype storage_id: str
        :keyword storage_path: The URI of the storage path to save the packet capture. Must be a
         well-formed URI describing the location to save the packet capture.
        :paramtype storage_path: str
        :keyword file_path: A valid local path on the targeting VM. Must include the name of the
         capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if
         no storage ID is provided, otherwise optional.
        :paramtype file_path: str
        """
        super().__init__(**kwargs)
        self.storage_id = storage_id
        self.storage_path = storage_path
        self.file_path = file_path


class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar rules: Collection of RouteFilterRules contained within a route filter.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
    :vartype ipv6_peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "rules": {"key": "properties.rules", "type": "[RouteFilterRule]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "ipv6_peerings": {"key": "properties.ipv6Peerings", "type": "[ExpressRouteCircuitPeering]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["_models.RouteFilterRule"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        ipv6_peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rules: Collection of RouteFilterRules contained within a route filter.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.RouteFilterRule]
        :keyword peerings: A collection of references to express route circuit peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
        :keyword ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
        :paramtype ipv6_peerings:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.type = None
        self.tags = tags
        self.rules = rules
        self.peerings = peerings
        self.ipv6_peerings = ipv6_peerings
        self.provisioning_state = None


class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar access: The access type of the rule. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2019_08_01.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. "Community"
    :vartype route_filter_rule_type: str or
     ~azure.mgmt.network.v2019_08_01.models.RouteFilterRuleType
    :ivar communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :vartype communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "access": {"key": "properties.access", "type": "str"},
        "route_filter_rule_type": {"key": "properties.routeFilterRuleType", "type": "str"},
        "communities": {"key": "properties.communities", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        access: Optional[Union[str, "_models.Access"]] = None,
        route_filter_rule_type: Optional[Union[str, "_models.RouteFilterRuleType"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword access: The access type of the rule. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2019_08_01.models.Access
        :keyword route_filter_rule_type: The rule type of the rule. "Community"
        :paramtype route_filter_rule_type: str or
         ~azure.mgmt.network.v2019_08_01.models.RouteFilterRuleType
        :keyword communities: The collection for bgp community values to filter on. e.g.
         ['12076:5010','12076:5020'].
        :paramtype communities: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.access = access
        self.route_filter_rule_type = route_filter_rule_type
        self.communities = communities
        self.provisioning_state = None


class PeerExpressRouteCircuitConnection(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the circuit.
    :vartype express_route_circuit_peering: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the peered circuit.
    :vartype peer_express_route_circuit_peering: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
    :vartype address_prefix: str
    :ivar circuit_connection_status: Express Route Circuit connection state. Known values are:
     "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.v2019_08_01.models.CircuitConnectionStatus
    :ivar connection_name: The name of the express route circuit connection resource.
    :vartype connection_name: str
    :ivar auth_resource_guid: The resource guid of the authorization used for the express route
     circuit connection.
    :vartype auth_resource_guid: str
    :ivar provisioning_state: The provisioning state of the peer express route circuit connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "circuit_connection_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "express_route_circuit_peering": {"key": "properties.expressRouteCircuitPeering", "type": "SubResource"},
        "peer_express_route_circuit_peering": {
            "key": "properties.peerExpressRouteCircuitPeering",
            "type": "SubResource",
        },
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "circuit_connection_status": {"key": "properties.circuitConnectionStatus", "type": "str"},
        "connection_name": {"key": "properties.connectionName", "type": "str"},
        "auth_resource_guid": {"key": "properties.authResourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        express_route_circuit_peering: Optional["_models.SubResource"] = None,
        peer_express_route_circuit_peering: Optional["_models.SubResource"] = None,
        address_prefix: Optional[str] = None,
        connection_name: Optional[str] = None,
        auth_resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the circuit.
        :paramtype express_route_circuit_peering: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the peered circuit.
        :paramtype peer_express_route_circuit_peering:
         ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :paramtype address_prefix: str
        :keyword connection_name: The name of the express route circuit connection resource.
        :paramtype connection_name: str
        :keyword auth_resource_guid: The resource guid of the authorization used for the express route
         circuit connection.
        :paramtype auth_resource_guid: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.peer_express_route_circuit_peering = peer_express_route_circuit_peering
        self.address_prefix = address_prefix
        self.circuit_connection_status = None
        self.connection_name = connection_name
        self.auth_resource_guid = auth_resource_guid
        self.provisioning_state = None


class PeerExpressRouteCircuitConnectionListResult(_serialization.Model):
    """Response for ListPeeredConnections API service call retrieves all global reach peer circuit connections that belongs to a Private Peering for an ExpressRouteCircuit.

    :ivar value: The global reach peer circuit connection associated with Private Peering in an
     ExpressRoute Circuit.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.PeerExpressRouteCircuitConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PeerExpressRouteCircuitConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PeerExpressRouteCircuitConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The global reach peer circuit connection associated with Private Peering in an
         ExpressRoute Circuit.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.PeerExpressRouteCircuitConnection]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySettings(_serialization.Model):
    """Defines contents of a web application firewall global configuration.

    :ivar state: Describes if the policy is in enabled state or disabled state. Known values are:
     "Disabled" and "Enabled".
    :vartype state: str or
     ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallEnabledState
    :ivar mode: Describes if it is in detection mode or prevention mode at policy level. Known
     values are: "Prevention" and "Detection".
    :vartype mode: str or ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallMode
    :ivar request_body_check: Whether to allow WAF to check request Body.
    :vartype request_body_check: bool
    :ivar max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
    :vartype max_request_body_size_in_kb: int
    :ivar file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :vartype file_upload_limit_in_mb: int
    """

    _validation = {
        "max_request_body_size_in_kb": {"maximum": 128, "minimum": 8},
        "file_upload_limit_in_mb": {"minimum": 0},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "request_body_check": {"key": "requestBodyCheck", "type": "bool"},
        "max_request_body_size_in_kb": {"key": "maxRequestBodySizeInKb", "type": "int"},
        "file_upload_limit_in_mb": {"key": "fileUploadLimitInMb", "type": "int"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.WebApplicationFirewallEnabledState"]] = None,
        mode: Optional[Union[str, "_models.WebApplicationFirewallMode"]] = None,
        request_body_check: Optional[bool] = None,
        max_request_body_size_in_kb: Optional[int] = None,
        file_upload_limit_in_mb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword state: Describes if the policy is in enabled state or disabled state. Known values
         are: "Disabled" and "Enabled".
        :paramtype state: str or
         ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallEnabledState
        :keyword mode: Describes if it is in detection mode or prevention mode at policy level. Known
         values are: "Prevention" and "Detection".
        :paramtype mode: str or ~azure.mgmt.network.v2019_08_01.models.WebApplicationFirewallMode
        :keyword request_body_check: Whether to allow WAF to check request Body.
        :paramtype request_body_check: bool
        :keyword max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :paramtype max_request_body_size_in_kb: int
        :keyword file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :paramtype file_upload_limit_in_mb: int
        """
        super().__init__(**kwargs)
        self.state = state
        self.mode = mode
        self.request_body_check = request_body_check
        self.max_request_body_size_in_kb = max_request_body_size_in_kb
        self.file_upload_limit_in_mb = file_upload_limit_in_mb


class PrepareNetworkPoliciesRequest(_serialization.Model):
    """Details of PrepareNetworkPolicies for Subnet.

    :ivar service_name: The name of the service for which subnet is being prepared for.
    :vartype service_name: str
    :ivar network_intent_policy_configurations: A list of NetworkIntentPolicyConfiguration.
    :vartype network_intent_policy_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkIntentPolicyConfiguration]
    """

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "network_intent_policy_configurations": {
            "key": "networkIntentPolicyConfigurations",
            "type": "[NetworkIntentPolicyConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        service_name: Optional[str] = None,
        network_intent_policy_configurations: Optional[List["_models.NetworkIntentPolicyConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword service_name: The name of the service for which subnet is being prepared for.
        :paramtype service_name: str
        :keyword network_intent_policy_configurations: A list of NetworkIntentPolicyConfiguration.
        :paramtype network_intent_policy_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.NetworkIntentPolicyConfiguration]
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.network_intent_policy_configurations = network_intent_policy_configurations


class PrivateEndpoint(Resource):  # pylint: disable=too-many-instance-attributes
    """Private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: The ID of the subnet from which the private IP will be allocated.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
    :ivar network_interfaces: An array of references to the network interfaces created for this
     private endpoint.
    :vartype network_interfaces: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterface]
    :ivar provisioning_state: The provisioning state of the private endpoint resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_link_service_connections: A grouping of information about the connection to the
     remote resource.
    :vartype private_link_service_connections:
     list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnection]
    :ivar manual_private_link_service_connections: A grouping of information about the connection
     to the remote resource. Used when the network admin does not have access to approve connections
     to the remote resource.
    :vartype manual_private_link_service_connections:
     list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnection]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_service_connections": {
            "key": "properties.privateLinkServiceConnections",
            "type": "[PrivateLinkServiceConnection]",
        },
        "manual_private_link_service_connections": {
            "key": "properties.manualPrivateLinkServiceConnections",
            "type": "[PrivateLinkServiceConnection]",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        subnet: Optional["_models.Subnet"] = None,
        private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = None,
        manual_private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword subnet: The ID of the subnet from which the private IP will be allocated.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
        :keyword private_link_service_connections: A grouping of information about the connection to
         the remote resource.
        :paramtype private_link_service_connections:
         list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnection]
        :keyword manual_private_link_service_connections: A grouping of information about the
         connection to the remote resource. Used when the network admin does not have access to approve
         connections to the remote resource.
        :paramtype manual_private_link_service_connections:
         list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnection]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.subnet = subnet
        self.network_interfaces = None
        self.provisioning_state = None
        self.private_link_service_connections = private_link_service_connections
        self.manual_private_link_service_connections = manual_private_link_service_connections


class PrivateEndpointConnection(SubResource):
    """PrivateEndpointConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.network.v2019_08_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.network.v2019_08_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointListResult(_serialization.Model):
    """Response for the ListPrivateEndpoints API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of private endpoint resources in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.PrivateEndpoint]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpoint"]] = None, **kwargs):
        """
        :keyword value: A list of private endpoint resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.PrivateEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkService(Resource):  # pylint: disable=too-many-instance-attributes
    """Private link service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar load_balancer_frontend_ip_configurations: An array of references to the load balancer IP
     configurations.
    :vartype load_balancer_frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration]
    :ivar ip_configurations: An array of private link service IP configurations.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceIpConfiguration]
    :ivar network_interfaces: An array of references to the network interfaces created for this
     private link service.
    :vartype network_interfaces: list[~azure.mgmt.network.v2019_08_01.models.NetworkInterface]
    :ivar provisioning_state: The provisioning state of the private link service resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_endpoint_connections: An array of list about connections to the private endpoint.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.network.v2019_08_01.models.PrivateEndpointConnection]
    :ivar visibility: The visibility list of the private link service.
    :vartype visibility:
     ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServicePropertiesVisibility
    :ivar auto_approval: The auto-approval list of the private link service.
    :vartype auto_approval:
     ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServicePropertiesAutoApproval
    :ivar fqdns: The list of Fqdn.
    :vartype fqdns: list[str]
    :ivar alias: The alias of the private link service.
    :vartype alias: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "alias": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "load_balancer_frontend_ip_configurations": {
            "key": "properties.loadBalancerFrontendIpConfigurations",
            "type": "[FrontendIPConfiguration]",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[PrivateLinkServiceIpConfiguration]"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "visibility": {"key": "properties.visibility", "type": "PrivateLinkServicePropertiesVisibility"},
        "auto_approval": {"key": "properties.autoApproval", "type": "PrivateLinkServicePropertiesAutoApproval"},
        "fqdns": {"key": "properties.fqdns", "type": "[str]"},
        "alias": {"key": "properties.alias", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        load_balancer_frontend_ip_configurations: Optional[List["_models.FrontendIPConfiguration"]] = None,
        ip_configurations: Optional[List["_models.PrivateLinkServiceIpConfiguration"]] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        visibility: Optional["_models.PrivateLinkServicePropertiesVisibility"] = None,
        auto_approval: Optional["_models.PrivateLinkServicePropertiesAutoApproval"] = None,
        fqdns: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword load_balancer_frontend_ip_configurations: An array of references to the load balancer
         IP configurations.
        :paramtype load_balancer_frontend_ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration]
        :keyword ip_configurations: An array of private link service IP configurations.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceIpConfiguration]
        :keyword private_endpoint_connections: An array of list about connections to the private
         endpoint.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.network.v2019_08_01.models.PrivateEndpointConnection]
        :keyword visibility: The visibility list of the private link service.
        :paramtype visibility:
         ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServicePropertiesVisibility
        :keyword auto_approval: The auto-approval list of the private link service.
        :paramtype auto_approval:
         ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServicePropertiesAutoApproval
        :keyword fqdns: The list of Fqdn.
        :paramtype fqdns: list[str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.load_balancer_frontend_ip_configurations = load_balancer_frontend_ip_configurations
        self.ip_configurations = ip_configurations
        self.network_interfaces = None
        self.provisioning_state = None
        self.private_endpoint_connections = private_endpoint_connections
        self.visibility = visibility
        self.auto_approval = auto_approval
        self.fqdns = fqdns
        self.alias = None


class PrivateLinkServiceConnection(SubResource):
    """PrivateLinkServiceConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the private link service connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_link_service_id: The resource id of private link service.
    :vartype private_link_service_id: str
    :ivar group_ids: The ID(s) of the group(s) obtained from the remote resource that this private
     endpoint should connect to.
    :vartype group_ids: list[str]
    :ivar request_message: A message passed to the owner of the remote resource with this
     connection request. Restricted to 140 chars.
    :vartype request_message: str
    :ivar private_link_service_connection_state: A collection of read-only information about the
     state of the connection to the remote resource.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_service_id": {"key": "properties.privateLinkServiceId", "type": "str"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "request_message": {"key": "properties.requestMessage", "type": "str"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_link_service_id: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        request_message: Optional[str] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword private_link_service_id: The resource id of private link service.
        :paramtype private_link_service_id: str
        :keyword group_ids: The ID(s) of the group(s) obtained from the remote resource that this
         private endpoint should connect to.
        :paramtype group_ids: list[str]
        :keyword request_message: A message passed to the owner of the remote resource with this
         connection request. Restricted to 140 chars.
        :paramtype request_message: str
        :keyword private_link_service_connection_state: A collection of read-only information about the
         state of the connection to the remote resource.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.network.v2019_08_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = None
        self.provisioning_state = None
        self.private_link_service_id = private_link_service_id
        self.group_ids = group_ids
        self.request_message = request_message
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service.
    :vartype status: str
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service.
        :paramtype status: str
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkServiceIpConfiguration(SubResource):
    """The private link service ip configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of private link service ip configuration.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
    :ivar primary: Whether the ip configuration is primary or not.
    :vartype primary: bool
    :ivar provisioning_state: The provisioning state of the private link service IP configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
     Default is IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        primary: Optional[bool] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of private link service ip configuration.
        :paramtype name: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.Subnet
        :keyword primary: Whether the ip configuration is primary or not.
        :paramtype primary: bool
        :keyword private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
         Default is IPv4. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.primary = primary
        self.provisioning_state = None
        self.private_ip_address_version = private_ip_address_version


class PrivateLinkServiceListResult(_serialization.Model):
    """Response for the ListPrivateLinkService API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of PrivateLinkService resources in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkService]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkService"]] = None, **kwargs):
        """
        :keyword value: A list of PrivateLinkService resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.PrivateLinkService]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceSet(_serialization.Model):
    """The base resource set for visibility and auto-approval.

    :ivar subscriptions: The list of subscriptions.
    :vartype subscriptions: list[str]
    """

    _attribute_map = {
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
    }

    def __init__(self, *, subscriptions: Optional[List[str]] = None, **kwargs):
        """
        :keyword subscriptions: The list of subscriptions.
        :paramtype subscriptions: list[str]
        """
        super().__init__(**kwargs)
        self.subscriptions = subscriptions


class PrivateLinkServicePropertiesAutoApproval(ResourceSet):
    """The auto-approval list of the private link service.

    :ivar subscriptions: The list of subscriptions.
    :vartype subscriptions: list[str]
    """

    _attribute_map = {
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
    }

    def __init__(self, *, subscriptions: Optional[List[str]] = None, **kwargs):
        """
        :keyword subscriptions: The list of subscriptions.
        :paramtype subscriptions: list[str]
        """
        super().__init__(subscriptions=subscriptions, **kwargs)


class PrivateLinkServicePropertiesVisibility(ResourceSet):
    """The visibility list of the private link service.

    :ivar subscriptions: The list of subscriptions.
    :vartype subscriptions: list[str]
    """

    _attribute_map = {
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
    }

    def __init__(self, *, subscriptions: Optional[List[str]] = None, **kwargs):
        """
        :keyword subscriptions: The list of subscriptions.
        :paramtype subscriptions: list[str]
        """
        super().__init__(subscriptions=subscriptions, **kwargs)


class PrivateLinkServiceVisibility(_serialization.Model):
    """Response for the CheckPrivateLinkServiceVisibility API service call.

    :ivar visible: Private Link Service Visibility (True/False).
    :vartype visible: bool
    """

    _attribute_map = {
        "visible": {"key": "visible", "type": "bool"},
    }

    def __init__(self, *, visible: Optional[bool] = None, **kwargs):
        """
        :keyword visible: Private Link Service Visibility (True/False).
        :paramtype visible: bool
        """
        super().__init__(**kwargs)
        self.visible = visible


class Probe(SubResource):  # pylint: disable=too-many-instance-attributes
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of probes used by the load
     balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is
     required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response
     from the specifies URI is required for the probe to be successful. Known values are: "Http",
     "Tcp", and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ProbeProtocol
    :ivar port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :vartype port: int
    :ivar interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :vartype interval_in_seconds: int
    :ivar number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :vartype number_of_probes: int
    :ivar request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :vartype request_path: str
    :ivar provisioning_state: The provisioning state of the probe resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "interval_in_seconds": {"key": "properties.intervalInSeconds", "type": "int"},
        "number_of_probes": {"key": "properties.numberOfProbes", "type": "int"},
        "request_path": {"key": "properties.requestPath", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ProbeProtocol"]] = None,
        port: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        number_of_probes: Optional[int] = None,
        request_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of probes used by the
         load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is
         required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response
         from the specifies URI is required for the probe to be successful. Known values are: "Http",
         "Tcp", and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.ProbeProtocol
        :keyword port: The port for communicating the probe. Possible values range from 1 to 65535,
         inclusive.
        :paramtype port: int
        :keyword interval_in_seconds: The interval, in seconds, for how frequently to probe the
         endpoint for health status. Typically, the interval is slightly less than half the allocated
         timeout period (in seconds) which allows two full probes before taking the instance out of
         rotation. The default value is 15, the minimum value is 5.
        :paramtype interval_in_seconds: int
        :keyword number_of_probes: The number of probes where if no response, will result in stopping
         further traffic from being delivered to the endpoint. This values allows endpoints to be taken
         out of rotation faster or slower than the typical times used in Azure.
        :paramtype number_of_probes: int
        :keyword request_path: The URI used for requesting health status from the VM. Path is required
         if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        :paramtype request_path: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = None
        self.load_balancing_rules = None
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.number_of_probes = number_of_probes
        self.request_path = request_path
        self.provisioning_state = None


class ProtocolConfiguration(_serialization.Model):
    """Configuration of the protocol.

    :ivar http_configuration: HTTP configuration of the connectivity check.
    :vartype http_configuration: ~azure.mgmt.network.v2019_08_01.models.HTTPConfiguration
    """

    _attribute_map = {
        "http_configuration": {"key": "HTTPConfiguration", "type": "HTTPConfiguration"},
    }

    def __init__(self, *, http_configuration: Optional["_models.HTTPConfiguration"] = None, **kwargs):
        """
        :keyword http_configuration: HTTP configuration of the connectivity check.
        :paramtype http_configuration: ~azure.mgmt.network.v2019_08_01.models.HTTPConfiguration
        """
        super().__init__(**kwargs)
        self.http_configuration = http_configuration


class ProtocolCustomSettingsFormat(_serialization.Model):
    """DDoS custom policy properties.

    :ivar protocol: The protocol for which the DDoS protection policy is being customized. Known
     values are: "Tcp", "Udp", and "Syn".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.DdosCustomPolicyProtocol
    :ivar trigger_rate_override: The customized DDoS protection trigger rate.
    :vartype trigger_rate_override: str
    :ivar source_rate_override: The customized DDoS protection source rate.
    :vartype source_rate_override: str
    :ivar trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity
     degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger
     rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less
     sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t.
     normal traffic. Known values are: "Relaxed", "Low", "Default", and "High".
    :vartype trigger_sensitivity_override: str or
     ~azure.mgmt.network.v2019_08_01.models.DdosCustomPolicyTriggerSensitivityOverride
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "trigger_rate_override": {"key": "triggerRateOverride", "type": "str"},
        "source_rate_override": {"key": "sourceRateOverride", "type": "str"},
        "trigger_sensitivity_override": {"key": "triggerSensitivityOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.DdosCustomPolicyProtocol"]] = None,
        trigger_rate_override: Optional[str] = None,
        source_rate_override: Optional[str] = None,
        trigger_sensitivity_override: Optional[Union[str, "_models.DdosCustomPolicyTriggerSensitivityOverride"]] = None,
        **kwargs
    ):
        """
        :keyword protocol: The protocol for which the DDoS protection policy is being customized. Known
         values are: "Tcp", "Udp", and "Syn".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.DdosCustomPolicyProtocol
        :keyword trigger_rate_override: The customized DDoS protection trigger rate.
        :paramtype trigger_rate_override: str
        :keyword source_rate_override: The customized DDoS protection source rate.
        :paramtype source_rate_override: str
        :keyword trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity
         degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger
         rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less
         sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t.
         normal traffic. Known values are: "Relaxed", "Low", "Default", and "High".
        :paramtype trigger_sensitivity_override: str or
         ~azure.mgmt.network.v2019_08_01.models.DdosCustomPolicyTriggerSensitivityOverride
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.trigger_rate_override = trigger_rate_override
        self.source_rate_override = source_rate_override
        self.trigger_sensitivity_override = trigger_sensitivity_override


class PublicIPAddress(Resource):  # pylint: disable=too-many-instance-attributes
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The public IP address SKU.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddressSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar public_ip_allocation_method: The public IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype public_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar public_ip_address_version: The public IP address version. Known values are: "IPv4" and
     "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP address.
    :vartype ip_configuration: ~azure.mgmt.network.v2019_08_01.models.IPConfiguration
    :ivar dns_settings: The FQDN of the DNS record associated with the public IP address.
    :vartype dns_settings: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddressDnsSettings
    :ivar ddos_settings: The DDoS protection custom policy associated with the public IP address.
    :vartype ddos_settings: ~azure.mgmt.network.v2019_08_01.models.DdosSettings
    :ivar ip_tags: The list of tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.network.v2019_08_01.models.IpTag]
    :ivar ip_address: The IP address associated with the public IP address resource.
    :vartype ip_address: str
    :ivar public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated from.
    :vartype public_ip_prefix: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar resource_guid: The resource GUID property of the public IP address resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP address resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "ip_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "PublicIPAddressSku"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "public_ip_allocation_method": {"key": "properties.publicIPAllocationMethod", "type": "str"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "ip_configuration": {"key": "properties.ipConfiguration", "type": "IPConfiguration"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "PublicIPAddressDnsSettings"},
        "ddos_settings": {"key": "properties.ddosSettings", "type": "DdosSettings"},
        "ip_tags": {"key": "properties.ipTags", "type": "[IpTag]"},
        "ip_address": {"key": "properties.ipAddress", "type": "str"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.PublicIPAddressSku"] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        public_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        dns_settings: Optional["_models.PublicIPAddressDnsSettings"] = None,
        ddos_settings: Optional["_models.DdosSettings"] = None,
        ip_tags: Optional[List["_models.IpTag"]] = None,
        ip_address: Optional[str] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The public IP address SKU.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddressSku
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword public_ip_allocation_method: The public IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype public_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword public_ip_address_version: The public IP address version. Known values are: "IPv4" and
         "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
        :keyword dns_settings: The FQDN of the DNS record associated with the public IP address.
        :paramtype dns_settings: ~azure.mgmt.network.v2019_08_01.models.PublicIPAddressDnsSettings
        :keyword ddos_settings: The DDoS protection custom policy associated with the public IP
         address.
        :paramtype ddos_settings: ~azure.mgmt.network.v2019_08_01.models.DdosSettings
        :keyword ip_tags: The list of tags associated with the public IP address.
        :paramtype ip_tags: list[~azure.mgmt.network.v2019_08_01.models.IpTag]
        :keyword ip_address: The IP address associated with the public IP address resource.
        :paramtype ip_address: str
        :keyword public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated
         from.
        :paramtype public_ip_prefix: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword resource_guid: The resource GUID property of the public IP address resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.zones = zones
        self.public_ip_allocation_method = public_ip_allocation_method
        self.public_ip_address_version = public_ip_address_version
        self.ip_configuration = None
        self.dns_settings = dns_settings
        self.ddos_settings = ddos_settings
        self.ip_tags = ip_tags
        self.ip_address = ip_address
        self.public_ip_prefix = public_ip_prefix
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = resource_guid
        self.provisioning_state = None


class PublicIPAddressDnsSettings(_serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :ivar domain_name_label: The domain name label. The concatenation of the domain name label and
     the regionalized DNS zone make up the fully qualified domain name associated with the public IP
     address. If a domain name label is specified, an A DNS record is created for the public IP in
     the Microsoft Azure DNS system.
    :vartype domain_name_label: str
    :ivar fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public IP.
     This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :vartype fqdn: str
    :ivar reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that resolves
     to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created
     pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :vartype reverse_fqdn: str
    """

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "reverse_fqdn": {"key": "reverseFqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain_name_label: Optional[str] = None,
        fqdn: Optional[str] = None,
        reverse_fqdn: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword domain_name_label: The domain name label. The concatenation of the domain name label
         and the regionalized DNS zone make up the fully qualified domain name associated with the
         public IP address. If a domain name label is specified, an A DNS record is created for the
         public IP in the Microsoft Azure DNS system.
        :paramtype domain_name_label: str
        :keyword fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public
         IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :paramtype fqdn: str
        :keyword reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that
         resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is
         created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :paramtype reverse_fqdn: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn


class PublicIPAddressListResult(_serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :ivar value: A list of public IP addresses that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.PublicIPAddress]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicIPAddress]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PublicIPAddress"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of public IP addresses that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.PublicIPAddress]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PublicIPAddressSku(_serialization.Model):
    """SKU of a public IP address.

    :ivar name: Name of a public IP address SKU. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.PublicIPAddressSkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = None, **kwargs):
        """
        :keyword name: Name of a public IP address SKU. Known values are: "Basic" and "Standard".
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.PublicIPAddressSkuName
        """
        super().__init__(**kwargs)
        self.name = name


class PublicIPPrefix(Resource):  # pylint: disable=too-many-instance-attributes
    """Public IP prefix resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The public IP prefix SKU.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.PublicIPPrefixSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar public_ip_address_version: The public IP address version. Known values are: "IPv4" and
     "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
    :ivar ip_tags: The list of tags associated with the public IP prefix.
    :vartype ip_tags: list[~azure.mgmt.network.v2019_08_01.models.IpTag]
    :ivar prefix_length: The Length of the Public IP Prefix.
    :vartype prefix_length: int
    :ivar ip_prefix: The allocated Prefix.
    :vartype ip_prefix: str
    :ivar public_ip_addresses: The list of all referenced PublicIPAddresses.
    :vartype public_ip_addresses:
     list[~azure.mgmt.network.v2019_08_01.models.ReferencedPublicIpAddress]
    :ivar load_balancer_frontend_ip_configuration: The reference to load balancer frontend IP
     configuration associated with the public IP prefix.
    :vartype load_balancer_frontend_ip_configuration:
     ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar resource_guid: The resource GUID property of the public IP prefix resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP prefix resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "load_balancer_frontend_ip_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "PublicIPPrefixSku"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "ip_tags": {"key": "properties.ipTags", "type": "[IpTag]"},
        "prefix_length": {"key": "properties.prefixLength", "type": "int"},
        "ip_prefix": {"key": "properties.ipPrefix", "type": "str"},
        "public_ip_addresses": {"key": "properties.publicIPAddresses", "type": "[ReferencedPublicIpAddress]"},
        "load_balancer_frontend_ip_configuration": {
            "key": "properties.loadBalancerFrontendIpConfiguration",
            "type": "SubResource",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.PublicIPPrefixSku"] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        ip_tags: Optional[List["_models.IpTag"]] = None,
        prefix_length: Optional[int] = None,
        ip_prefix: Optional[str] = None,
        public_ip_addresses: Optional[List["_models.ReferencedPublicIpAddress"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The public IP prefix SKU.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.PublicIPPrefixSku
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword public_ip_address_version: The public IP address version. Known values are: "IPv4" and
         "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.network.v2019_08_01.models.IPVersion
        :keyword ip_tags: The list of tags associated with the public IP prefix.
        :paramtype ip_tags: list[~azure.mgmt.network.v2019_08_01.models.IpTag]
        :keyword prefix_length: The Length of the Public IP Prefix.
        :paramtype prefix_length: int
        :keyword ip_prefix: The allocated Prefix.
        :paramtype ip_prefix: str
        :keyword public_ip_addresses: The list of all referenced PublicIPAddresses.
        :paramtype public_ip_addresses:
         list[~azure.mgmt.network.v2019_08_01.models.ReferencedPublicIpAddress]
        :keyword resource_guid: The resource GUID property of the public IP prefix resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.zones = zones
        self.public_ip_address_version = public_ip_address_version
        self.ip_tags = ip_tags
        self.prefix_length = prefix_length
        self.ip_prefix = ip_prefix
        self.public_ip_addresses = public_ip_addresses
        self.load_balancer_frontend_ip_configuration = None
        self.resource_guid = resource_guid
        self.provisioning_state = None


class PublicIPPrefixListResult(_serialization.Model):
    """Response for ListPublicIpPrefixes API service call.

    :ivar value: A list of public IP prefixes that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.PublicIPPrefix]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicIPPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PublicIPPrefix"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of public IP prefixes that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.PublicIPPrefix]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PublicIPPrefixSku(_serialization.Model):
    """SKU of a public IP prefix.

    :ivar name: Name of a public IP prefix SKU. "Standard"
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.PublicIPPrefixSkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.PublicIPPrefixSkuName"]] = None, **kwargs):
        """
        :keyword name: Name of a public IP prefix SKU. "Standard"
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.PublicIPPrefixSkuName
        """
        super().__init__(**kwargs)
        self.name = name


class QueryTroubleshootingParameters(_serialization.Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The target resource ID to query the troubleshooting result. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs):
        """
        :keyword target_resource_id: The target resource ID to query the troubleshooting result.
         Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class ReferencedPublicIpAddress(_serialization.Model):
    """Reference to a public IP address.

    :ivar id: The PublicIPAddress Reference.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The PublicIPAddress Reference.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar linked_resource_type: Resource type of the linked resource.
    :vartype linked_resource_type: str
    :ivar link: Link to the external resource.
    :vartype link: str
    :ivar provisioning_state: The provisioning state of the resource navigation link resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "linked_resource_type": {"key": "properties.linkedResourceType", "type": "str"},
        "link": {"key": "properties.link", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        linked_resource_type: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword linked_resource_type: Resource type of the linked resource.
        :paramtype linked_resource_type: str
        :keyword link: Link to the external resource.
        :paramtype link: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None


class ResourceNavigationLinksListResult(_serialization.Model):
    """Response for ResourceNavigationLinks_List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The resource navigation links in a subnet.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ResourceNavigationLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceNavigationLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ResourceNavigationLink"]] = None, **kwargs):
        """
        :keyword value: The resource navigation links in a subnet.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ResourceNavigationLink]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RetentionPolicyParameters(_serialization.Model):
    """Parameters that define the retention policy for flow log.

    :ivar days: Number of days to retain flow log records.
    :vartype days: int
    :ivar enabled: Flag to enable/disable retention.
    :vartype enabled: bool
    """

    _attribute_map = {
        "days": {"key": "days", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, days: int = 0, enabled: bool = False, **kwargs):
        """
        :keyword days: Number of days to retain flow log records.
        :paramtype days: int
        :keyword enabled: Flag to enable/disable retention.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.days = days
        self.enabled = enabled


class Route(SubResource):
    """Route resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_prefix: The destination CIDR to which the route applies.
    :vartype address_prefix: str
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2019_08_01.models.RouteNextHopType
    :ivar next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :vartype next_hop_ip_address: str
    :ivar provisioning_state: The provisioning state of the route resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "next_hop_type": {"key": "properties.nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "properties.nextHopIpAddress", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_prefix: The destination CIDR to which the route applies.
        :paramtype address_prefix: str
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
         "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2019_08_01.models.RouteNextHopType
        :keyword next_hop_ip_address: The IP address packets should be forwarded to. Next hop values
         are only allowed in routes where the next hop type is VirtualAppliance.
        :paramtype next_hop_ip_address: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = None


class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rules: Collection of RouteFilterRules contained within a route filter.
    :vartype rules: list[~azure.mgmt.network.v2019_08_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
    :vartype ipv6_peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[RouteFilterRule]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "ipv6_peerings": {"key": "properties.ipv6Peerings", "type": "[ExpressRouteCircuitPeering]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["_models.RouteFilterRule"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        ipv6_peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rules: Collection of RouteFilterRules contained within a route filter.
        :paramtype rules: list[~azure.mgmt.network.v2019_08_01.models.RouteFilterRule]
        :keyword peerings: A collection of references to express route circuit peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
        :keyword ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
        :paramtype ipv6_peerings:
         list[~azure.mgmt.network.v2019_08_01.models.ExpressRouteCircuitPeering]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.rules = rules
        self.peerings = peerings
        self.ipv6_peerings = ipv6_peerings
        self.provisioning_state = None


class RouteFilterListResult(_serialization.Model):
    """Response for the ListRouteFilters API service call.

    :ivar value: A list of route filters in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.RouteFilter]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteFilter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteFilter"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of route filters in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.RouteFilter]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar access: The access type of the rule. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2019_08_01.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. "Community"
    :vartype route_filter_rule_type: str or
     ~azure.mgmt.network.v2019_08_01.models.RouteFilterRuleType
    :ivar communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :vartype communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "access": {"key": "properties.access", "type": "str"},
        "route_filter_rule_type": {"key": "properties.routeFilterRuleType", "type": "str"},
        "communities": {"key": "properties.communities", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        location: Optional[str] = None,
        access: Optional[Union[str, "_models.Access"]] = None,
        route_filter_rule_type: Optional[Union[str, "_models.RouteFilterRuleType"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword access: The access type of the rule. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2019_08_01.models.Access
        :keyword route_filter_rule_type: The rule type of the rule. "Community"
        :paramtype route_filter_rule_type: str or
         ~azure.mgmt.network.v2019_08_01.models.RouteFilterRuleType
        :keyword communities: The collection for bgp community values to filter on. e.g.
         ['12076:5010','12076:5020'].
        :paramtype communities: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.etag = None
        self.access = access
        self.route_filter_rule_type = route_filter_rule_type
        self.communities = communities
        self.provisioning_state = None


class RouteFilterRuleListResult(_serialization.Model):
    """Response for the ListRouteFilterRules API service call.

    :ivar value: A list of RouteFilterRules in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.RouteFilterRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteFilterRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteFilterRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of RouteFilterRules in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.RouteFilterRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteListResult(_serialization.Model):
    """Response for the ListRoute API service call.

    :ivar value: A list of routes in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.Route]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Route]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Route"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: A list of routes in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.Route]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar routes: Collection of routes contained within a route table.
    :vartype routes: list[~azure.mgmt.network.v2019_08_01.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
    :ivar disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that route
     table. True means disable.
    :vartype disable_bgp_route_propagation: bool
    :ivar provisioning_state: The provisioning state of the route table resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "subnets": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[Route]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "disable_bgp_route_propagation": {"key": "properties.disableBgpRoutePropagation", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        routes: Optional[List["_models.Route"]] = None,
        disable_bgp_route_propagation: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword routes: Collection of routes contained within a route table.
        :paramtype routes: list[~azure.mgmt.network.v2019_08_01.models.Route]
        :keyword disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that
         route table. True means disable.
        :paramtype disable_bgp_route_propagation: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.routes = routes
        self.subnets = None
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.provisioning_state = None


class RouteTableListResult(_serialization.Model):
    """Response for the ListRouteTable API service call.

    :ivar value: A list of route tables in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.RouteTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteTable"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of route tables in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.RouteTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityGroupNetworkInterface(_serialization.Model):
    """Network interface and all its associated security rules.

    :ivar id: ID of the network interface.
    :vartype id: str
    :ivar security_rule_associations: All security rules associated with the network interface.
    :vartype security_rule_associations:
     ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAssociations
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rule_associations": {"key": "securityRuleAssociations", "type": "SecurityRuleAssociations"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        security_rule_associations: Optional["_models.SecurityRuleAssociations"] = None,
        **kwargs
    ):
        """
        :keyword id: ID of the network interface.
        :paramtype id: str
        :keyword security_rule_associations: All security rules associated with the network interface.
        :paramtype security_rule_associations:
         ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAssociations
        """
        super().__init__(**kwargs)
        self.id = id
        self.security_rule_associations = security_rule_associations


class SecurityGroupViewParameters(_serialization.Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: ID of the target VM. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs):
        """
        :keyword target_resource_id: ID of the target VM. Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class SecurityGroupViewResult(_serialization.Model):
    """The information about security rules applied to the specified VM.

    :ivar network_interfaces: List of network interfaces on the specified VM.
    :vartype network_interfaces:
     list[~azure.mgmt.network.v2019_08_01.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[SecurityGroupNetworkInterface]"},
    }

    def __init__(self, *, network_interfaces: Optional[List["_models.SecurityGroupNetworkInterface"]] = None, **kwargs):
        """
        :keyword network_interfaces: List of network interfaces on the specified VM.
        :paramtype network_interfaces:
         list[~azure.mgmt.network.v2019_08_01.models.SecurityGroupNetworkInterface]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class SecurityRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Network security rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "*", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleProtocol
    :ivar source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_range: str
    :ivar source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :vartype source_address_prefix: str
    :ivar source_address_prefixes: The CIDR or source IP ranges.
    :vartype source_address_prefixes: list[str]
    :ivar source_application_security_groups: The application security group specified as source.
    :vartype source_application_security_groups:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
    :ivar destination_address_prefix: The destination address prefix. CIDR or destination IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :vartype destination_address_prefix: str
    :ivar destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :vartype destination_address_prefixes: list[str]
    :ivar destination_application_security_groups: The application security group specified as
     destination.
    :vartype destination_application_security_groups:
     list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: The network traffic is allowed or denied. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAccess
    :ivar priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleDirection
    :ivar provisioning_state: The provisioning state of the security rule resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "source_port_range": {"key": "properties.sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "properties.destinationPortRange", "type": "str"},
        "source_address_prefix": {"key": "properties.sourceAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "properties.sourceAddressPrefixes", "type": "[str]"},
        "source_application_security_groups": {
            "key": "properties.sourceApplicationSecurityGroups",
            "type": "[ApplicationSecurityGroup]",
        },
        "destination_address_prefix": {"key": "properties.destinationAddressPrefix", "type": "str"},
        "destination_address_prefixes": {"key": "properties.destinationAddressPrefixes", "type": "[str]"},
        "destination_application_security_groups": {
            "key": "properties.destinationApplicationSecurityGroups",
            "type": "[ApplicationSecurityGroup]",
        },
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        source_application_security_groups: Optional[List["_models.ApplicationSecurityGroup"]] = None,
        destination_address_prefix: Optional[str] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        destination_application_security_groups: Optional[List["_models.ApplicationSecurityGroup"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "*", and "Ah".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleProtocol
        :keyword source_port_range: The source port or range. Integer or range between 0 and 65535.
         Asterisk '*' can also be used to match all ports.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range. Integer or range between 0 and
         65535. Asterisk '*' can also be used to match all ports.
        :paramtype destination_port_range: str
        :keyword source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
         match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
         can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :paramtype source_address_prefix: str
        :keyword source_address_prefixes: The CIDR or source IP ranges.
        :paramtype source_address_prefixes: list[str]
        :keyword source_application_security_groups: The application security group specified as
         source.
        :paramtype source_application_security_groups:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
        :keyword destination_address_prefix: The destination address prefix. CIDR or destination IP
         range. Asterisk '*' can also be used to match all source IPs. Default tags such as
         'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :paramtype destination_address_prefix: str
        :keyword destination_address_prefixes: The destination address prefixes. CIDR or destination IP
         ranges.
        :paramtype destination_address_prefixes: list[str]
        :keyword destination_application_security_groups: The application security group specified as
         destination.
        :paramtype destination_application_security_groups:
         list[~azure.mgmt.network.v2019_08_01.models.ApplicationSecurityGroup]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: The network traffic is allowed or denied. Known values are: "Allow" and
         "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleAccess
        :keyword priority: The priority of the rule. The value can be between 100 and 4096. The
         priority number must be unique for each rule in the collection. The lower the priority number,
         the higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. The direction specifies if rule will be
         evaluated on incoming or outgoing traffic. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2019_08_01.models.SecurityRuleDirection
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.source_application_security_groups = source_application_security_groups
        self.destination_address_prefix = destination_address_prefix
        self.destination_address_prefixes = destination_address_prefixes
        self.destination_application_security_groups = destination_application_security_groups
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class SecurityRuleAssociations(_serialization.Model):
    """All security rules associated with the network interface.

    :ivar network_interface_association: Network interface and it's custom security rules.
    :vartype network_interface_association:
     ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceAssociation
    :ivar subnet_association: Subnet and it's custom security rules.
    :vartype subnet_association: ~azure.mgmt.network.v2019_08_01.models.SubnetAssociation
    :ivar default_security_rules: Collection of default security rules of the network security
     group.
    :vartype default_security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
    :ivar effective_security_rules: Collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        "network_interface_association": {"key": "networkInterfaceAssociation", "type": "NetworkInterfaceAssociation"},
        "subnet_association": {"key": "subnetAssociation", "type": "SubnetAssociation"},
        "default_security_rules": {"key": "defaultSecurityRules", "type": "[SecurityRule]"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
    }

    def __init__(
        self,
        *,
        network_interface_association: Optional["_models.NetworkInterfaceAssociation"] = None,
        subnet_association: Optional["_models.SubnetAssociation"] = None,
        default_security_rules: Optional[List["_models.SecurityRule"]] = None,
        effective_security_rules: Optional[List["_models.EffectiveNetworkSecurityRule"]] = None,
        **kwargs
    ):
        """
        :keyword network_interface_association: Network interface and it's custom security rules.
        :paramtype network_interface_association:
         ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceAssociation
        :keyword subnet_association: Subnet and it's custom security rules.
        :paramtype subnet_association: ~azure.mgmt.network.v2019_08_01.models.SubnetAssociation
        :keyword default_security_rules: Collection of default security rules of the network security
         group.
        :paramtype default_security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
        :keyword effective_security_rules: Collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.v2019_08_01.models.EffectiveNetworkSecurityRule]
        """
        super().__init__(**kwargs)
        self.network_interface_association = network_interface_association
        self.subnet_association = subnet_association
        self.default_security_rules = default_security_rules
        self.effective_security_rules = effective_security_rules


class SecurityRuleListResult(_serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group.

    :ivar value: The security rules in a network security group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SecurityRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The security rules in a network security group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceAssociationLink(SubResource):
    """ServiceAssociationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar linked_resource_type: Resource type of the linked resource.
    :vartype linked_resource_type: str
    :ivar link: Link to the external resource.
    :vartype link: str
    :ivar provisioning_state: The provisioning state of the service association link resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar allow_delete: If true, the resource can be deleted.
    :vartype allow_delete: bool
    :ivar locations: A list of locations.
    :vartype locations: list[str]
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "linked_resource_type": {"key": "properties.linkedResourceType", "type": "str"},
        "link": {"key": "properties.link", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "allow_delete": {"key": "properties.allowDelete", "type": "bool"},
        "locations": {"key": "properties.locations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        linked_resource_type: Optional[str] = None,
        link: Optional[str] = None,
        allow_delete: Optional[bool] = None,
        locations: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword linked_resource_type: Resource type of the linked resource.
        :paramtype linked_resource_type: str
        :keyword link: Link to the external resource.
        :paramtype link: str
        :keyword allow_delete: If true, the resource can be deleted.
        :paramtype allow_delete: bool
        :keyword locations: A list of locations.
        :paramtype locations: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None
        self.allow_delete = allow_delete
        self.locations = locations


class ServiceAssociationLinksListResult(_serialization.Model):
    """Response for ServiceAssociationLinks_List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The service association links in a subnet.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ServiceAssociationLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceAssociationLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ServiceAssociationLink"]] = None, **kwargs):
        """
        :keyword value: The service association links in a subnet.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ServiceAssociationLink]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceEndpointPolicy(Resource):
    """Service End point policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar service_endpoint_policy_definitions: A collection of service endpoint policy definitions
     of the service endpoint policy.
    :vartype service_endpoint_policy_definitions:
     list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicyDefinition]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
    :ivar resource_guid: The resource GUID property of the service endpoint policy resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the service endpoint policy resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "subnets": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "service_endpoint_policy_definitions": {
            "key": "properties.serviceEndpointPolicyDefinitions",
            "type": "[ServiceEndpointPolicyDefinition]",
        },
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        service_endpoint_policy_definitions: Optional[List["_models.ServiceEndpointPolicyDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword service_endpoint_policy_definitions: A collection of service endpoint policy
         definitions of the service endpoint policy.
        :paramtype service_endpoint_policy_definitions:
         list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicyDefinition]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.service_endpoint_policy_definitions = service_endpoint_policy_definitions
        self.subnets = None
        self.resource_guid = None
        self.provisioning_state = None


class ServiceEndpointPolicyDefinition(SubResource):
    """Service Endpoint policy definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar service: Service endpoint name.
    :vartype service: str
    :ivar service_resources: A list of service resources.
    :vartype service_resources: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint policy definition
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "service": {"key": "properties.service", "type": "str"},
        "service_resources": {"key": "properties.serviceResources", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        service: Optional[str] = None,
        service_resources: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword service: Service endpoint name.
        :paramtype service: str
        :keyword service_resources: A list of service resources.
        :paramtype service_resources: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.description = description
        self.service = service
        self.service_resources = service_resources
        self.provisioning_state = None


class ServiceEndpointPolicyDefinitionListResult(_serialization.Model):
    """Response for ListServiceEndpointPolicyDefinition API service call. Retrieves all service endpoint policy definition that belongs to a service endpoint policy.

    :ivar value: The service endpoint policy definition in a service endpoint policy.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicyDefinition]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceEndpointPolicyDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ServiceEndpointPolicyDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The service endpoint policy definition in a service endpoint policy.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicyDefinition]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceEndpointPolicyListResult(_serialization.Model):
    """Response for ListServiceEndpointPolicies API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ServiceEndpointPolicy resources.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicy]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceEndpointPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ServiceEndpointPolicy"]] = None, **kwargs):
        """
        :keyword value: A list of ServiceEndpointPolicy resources.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceEndpointPropertiesFormat(_serialization.Model):
    """The service endpoint properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service: The type of the endpoint service.
    :vartype service: str
    :ivar locations: A list of locations.
    :vartype locations: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "service": {"key": "service", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, service: Optional[str] = None, locations: Optional[List[str]] = None, **kwargs):
        """
        :keyword service: The type of the endpoint service.
        :paramtype service: str
        :keyword locations: A list of locations.
        :paramtype locations: list[str]
        """
        super().__init__(**kwargs)
        self.service = service
        self.locations = locations
        self.provisioning_state = None


class ServiceTagInformation(_serialization.Model):
    """The service tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Properties of the service tag information.
    :vartype properties:
     ~azure.mgmt.network.v2019_08_01.models.ServiceTagInformationPropertiesFormat
    :ivar name: The name of service tag.
    :vartype name: str
    :ivar id: The ID of service tag.
    :vartype id: str
    """

    _validation = {
        "properties": {"readonly": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ServiceTagInformationPropertiesFormat"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.properties = None
        self.name = None
        self.id = None


class ServiceTagInformationPropertiesFormat(_serialization.Model):
    """Properties of the service tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar change_number: The iteration number of service tag.
    :vartype change_number: str
    :ivar region: The region of service tag.
    :vartype region: str
    :ivar system_service: The name of system service.
    :vartype system_service: str
    :ivar address_prefixes: The list of IP address prefixes.
    :vartype address_prefixes: list[str]
    """

    _validation = {
        "change_number": {"readonly": True},
        "region": {"readonly": True},
        "system_service": {"readonly": True},
        "address_prefixes": {"readonly": True},
    }

    _attribute_map = {
        "change_number": {"key": "changeNumber", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "system_service": {"key": "systemService", "type": "str"},
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.change_number = None
        self.region = None
        self.system_service = None
        self.address_prefixes = None


class ServiceTagsListResult(_serialization.Model):
    """Response for the ListServiceTags API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the cloud.
    :vartype name: str
    :ivar id: The ID of the cloud.
    :vartype id: str
    :ivar type: The azure resource type.
    :vartype type: str
    :ivar change_number: The iteration number.
    :vartype change_number: str
    :ivar cloud: The name of the cloud.
    :vartype cloud: str
    :ivar values: The list of service tag information resources.
    :vartype values: list[~azure.mgmt.network.v2019_08_01.models.ServiceTagInformation]
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "change_number": {"readonly": True},
        "cloud": {"readonly": True},
        "values": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "change_number": {"key": "changeNumber", "type": "str"},
        "cloud": {"key": "cloud", "type": "str"},
        "values": {"key": "values", "type": "[ServiceTagInformation]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.change_number = None
        self.cloud = None
        self.values = None


class Subnet(SubResource):  # pylint: disable=too-many-instance-attributes
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_prefix: The address prefix for the subnet.
    :vartype address_prefix: str
    :ivar address_prefixes: List of address prefixes for the subnet.
    :vartype address_prefixes: list[str]
    :ivar network_security_group: The reference of the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroup
    :ivar route_table: The reference of the RouteTable resource.
    :vartype route_table: ~azure.mgmt.network.v2019_08_01.models.RouteTable
    :ivar nat_gateway: Nat gateway associated with this subnet.
    :vartype nat_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar service_endpoints: An array of service endpoints.
    :vartype service_endpoints:
     list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPropertiesFormat]
    :ivar service_endpoint_policies: An array of service endpoint policies.
    :vartype service_endpoint_policies:
     list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicy]
    :ivar private_endpoints: An array of references to private endpoints.
    :vartype private_endpoints: list[~azure.mgmt.network.v2019_08_01.models.PrivateEndpoint]
    :ivar ip_configurations: An array of references to the network interface IP configurations
     using subnet.
    :vartype ip_configurations: list[~azure.mgmt.network.v2019_08_01.models.IPConfiguration]
    :ivar ip_configuration_profiles: Array of IP configuration profiles which reference this
     subnet.
    :vartype ip_configuration_profiles:
     list[~azure.mgmt.network.v2019_08_01.models.IPConfigurationProfile]
    :ivar resource_navigation_links: An array of references to the external resources using subnet.
    :vartype resource_navigation_links:
     list[~azure.mgmt.network.v2019_08_01.models.ResourceNavigationLink]
    :ivar service_association_links: An array of references to services injecting into this subnet.
    :vartype service_association_links:
     list[~azure.mgmt.network.v2019_08_01.models.ServiceAssociationLink]
    :ivar delegations: An array of references to the delegations on the subnet.
    :vartype delegations: list[~azure.mgmt.network.v2019_08_01.models.Delegation]
    :ivar purpose: A read-only string identifying the intention of use for this subnet based on
     delegations and other user-defined properties.
    :vartype purpose: str
    :ivar provisioning_state: The provisioning state of the subnet resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar private_endpoint_network_policies: Enable or Disable apply network policies on private
     end point in the subnet.
    :vartype private_endpoint_network_policies: str
    :ivar private_link_service_network_policies: Enable or Disable apply network policies on
     private link service in the subnet.
    :vartype private_link_service_network_policies: str
    """

    _validation = {
        "private_endpoints": {"readonly": True},
        "ip_configurations": {"readonly": True},
        "ip_configuration_profiles": {"readonly": True},
        "purpose": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "address_prefixes": {"key": "properties.addressPrefixes", "type": "[str]"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "route_table": {"key": "properties.routeTable", "type": "RouteTable"},
        "nat_gateway": {"key": "properties.natGateway", "type": "SubResource"},
        "service_endpoints": {"key": "properties.serviceEndpoints", "type": "[ServiceEndpointPropertiesFormat]"},
        "service_endpoint_policies": {"key": "properties.serviceEndpointPolicies", "type": "[ServiceEndpointPolicy]"},
        "private_endpoints": {"key": "properties.privateEndpoints", "type": "[PrivateEndpoint]"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfiguration]"},
        "ip_configuration_profiles": {"key": "properties.ipConfigurationProfiles", "type": "[IPConfigurationProfile]"},
        "resource_navigation_links": {"key": "properties.resourceNavigationLinks", "type": "[ResourceNavigationLink]"},
        "service_association_links": {"key": "properties.serviceAssociationLinks", "type": "[ServiceAssociationLink]"},
        "delegations": {"key": "properties.delegations", "type": "[Delegation]"},
        "purpose": {"key": "properties.purpose", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_network_policies": {"key": "properties.privateEndpointNetworkPolicies", "type": "str"},
        "private_link_service_network_policies": {"key": "properties.privateLinkServiceNetworkPolicies", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        address_prefixes: Optional[List[str]] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        route_table: Optional["_models.RouteTable"] = None,
        nat_gateway: Optional["_models.SubResource"] = None,
        service_endpoints: Optional[List["_models.ServiceEndpointPropertiesFormat"]] = None,
        service_endpoint_policies: Optional[List["_models.ServiceEndpointPolicy"]] = None,
        resource_navigation_links: Optional[List["_models.ResourceNavigationLink"]] = None,
        service_association_links: Optional[List["_models.ServiceAssociationLink"]] = None,
        delegations: Optional[List["_models.Delegation"]] = None,
        private_endpoint_network_policies: Optional[str] = None,
        private_link_service_network_policies: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_prefix: The address prefix for the subnet.
        :paramtype address_prefix: str
        :keyword address_prefixes: List of address prefixes for the subnet.
        :paramtype address_prefixes: list[str]
        :keyword network_security_group: The reference of the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.v2019_08_01.models.NetworkSecurityGroup
        :keyword route_table: The reference of the RouteTable resource.
        :paramtype route_table: ~azure.mgmt.network.v2019_08_01.models.RouteTable
        :keyword nat_gateway: Nat gateway associated with this subnet.
        :paramtype nat_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword service_endpoints: An array of service endpoints.
        :paramtype service_endpoints:
         list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPropertiesFormat]
        :keyword service_endpoint_policies: An array of service endpoint policies.
        :paramtype service_endpoint_policies:
         list[~azure.mgmt.network.v2019_08_01.models.ServiceEndpointPolicy]
        :keyword resource_navigation_links: An array of references to the external resources using
         subnet.
        :paramtype resource_navigation_links:
         list[~azure.mgmt.network.v2019_08_01.models.ResourceNavigationLink]
        :keyword service_association_links: An array of references to services injecting into this
         subnet.
        :paramtype service_association_links:
         list[~azure.mgmt.network.v2019_08_01.models.ServiceAssociationLink]
        :keyword delegations: An array of references to the delegations on the subnet.
        :paramtype delegations: list[~azure.mgmt.network.v2019_08_01.models.Delegation]
        :keyword private_endpoint_network_policies: Enable or Disable apply network policies on private
         end point in the subnet.
        :paramtype private_endpoint_network_policies: str
        :keyword private_link_service_network_policies: Enable or Disable apply network policies on
         private link service in the subnet.
        :paramtype private_link_service_network_policies: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.address_prefixes = address_prefixes
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.nat_gateway = nat_gateway
        self.service_endpoints = service_endpoints
        self.service_endpoint_policies = service_endpoint_policies
        self.private_endpoints = None
        self.ip_configurations = None
        self.ip_configuration_profiles = None
        self.resource_navigation_links = resource_navigation_links
        self.service_association_links = service_association_links
        self.delegations = delegations
        self.purpose = None
        self.provisioning_state = None
        self.private_endpoint_network_policies = private_endpoint_network_policies
        self.private_link_service_network_policies = private_link_service_network_policies


class SubnetAssociation(_serialization.Model):
    """Subnet and it's custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :ivar security_rules: Collection of custom security rules.
    :vartype security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rules": {"key": "securityRules", "type": "[SecurityRule]"},
    }

    def __init__(self, *, security_rules: Optional[List["_models.SecurityRule"]] = None, **kwargs):
        """
        :keyword security_rules: Collection of custom security rules.
        :paramtype security_rules: list[~azure.mgmt.network.v2019_08_01.models.SecurityRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class SubnetListResult(_serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.

    :ivar value: The subnets in a virtual network.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Subnet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Subnet"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The subnets in a virtual network.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class Topology(_serialization.Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially created for the resource
     group.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: ~datetime.datetime
    :ivar resources: A list of topology resources.
    :vartype resources: list[~azure.mgmt.network.v2019_08_01.models.TopologyResource]
    """

    _validation = {
        "id": {"readonly": True},
        "created_date_time": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
        "resources": {"key": "resources", "type": "[TopologyResource]"},
    }

    def __init__(self, *, resources: Optional[List["_models.TopologyResource"]] = None, **kwargs):
        """
        :keyword resources: A list of topology resources.
        :paramtype resources: list[~azure.mgmt.network.v2019_08_01.models.TopologyResource]
        """
        super().__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = resources


class TopologyAssociation(_serialization.Model):
    """Resources that have an association with the parent resource.

    :ivar name: The name of the resource that is associated with the parent resource.
    :vartype name: str
    :ivar resource_id: The ID of the resource that is associated with the parent resource.
    :vartype resource_id: str
    :ivar association_type: The association type of the child resource to the parent resource.
     Known values are: "Associated" and "Contains".
    :vartype association_type: str or ~azure.mgmt.network.v2019_08_01.models.AssociationType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "association_type": {"key": "associationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        resource_id: Optional[str] = None,
        association_type: Optional[Union[str, "_models.AssociationType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the resource that is associated with the parent resource.
        :paramtype name: str
        :keyword resource_id: The ID of the resource that is associated with the parent resource.
        :paramtype resource_id: str
        :keyword association_type: The association type of the child resource to the parent resource.
         Known values are: "Associated" and "Contains".
        :paramtype association_type: str or ~azure.mgmt.network.v2019_08_01.models.AssociationType
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.association_type = association_type


class TopologyParameters(_serialization.Model):
    """Parameters that define the representation of topology.

    :ivar target_resource_group_name: The name of the target resource group to perform topology on.
    :vartype target_resource_group_name: str
    :ivar target_virtual_network: The reference of the Virtual Network resource.
    :vartype target_virtual_network: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar target_subnet: The reference of the Subnet resource.
    :vartype target_subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    """

    _attribute_map = {
        "target_resource_group_name": {"key": "targetResourceGroupName", "type": "str"},
        "target_virtual_network": {"key": "targetVirtualNetwork", "type": "SubResource"},
        "target_subnet": {"key": "targetSubnet", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        target_resource_group_name: Optional[str] = None,
        target_virtual_network: Optional["_models.SubResource"] = None,
        target_subnet: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword target_resource_group_name: The name of the target resource group to perform topology
         on.
        :paramtype target_resource_group_name: str
        :keyword target_virtual_network: The reference of the Virtual Network resource.
        :paramtype target_virtual_network: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword target_subnet: The reference of the Subnet resource.
        :paramtype target_subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.target_resource_group_name = target_resource_group_name
        self.target_virtual_network = target_virtual_network
        self.target_subnet = target_subnet


class TopologyResource(_serialization.Model):
    """The network resource topology information for the given resource group.

    :ivar name: Name of the resource.
    :vartype name: str
    :ivar id: ID of the resource.
    :vartype id: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar associations: Holds the associations the resource has with other resources in the
     resource group.
    :vartype associations: list[~azure.mgmt.network.v2019_08_01.models.TopologyAssociation]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "associations": {"key": "associations", "type": "[TopologyAssociation]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        associations: Optional[List["_models.TopologyAssociation"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword id: ID of the resource.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword associations: Holds the associations the resource has with other resources in the
         resource group.
        :paramtype associations: list[~azure.mgmt.network.v2019_08_01.models.TopologyAssociation]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.location = location
        self.associations = associations


class TrafficAnalyticsConfigurationProperties(_serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Flag to enable/disable traffic analytics. Required.
    :vartype enabled: bool
    :ivar workspace_id: The resource guid of the attached workspace.
    :vartype workspace_id: str
    :ivar workspace_region: The location of the attached workspace.
    :vartype workspace_region: str
    :ivar workspace_resource_id: Resource Id of the attached workspace.
    :vartype workspace_resource_id: str
    :ivar traffic_analytics_interval: The interval in minutes which would decide how frequently TA
     service should do flow analytics.
    :vartype traffic_analytics_interval: int
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "workspace_region": {"key": "workspaceRegion", "type": "str"},
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
        "traffic_analytics_interval": {"key": "trafficAnalyticsInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        workspace_id: Optional[str] = None,
        workspace_region: Optional[str] = None,
        workspace_resource_id: Optional[str] = None,
        traffic_analytics_interval: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword enabled: Flag to enable/disable traffic analytics. Required.
        :paramtype enabled: bool
        :keyword workspace_id: The resource guid of the attached workspace.
        :paramtype workspace_id: str
        :keyword workspace_region: The location of the attached workspace.
        :paramtype workspace_region: str
        :keyword workspace_resource_id: Resource Id of the attached workspace.
        :paramtype workspace_resource_id: str
        :keyword traffic_analytics_interval: The interval in minutes which would decide how frequently
         TA service should do flow analytics.
        :paramtype traffic_analytics_interval: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workspace_id = workspace_id
        self.workspace_region = workspace_region
        self.workspace_resource_id = workspace_resource_id
        self.traffic_analytics_interval = traffic_analytics_interval


class TrafficAnalyticsProperties(_serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    All required parameters must be populated in order to send to Azure.

    :ivar network_watcher_flow_analytics_configuration: Parameters that define the configuration of
     traffic analytics. Required.
    :vartype network_watcher_flow_analytics_configuration:
     ~azure.mgmt.network.v2019_08_01.models.TrafficAnalyticsConfigurationProperties
    """

    _validation = {
        "network_watcher_flow_analytics_configuration": {"required": True},
    }

    _attribute_map = {
        "network_watcher_flow_analytics_configuration": {
            "key": "networkWatcherFlowAnalyticsConfiguration",
            "type": "TrafficAnalyticsConfigurationProperties",
        },
    }

    def __init__(
        self,
        *,
        network_watcher_flow_analytics_configuration: "_models.TrafficAnalyticsConfigurationProperties",
        **kwargs
    ):
        """
        :keyword network_watcher_flow_analytics_configuration: Parameters that define the configuration
         of traffic analytics. Required.
        :paramtype network_watcher_flow_analytics_configuration:
         ~azure.mgmt.network.v2019_08_01.models.TrafficAnalyticsConfigurationProperties
        """
        super().__init__(**kwargs)
        self.network_watcher_flow_analytics_configuration = network_watcher_flow_analytics_configuration


class TrafficSelectorPolicy(_serialization.Model):
    """An traffic selector policy for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :ivar local_address_ranges: A collection of local address spaces in CIDR format. Required.
    :vartype local_address_ranges: list[str]
    :ivar remote_address_ranges: A collection of remote address spaces in CIDR format. Required.
    :vartype remote_address_ranges: list[str]
    """

    _validation = {
        "local_address_ranges": {"required": True},
        "remote_address_ranges": {"required": True},
    }

    _attribute_map = {
        "local_address_ranges": {"key": "localAddressRanges", "type": "[str]"},
        "remote_address_ranges": {"key": "remoteAddressRanges", "type": "[str]"},
    }

    def __init__(self, *, local_address_ranges: List[str], remote_address_ranges: List[str], **kwargs):
        """
        :keyword local_address_ranges: A collection of local address spaces in CIDR format. Required.
        :paramtype local_address_ranges: list[str]
        :keyword remote_address_ranges: A collection of remote address spaces in CIDR format. Required.
        :paramtype remote_address_ranges: list[str]
        """
        super().__init__(**kwargs)
        self.local_address_ranges = local_address_ranges
        self.remote_address_ranges = remote_address_ranges


class TroubleshootingDetails(_serialization.Model):
    """Information gained from troubleshooting of specified resource.

    :ivar id: The id of the get troubleshoot operation.
    :vartype id: str
    :ivar reason_type: Reason type of failure.
    :vartype reason_type: str
    :ivar summary: A summary of troubleshooting.
    :vartype summary: str
    :ivar detail: Details on troubleshooting results.
    :vartype detail: str
    :ivar recommended_actions: List of recommended actions.
    :vartype recommended_actions:
     list[~azure.mgmt.network.v2019_08_01.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "reason_type": {"key": "reasonType", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
        "detail": {"key": "detail", "type": "str"},
        "recommended_actions": {"key": "recommendedActions", "type": "[TroubleshootingRecommendedActions]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        reason_type: Optional[str] = None,
        summary: Optional[str] = None,
        detail: Optional[str] = None,
        recommended_actions: Optional[List["_models.TroubleshootingRecommendedActions"]] = None,
        **kwargs
    ):
        """
        :keyword id: The id of the get troubleshoot operation.
        :paramtype id: str
        :keyword reason_type: Reason type of failure.
        :paramtype reason_type: str
        :keyword summary: A summary of troubleshooting.
        :paramtype summary: str
        :keyword detail: Details on troubleshooting results.
        :paramtype detail: str
        :keyword recommended_actions: List of recommended actions.
        :paramtype recommended_actions:
         list[~azure.mgmt.network.v2019_08_01.models.TroubleshootingRecommendedActions]
        """
        super().__init__(**kwargs)
        self.id = id
        self.reason_type = reason_type
        self.summary = summary
        self.detail = detail
        self.recommended_actions = recommended_actions


class TroubleshootingParameters(_serialization.Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The target resource to troubleshoot. Required.
    :vartype target_resource_id: str
    :ivar storage_id: The ID for the storage account to save the troubleshoot result. Required.
    :vartype storage_id: str
    :ivar storage_path: The path to the blob to save the troubleshoot result in. Required.
    :vartype storage_path: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "storage_path": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "storage_path": {"key": "properties.storagePath", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, storage_id: str, storage_path: str, **kwargs):
        """
        :keyword target_resource_id: The target resource to troubleshoot. Required.
        :paramtype target_resource_id: str
        :keyword storage_id: The ID for the storage account to save the troubleshoot result. Required.
        :paramtype storage_id: str
        :keyword storage_path: The path to the blob to save the troubleshoot result in. Required.
        :paramtype storage_path: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.storage_path = storage_path


class TroubleshootingRecommendedActions(_serialization.Model):
    """Recommended actions based on discovered issues.

    :ivar action_id: ID of the recommended action.
    :vartype action_id: str
    :ivar action_text: Description of recommended actions.
    :vartype action_text: str
    :ivar action_uri: The uri linking to a documentation for the recommended troubleshooting
     actions.
    :vartype action_uri: str
    :ivar action_uri_text: The information from the URI for the recommended troubleshooting
     actions.
    :vartype action_uri_text: str
    """

    _attribute_map = {
        "action_id": {"key": "actionId", "type": "str"},
        "action_text": {"key": "actionText", "type": "str"},
        "action_uri": {"key": "actionUri", "type": "str"},
        "action_uri_text": {"key": "actionUriText", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_id: Optional[str] = None,
        action_text: Optional[str] = None,
        action_uri: Optional[str] = None,
        action_uri_text: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_id: ID of the recommended action.
        :paramtype action_id: str
        :keyword action_text: Description of recommended actions.
        :paramtype action_text: str
        :keyword action_uri: The uri linking to a documentation for the recommended troubleshooting
         actions.
        :paramtype action_uri: str
        :keyword action_uri_text: The information from the URI for the recommended troubleshooting
         actions.
        :paramtype action_uri_text: str
        """
        super().__init__(**kwargs)
        self.action_id = action_id
        self.action_text = action_text
        self.action_uri = action_uri
        self.action_uri_text = action_uri_text


class TroubleshootingResult(_serialization.Model):
    """Troubleshooting information gained from specified resource.

    :ivar start_time: The start time of the troubleshooting.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the troubleshooting.
    :vartype end_time: ~datetime.datetime
    :ivar code: The result code of the troubleshooting.
    :vartype code: str
    :ivar results: Information from troubleshooting.
    :vartype results: list[~azure.mgmt.network.v2019_08_01.models.TroubleshootingDetails]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "code": {"key": "code", "type": "str"},
        "results": {"key": "results", "type": "[TroubleshootingDetails]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        results: Optional[List["_models.TroubleshootingDetails"]] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time of the troubleshooting.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the troubleshooting.
        :paramtype end_time: ~datetime.datetime
        :keyword code: The result code of the troubleshooting.
        :paramtype code: str
        :keyword results: Information from troubleshooting.
        :paramtype results: list[~azure.mgmt.network.v2019_08_01.models.TroubleshootingDetails]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.results = results


class TunnelConnectionHealth(_serialization.Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual Network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar last_connection_established_utc_time: The time at which connection was established in Utc
     format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        "tunnel": {"readonly": True},
        "connection_status": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "last_connection_established_utc_time": {"readonly": True},
    }

    _attribute_map = {
        "tunnel": {"key": "tunnel", "type": "str"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "ingress_bytes_transferred": {"key": "ingressBytesTransferred", "type": "int"},
        "egress_bytes_transferred": {"key": "egressBytesTransferred", "type": "int"},
        "last_connection_established_utc_time": {"key": "lastConnectionEstablishedUtcTime", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None


class UnprepareNetworkPoliciesRequest(_serialization.Model):
    """Details of UnprepareNetworkPolicies for Subnet.

    :ivar service_name: The name of the service for which subnet is being unprepared for.
    :vartype service_name: str
    """

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
    }

    def __init__(self, *, service_name: Optional[str] = None, **kwargs):
        """
        :keyword service_name: The name of the service for which subnet is being unprepared for.
        :paramtype service_name: str
        """
        super().__init__(**kwargs)
        self.service_name = service_name


class Usage(_serialization.Model):
    """Describes network resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :ivar unit: An enum describing the unit of measurement. Required. "Count"
    :vartype unit: str or ~azure.mgmt.network.v2019_08_01.models.UsageUnit
    :ivar current_value: The current value of the usage. Required.
    :vartype current_value: int
    :ivar limit: The limit of usage. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.network.v2019_08_01.models.UsageName
    """

    _validation = {
        "id": {"readonly": True},
        "unit": {"required": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "_models.UsageUnit"],
        current_value: int,
        limit: int,
        name: "_models.UsageName",
        **kwargs
    ):
        """
        :keyword unit: An enum describing the unit of measurement. Required. "Count"
        :paramtype unit: str or ~azure.mgmt.network.v2019_08_01.models.UsageUnit
        :keyword current_value: The current value of the usage. Required.
        :paramtype current_value: int
        :keyword limit: The limit of usage. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.network.v2019_08_01.models.UsageName
        """
        super().__init__(**kwargs)
        self.id = None
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The usage names.

    :ivar value: A string describing the resource name.
    :vartype value: str
    :ivar localized_value: A localized string describing the resource name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs):
        """
        :keyword value: A string describing the resource name.
        :paramtype value: str
        :keyword localized_value: A localized string describing the resource name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(_serialization.Model):
    """The list usages operation response.

    :ivar value: The list network resource usages.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.Usage]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Usage"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list network resource usages.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.Usage]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VerificationIPFlowParameters(_serialization.Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The ID of the target resource to perform next-hop on. Required.
    :vartype target_resource_id: str
    :ivar direction: The direction of the packet represented as a 5-tuple. Required. Known values
     are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2019_08_01.models.Direction
    :ivar protocol: Protocol to be verified on. Required. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.network.v2019_08_01.models.IpFlowProtocol
    :ivar local_port: The local port. Acceptable values are a single integer in the range
     (0-65535). Support for * for the source port, which depends on the direction. Required.
    :vartype local_port: str
    :ivar remote_port: The remote port. Acceptable values are a single integer in the range
     (0-65535). Support for * for the source port, which depends on the direction. Required.
    :vartype remote_port: str
    :ivar local_ip_address: The local IP address. Acceptable values are valid IPv4 addresses.
     Required.
    :vartype local_ip_address: str
    :ivar remote_ip_address: The remote IP address. Acceptable values are valid IPv4 addresses.
     Required.
    :vartype remote_ip_address: str
    :ivar target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled
     on any of them, then this parameter must be specified. Otherwise optional).
    :vartype target_nic_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "direction": {"required": True},
        "protocol": {"required": True},
        "local_port": {"required": True},
        "remote_port": {"required": True},
        "local_ip_address": {"required": True},
        "remote_ip_address": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "direction": {"key": "direction", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "local_port": {"key": "localPort", "type": "str"},
        "remote_port": {"key": "remotePort", "type": "str"},
        "local_ip_address": {"key": "localIPAddress", "type": "str"},
        "remote_ip_address": {"key": "remoteIPAddress", "type": "str"},
        "target_nic_resource_id": {"key": "targetNicResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        direction: Union[str, "_models.Direction"],
        protocol: Union[str, "_models.IpFlowProtocol"],
        local_port: str,
        remote_port: str,
        local_ip_address: str,
        remote_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The ID of the target resource to perform next-hop on. Required.
        :paramtype target_resource_id: str
        :keyword direction: The direction of the packet represented as a 5-tuple. Required. Known
         values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2019_08_01.models.Direction
        :keyword protocol: Protocol to be verified on. Required. Known values are: "TCP" and "UDP".
        :paramtype protocol: str or ~azure.mgmt.network.v2019_08_01.models.IpFlowProtocol
        :keyword local_port: The local port. Acceptable values are a single integer in the range
         (0-65535). Support for * for the source port, which depends on the direction. Required.
        :paramtype local_port: str
        :keyword remote_port: The remote port. Acceptable values are a single integer in the range
         (0-65535). Support for * for the source port, which depends on the direction. Required.
        :paramtype remote_port: str
        :keyword local_ip_address: The local IP address. Acceptable values are valid IPv4 addresses.
         Required.
        :paramtype local_ip_address: str
        :keyword remote_ip_address: The remote IP address. Acceptable values are valid IPv4 addresses.
         Required.
        :paramtype remote_ip_address: str
        :keyword target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
         enabled on any of them, then this parameter must be specified. Otherwise optional).
        :paramtype target_nic_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.direction = direction
        self.protocol = protocol
        self.local_port = local_port
        self.remote_port = remote_port
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class VerificationIPFlowResult(_serialization.Model):
    """Results of IP flow verification on the target resource.

    :ivar access: Indicates whether the traffic is allowed or denied. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.network.v2019_08_01.models.Access
    :ivar rule_name: Name of the rule. If input is not matched against any security rule, it is not
     displayed.
    :vartype rule_name: str
    """

    _attribute_map = {
        "access": {"key": "access", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
    }

    def __init__(
        self, *, access: Optional[Union[str, "_models.Access"]] = None, rule_name: Optional[str] = None, **kwargs
    ):
        """
        :keyword access: Indicates whether the traffic is allowed or denied. Known values are: "Allow"
         and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2019_08_01.models.Access
        :keyword rule_name: Name of the rule. If input is not matched against any security rule, it is
         not displayed.
        :paramtype rule_name: str
        """
        super().__init__(**kwargs)
        self.access = access
        self.rule_name = rule_name


class VirtualHub(Resource):  # pylint: disable=too-many-instance-attributes
    """VirtualHub Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_wan: The VirtualWAN to which the VirtualHub belongs.
    :vartype virtual_wan: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar vpn_gateway: The VpnGateway associated with this VirtualHub.
    :vartype vpn_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar p2_s_vpn_gateway: The P2SVpnGateway associated with this VirtualHub.
    :vartype p2_s_vpn_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar express_route_gateway: The expressRouteGateway associated with this VirtualHub.
    :vartype express_route_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar azure_firewall: The azureFirewall associated with this VirtualHub.
    :vartype azure_firewall: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar virtual_network_connections: List of all vnet connections with this VirtualHub.
    :vartype virtual_network_connections:
     list[~azure.mgmt.network.v2019_08_01.models.HubVirtualNetworkConnection]
    :ivar address_prefix: Address-prefix for this VirtualHub.
    :vartype address_prefix: str
    :ivar route_table: The routeTable associated with this virtual hub.
    :vartype route_table: ~azure.mgmt.network.v2019_08_01.models.VirtualHubRouteTable
    :ivar provisioning_state: The provisioning state of the virtual hub resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar security_provider_name: The Security Provider name.
    :vartype security_provider_name: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_wan": {"key": "properties.virtualWan", "type": "SubResource"},
        "vpn_gateway": {"key": "properties.vpnGateway", "type": "SubResource"},
        "p2_s_vpn_gateway": {"key": "properties.p2SVpnGateway", "type": "SubResource"},
        "express_route_gateway": {"key": "properties.expressRouteGateway", "type": "SubResource"},
        "azure_firewall": {"key": "properties.azureFirewall", "type": "SubResource"},
        "virtual_network_connections": {
            "key": "properties.virtualNetworkConnections",
            "type": "[HubVirtualNetworkConnection]",
        },
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "route_table": {"key": "properties.routeTable", "type": "VirtualHubRouteTable"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "security_provider_name": {"key": "properties.securityProviderName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_wan: Optional["_models.SubResource"] = None,
        vpn_gateway: Optional["_models.SubResource"] = None,
        p2_s_vpn_gateway: Optional["_models.SubResource"] = None,
        express_route_gateway: Optional["_models.SubResource"] = None,
        azure_firewall: Optional["_models.SubResource"] = None,
        virtual_network_connections: Optional[List["_models.HubVirtualNetworkConnection"]] = None,
        address_prefix: Optional[str] = None,
        route_table: Optional["_models.VirtualHubRouteTable"] = None,
        security_provider_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_wan: The VirtualWAN to which the VirtualHub belongs.
        :paramtype virtual_wan: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword vpn_gateway: The VpnGateway associated with this VirtualHub.
        :paramtype vpn_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword p2_s_vpn_gateway: The P2SVpnGateway associated with this VirtualHub.
        :paramtype p2_s_vpn_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword express_route_gateway: The expressRouteGateway associated with this VirtualHub.
        :paramtype express_route_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword azure_firewall: The azureFirewall associated with this VirtualHub.
        :paramtype azure_firewall: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword virtual_network_connections: List of all vnet connections with this VirtualHub.
        :paramtype virtual_network_connections:
         list[~azure.mgmt.network.v2019_08_01.models.HubVirtualNetworkConnection]
        :keyword address_prefix: Address-prefix for this VirtualHub.
        :paramtype address_prefix: str
        :keyword route_table: The routeTable associated with this virtual hub.
        :paramtype route_table: ~azure.mgmt.network.v2019_08_01.models.VirtualHubRouteTable
        :keyword security_provider_name: The Security Provider name.
        :paramtype security_provider_name: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.virtual_wan = virtual_wan
        self.vpn_gateway = vpn_gateway
        self.p2_s_vpn_gateway = p2_s_vpn_gateway
        self.express_route_gateway = express_route_gateway
        self.azure_firewall = azure_firewall
        self.virtual_network_connections = virtual_network_connections
        self.address_prefix = address_prefix
        self.route_table = route_table
        self.provisioning_state = None
        self.security_provider_name = security_provider_name


class VirtualHubId(_serialization.Model):
    """Virtual Hub identifier.

    :ivar id: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be
     deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same
     subscription.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be
         deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same
         subscription.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualHubRoute(_serialization.Model):
    """VirtualHub route.

    :ivar address_prefixes: List of all addressPrefixes.
    :vartype address_prefixes: list[str]
    :ivar next_hop_ip_address: NextHop ip address.
    :vartype next_hop_ip_address: str
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "str"},
    }

    def __init__(
        self, *, address_prefixes: Optional[List[str]] = None, next_hop_ip_address: Optional[str] = None, **kwargs
    ):
        """
        :keyword address_prefixes: List of all addressPrefixes.
        :paramtype address_prefixes: list[str]
        :keyword next_hop_ip_address: NextHop ip address.
        :paramtype next_hop_ip_address: str
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes
        self.next_hop_ip_address = next_hop_ip_address


class VirtualHubRouteTable(_serialization.Model):
    """VirtualHub route table.

    :ivar routes: List of all routes.
    :vartype routes: list[~azure.mgmt.network.v2019_08_01.models.VirtualHubRoute]
    """

    _attribute_map = {
        "routes": {"key": "routes", "type": "[VirtualHubRoute]"},
    }

    def __init__(self, *, routes: Optional[List["_models.VirtualHubRoute"]] = None, **kwargs):
        """
        :keyword routes: List of all routes.
        :paramtype routes: list[~azure.mgmt.network.v2019_08_01.models.VirtualHubRoute]
        """
        super().__init__(**kwargs)
        self.routes = routes


class VirtualNetwork(Resource):  # pylint: disable=too-many-instance-attributes
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :vartype address_space: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
    :ivar dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :vartype dhcp_options: ~azure.mgmt.network.v2019_08_01.models.DhcpOptions
    :ivar subnets: A list of subnets in a Virtual Network.
    :vartype subnets: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
    :ivar virtual_network_peerings: A list of peerings in a Virtual Network.
    :vartype virtual_network_peerings:
     list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkPeering]
    :ivar resource_guid: The resourceGuid property of the Virtual Network resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar enable_ddos_protection: Indicates if DDoS protection is enabled for all the protected
     resources in the virtual network. It requires a DDoS protection plan associated with the
     resource.
    :vartype enable_ddos_protection: bool
    :ivar enable_vm_protection: Indicates if VM protection is enabled for all the subnets in the
     virtual network.
    :vartype enable_vm_protection: bool
    :ivar ddos_protection_plan: The DDoS protection plan associated with the virtual network.
    :vartype ddos_protection_plan: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar bgp_communities: Bgp Communities sent over ExpressRoute with each route corresponding to
     a prefix in this VNET.
    :vartype bgp_communities: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkBgpCommunities
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "address_space": {"key": "properties.addressSpace", "type": "AddressSpace"},
        "dhcp_options": {"key": "properties.dhcpOptions", "type": "DhcpOptions"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "virtual_network_peerings": {"key": "properties.virtualNetworkPeerings", "type": "[VirtualNetworkPeering]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "enable_ddos_protection": {"key": "properties.enableDdosProtection", "type": "bool"},
        "enable_vm_protection": {"key": "properties.enableVmProtection", "type": "bool"},
        "ddos_protection_plan": {"key": "properties.ddosProtectionPlan", "type": "SubResource"},
        "bgp_communities": {"key": "properties.bgpCommunities", "type": "VirtualNetworkBgpCommunities"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        address_space: Optional["_models.AddressSpace"] = None,
        dhcp_options: Optional["_models.DhcpOptions"] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        virtual_network_peerings: Optional[List["_models.VirtualNetworkPeering"]] = None,
        resource_guid: Optional[str] = None,
        enable_ddos_protection: bool = False,
        enable_vm_protection: bool = False,
        ddos_protection_plan: Optional["_models.SubResource"] = None,
        bgp_communities: Optional["_models.VirtualNetworkBgpCommunities"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_space: The AddressSpace that contains an array of IP address ranges that can
         be used by subnets.
        :paramtype address_space: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
        :keyword dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
         deployed in the virtual network.
        :paramtype dhcp_options: ~azure.mgmt.network.v2019_08_01.models.DhcpOptions
        :keyword subnets: A list of subnets in a Virtual Network.
        :paramtype subnets: list[~azure.mgmt.network.v2019_08_01.models.Subnet]
        :keyword virtual_network_peerings: A list of peerings in a Virtual Network.
        :paramtype virtual_network_peerings:
         list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkPeering]
        :keyword resource_guid: The resourceGuid property of the Virtual Network resource.
        :paramtype resource_guid: str
        :keyword enable_ddos_protection: Indicates if DDoS protection is enabled for all the protected
         resources in the virtual network. It requires a DDoS protection plan associated with the
         resource.
        :paramtype enable_ddos_protection: bool
        :keyword enable_vm_protection: Indicates if VM protection is enabled for all the subnets in the
         virtual network.
        :paramtype enable_vm_protection: bool
        :keyword ddos_protection_plan: The DDoS protection plan associated with the virtual network.
        :paramtype ddos_protection_plan: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword bgp_communities: Bgp Communities sent over ExpressRoute with each route corresponding
         to a prefix in this VNET.
        :paramtype bgp_communities: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkBgpCommunities
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.virtual_network_peerings = virtual_network_peerings
        self.resource_guid = resource_guid
        self.provisioning_state = None
        self.enable_ddos_protection = enable_ddos_protection
        self.enable_vm_protection = enable_vm_protection
        self.ddos_protection_plan = ddos_protection_plan
        self.bgp_communities = bgp_communities


class VirtualNetworkBgpCommunities(_serialization.Model):
    """Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_community: The BGP community associated with the virtual network.
     Required.
    :vartype virtual_network_community: str
    :ivar regional_community: The BGP community associated with the region of the virtual network.
    :vartype regional_community: str
    """

    _validation = {
        "virtual_network_community": {"required": True},
        "regional_community": {"readonly": True},
    }

    _attribute_map = {
        "virtual_network_community": {"key": "virtualNetworkCommunity", "type": "str"},
        "regional_community": {"key": "regionalCommunity", "type": "str"},
    }

    def __init__(self, *, virtual_network_community: str, **kwargs):
        """
        :keyword virtual_network_community: The BGP community associated with the virtual network.
         Required.
        :paramtype virtual_network_community: str
        """
        super().__init__(**kwargs)
        self.virtual_network_community = virtual_network_community
        self.regional_community = None


class VirtualNetworkConnectionGatewayReference(_serialization.Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of VirtualNetworkGateway or LocalNetworkGateway resource. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of VirtualNetworkGateway or LocalNetworkGateway resource. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: IP configurations for virtual network gateway.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayIPConfiguration]
    :ivar gateway_type: The type of this virtual network gateway. Known values are: "Vpn" and
     "ExpressRoute".
    :vartype gateway_type: str or ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayType
    :ivar vpn_type: The type of this virtual network gateway. Known values are: "PolicyBased" and
     "RouteBased".
    :vartype vpn_type: str or ~azure.mgmt.network.v2019_08_01.models.VpnType
    :ivar vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if
     gatewayType is not VPN. Known values are: "None", "Generation1", and "Generation2".
    :vartype vpn_gateway_generation: str or
     ~azure.mgmt.network.v2019_08_01.models.VpnGatewayGeneration
    :ivar enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :vartype enable_bgp: bool
    :ivar active: ActiveActive flag.
    :vartype active: bool
    :ivar gateway_default_site: The reference of the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :vartype gateway_default_site: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :vartype sku: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewaySku
    :ivar vpn_client_configuration: The reference of the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :vartype vpn_client_configuration:
     ~azure.mgmt.network.v2019_08_01.models.VpnClientConfiguration
    :ivar bgp_settings: Virtual network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.v2019_08_01.models.BgpSettings
    :ivar custom_routes: The reference of the address space resource which represents the custom
     routes address space specified by the customer for virtual network gateway and VpnClient.
    :vartype custom_routes: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
    :ivar resource_guid: The resource GUID property of the virtual network gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar enable_dns_forwarding: Whether dns forwarding is enabled or not.
    :vartype enable_dns_forwarding: bool
    :ivar inbound_dns_forwarding_endpoint: The IP address allocated by the gateway to which dns
     requests can be sent.
    :vartype inbound_dns_forwarding_endpoint: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "inbound_dns_forwarding_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualNetworkGatewayIPConfiguration]"},
        "gateway_type": {"key": "properties.gatewayType", "type": "str"},
        "vpn_type": {"key": "properties.vpnType", "type": "str"},
        "vpn_gateway_generation": {"key": "properties.vpnGatewayGeneration", "type": "str"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "active": {"key": "properties.activeActive", "type": "bool"},
        "gateway_default_site": {"key": "properties.gatewayDefaultSite", "type": "SubResource"},
        "sku": {"key": "properties.sku", "type": "VirtualNetworkGatewaySku"},
        "vpn_client_configuration": {"key": "properties.vpnClientConfiguration", "type": "VpnClientConfiguration"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "custom_routes": {"key": "properties.customRoutes", "type": "AddressSpace"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "enable_dns_forwarding": {"key": "properties.enableDnsForwarding", "type": "bool"},
        "inbound_dns_forwarding_endpoint": {"key": "properties.inboundDnsForwardingEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        ip_configurations: Optional[List["_models.VirtualNetworkGatewayIPConfiguration"]] = None,
        gateway_type: Optional[Union[str, "_models.VirtualNetworkGatewayType"]] = None,
        vpn_type: Optional[Union[str, "_models.VpnType"]] = None,
        vpn_gateway_generation: Optional[Union[str, "_models.VpnGatewayGeneration"]] = None,
        enable_bgp: Optional[bool] = None,
        active: Optional[bool] = None,
        gateway_default_site: Optional["_models.SubResource"] = None,
        sku: Optional["_models.VirtualNetworkGatewaySku"] = None,
        vpn_client_configuration: Optional["_models.VpnClientConfiguration"] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        custom_routes: Optional["_models.AddressSpace"] = None,
        resource_guid: Optional[str] = None,
        enable_dns_forwarding: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword ip_configurations: IP configurations for virtual network gateway.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayIPConfiguration]
        :keyword gateway_type: The type of this virtual network gateway. Known values are: "Vpn" and
         "ExpressRoute".
        :paramtype gateway_type: str or
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayType
        :keyword vpn_type: The type of this virtual network gateway. Known values are: "PolicyBased"
         and "RouteBased".
        :paramtype vpn_type: str or ~azure.mgmt.network.v2019_08_01.models.VpnType
        :keyword vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if
         gatewayType is not VPN. Known values are: "None", "Generation1", and "Generation2".
        :paramtype vpn_gateway_generation: str or
         ~azure.mgmt.network.v2019_08_01.models.VpnGatewayGeneration
        :keyword enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :paramtype enable_bgp: bool
        :keyword active: ActiveActive flag.
        :paramtype active: bool
        :keyword gateway_default_site: The reference of the LocalNetworkGateway resource which
         represents local network site having default routes. Assign Null value in case of removing
         existing default site setting.
        :paramtype gateway_default_site: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
         selected for Virtual network gateway.
        :paramtype sku: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewaySku
        :keyword vpn_client_configuration: The reference of the VpnClientConfiguration resource which
         represents the P2S VpnClient configurations.
        :paramtype vpn_client_configuration:
         ~azure.mgmt.network.v2019_08_01.models.VpnClientConfiguration
        :keyword bgp_settings: Virtual network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.v2019_08_01.models.BgpSettings
        :keyword custom_routes: The reference of the address space resource which represents the custom
         routes address space specified by the customer for virtual network gateway and VpnClient.
        :paramtype custom_routes: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
        :keyword resource_guid: The resource GUID property of the virtual network gateway resource.
        :paramtype resource_guid: str
        :keyword enable_dns_forwarding: Whether dns forwarding is enabled or not.
        :paramtype enable_dns_forwarding: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.vpn_gateway_generation = vpn_gateway_generation
        self.enable_bgp = enable_bgp
        self.active = active
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.bgp_settings = bgp_settings
        self.custom_routes = custom_routes
        self.resource_guid = resource_guid
        self.provisioning_state = None
        self.enable_dns_forwarding = enable_dns_forwarding
        self.inbound_dns_forwarding_endpoint = None


class VirtualNetworkGatewayConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: The reference to virtual network gateway resource. Required.
    :vartype virtual_network_gateway1: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGateway
    :ivar virtual_network_gateway2: The reference to virtual network gateway resource.
    :vartype virtual_network_gateway2: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGateway
    :ivar local_network_gateway2: The reference to local network gateway resource.
    :vartype local_network_gateway2: ~azure.mgmt.network.v2019_08_01.models.LocalNetworkGateway
    :ivar connection_type: Gateway connection type. Required. Known values are: "IPsec",
     "Vnet2Vnet", "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionType
    :ivar connection_protocol: Connection protocol used for this connection. Known values are:
     "IKEv2" and "IKEv1".
    :vartype connection_protocol: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionProtocol
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2019_08_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.v2019_08_01.models.IpsecPolicy]
    :ivar traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :vartype traffic_selector_policies:
     list[~azure.mgmt.network.v2019_08_01.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network gateway connection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
    :vartype express_route_gateway_bypass: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_gateway1": {"required": True},
        "connection_type": {"required": True},
        "connection_status": {"readonly": True},
        "tunnel_connection_status": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {"key": "properties.virtualNetworkGateway1", "type": "VirtualNetworkGateway"},
        "virtual_network_gateway2": {"key": "properties.virtualNetworkGateway2", "type": "VirtualNetworkGateway"},
        "local_network_gateway2": {"key": "properties.localNetworkGateway2", "type": "LocalNetworkGateway"},
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "connection_protocol": {"key": "properties.connectionProtocol", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "tunnel_connection_status": {"key": "properties.tunnelConnectionStatus", "type": "[TunnelConnectionHealth]"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "traffic_selector_policies": {"key": "properties.trafficSelectorPolicies", "type": "[TrafficSelectorPolicy]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_gateway_bypass": {"key": "properties.expressRouteGatewayBypass", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        virtual_network_gateway1: "_models.VirtualNetworkGateway",
        connection_type: Union[str, "_models.VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkGateway"] = None,
        local_network_gateway2: Optional["_models.LocalNetworkGateway"] = None,
        connection_protocol: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionProtocol"]] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        traffic_selector_policies: Optional[List["_models.TrafficSelectorPolicy"]] = None,
        resource_guid: Optional[str] = None,
        express_route_gateway_bypass: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: The reference to virtual network gateway resource. Required.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGateway
        :keyword virtual_network_gateway2: The reference to virtual network gateway resource.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGateway
        :keyword local_network_gateway2: The reference to local network gateway resource.
        :paramtype local_network_gateway2: ~azure.mgmt.network.v2019_08_01.models.LocalNetworkGateway
        :keyword connection_type: Gateway connection type. Required. Known values are: "IPsec",
         "Vnet2Vnet", "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionType
        :keyword connection_protocol: Connection protocol used for this connection. Known values are:
         "IKEv2" and "IKEv1".
        :paramtype connection_protocol: str or
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionProtocol
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.v2019_08_01.models.IpsecPolicy]
        :keyword traffic_selector_policies: The Traffic Selector Policies to be considered by this
         connection.
        :paramtype traffic_selector_policies:
         list[~azure.mgmt.network.v2019_08_01.models.TrafficSelectorPolicy]
        :keyword resource_guid: The resource GUID property of the virtual network gateway connection
         resource.
        :paramtype resource_guid: str
        :keyword express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
        :paramtype express_route_gateway_bypass: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.connection_protocol = connection_protocol
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.resource_guid = resource_guid
        self.provisioning_state = None
        self.express_route_gateway_bypass = express_route_gateway_bypass


class VirtualNetworkGatewayConnectionListEntity(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: The reference to virtual network gateway resource. Required.
    :vartype virtual_network_gateway1:
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkConnectionGatewayReference
    :ivar virtual_network_gateway2: The reference to virtual network gateway resource.
    :vartype virtual_network_gateway2:
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkConnectionGatewayReference
    :ivar local_network_gateway2: The reference to local network gateway resource.
    :vartype local_network_gateway2:
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkConnectionGatewayReference
    :ivar connection_type: Gateway connection type. Required. Known values are: "IPsec",
     "Vnet2Vnet", "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionType
    :ivar connection_protocol: Connection protocol used for this connection. Known values are:
     "IKEv2" and "IKEv1".
    :vartype connection_protocol: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionProtocol
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2019_08_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.v2019_08_01.models.IpsecPolicy]
    :ivar traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :vartype traffic_selector_policies:
     list[~azure.mgmt.network.v2019_08_01.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network gateway connection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
    :vartype express_route_gateway_bypass: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_gateway1": {"required": True},
        "connection_type": {"required": True},
        "connection_status": {"readonly": True},
        "tunnel_connection_status": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {
            "key": "properties.virtualNetworkGateway1",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "virtual_network_gateway2": {
            "key": "properties.virtualNetworkGateway2",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "local_network_gateway2": {
            "key": "properties.localNetworkGateway2",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "connection_protocol": {"key": "properties.connectionProtocol", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "tunnel_connection_status": {"key": "properties.tunnelConnectionStatus", "type": "[TunnelConnectionHealth]"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "traffic_selector_policies": {"key": "properties.trafficSelectorPolicies", "type": "[TrafficSelectorPolicy]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_gateway_bypass": {"key": "properties.expressRouteGatewayBypass", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        virtual_network_gateway1: "_models.VirtualNetworkConnectionGatewayReference",
        connection_type: Union[str, "_models.VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkConnectionGatewayReference"] = None,
        local_network_gateway2: Optional["_models.VirtualNetworkConnectionGatewayReference"] = None,
        connection_protocol: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionProtocol"]] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        traffic_selector_policies: Optional[List["_models.TrafficSelectorPolicy"]] = None,
        resource_guid: Optional[str] = None,
        express_route_gateway_bypass: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: The reference to virtual network gateway resource. Required.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkConnectionGatewayReference
        :keyword virtual_network_gateway2: The reference to virtual network gateway resource.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkConnectionGatewayReference
        :keyword local_network_gateway2: The reference to local network gateway resource.
        :paramtype local_network_gateway2:
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkConnectionGatewayReference
        :keyword connection_type: Gateway connection type. Required. Known values are: "IPsec",
         "Vnet2Vnet", "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionType
        :keyword connection_protocol: Connection protocol used for this connection. Known values are:
         "IKEv2" and "IKEv1".
        :paramtype connection_protocol: str or
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionProtocol
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.v2019_08_01.models.IpsecPolicy]
        :keyword traffic_selector_policies: The Traffic Selector Policies to be considered by this
         connection.
        :paramtype traffic_selector_policies:
         list[~azure.mgmt.network.v2019_08_01.models.TrafficSelectorPolicy]
        :keyword resource_guid: The resource GUID property of the virtual network gateway connection
         resource.
        :paramtype resource_guid: str
        :keyword express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
        :paramtype express_route_gateway_bypass: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.connection_protocol = connection_protocol
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.resource_guid = resource_guid
        self.provisioning_state = None
        self.express_route_gateway_bypass = express_route_gateway_bypass


class VirtualNetworkGatewayConnectionListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGatewayConnection"]] = None, **kwargs):
        """
        :keyword value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
         group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar public_ip_address: The reference of the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the virtual network gateway IP
     configuration resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2019_08_01.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword public_ip_address: The reference of the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None


class VirtualNetworkGatewayListConnectionsResult(_serialization.Model):
    """Response for the VirtualNetworkGatewayListConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value:
     list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionListEntity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnectionListEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGatewayConnectionListEntity"]] = None, **kwargs):
        """
        :keyword value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
         group.
        :paramtype value:
         list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewayConnectionListEntity]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewayListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of VirtualNetworkGateway resources that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGateway"]] = None, **kwargs):
        """
        :keyword value: A list of VirtualNetworkGateway resources that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGateway]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewaySku(_serialization.Model):
    """VirtualNetworkGatewaySku details.

    :ivar name: Gateway SKU name. Known values are: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
     "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", and "ErGw3AZ".
    :vartype name: str or ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewaySkuName
    :ivar tier: Gateway SKU tier. Known values are: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
     "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", and "ErGw3AZ".
    :vartype tier: str or ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewaySkuTier
    :ivar capacity: The capacity.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.VirtualNetworkGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.VirtualNetworkGatewaySkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Gateway SKU name. Known values are: "Basic", "HighPerformance", "Standard",
         "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
         "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", and "ErGw3AZ".
        :paramtype name: str or ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewaySkuName
        :keyword tier: Gateway SKU tier. Known values are: "Basic", "HighPerformance", "Standard",
         "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
         "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", and "ErGw3AZ".
        :paramtype tier: str or ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkGatewaySkuTier
        :keyword capacity: The capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class VirtualNetworkListResult(_serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :ivar value: A list of VirtualNetwork resources in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of VirtualNetwork resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetwork]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkListUsageResult(_serialization.Model):
    """Response for the virtual networks GetUsage API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: VirtualNetwork usage stats.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkUsage]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class VirtualNetworkPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peerings in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allow_virtual_network_access: Whether the VMs in the local virtual network space would be
     able to access the VMs in remote virtual network space.
    :vartype allow_virtual_network_access: bool
    :ivar allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local virtual
     network will be allowed/disallowed in remote virtual network.
    :vartype allow_forwarded_traffic: bool
    :ivar allow_gateway_transit: If gateway links can be used in remote virtual networking to link
     to this virtual network.
    :vartype allow_gateway_transit: bool
    :ivar use_remote_gateways: If remote gateways can be used on this virtual network. If the flag
     is set to true, and allowGatewayTransit on remote peering is also true, virtual network will
     use gateways of remote virtual network for transit. Only one peering can have this flag set to
     true. This flag cannot be set if virtual network already has a gateway.
    :vartype use_remote_gateways: bool
    :ivar remote_virtual_network: The reference of the remote virtual network. The remote virtual
     network can be in the same or different region (preview). See here to register for the preview
     and learn more
     (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
    :vartype remote_virtual_network: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar remote_address_space: The reference of the remote virtual network address space.
    :vartype remote_address_space: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
    :ivar peering_state: The status of the virtual network peering. Known values are: "Initiated",
     "Connected", and "Disconnected".
    :vartype peering_state: str or
     ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkPeeringState
    :ivar provisioning_state: The provisioning state of the virtual network peering resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "allow_virtual_network_access": {"key": "properties.allowVirtualNetworkAccess", "type": "bool"},
        "allow_forwarded_traffic": {"key": "properties.allowForwardedTraffic", "type": "bool"},
        "allow_gateway_transit": {"key": "properties.allowGatewayTransit", "type": "bool"},
        "use_remote_gateways": {"key": "properties.useRemoteGateways", "type": "bool"},
        "remote_virtual_network": {"key": "properties.remoteVirtualNetwork", "type": "SubResource"},
        "remote_address_space": {"key": "properties.remoteAddressSpace", "type": "AddressSpace"},
        "peering_state": {"key": "properties.peeringState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allow_virtual_network_access: Optional[bool] = None,
        allow_forwarded_traffic: Optional[bool] = None,
        allow_gateway_transit: Optional[bool] = None,
        use_remote_gateways: Optional[bool] = None,
        remote_virtual_network: Optional["_models.SubResource"] = None,
        remote_address_space: Optional["_models.AddressSpace"] = None,
        peering_state: Optional[Union[str, "_models.VirtualNetworkPeeringState"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword allow_virtual_network_access: Whether the VMs in the local virtual network space would
         be able to access the VMs in remote virtual network space.
        :paramtype allow_virtual_network_access: bool
        :keyword allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local
         virtual network will be allowed/disallowed in remote virtual network.
        :paramtype allow_forwarded_traffic: bool
        :keyword allow_gateway_transit: If gateway links can be used in remote virtual networking to
         link to this virtual network.
        :paramtype allow_gateway_transit: bool
        :keyword use_remote_gateways: If remote gateways can be used on this virtual network. If the
         flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network
         will use gateways of remote virtual network for transit. Only one peering can have this flag
         set to true. This flag cannot be set if virtual network already has a gateway.
        :paramtype use_remote_gateways: bool
        :keyword remote_virtual_network: The reference of the remote virtual network. The remote
         virtual network can be in the same or different region (preview). See here to register for the
         preview and learn more
         (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        :paramtype remote_virtual_network: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword remote_address_space: The reference of the remote virtual network address space.
        :paramtype remote_address_space: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
        :keyword peering_state: The status of the virtual network peering. Known values are:
         "Initiated", "Connected", and "Disconnected".
        :paramtype peering_state: str or
         ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkPeeringState
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allow_virtual_network_access = allow_virtual_network_access
        self.allow_forwarded_traffic = allow_forwarded_traffic
        self.allow_gateway_transit = allow_gateway_transit
        self.use_remote_gateways = use_remote_gateways
        self.remote_virtual_network = remote_virtual_network
        self.remote_address_space = remote_address_space
        self.peering_state = peering_state
        self.provisioning_state = None


class VirtualNetworkPeeringListResult(_serialization.Model):
    """Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network.

    :ivar value: The peerings in a virtual network.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The peerings in a virtual network.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkTap(Resource):  # pylint: disable=too-many-instance-attributes
    """Virtual Network Tap resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar network_interface_tap_configurations: Specifies the list of resource IDs for the network
     interface IP configuration that needs to be tapped.
    :vartype network_interface_tap_configurations:
     list[~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceTapConfiguration]
    :ivar resource_guid: The resource GUID property of the virtual network tap resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network tap resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    :ivar destination_network_interface_ip_configuration: The reference to the private IP Address
     of the collector nic that will receive the tap.
    :vartype destination_network_interface_ip_configuration:
     ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration
    :ivar destination_load_balancer_front_end_ip_configuration: The reference to the private IP
     address on the internal Load Balancer that will receive the tap.
    :vartype destination_load_balancer_front_end_ip_configuration:
     ~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration
    :ivar destination_port: The VXLAN destination port that will receive the tapped traffic.
    :vartype destination_port: int
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_interface_tap_configurations": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "network_interface_tap_configurations": {
            "key": "properties.networkInterfaceTapConfigurations",
            "type": "[NetworkInterfaceTapConfiguration]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "destination_network_interface_ip_configuration": {
            "key": "properties.destinationNetworkInterfaceIPConfiguration",
            "type": "NetworkInterfaceIPConfiguration",
        },
        "destination_load_balancer_front_end_ip_configuration": {
            "key": "properties.destinationLoadBalancerFrontEndIPConfiguration",
            "type": "FrontendIPConfiguration",
        },
        "destination_port": {"key": "properties.destinationPort", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        destination_network_interface_ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None,
        destination_load_balancer_front_end_ip_configuration: Optional["_models.FrontendIPConfiguration"] = None,
        destination_port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword destination_network_interface_ip_configuration: The reference to the private IP
         Address of the collector nic that will receive the tap.
        :paramtype destination_network_interface_ip_configuration:
         ~azure.mgmt.network.v2019_08_01.models.NetworkInterfaceIPConfiguration
        :keyword destination_load_balancer_front_end_ip_configuration: The reference to the private IP
         address on the internal Load Balancer that will receive the tap.
        :paramtype destination_load_balancer_front_end_ip_configuration:
         ~azure.mgmt.network.v2019_08_01.models.FrontendIPConfiguration
        :keyword destination_port: The VXLAN destination port that will receive the tapped traffic.
        :paramtype destination_port: int
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.network_interface_tap_configurations = None
        self.resource_guid = None
        self.provisioning_state = None
        self.destination_network_interface_ip_configuration = destination_network_interface_ip_configuration
        self.destination_load_balancer_front_end_ip_configuration = destination_load_balancer_front_end_ip_configuration
        self.destination_port = destination_port


class VirtualNetworkTapListResult(_serialization.Model):
    """Response for ListVirtualNetworkTap API service call.

    :ivar value: A list of VirtualNetworkTaps in a resource group.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkTap]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkTap]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetworkTap"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of VirtualNetworkTaps in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualNetworkTap]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkUsage(_serialization.Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name: ~azure.mgmt.network.v2019_08_01.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'.
    :vartype unit: str
    """

    _validation = {
        "current_value": {"readonly": True},
        "id": {"readonly": True},
        "limit": {"readonly": True},
        "name": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "current_value": {"key": "currentValue", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "limit": {"key": "limit", "type": "float"},
        "name": {"key": "name", "type": "VirtualNetworkUsageName"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None


class VirtualNetworkUsageName(_serialization.Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        "localized_value": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "localized_value": {"key": "localizedValue", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.localized_value = None
        self.value = None


class VirtualRouter(Resource):  # pylint: disable=too-many-instance-attributes
    """VirtualRouter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_router_asn: VirtualRouter ASN.
    :vartype virtual_router_asn: int
    :ivar virtual_router_ips: VirtualRouter IPs.
    :vartype virtual_router_ips: list[str]
    :ivar hosted_subnet: The Subnet on which VirtualRouter is hosted.
    :vartype hosted_subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar hosted_gateway: The Gateway on which VirtualRouter is hosted.
    :vartype hosted_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
    :ivar peerings: List of references to VirtualRouterPeerings.
    :vartype peerings: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "virtual_router_asn": {"maximum": 4294967295, "minimum": 1},
        "peerings": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_router_asn": {"key": "properties.virtualRouterAsn", "type": "int"},
        "virtual_router_ips": {"key": "properties.virtualRouterIps", "type": "[str]"},
        "hosted_subnet": {"key": "properties.hostedSubnet", "type": "SubResource"},
        "hosted_gateway": {"key": "properties.hostedGateway", "type": "SubResource"},
        "peerings": {"key": "properties.peerings", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_router_asn: Optional[int] = None,
        virtual_router_ips: Optional[List[str]] = None,
        hosted_subnet: Optional["_models.SubResource"] = None,
        hosted_gateway: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_router_asn: VirtualRouter ASN.
        :paramtype virtual_router_asn: int
        :keyword virtual_router_ips: VirtualRouter IPs.
        :paramtype virtual_router_ips: list[str]
        :keyword hosted_subnet: The Subnet on which VirtualRouter is hosted.
        :paramtype hosted_subnet: ~azure.mgmt.network.v2019_08_01.models.SubResource
        :keyword hosted_gateway: The Gateway on which VirtualRouter is hosted.
        :paramtype hosted_gateway: ~azure.mgmt.network.v2019_08_01.models.SubResource
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.virtual_router_asn = virtual_router_asn
        self.virtual_router_ips = virtual_router_ips
        self.hosted_subnet = hosted_subnet
        self.hosted_gateway = hosted_gateway
        self.peerings = None
        self.provisioning_state = None


class VirtualRouterListResult(_serialization.Model):
    """Response for ListVirtualRouters API service call.

    :ivar value: List of Virtual Routers.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualRouter]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualRouter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualRouter"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Virtual Routers.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualRouter]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualRouterPeering(SubResource):
    """Virtual Router Peering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Gets name of the peering unique to VirtualRouter. This name can be used to access
     the resource.
    :vartype name: str
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Peering type.
    :vartype type: str
    :ivar peer_asn: Peer ASN.
    :vartype peer_asn: int
    :ivar peer_ip: Peer IP.
    :vartype peer_ip: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "peer_asn": {"key": "properties.peerAsn", "type": "int"},
        "peer_ip": {"key": "properties.peerIp", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peer_asn: Optional[int] = None,
        peer_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Gets name of the peering unique to VirtualRouter. This name can be used to
         access the resource.
        :paramtype name: str
        :keyword peer_asn: Peer ASN.
        :paramtype peer_asn: int
        :keyword peer_ip: Peer IP.
        :paramtype peer_ip: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.peer_asn = peer_asn
        self.peer_ip = peer_ip
        self.provisioning_state = None


class VirtualRouterPeeringListResult(_serialization.Model):
    """Response for ListVirtualRouterPeerings API service call.

    :ivar value: List of VirtualRouterPeerings in a VirtualRouter.
    :vartype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualRouterPeering]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualRouterPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualRouterPeering"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of VirtualRouterPeerings in a VirtualRouter.
        :paramtype value: list[~azure.mgmt.network.v2019_08_01.models.VirtualRouterPeering]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualWAN(Resource):  # pylint: disable=too-many-instance-attributes
    """VirtualWAN Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar disable_vpn_encryption: Vpn encryption to be disabled or not.
    :vartype disable_vpn_encryption: bool
    :ivar virtual_hubs: List of VirtualHubs in the VirtualWAN.
    :vartype virtual_hubs: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar vpn_sites: List of VpnSites in the VirtualWAN.
    :vartype vpn_sites: list[~azure.mgmt.network.v2019_08_01.models.SubResource]
    :ivar allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
    :vartype allow_branch_to_branch_traffic: bool
    :ivar allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
    :vartype allow_vnet_to_vnet_traffic: bool
    :ivar office365_local_breakout_category: The office local breakout category. Known values are:
     "Optimize", "OptimizeAndAllow", "All", and "None".
    :vartype office365_local_breakout_category: str or
     ~azure.mgmt.network.v2019_08_01.models.OfficeTrafficCategory
    :ivar provisioning_state: The provisioning state of the virtual WAN resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2019_08_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "virtual_hubs": {"readonly": True},
        "vpn_sites": {"readonly": True},
        "office365_local_breakout_category": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "disable_vpn_encryption": {"key": "properties.disableVpnEncryption", "type": "bool"},
        "virtual_hubs": {"key": "properties.virtualHubs", "type": "[SubResource]"},
        "vpn_sites": {"key": "properties.vpnSites", "type": "[SubResource]"},
        "allow_branch_to_branch_traffic": {"key": "properties.allowBranchToBranchTraffic", "type": "bool"},
        "allow_vnet_to_vnet_traffic": {"key": "properties.allowVnetToVnetTraffic", "type": "bool"},
        "office365_local_breakout_category": {"key": "properties.office365LocalBreakoutCategory", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        disable_vpn_encryption: Optional[bool] = None,
        allow_branch_to_branch_traffic: Optional[bool] = None,
        allow_vnet_to_vnet_traffic: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword disable_vpn_encryption: Vpn encryption to be disabled or not.
        :paramtype disable_vpn_encryption: bool
        :keyword allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
        :paramtype allow_branch_to_branch_traffic: bool
        :keyword allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
        :paramtype allow_vnet_to_vnet_traffic: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.disable_vpn_encryption = disable_vpn_encryption
        self.virtual_hubs = None
        self.vpn_sites = None
        self.allow_branch_to_branch_traffic = allow_branch_to_branch_traffic
        self.allow_vnet_to_vnet_traffic = allow_vnet_to_vnet_traffic
        self.office365_local_breakout_category = None
        self.provisioning_state = None


class VirtualWanSecurityProvider(_serialization.Model):
    """Collection of SecurityProviders.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the security provider.
    :vartype name: str
    :ivar url: Url of the security provider.
    :vartype url: str
    :ivar type: Name of the security provider. Known values are: "External" and "Native".
    :vartype type: str or ~azure.mgmt.network.v2019_08_01.models.VirtualWanSecurityProviderType
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, url: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the security provider.
        :paramtype name: str
        :keyword url: Url of the security provider.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.url = url
        self.type = None


class VirtualWanSecurityProviders(_serialization.Model):
    """Collection of SecurityProviders.

    :ivar supported_providers: List of VirtualWAN security providers.
    :vartype supported_providers:
     list[~azure.mgmt.network.v2019_08_01.models.VirtualWanSecurityProvider]
    """

    _attribute_map = {
        "supported_providers": {"key": "supportedProviders", "type": "[VirtualWanSecurityProvider]"},
    }

    def __init__(self, *, supported_providers: Optional[List["_models.VirtualWanSecurityProvider"]] = None, **kwargs):
        """
        :keyword supported_providers: List of VirtualWAN security providers.
        :paramtype supported_providers:
         list[~azure.mgmt.network.v2019_08_01.models.VirtualWanSecurityProvider]
        """
        super().__init__(**kwargs)
        self.supported_providers = supported_providers


class VirtualWanVpnProfileParameters(_serialization.Model):
    """Virtual Wan Vpn profile parameters Vpn profile generation.

    :ivar vpn_server_configuration_resource_id: VpnServerConfiguration partial resource uri with
     which VirtualWan is associated to.
    :vartype vpn_server_configuration_resource_id: str
    :ivar authentication_method: VPN client authentication method. Known values are: "EAPTLS" and
     "EAPMSCHAPv2".
    :vartype authentication_method: str or
     ~azure.mgmt.network.v2019_08_01.models.AuthenticationMethod
    """

    _attribute_map = {
        "vpn_server_configuration_resource_id": {"key": "vpnServerConfigurationResourceId", "type": "str"},
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
    }

    def __init__(
        self,
        *,
        vpn_server_configuration_resource_id: Optional[str] = None,
        authentication_method: Optional[Union[str, "_models.AuthenticationMethod"]] = None,
        **kwargs
    ):
        """
        :keyword vpn_server_configuration_resource_id: VpnServerConfiguration partial resource uri with
         which VirtualWan is associated to.
        :paramtype vpn_server_configuration_resource_id: str
        :keyword authentication_method: VPN client authentication method. Known values are: "EAPTLS"
         and "EAPMSCHAPv2".
        :paramtype authentication_method: str or
         ~azure.mgmt.network.v2019_08_01.models.AuthenticationMethod
        """
        super().__init__(**kwargs)
        self.vpn_server_configuration_resource_id = vpn_server_configuration_resource_id
        self.authentication_method = authentication_method


class VpnClientConfiguration(_serialization.Model):
    """VpnClientConfiguration for P2S client.

    :ivar vpn_client_address_pool: The reference of the address space resource which represents
     Address space for P2S VpnClient.
    :vartype vpn_client_address_pool: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
    :ivar vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
    :vartype vpn_client_root_certificates:
     list[~azure.mgmt.network.v2019_08_01.models.VpnClientRootCertificate]
    :ivar vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
    :vartype vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2019_08_01.models.VpnClientRevokedCertificate]
    :ivar vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
    :vartype vpn_client_protocols: list[str or
     ~azure.mgmt.network.v2019_08_01.models.VpnClientProtocol]
    :ivar vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S client.
    :vartype vpn_client_ipsec_policies: list[~azure.mgmt.network.v2019_08_01.models.IpsecPolicy]
    :ivar radius_server_address: The radius server address property of the VirtualNetworkGateway
     resource for vpn client connection.
    :vartype radius_server_address: str
    :ivar radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
     for vpn client connection.
    :vartype radius_server_secret: str
    :ivar aad_tenant: The AADTenant property of the VirtualNetworkGateway resource for vpn client
     connection used for AAD authentication.
    :vartype aad_tenant: str
    :ivar aad_audience: The AADAudience property of the VirtualNetworkGateway resource for vpn
     client connection used for AAD authentication.
    :vartype aad_audience: str
    :ivar aad_issuer: The AADIssuer property of the VirtualNetworkGateway resource for vpn client
     connection used for AAD authentication.
    :vartype aad_issuer: str
    """

    _attribute_map = {
        "vpn_client_address_pool": {"key": "vpnClientAddressPool", "type": "AddressSpace"},
        "vpn_client_root_certificates": {"key": "vpnClientRootCertificates", "type": "[VpnClientRootCertificate]"},
        "vpn_client_revoked_certificates": {
            "key": "vpnClientRevokedCertificates",
            "type": "[VpnClientRevokedCertificate]",
        },
        "vpn_client_protocols": {"key": "vpnClientProtocols", "type": "[str]"},
        "vpn_client_ipsec_policies": {"key": "vpnClientIpsecPolicies", "type": "[IpsecPolicy]"},
        "radius_server_address": {"key": "radiusServerAddress", "type": "str"},
        "radius_server_secret": {"key": "radiusServerSecret", "type": "str"},
        "aad_tenant": {"key": "aadTenant", "type": "str"},
        "aad_audience": {"key": "aadAudience", "type": "str"},
        "aad_issuer": {"key": "aadIssuer", "type": "str"},
    }

    def __init__(
        self,
        *,
        vpn_client_address_pool: Optional["_models.AddressSpace"] = None,
        vpn_client_root_certificates: Optional[List["_models.VpnClientRootCertificate"]] = None,
        vpn_client_revoked_certificates: Optional[List["_models.VpnClientRevokedCertificate"]] = None,
        vpn_client_protocols: Optional[List[Union[str, "_models.VpnClientProtocol"]]] = None,
        vpn_client_ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        radius_server_address: Optional[str] = None,
        radius_server_secret: Optional[str] = None,
        aad_tenant: Optional[str] = None,
        aad_audience: Optional[str] = None,
        aad_issuer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword vpn_client_address_pool: The reference of the address space resource which represents
         Address space for P2S VpnClient.
        :paramtype vpn_client_address_pool: ~azure.mgmt.network.v2019_08_01.models.AddressSpace
        :keyword vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        :paramtype vpn_client_root_certificates:
         list[~azure.mgmt.network.v2019_08_01.models.VpnClientRootCertificate]
        :keyword vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
         gateway.
        :paramtype vpn_client_revoked_