import time
from unittest.mock import Mock, patch

from pysnmp.proto import rfc1905

from cloudshell.snmp.core.snmp_response_reader import SnmpResponseReader

# Generated by CodiumAI


class TestSnmpResponseReader:
    #  SnmpResponseReader can be instantiated with required parameters
    def test_instantiation(self):
        snmp_engine = Mock()
        logger = Mock()
        reader = SnmpResponseReader(snmp_engine, logger)
        assert reader._snmp_engine == snmp_engine
        assert reader._logger == logger
        assert reader._context_id is None
        assert reader._context_name == ""
        assert reader._get_bulk_flag is False
        assert reader._get_bulk_repetitions == 25
        assert reader._retry_count == 2
        assert reader._stop_oid is None
        assert reader.cb_ctx == {
            "is_snmp_timeout": False,
            "reqTime": reader.cb_ctx.get("reqTime", time.time()),
            "": True,
            "retries": reader._retry_count,
        }
        assert reader.result == set()

    #  SnmpResponseReader can send a get request and receive a response
    def test_send_get_var_binds(self):
        logger = Mock()
        snmp_engine = Mock()
        with patch(
            "cloudshell.snmp.core.snmp_response_reader.cmdgen.GetCommandGenerator"
        ) as cmd_gen:
            reader = SnmpResponseReader(snmp_engine, logger)
            oid = "1.3.6.1.2.1.1.1.0"
            stop_oid = "1.3.6.1.2.1.1.2.0"

            reader.send_get_var_binds(oid, stop_oid)

            cmd_gen.assert_called_once_with()
            cmd_gen.return_value.sendVarBinds.assert_called_once_with(
                snmp_engine,
                "tgt",
                reader._context_id,
                reader._context_name,
                [(oid, None)],
                reader.cb_fun,
                reader.cb_ctx,
            )

    #  SnmpResponseReader can send a walk request and receive a response
    def test_send_walk_var_binds(self):
        snmp_engine = Mock()
        logger = Mock()
        reader = SnmpResponseReader(snmp_engine, logger)
        oid = "1.3.6.1.2.1.1.1"
        stop_oid = "1.3.6.1.2.1.1.2"
        with patch(
            "cloudshell.snmp.core.snmp_response_reader.cmdgen.NextCommandGenerator"
        ) as cmd_gen:
            reader.send_walk_var_binds(oid, stop_oid)

            cmd_gen.assert_called_once_with()
            cmd_gen.return_value.sendVarBinds.assert_called_once_with(
                snmp_engine,
                "tgt",
                reader._context_id,
                reader._context_name,
                [(oid, None)],
                reader.cb_walk_fun,
                reader.cb_ctx,
            )

    #  SnmpResponseReader can handle invalid SNMP responses
    def test_parse_response_invalid_snmp(self):
        snmp_engine = Mock()
        logger = Mock()
        reader = SnmpResponseReader(snmp_engine, logger)
        oid = "1.3.6.1.2.1.1.1.0"
        value = Mock(tagSet=rfc1905.NoSuchObject.tagSet)

        result = reader._parse_response(oid, value)

        assert result is True
        assert reader.result == set()
