from distutils.core import setup

setup(name='py2FaceR',
      version='0.1.1',
      description='Sync desktop Picasa facial recognition data to flickr',
      author='Paul Collins',
      author_email='paul.collins.iii@gmail.com',
      url='https://bitbucket.org/paulcollinsiii/py2facer/wiki/Home',
      license='GPL3',
      packages=['py2facer',
                'py2facer.commands',
                'py2facer.lib',
                'py2facer.tests', ],
      package_dir={'py2facer' : 'src/py2facer'},
      package_data={'py2facer' : ['tests/testdata/*.jpg',
                                  'tests/testdata/*.JPG',
                                  'tests/testdata/*.xml',
                                  'tests/testdata/.picasa.ini',
                                  'py2FaceR.conf']},
      scripts=['src/py2FaceR.py'],
      install_requires=['flickrapi',
                        'PIL',
                        'sqlalchemy', ],
      classifiers=['Development Status :: 2 - Pre-Alpha',
                   'Environment :: Console',
                   'Intended Audience :: Developers',
                   'License :: OSI Approved :: GNU General Public License (GPL)',
                   'Natural Language :: English',
                   'Operating System :: Microsoft :: Windows',
                   'Programming Language :: Python :: 2.7',
                   'Topic :: Utilities'
                   ],
      )
