""" Test tmpdirs module """
from __future__ import division, print_function, absolute_import

from os import getcwd
from os.path import realpath, abspath, dirname, isfile, join as pjoin, exists

from scipy.lib._tmpdirs import tempdir, in_tempdir, in_dir

from nose.tools import assert_true, assert_false, assert_equal

MY_PATH = abspath(__file__)
MY_DIR = dirname(MY_PATH)


def test_tempdir():
    with tempdir() as tmpdir:
        fname = pjoin(tmpdir, 'example_file.txt')
        with open(fname, 'wt') as fobj:
            _ = fobj.write('a string\\n')
    assert_false(exists(tmpdir))


def test_in_tempdir():
    my_cwd = getcwd()
    with in_tempdir() as tmpdir:
        _ = open('test.txt', 'wt').write('some text')
        assert_true(isfile('test.txt'))
        assert_true(isfile(pjoin(tmpdir, 'test.txt')))
    assert_false(exists(tmpdir))
    assert_equal(getcwd(), my_cwd)


def test_given_directory():
    # Test InGivenDirectory
    cwd = getcwd()
    with in_dir() as tmpdir:
        assert_equal(tmpdir, abspath(cwd))
        assert_equal(tmpdir, abspath(getcwd()))
    with in_dir(MY_DIR) as tmpdir:
        assert_equal(tmpdir, MY_DIR)
        assert_equal(realpath(MY_DIR), realpath(abspath(getcwd())))
    # We were deleting the Given directory!  Check not so now.
    assert_true(isfile(MY_PATH))
