# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobScheduleAddParameter(Model):
    """
    A job schedule that allows recurring jobs by specifying when to run jobs
    and a specification used to create each job.

    :param id: Gets or sets a string that uniquely identifies the schedule
     within the account. A GUID is recommended.
    :type id: str
    :param display_name: Gets or sets the display name for the schedule.
    :type display_name: str
    :param schedule: Gets or sets the schedule according to which jobs will
     be created.
    :type schedule: :class:`Schedule <azure.batch.models.Schedule>`
    :param job_specification: Gets or sets the details of the jobs to be
     created on this schedule.
    :type job_specification: :class:`JobSpecification
     <azure.batch.models.JobSpecification>`
    :param metadata: Gets or sets a list of name-value pairs associated with
     the schedule as metadata.
    :type metadata: list of :class:`MetadataItem
     <azure.batch.models.MetadataItem>`
    """ 

    _validation = {
        'id': {'required': True},
        'schedule': {'required': True},
        'job_specification': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, id, schedule, job_specification, display_name=None, metadata=None):
        self.id = id
        self.display_name = display_name
        self.schedule = schedule
        self.job_specification = job_specification
        self.metadata = metadata
