# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FileProperties(Model):
    """
    The properties of a file on a compute node.

    :param creation_time: Gets or sets the file creation time.
    :type creation_time: datetime
    :param last_modified: Gets or sets the time at which the file was last
     modified.
    :type last_modified: datetime
    :param content_length: Gets or sets the length of the file.
    :type content_length: long
    :param content_type: Gets or sets the content type of the file.
    :type content_type: str
    :param file_mode: Gets or sets the file mode attribute in octal format.
     This property will be returned only from a Linux compute node.
    :type file_mode: str
    """ 

    _validation = {
        'last_modified': {'required': True},
        'content_length': {'required': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'content_length': {'key': 'contentLength', 'type': 'long'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, last_modified, content_length, creation_time=None, content_type=None, file_mode=None):
        self.creation_time = creation_time
        self.last_modified = last_modified
        self.content_length = content_length
        self.content_type = content_type
        self.file_mode = file_mode
