# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ComputeNodeUser(Model):
    """
    An user account on a compute node.

    :param name: Gets or sets the user name of the account.
    :type name: str
    :param is_admin: Gets or sets whether the account should be an
     administrator on the compute node.
    :type is_admin: bool
    :param expiry_time: Gets or sets the time at which the account should
     expire. If omitted, the default is 1 day from the current time.
    :type expiry_time: datetime
    :param password: Gets or sets the password of the account.
    :type password: str
    :param ssh_public_key: Gets or sets the SSH public key that can be used
     for remote login to the compute node.
    :type ssh_public_key: str
    """ 

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'password': {'key': 'password', 'type': 'str'},
        'ssh_public_key': {'key': 'sshPublicKey', 'type': 'str'},
    }

    def __init__(self, name, is_admin=None, expiry_time=None, password=None, ssh_public_key=None):
        self.name = name
        self.is_admin = is_admin
        self.expiry_time = expiry_time
        self.password = password
        self.ssh_public_key = ssh_public_key
