# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import identity_sets_pb2 as identity__sets__pb2


class IdentitySetsStub(object):
    """A IdentitySet is a named grouping of Identity Aliases for Accounts.
    An Account's relationship to a IdentitySet is defined via IdentityAlias objects.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.IdentitySets/Create',
                request_serializer=identity__sets__pb2.IdentitySetCreateRequest.SerializeToString,
                response_deserializer=identity__sets__pb2.IdentitySetCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.IdentitySets/Get',
                request_serializer=identity__sets__pb2.IdentitySetGetRequest.SerializeToString,
                response_deserializer=identity__sets__pb2.IdentitySetGetResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.IdentitySets/Update',
                request_serializer=identity__sets__pb2.IdentitySetUpdateRequest.SerializeToString,
                response_deserializer=identity__sets__pb2.IdentitySetUpdateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.IdentitySets/Delete',
                request_serializer=identity__sets__pb2.IdentitySetDeleteRequest.SerializeToString,
                response_deserializer=identity__sets__pb2.IdentitySetDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.IdentitySets/List',
                request_serializer=identity__sets__pb2.IdentitySetListRequest.SerializeToString,
                response_deserializer=identity__sets__pb2.IdentitySetListResponse.FromString,
                )


class IdentitySetsServicer(object):
    """A IdentitySet is a named grouping of Identity Aliases for Accounts.
    An Account's relationship to a IdentitySet is defined via IdentityAlias objects.
    """

    def Create(self, request, context):
        """Create registers a new IdentitySet.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one IdentitySet by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update replaces all the fields of a IdentitySet by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a IdentitySet by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of IdentitySets matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_IdentitySetsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=identity__sets__pb2.IdentitySetCreateRequest.FromString,
                    response_serializer=identity__sets__pb2.IdentitySetCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=identity__sets__pb2.IdentitySetGetRequest.FromString,
                    response_serializer=identity__sets__pb2.IdentitySetGetResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=identity__sets__pb2.IdentitySetUpdateRequest.FromString,
                    response_serializer=identity__sets__pb2.IdentitySetUpdateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=identity__sets__pb2.IdentitySetDeleteRequest.FromString,
                    response_serializer=identity__sets__pb2.IdentitySetDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=identity__sets__pb2.IdentitySetListRequest.FromString,
                    response_serializer=identity__sets__pb2.IdentitySetListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.IdentitySets', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class IdentitySets(object):
    """A IdentitySet is a named grouping of Identity Aliases for Accounts.
    An Account's relationship to a IdentitySet is defined via IdentityAlias objects.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentitySets/Create',
            identity__sets__pb2.IdentitySetCreateRequest.SerializeToString,
            identity__sets__pb2.IdentitySetCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentitySets/Get',
            identity__sets__pb2.IdentitySetGetRequest.SerializeToString,
            identity__sets__pb2.IdentitySetGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentitySets/Update',
            identity__sets__pb2.IdentitySetUpdateRequest.SerializeToString,
            identity__sets__pb2.IdentitySetUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentitySets/Delete',
            identity__sets__pb2.IdentitySetDeleteRequest.SerializeToString,
            identity__sets__pb2.IdentitySetDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentitySets/List',
            identity__sets__pb2.IdentitySetListRequest.SerializeToString,
            identity__sets__pb2.IdentitySetListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
