# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_copy_request(
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_request(
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_list_by_database_request(
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    subscription_id: str,
    *,
    only_latest_per_database: Optional[bool] = None,
    database_state: Optional[Union[str, _models.DatabaseState]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if only_latest_per_database is not None:
        _params["onlyLatestPerDatabase"] = _SERIALIZER.query(
            "only_latest_per_database", only_latest_per_database, "bool"
        )
    if database_state is not None:
        _params["databaseState"] = _SERIALIZER.query("database_state", database_state, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_by_location_request(
    location_name: str,
    subscription_id: str,
    *,
    only_latest_per_database: Optional[bool] = None,
    database_state: Optional[Union[str, _models.DatabaseState]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if only_latest_per_database is not None:
        _params["onlyLatestPerDatabase"] = _SERIALIZER.query(
            "only_latest_per_database", only_latest_per_database, "bool"
        )
    if database_state is not None:
        _params["databaseState"] = _SERIALIZER.query("database_state", database_state, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_by_server_request(
    location_name: str,
    long_term_retention_server_name: str,
    subscription_id: str,
    *,
    only_latest_per_database: Optional[bool] = None,
    database_state: Optional[Union[str, _models.DatabaseState]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if only_latest_per_database is not None:
        _params["onlyLatestPerDatabase"] = _SERIALIZER.query(
            "only_latest_per_database", only_latest_per_database, "bool"
        )
    if database_state is not None:
        _params["databaseState"] = _SERIALIZER.query("database_state", database_state, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_copy_by_resource_group_request(
    resource_group_name: str,
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_by_resource_group_request(
    resource_group_name: str,
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_by_resource_group_request(
    resource_group_name: str,
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_by_resource_group_request(
    resource_group_name: str,
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    backup_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "backupName": _SERIALIZER.url("backup_name", backup_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_list_by_resource_group_database_request(
    resource_group_name: str,
    location_name: str,
    long_term_retention_server_name: str,
    long_term_retention_database_name: str,
    subscription_id: str,
    *,
    only_latest_per_database: Optional[bool] = None,
    database_state: Optional[Union[str, _models.DatabaseState]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "longTermRetentionDatabaseName": _SERIALIZER.url(
            "long_term_retention_database_name", long_term_retention_database_name, "str"
        ),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if only_latest_per_database is not None:
        _params["onlyLatestPerDatabase"] = _SERIALIZER.query(
            "only_latest_per_database", only_latest_per_database, "bool"
        )
    if database_state is not None:
        _params["databaseState"] = _SERIALIZER.query("database_state", database_state, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_by_resource_group_location_request(
    resource_group_name: str,
    location_name: str,
    subscription_id: str,
    *,
    only_latest_per_database: Optional[bool] = None,
    database_state: Optional[Union[str, _models.DatabaseState]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if only_latest_per_database is not None:
        _params["onlyLatestPerDatabase"] = _SERIALIZER.query(
            "only_latest_per_database", only_latest_per_database, "bool"
        )
    if database_state is not None:
        _params["databaseState"] = _SERIALIZER.query("database_state", database_state, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_by_resource_group_server_request(
    resource_group_name: str,
    location_name: str,
    long_term_retention_server_name: str,
    subscription_id: str,
    *,
    only_latest_per_database: Optional[bool] = None,
    database_state: Optional[Union[str, _models.DatabaseState]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-05-01-preview"] = kwargs.pop(
        "api_version", _params.pop("api-version", "2021-05-01-preview")
    )
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "locationName": _SERIALIZER.url("location_name", location_name, "str"),
        "longTermRetentionServerName": _SERIALIZER.url(
            "long_term_retention_server_name", long_term_retention_server_name, "str"
        ),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if only_latest_per_database is not None:
        _params["onlyLatestPerDatabase"] = _SERIALIZER.query(
            "only_latest_per_database", only_latest_per_database, "bool"
        )
    if database_state is not None:
        _params["databaseState"] = _SERIALIZER.query("database_state", database_state, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class LongTermRetentionBackupsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.sql.SqlManagementClient`'s
        :attr:`long_term_retention_backups` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    def _copy_initial(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> Optional[_models.LongTermRetentionBackupOperationResult]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.LongTermRetentionBackupOperationResult]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CopyLongTermRetentionBackupParameters")

        request = build_copy_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._copy_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _copy_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy"
    }

    @overload
    def begin_copy(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.CopyLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_copy(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_copy(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Is either a
         CopyLongTermRetentionBackupParameters type or a IO type. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._copy_initial(
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_copy.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy"
    }

    def _update_initial(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> Optional[_models.LongTermRetentionBackupOperationResult]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.LongTermRetentionBackupOperationResult]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "UpdateLongTermRetentionBackupParameters")

        request = build_update_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update"
    }

    @overload
    def begin_update(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.UpdateLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Is either a
         UpdateLongTermRetentionBackupParameters type or a IO type. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update"
    }

    @distributed_trace
    def get(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> _models.LongTermRetentionBackup:
        """Gets a long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LongTermRetentionBackup or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.LongTermRetentionBackup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackup] = kwargs.pop("cls", None)

        request = build_get_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LongTermRetentionBackup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}"
    }

    def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}"
    }

    @distributed_trace
    def begin_delete(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> LROPoller[None]:
        """Deletes a long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_initial(  # type: ignore
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}"
    }

    @distributed_trace
    def list_by_database(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> Iterable["_models.LongTermRetentionBackup"]:
        """Lists all long term retention backups for a database.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_database_request(
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    long_term_retention_database_name=long_term_retention_database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    template_url=self.list_by_database.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_database.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups"
    }

    @distributed_trace
    def list_by_location(
        self,
        location_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> Iterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given location.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_location_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    template_url=self.list_by_location.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_location.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups"
    }

    @distributed_trace
    def list_by_server(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> Iterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given server.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_server_request(
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    template_url=self.list_by_server.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_server.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups"
    }

    def _copy_by_resource_group_initial(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> Optional[_models.LongTermRetentionBackupOperationResult]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.LongTermRetentionBackupOperationResult]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CopyLongTermRetentionBackupParameters")

        request = build_copy_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._copy_by_resource_group_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _copy_by_resource_group_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy"
    }

    @overload
    def begin_copy_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.CopyLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup to a different server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_copy_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup to a different server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_copy_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup to a different server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Is either a
         CopyLongTermRetentionBackupParameters type or a IO type. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._copy_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_copy_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy"
    }

    def _update_by_resource_group_initial(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> Optional[_models.LongTermRetentionBackupOperationResult]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.LongTermRetentionBackupOperationResult]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "UpdateLongTermRetentionBackupParameters")

        request = build_update_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_by_resource_group_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_by_resource_group_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update"
    }

    @overload
    def begin_update_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.UpdateLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO],
        **kwargs: Any
    ) -> LROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Is either a
         UpdateLongTermRetentionBackupParameters type or a IO type. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongTermRetentionBackupOperationResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_update_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update"
    }

    @distributed_trace
    def get_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> _models.LongTermRetentionBackup:
        """Gets a long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LongTermRetentionBackup or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.LongTermRetentionBackup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackup] = kwargs.pop("cls", None)

        request = build_get_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_by_resource_group.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LongTermRetentionBackup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}"
    }

    def _delete_by_resource_group_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_by_resource_group_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_by_resource_group_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}"
    }

    @distributed_trace
    def begin_delete_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> LROPoller[None]:
        """Deletes a long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_by_resource_group_initial(  # type: ignore
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_delete_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}"
    }

    @distributed_trace
    def list_by_resource_group_database(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> Iterable["_models.LongTermRetentionBackup"]:
        """Lists all long term retention backups for a database.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_database_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    long_term_retention_database_name=long_term_retention_database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    template_url=self.list_by_resource_group_database.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_resource_group_database.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups"
    }

    @distributed_trace
    def list_by_resource_group_location(
        self,
        resource_group_name: str,
        location_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> Iterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given location.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_location_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    template_url=self.list_by_resource_group_location.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_resource_group_location.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups"
    }

    @distributed_trace
    def list_by_resource_group_server(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> Iterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-05-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-05-01-preview")
        )
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_server_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    template_url=self.list_by_resource_group_server.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_resource_group_server.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups"
    }
