# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import HDInsightManagementClientConfiguration
from .operations import ClustersOperations
from .operations import ApplicationsOperations
from .operations import LocationsOperations
from .operations import ConfigurationsOperations
from .operations import ExtensionsOperations
from .operations import ScriptActionsOperations
from .operations import ScriptExecutionHistoryOperations
from .operations import Operations
from .operations import VirtualMachinesOperations
from . import models


class HDInsightManagementClient(SDKClient):
    """HDInsight Management Client

    :ivar config: Configuration for client.
    :vartype config: HDInsightManagementClientConfiguration

    :ivar clusters: Clusters operations
    :vartype clusters: azure.mgmt.hdinsight.operations.ClustersOperations
    :ivar applications: Applications operations
    :vartype applications: azure.mgmt.hdinsight.operations.ApplicationsOperations
    :ivar locations: Locations operations
    :vartype locations: azure.mgmt.hdinsight.operations.LocationsOperations
    :ivar configurations: Configurations operations
    :vartype configurations: azure.mgmt.hdinsight.operations.ConfigurationsOperations
    :ivar extensions: Extensions operations
    :vartype extensions: azure.mgmt.hdinsight.operations.ExtensionsOperations
    :ivar script_actions: ScriptActions operations
    :vartype script_actions: azure.mgmt.hdinsight.operations.ScriptActionsOperations
    :ivar script_execution_history: ScriptExecutionHistory operations
    :vartype script_execution_history: azure.mgmt.hdinsight.operations.ScriptExecutionHistoryOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.hdinsight.operations.Operations
    :ivar virtual_machines: VirtualMachines operations
    :vartype virtual_machines: azure.mgmt.hdinsight.operations.VirtualMachinesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription credentials which uniquely
     identify Microsoft Azure subscription. The subscription ID forms part of
     the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = HDInsightManagementClientConfiguration(credentials, subscription_id, base_url)
        super(HDInsightManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-06-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.clusters = ClustersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.applications = ApplicationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.configurations = ConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.extensions = ExtensionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.script_actions = ScriptActionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.script_execution_history = ScriptExecutionHistoryOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self.config, self._serialize, self._deserialize)
