
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class OrderValidationResult(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getValidationResults(self,orderId):
		""" Retrieves a list of the validation results associated with the order.
		
		Args:
			| orderId (string) - Unique identifier of the order.
		
		Returns:
			| array of OrderValidationResult 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/validationresults", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addValidationResult(self,validationResult, orderId, responseFields = None):
		""" Add a new order validation result to a submitted order.
		
		Args:
			| validationResult(validationResult) - Properties of the resulting order validation performed by an order validation capability.
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| OrderValidationResult 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/validationresults?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(validationResult).execute();
		return self.client.result();

	
	
	