
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class CartItem(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getCartItem(self,cartItemId, responseFields = None):
		""" Retrieves a particular cart item by providing the cart item ID.
		
		Args:
			| cartItemId (string) - Identifier of the cart item to delete.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items/{cartItemId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("cartItemId", cartItemId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getCartItems(self,responseFields = None):
		""" Retrieves a list of cart items including the total number of items in the cart.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartItemCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addItemToCart(self,cartItem, responseFields = None):
		""" Adds a product to the current shopper's cart.
		
		Args:
			| cartItem(cartItem) - Properties of an item added to an active shopping cart.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(cartItem).execute();
		return self.client.result();

	
		
	def updateCartItemQuantity(self,cartItemId, quantity, responseFields = None):
		""" Update the quantity of an individual cart item in the cart of the current shopper.
		
		Args:
			| cartItemId (string) - Identifier of the cart item to delete.
			| quantity (int) - The number of cart items in the shopper's active cart.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items/{cartItemId}/{quantity}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("cartItemId", cartItemId);
		url.formatUrl("quantity", quantity);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateCartItem(self,cartItem, cartItemId, responseFields = None):
		""" Update the product or product quantity of an item in the current shopper's cart.
		
		Args:
			| cartItem(cartItem) - Properties of an item added to an active shopping cart.
			| cartItemId (string) - Identifier of the cart item to delete.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartItem 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items/{cartItemId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("cartItemId", cartItemId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(cartItem).execute();
		return self.client.result();

	
		
	def removeAllCartItems(self,):
		""" Removes all items in the current shopper's active cart.
		
		Returns:
			| Cart 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items", "DELETE", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def deleteCartItem(self,cartItemId):
		""" Deletes a specific cart item by providing the cart item ID.
		
		Args:
			| cartItemId (string) - Identifier of the cart item to delete.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/items/{cartItemId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("cartItemId", cartItemId);
		self.client.withResourceUrl(url).execute();

	
	
	