// ---------------------------------------------------
// automatically generated by SIMPLEX GUI, do not edit
// ---------------------------------------------------

#ifndef simplex_input_h
#define simplex_input_h

#include <string>
#include <map>
#include <tuple>
#include <vector>
using namespace std;

// labels for parameters and data import
const string EBLabel = "Electron Beam";
const string SeedLabel = "Seed Light";
const string SPXOutLabel = "SIMPLEX Output";
const string UndLabel = "Undulator";
const string WakeLabel = "Wakefield";
const string LatticeLabel = "Lattice";
const string ChicaneLabel = "Chicane";
const string DispersionLabel = "Dispersion";
const string AlignmentLabel = "Alignment";
const string SimCondLabel = "Simulation Conditions";
const string DataDumpLabel = "Data Dump Configurations";
const string OutFileLabel = "Output File";
const string PostPLabel = "Post-Processing";
const string ScanLabel = "Scan Parameter";
const string Fin1ScanLabel = "Scan Process: ";
const string ScanOutLabel = "Output File: ";
const string ErrorLabel = "Error: ";
const string WarningLabel = "Warning: ";
const string InputLabel = "Input";
const string GainCurveLabel = "Gain Curve";
const string RadCharactLabel = "Characteristics";
const string TempProfileLabel = "Temporal Profile";
const string SpecProfileLabel = "Spectral Profile";
const string SpatProfileLabel = "Spatial Profile";
const string AnglProfileLabel = "Angular Profile";
const string KValueTrendLabel = "K Value Trend";
const string CoordinateLabel = "Raw Data Export";
const string StepCoordLabel = "Steps (m)";
const string StepIndexLabel = "Step Index";
const string SliceCoordLabel = "Slices (m)";
const string XYCoordLabel = "Grid Intervals (m,rad)";
const string AvgEnergyLabel = "Average Electron Energy (GeV)";
const string SliceEmittanceLabel = "Normalized Slice Emittance (mm.mrad)";
const string SliceEspreadLabel = "Slice Energy Spread";
const string PeakCurrLabel = "Peak Current (A)";
const string SimulatedChargeLabel = "Total Charge Simulated (C)";
const string TotalStepsLabel = "Total Steps Simulated";
const string CentralEnergyLabel = "Central Photon Energy (eV)";
const string XYPointsLabel = "Grid Points";
const string BeamletsLabel = "Beamlets";
const string ParticlesLabel = "Particles/Beamlet";
const string DataDimLabel = "dimension";
const string DataTitlesLabel = "titles";
const string UnitsLabel = "units";
const string VariablesLabel = "variables";
const string RetInfLabel = "returns";
const string DataNameLabel = "Data File";
const string EtDistLabel = "Ref. Particles in (t,E)";
const string CurrentProfLabel = "Current Profile";
const string EtProfLabel = "E-t Profile";
const string PostPResultLabel = "Processed";
const string PlotScatterLabel = "scatter";
const string PPMicroBunchLabel = "Simplified Microbunch Evaluation";
const string PPFDlabel = "Field Distribution";
const string PP1stIntLabel = "1st Integral";
const string PP2ndIntLabel = "2nd Integral";
const string PPPhaseErrLabel = "Phase Error";
const string PPKValue = "K Value Trend";
const string PPDetune = "Detuning Trend";
const string PPWakeBunch = "Wakefield Temporal Profile";
const string PPWakeEvar = "Energy Distribution";
const string PPBetaLabel = "betatron Functions";
const string PPOptBetaLabel = "Optimization";
const string PPFocusStrength = "Focusing Strength";
const string PPDispersion = "Dispersion";
const string PPMonoSpectrum = "Mono. Spectrum";
const string IntegerLabel = "INTEGER";
const string IncrementalLabel = "INCREMENTAL";
const string NumberLabel = "NUMBER";
const string DataLabel = "data";
const string GridLabel = "GRID";
const string BoolLabel = "BOOLEAN";
const string StringLabel = "STRING";
const string SelectionLabel = "SELECTION";
const string ArrayLabel = "NUMBERARRAY";
const string ArrayIntegerLabel = "INTEGERARRAY";
const string ArrayIncrementalLabel = "INCRARRAY";

// labels for selections
const string NotAvaliable = "N.A.";
const string CustomLabel = "Customize";
const string GaussianBunch = "Gaussian";
const string BoxcarBunch = "Boxcar";
const string SimplexOutput = "SIMPLEX Output";
const string CustomSlice = "Slice Parameters";
const string CustomCurrent = "Current Profile";
const string CustomEt = "E-t Profile";
const string CustomParticle = "Particle Distribution";
const string ProjectedPrm = "Projected";
const string SlicedPrmOptimize = "Sliced (Optimized)";
const string SlicedPrmCustom = "Sliced (Custom)";
const string UndDataLabel = "Undulator Data";
const string WakeDataLabel = "Wakefield Data";
const string MonoDataLabel = "Monochromator Data";
const string UnitMeter = "m";
const string UnitMiliMeter = "mm";
const string UnitRad = "rad";
const string UnitMiliRad = "mrad";
const string UnitSec = "s";
const string UnitpSec = "ps";
const string UnitfSec = "fs";
const string UnitGeV = "GeV";
const string UnitMeV = "MeV";
const string UnitGamma = "gamma";
const string GaussianPulse = "Gaussian Beam";
const string ChirpedPulse = "Chirp Pulse";
const string LinearUndLabel = "Linear";
const string HelicalUndLabel = "Helical";
const string EllipticUndLabel = "Elliptical";
const string MultiHarmUndLabel = "Multi-Harmonic";
const string MultiHarmContLabel = "Multi-Harmonic Contents";
const string TaperCustomLabel = "Custom Taper";
const string DataAllocLabel = "Data Allocation";
const string TaperStair = "Stair-Like";
const string TaperContinuous = "Continuous";
const string TaperCustom = "Custom";
const string TaperOptWhole = "Projection";
const string TaperOptSlice = "Slice";
const string TaperOptWake = "Compensate Wake";
const string IdealLabel = "Ideal";
const string SpecifyErrLabel = "Specify Error";
const string ImportDataLabel = "Import Data";
const string FUFULabel = "FUFU (QF-U-QF-U)";
const string FUDULabel = "FUDU (QF-U-QD-U)";
const string DUFULabel = "DUFU (QD-U-QF-U)";
const string DoubletLabel = "Doublet (QF-QD-U)";
const string TripletLabel = "Triplet (QF-QD-QF-U)";
const string CombinedLabel = "Undulator Combined";
const string XtalTransLabel = "Transmission";
const string XtalReflecLabel = "Reflection";
const string C400Label = "Diamond (400)";
const string C220Label = "Diamond (220)";
const string Si111Label = "Silicon (111)";
const string TargetOffsetLabel = "Specify Offset";
const string TargetErrorLabel = "Specify Tolerance";
const string OffsetEachLabel = "Offset for Each Segment";
const string TimeDepLabel = "Time Dependent";
const string SSLabel = "Steady State";
const string CyclicLabel = "Cyclic";
const string SmoothingGauss = "Gaussian Mode";
const string KillQuiteLoad = "Disable Quiet Loading";
const string KillShotNoize = "Kill Shotnoize";
const string RealElectronNumber = "Real Electron Number";
const string DumpSegExitLabel = "All Segments";
const string DumpSpecifyLabel = "Specific Segments";
const string DumpUndExitLabel = "Final Step";
const string RegularIntSteps = "Regular Interval";
const string WholeSliceLabel = "All Slices";
const string SpecificSliceLabel = "Specific Slices";
const string SliceLabel = "s (m)";
const string CurrentLabel = "I (A)";
const string EnergyLabel = "Energy (GeV)";
const string EspLabel = "Energy Spread";
const string EmittxLabel = "&epsilon;<sub>x</sub> (mm.mrad)";
const string EmittyLabel = "&epsilon;<sub>y</sub> (mm.mrad)";
const string BetaxLabel = "&beta;<sub>x</sub> (m)";
const string BetayLabel = "&beta;<sub>y</sub> (m)";
const string AlphaxLabel = "&alpha;<sub>x</sub>";
const string AlphayLabel = "&alpha;<sub>y</sub>";
const string XavLabel = "&lt;x&gt; (m)";
const string YavLabel = "&lt;y&gt; (m)";
const string XpavLabel = "&lt;x'&gt; (rad)";
const string YpavLabel = "&lt;y'&gt; (rad)";
const string CalcStatusLabel = "Simulation Status: ";
const string InitStatusLabel = "Initializing: ";
const string ScanPrmItems = "4";
const string PPBetaOptQgrad = "Average";
const string PPBetaOptInitial = "Matching";
const string PostPPowerLabel = "Radiation Power";
const string PostPFluxLabel = "Photon Flux";
const string PostPCampLabel = "Complex Amplitude";
const string PostPBunchFLabel = "Bunch Factor";
const string PostPEnergyLabel = "Energy Distribution";
const string PostPPartDistLabel = "Particle Motion";
const string PostPFarLabel = "Far Field";
const string PostPNearLabel = "Near Field";
const string PostPtXLabel = "(s, x)";
const string PostPtYLabel = "(s, y)";
const string PostPtetaLabel = "(s, &Delta;&gamma;/&gamma;)";
const string PostPIntegFullLabel = "Whole";
const string PostPIntegPartialLabel = "Set Window";
const string PostPWignerLabel = "Wigner Function";
const string PostPRealLabel = "Real Part";
const string PostPImagLabel = "Imaginary Part";
const string PostPExLabel = "x";
const string PostPEyLabel = "y";
const string PostPBothLabel = "Both";
const string PostPTimeDomainLabel = "Temporal";
const string PostPSpatDomainLabel = "Spatial";
const string PostPXAxisLabel = "x";
const string PostPYAxisLabel = "y";
const string PulseEnergyLabel = "Pulse Energy";
const string RadPowerLabel = "Radiation Power";
const string SpatEnergyDensLabel = "Spatial Energy Density";
const string AngEnergyDensLabel = "Angular Energy Density";
const string SpatPowerDensLabel = "Spatial Power Density";
const string AngPowerDensLabel = "Angular Power Density";
const string BunchFactorLabel = "Bunch Factor";
const string ELossLabel = "Energy Loss";
const string PLossLabel = "Power Loss";
const string EspreadLabel = "Energy Spread";
const string PulselengthLabel = "RMS Pulse Length";
const string BandwidthLabel = "RMS Bandwidth";
const string DivergenceX = "RMS Divergence (x)";
const string DivergenceY = "RMS Divergence (y)";
const string BeamSizeX = "RMS Beam Size (x)";
const string BeamSizeY = "RMS Beam Size (y)";
const string CurvatureLabel = "Wavefront Curvature";
const string ElapsedTimeLabel = "Elapsed Time (sec)";

// labels to force update for scan option
const vector<string>  UpdateScans {
	"Pulse Energy (J)", "Electron Delay (fs)", "&hbar;&omega;<sub>1st</sub> (eV)", "&lambda;<sub>1st</sub> (nm)"
};

const map<string, vector<double>> BuiltinXtals {
	{"Diamond (400)", vector<double> {12.72, 0.089175, 0.045385}},
	{"Diamond (220)", vector<double> {15.68, 0.1261, 0.045385}},
	{"Silicon (111)", vector<double> {42.484, 0.31357, 0.16019}}
};

// Electron Beam
enum EBeamIndex {
	eenergy_ = 0, bunchleng_, bunchlenr_, bunchcharge_, espread_, echirp_, pkcurr_, r56_,
		twisspos_, NumEBeamPrm,
	emitt_ = 0, eta_, ebmsize_, ediv_, avgsize_, bunchbeta_, bunchalpha_, NumEBeamVec,
	bmprofile_ = 0, twissbunch_, NumEBeamSel,
	partfile_ = 0, NumEBeamStr,
	slicefile_ = 0, currfile_, etfile_, partspec_, basespec_, NumEBeamData
};

const map<string, tuple<int, string>> EBeam {
	{"Electron Energy (GeV)", tuple<int, string> (eenergy_, "NUMBER")},
	{"RMS Bunch Length (m)", tuple<int, string> (bunchleng_, "NUMBER")},
	{"Bunch Length (m)", tuple<int, string> (bunchlenr_, "NUMBER")},
	{"Bunch Charge (nC)", tuple<int, string> (bunchcharge_, "NUMBER")},
	{"RMS Energy Spread", tuple<int, string> (espread_, "NUMBER")},
	{"Energy Chirp (m<sup>-1</sup>)", tuple<int, string> (echirp_, "NUMBER")},
	{"Peak Current (A)", tuple<int, string> (pkcurr_, "NUMBER")},
	{"R<sub>56</sub> (m)", tuple<int, string> (r56_, "NUMBER")},
	{"Slice Position (m)", tuple<int, string> (twisspos_, "NUMBER")},
	{"&epsilon;<sub>x,y</sub> (mm.mrad)", tuple<int, string> (emitt_, "NUMBERARRAY")},
	{"&eta;<sub>x,y</sub> (m)", tuple<int, string> (eta_, "NUMBERARRAY")},
	{"&sigma;<sub>0x,0y</sub> (mm)", tuple<int, string> (ebmsize_, "NUMBERARRAY")},
	{"&sigma;<sub>0x',0y'</sub> (mrad)", tuple<int, string> (ediv_, "NUMBERARRAY")},
	{"&lt;&sigma;<sub>x,y</sub>&gt; (mm)", tuple<int, string> (avgsize_, "NUMBERARRAY")},
	{"&beta;<sub>x,y</sub> (m)", tuple<int, string> (bunchbeta_, "NUMBERARRAY")},
	{"&alpha;<sub>x,y</sub> (m)", tuple<int, string> (bunchalpha_, "NUMBERARRAY")},
	{"Bunch Profile", tuple<int, string> (bmprofile_, "SELECTION")},
	{"Bunch Twiss Prms.", tuple<int, string> (twissbunch_, "SELECTION")},
	{"Particle Distribution", tuple<int, string> (partfile_, "STRING")},
	{"Slice Parameters", tuple<int, string> (slicefile_, "data")},
	{"Current Profile", tuple<int, string> (currfile_, "data")},
	{"E-t Profile", tuple<int, string> (etfile_, "data")},
	{"Sliced Particle Spec.", tuple<int, string> (partspec_, "data")},
	{"Base Spec.", tuple<int, string> (basespec_, "data")}
};

const map<string, tuple<int, string>> EBeamSimple {
	{"eenergy", tuple<int, string> (eenergy_, "NUMBER")},
	{"bunchleng", tuple<int, string> (bunchleng_, "NUMBER")},
	{"bunchlenr", tuple<int, string> (bunchlenr_, "NUMBER")},
	{"bunchcharge", tuple<int, string> (bunchcharge_, "NUMBER")},
	{"espread", tuple<int, string> (espread_, "NUMBER")},
	{"echirp", tuple<int, string> (echirp_, "NUMBER")},
	{"pkcurr", tuple<int, string> (pkcurr_, "NUMBER")},
	{"r56", tuple<int, string> (r56_, "NUMBER")},
	{"twisspos", tuple<int, string> (twisspos_, "NUMBER")},
	{"emitt", tuple<int, string> (emitt_, "NUMBERARRAY")},
	{"eta", tuple<int, string> (eta_, "NUMBERARRAY")},
	{"ebmsize", tuple<int, string> (ebmsize_, "NUMBERARRAY")},
	{"ediv", tuple<int, string> (ediv_, "NUMBERARRAY")},
	{"avgsize", tuple<int, string> (avgsize_, "NUMBERARRAY")},
	{"bunchbeta", tuple<int, string> (bunchbeta_, "NUMBERARRAY")},
	{"bunchalpha", tuple<int, string> (bunchalpha_, "NUMBERARRAY")},
	{"bmprofile", tuple<int, string> (bmprofile_, "SELECTION")},
	{"twissbunch", tuple<int, string> (twissbunch_, "SELECTION")},
	{"partfile", tuple<int, string> (partfile_, "STRING")},
	{"slicefile", tuple<int, string> (slicefile_, "data")},
	{"currfile", tuple<int, string> (currfile_, "data")},
	{"etfile", tuple<int, string> (etfile_, "data")},
	{"partspec", tuple<int, string> (partspec_, "data")},
	{"basespec", tuple<int, string> (basespec_, "data")}
};

const vector<double> DefEBeamPrm {
	8, 0.000005, 0.00001, 0.15, 0.0001, 0, 3588, 0,
	0
};

const vector<vector<double>> DefEBeamVec {
	{0.4, 0.4}, {0, 0}, {0.00002, 0.00002}, {0.000001, 0.000001}, {0, 0}, {20, 20}, {0, 0}
};

const vector<bool> DefEBeamBool {};

const vector<string> DefEBeamSel {
	"Gaussian", "Projected"
};

const vector<string> DefEBeamStr {
	""
};

// Seed Light
enum SeedIndex {
	pkpower_ = 0, relwavelen_, wavelen_, pulseenergy_, pulselen_, spotsize_, raylen_, waistpos_,
		timing_, CEP_, gdd_, tod_, stplen_, chirprate_, phase_, NumSeedPrm,
	seedprofile_ = 0, NumSeedSel
};

const map<string, tuple<int, string>> Seed {
	{"Peak Power (W)", tuple<int, string> (pkpower_, "NUMBER")},
	{"&Delta;&lambda;/&lambda;<sub>1</sub>", tuple<int, string> (relwavelen_, "NUMBER")},
	{"Wavelength (nm)", tuple<int, string> (wavelen_, "NUMBER")},
	{"Pulse Energy (J)", tuple<int, string> (pulseenergy_, "NUMBER")},
	{"FWHM Pulse Length (fs)", tuple<int, string> (pulselen_, "NUMBER")},
	{"FWHM Spot Size (mm)", tuple<int, string> (spotsize_, "NUMBER")},
	{"Rayleigh Length (m)", tuple<int, string> (raylen_, "NUMBER")},
	{"Position of Waist (m)", tuple<int, string> (waistpos_, "NUMBER")},
	{"Relative Time (fs)", tuple<int, string> (timing_, "NUMBER")},
	{"Carrier Envelope Phase (&deg;)", tuple<int, string> (CEP_, "NUMBER")},
	{"GDD (fs<sup>2</sup>)", tuple<int, string> (gdd_, "NUMBER")},
	{"TOD (fs<sup>3</sup>)", tuple<int, string> (tod_, "NUMBER")},
	{"Stretched Pulse Length (fs)", tuple<int, string> (stplen_, "NUMBER")},
	{"Chirp Rate (&Delta;&omega;/&omega;)", tuple<int, string> (chirprate_, "NUMBER")},
	{"Phase Offset (&deg;)", tuple<int, string> (phase_, "NUMBER")},
	{"Seed Light", tuple<int, string> (seedprofile_, "SELECTION")}
};

const map<string, tuple<int, string>> SeedSimple {
	{"pkpower", tuple<int, string> (pkpower_, "NUMBER")},
	{"relwavelen", tuple<int, string> (relwavelen_, "NUMBER")},
	{"wavelen", tuple<int, string> (wavelen_, "NUMBER")},
	{"pulseenergy", tuple<int, string> (pulseenergy_, "NUMBER")},
	{"pulselen", tuple<int, string> (pulselen_, "NUMBER")},
	{"spotsize", tuple<int, string> (spotsize_, "NUMBER")},
	{"raylen", tuple<int, string> (raylen_, "NUMBER")},
	{"waistpos", tuple<int, string> (waistpos_, "NUMBER")},
	{"timing", tuple<int, string> (timing_, "NUMBER")},
	{"CEP", tuple<int, string> (CEP_, "NUMBER")},
	{"gdd", tuple<int, string> (gdd_, "NUMBER")},
	{"tod", tuple<int, string> (tod_, "NUMBER")},
	{"stplen", tuple<int, string> (stplen_, "NUMBER")},
	{"chirprate", tuple<int, string> (chirprate_, "NUMBER")},
	{"phase", tuple<int, string> (phase_, "NUMBER")},
	{"seedprofile", tuple<int, string> (seedprofile_, "SELECTION")}
};

const vector<double> DefSeedPrm {
	1000000000, 0, 1, 0.001, 40, 0.05, 10, 0,
	0, 0, 0, 0, 40, 0.1, 0
};

const vector<vector<double>> DefSeedVec {};

const vector<bool> DefSeedBool {};

const vector<string> DefSeedSel {
	"N.A."
};

const vector<string> DefSeedStr {};

// Microbunch Evaluation
enum MbunchIndex {
	mbparticles_ = 0, mbaccinteg_, tpoints_, epoints_, mbr56_, nr56_, mbsegments_, relwavelen2_,
		CEP2_, gdd2_, tod2_, timing2_, NumMbunchPrm,
	mbtrange_ = 0, erange_, NumMbunchVec,
	iscurrent_ = 0, isEt_, isoptR56_, wpulse_, NumMbunchBool
};

const map<string, tuple<int, string>> Mbunch {
	{"Particles/&lambda;", tuple<int, string> (mbparticles_, "NUMBER")},
	{"Accuracy of Integration", tuple<int, string> (mbaccinteg_, "NUMBER")},
	{"Points/&lambda;", tuple<int, string> (tpoints_, "NUMBER")},
	{"Energy Points", tuple<int, string> (epoints_, "NUMBER")},
	{"R<sub>56</sub> (m)", tuple<int, string> (mbr56_, "NUMBER")},
	{"Normalized R<sub>56</sub>", tuple<int, string> (nr56_, "NUMBER")},
	{"Number of Undulators", tuple<int, string> (mbsegments_, "NUMBER")},
	{"&Delta;&lambda;/&lambda;", tuple<int, string> (relwavelen2_, "NUMBER")},
	{"CEP (&deg;)", tuple<int, string> (CEP2_, "NUMBER")},
	{"GDD (fs<sup>2</sup>)", tuple<int, string> (gdd2_, "NUMBER")},
	{"TOD (fs<sup>2</sup>)", tuple<int, string> (tod2_, "NUMBER")},
	{"Time Delay (fs)", tuple<int, string> (timing2_, "NUMBER")},
	{"Temporal Range", tuple<int, string> (mbtrange_, "NUMBERARRAY")},
	{"Energy Range", tuple<int, string> (erange_, "NUMBERARRAY")},
	{"Current Profile", tuple<int, string> (iscurrent_, "BOOLEAN")},
	{"E-t Profile", tuple<int, string> (isEt_, "BOOLEAN")},
	{"Optimize R<sub>56</sub>", tuple<int, string> (isoptR56_, "BOOLEAN")},
	{"Double Pulse", tuple<int, string> (wpulse_, "BOOLEAN")}
};

const map<string, tuple<int, string>> MbunchSimple {
	{"mbparticles", tuple<int, string> (mbparticles_, "NUMBER")},
	{"mbaccinteg", tuple<int, string> (mbaccinteg_, "NUMBER")},
	{"tpoints", tuple<int, string> (tpoints_, "NUMBER")},
	{"epoints", tuple<int, string> (epoints_, "NUMBER")},
	{"mbr56", tuple<int, string> (mbr56_, "NUMBER")},
	{"nr56", tuple<int, string> (nr56_, "NUMBER")},
	{"mbsegments", tuple<int, string> (mbsegments_, "NUMBER")},
	{"relwavelen2", tuple<int, string> (relwavelen2_, "NUMBER")},
	{"CEP2", tuple<int, string> (CEP2_, "NUMBER")},
	{"gdd2", tuple<int, string> (gdd2_, "NUMBER")},
	{"tod2", tuple<int, string> (tod2_, "NUMBER")},
	{"timing2", tuple<int, string> (timing2_, "NUMBER")},
	{"mbtrange", tuple<int, string> (mbtrange_, "NUMBERARRAY")},
	{"erange", tuple<int, string> (erange_, "NUMBERARRAY")},
	{"iscurrent", tuple<int, string> (iscurrent_, "BOOLEAN")},
	{"isEt", tuple<int, string> (isEt_, "BOOLEAN")},
	{"isoptR56", tuple<int, string> (isoptR56_, "BOOLEAN")},
	{"wpulse", tuple<int, string> (wpulse_, "BOOLEAN")}
};

const vector<double> DefMbunchPrm {
	16, 1, 16, 21, 0.000001, 1, 1, 0,
	0, 0, 0, 0
};

const vector<vector<double>> DefMbunchVec {
	{-5e-7, 5e-7}, {-0.001, 0.001}
};

const vector<bool> DefMbunchBool {
	false, false, false, false
};

const vector<string> DefMbunchSel {};

const vector<string> DefMbunchStr {};

// SIMPLEX Output
enum SPXOutIndex {
	spxstep_ = 0, spxstepz_, bmletsout_, paticlesout_, matching_, spxenergy_, NumSPXOutPrm,
	spxfile_ = 0, NumSPXOutStr,
	spxstepzarr_ = 0, NumSPXOutData
};

const map<string, tuple<int, string>> SPXOut {
	{"Step Index to Retrieve Data", tuple<int, string> (spxstep_, "NUMBER")},
	{"z (m)", tuple<int, string> (spxstepz_, "NUMBER")},
	{"Total Beamlets", tuple<int, string> (bmletsout_, "NUMBER")},
	{"Particles/Beamlet", tuple<int, string> (paticlesout_, "NUMBER")},
	{"Drift Length (m)", tuple<int, string> (matching_, "NUMBER")},
	{"Photon Energy (eV)", tuple<int, string> (spxenergy_, "NUMBER")},
	{"Data Name", tuple<int, string> (spxfile_, "STRING")},
	{"Exported Positions (m)", tuple<int, string> (spxstepzarr_, "GRID")}
};

const map<string, tuple<int, string>> SPXOutSimple {
	{"spxstep", tuple<int, string> (spxstep_, "NUMBER")},
	{"spxstepz", tuple<int, string> (spxstepz_, "NUMBER")},
	{"bmletsout", tuple<int, string> (bmletsout_, "NUMBER")},
	{"paticlesout", tuple<int, string> (paticlesout_, "NUMBER")},
	{"matching", tuple<int, string> (matching_, "NUMBER")},
	{"spxenergy", tuple<int, string> (spxenergy_, "NUMBER")},
	{"spxfile", tuple<int, string> (spxfile_, "STRING")},
	{"spxstepzarr", tuple<int, string> (spxstepzarr_, "GRID")}
};

const vector<double> DefSPXOutPrm {
	0, 100, 0, 0, 1, 10
};

const vector<vector<double>> DefSPXOutVec {};

const vector<bool> DefSPXOutBool {};

const vector<string> DefSPXOutSel {};

const vector<string> DefSPXOutStr {
	""
};

// Undulator
enum UndIndex {
	K_ = 0, Kperp_, epukratio_, lu_, length_, segments_, interval_, peakb_,
		periods_, slippage_, exslippage_, slicepos_, initial_, incrseg_, base_, incrtaper_,
		Kexit_, detune_, umrandseed_, phaseerr_, berr_, tgtsegment_, NumUndPrm,
	xyerr_ = 0, NumUndVec,
	umautoseed_ = 0, allsegment_, NumUndBool,
	utype_ = 0, taper_, opttype_, umodel_, NumUndSel,
	multiharm_ = 0, tapercustom_, udata_, NumUndData
};

const map<string, tuple<int, string>> Und {
	{"K Value", tuple<int, string> (K_, "NUMBER")},
	{"K<sub>&perp;</sub>", tuple<int, string> (Kperp_, "NUMBER")},
	{"tan<sup>-1</sup>(K<sub>x</sub>/K<sub>y</sub>) (&deg;)", tuple<int, string> (epukratio_, "NUMBER")},
	{"&lambda;<sub>u</sub> (mm)", tuple<int, string> (lu_, "NUMBER")},
	{"Length/Segment (m)", tuple<int, string> (length_, "NUMBER")},
	{"Number of Segments", tuple<int, string> (segments_, "NUMBER")},
	{"Segment Interval", tuple<int, string> (interval_, "NUMBER")},
	{"Peak Field (T)", tuple<int, string> (peakb_, "NUMBER")},
	{"Periods/Segment", tuple<int, string> (periods_, "NUMBER")},
	{"Slippage in Drift (2&pi;)", tuple<int, string> (slippage_, "NUMBER")},
	{"Extra Slippage (&deg;)", tuple<int, string> (exslippage_, "NUMBER")},
	{"Target Slice Position (m)", tuple<int, string> (slicepos_, "NUMBER")},
	{"Initial Segment", tuple<int, string> (initial_, "NUMBER")},
	{"Increment Segment Interval", tuple<int, string> (incrseg_, "NUMBER")},
	{"Base Linear Taper (m<sup>-1</sup>)", tuple<int, string> (base_, "NUMBER")},
	{"Taper Increment (m<sup>-1</sup>)", tuple<int, string> (incrtaper_, "NUMBER")},
	{"K Value@Exit", tuple<int, string> (Kexit_, "NUMBER")},
	{"Resonance Detuning@Exit", tuple<int, string> (detune_, "NUMBER")},
	{"Random Number Seed", tuple<int, string> (umrandseed_, "NUMBER")},
	{"&sigma;<sub>&phi;</sub> (&deg;)", tuple<int, string> (phaseerr_, "NUMBER")},
	{"&sigma;<sub>B</sub>/B (%)", tuple<int, string> (berr_, "NUMBER")},
	{"Target Segment", tuple<int, string> (tgtsegment_, "NUMBER")},
	{"&sigma;<sub>x,y</sub> (mm)", tuple<int, string> (xyerr_, "NUMBERARRAY")},
	{"Random Number Auto Seeding", tuple<int, string> (umautoseed_, "BOOLEAN")},
	{"Apply to All Segments", tuple<int, string> (allsegment_, "BOOLEAN")},
	{"Undulator Type", tuple<int, string> (utype_, "SELECTION")},
	{"Tapering", tuple<int, string> (taper_, "SELECTION")},
	{"Optimization", tuple<int, string> (opttype_, "SELECTION")},
	{"Undulator Model", tuple<int, string> (umodel_, "SELECTION")},
	{"Multi-Harmonic Contents", tuple<int, string> (multiharm_, "GRID")},
	{"Custom Taper", tuple<int, string> (tapercustom_, "GRID")},
	{"Data Allocation", tuple<int, string> (udata_, "GRID")}
};

const map<string, tuple<int, string>> UndSimple {
	{"K", tuple<int, string> (K_, "NUMBER")},
	{"Kperp", tuple<int, string> (Kperp_, "NUMBER")},
	{"epukratio", tuple<int, string> (epukratio_, "NUMBER")},
	{"lu", tuple<int, string> (lu_, "NUMBER")},
	{"length", tuple<int, string> (length_, "NUMBER")},
	{"segments", tuple<int, string> (segments_, "NUMBER")},
	{"interval", tuple<int, string> (interval_, "NUMBER")},
	{"peakb", tuple<int, string> (peakb_, "NUMBER")},
	{"periods", tuple<int, string> (periods_, "NUMBER")},
	{"slippage", tuple<int, string> (slippage_, "NUMBER")},
	{"exslippage", tuple<int, string> (exslippage_, "NUMBER")},
	{"slicepos", tuple<int, string> (slicepos_, "NUMBER")},
	{"initial", tuple<int, string> (initial_, "NUMBER")},
	{"incrseg", tuple<int, string> (incrseg_, "NUMBER")},
	{"base", tuple<int, string> (base_, "NUMBER")},
	{"incrtaper", tuple<int, string> (incrtaper_, "NUMBER")},
	{"Kexit", tuple<int, string> (Kexit_, "NUMBER")},
	{"detune", tuple<int, string> (detune_, "NUMBER")},
	{"umrandseed", tuple<int, string> (umrandseed_, "NUMBER")},
	{"phaseerr", tuple<int, string> (phaseerr_, "NUMBER")},
	{"berr", tuple<int, string> (berr_, "NUMBER")},
	{"tgtsegment", tuple<int, string> (tgtsegment_, "NUMBER")},
	{"xyerr", tuple<int, string> (xyerr_, "NUMBERARRAY")},
	{"umautoseed", tuple<int, string> (umautoseed_, "BOOLEAN")},
	{"allsegment", tuple<int, string> (allsegment_, "BOOLEAN")},
	{"utype", tuple<int, string> (utype_, "SELECTION")},
	{"taper", tuple<int, string> (taper_, "SELECTION")},
	{"opttype", tuple<int, string> (opttype_, "SELECTION")},
	{"umodel", tuple<int, string> (umodel_, "SELECTION")},
	{"multiharm", tuple<int, string> (multiharm_, "GRID")},
	{"tapercustom", tuple<int, string> (tapercustom_, "GRID")},
	{"udata", tuple<int, string> (udata_, "GRID")}
};

const vector<double> DefUndPrm {
	2.18, 2.18, 30, 18, 5, 18, 6.15, 1.25,
	273, 27, 0, 0, 10, 2, 0.001, 0.001,
	2.024, 0.08, 1, 5, 0.5, 1
};

const vector<vector<double>> DefUndVec {
	{0.001, 0.001}
};

const vector<bool> DefUndBool {
	false, false
};

const vector<string> DefUndSel {
	"Linear", "N.A.", "N.A.", "Ideal"
};

const vector<string> DefUndStr {};

// Wakefield
enum WakeIndex {
	aperture_ = 0, resistivity_, relaxtime_, height_, corrlen_, permit_, thickness_, NumWakePrm,
	wakeon_ = 0, resistive_, paralell_, roughness_, dielec_, spcharge_, wakecustom_, NumWakeBool,
	wakecustomdata_ = 0, NumWakeData
};

const map<string, tuple<int, string>> Wake {
	{"Aperture (m)", tuple<int, string> (aperture_, "NUMBER")},
	{"Resistivity (&Omega;m)", tuple<int, string> (resistivity_, "NUMBER")},
	{"Relaxation Time (sec)", tuple<int, string> (relaxtime_, "NUMBER")},
	{"RMS Height (m)", tuple<int, string> (height_, "NUMBER")},
	{"Correlation Length (m)", tuple<int, string> (corrlen_, "NUMBER")},
	{"&epsilon;/&epsilon;<sub>0</sub>", tuple<int, string> (permit_, "NUMBER")},
	{"Thickness (m)", tuple<int, string> (thickness_, "NUMBER")},
	{"Wakefield On", tuple<int, string> (wakeon_, "BOOLEAN")},
	{"Resistive", tuple<int, string> (resistive_, "BOOLEAN")},
	{"Parallel Plate", tuple<int, string> (paralell_, "BOOLEAN")},
	{"Surface Roughness", tuple<int, string> (roughness_, "BOOLEAN")},
	{"Dielectric Layer", tuple<int, string> (dielec_, "BOOLEAN")},
	{"Space Charge", tuple<int, string> (spcharge_, "BOOLEAN")},
	{"Additional Custom Wake", tuple<int, string> (wakecustom_, "BOOLEAN")},
	{"Wakefield Data", tuple<int, string> (wakecustomdata_, "data")}
};

const map<string, tuple<int, string>> WakeSimple {
	{"aperture", tuple<int, string> (aperture_, "NUMBER")},
	{"resistivity", tuple<int, string> (resistivity_, "NUMBER")},
	{"relaxtime", tuple<int, string> (relaxtime_, "NUMBER")},
	{"height", tuple<int, string> (height_, "NUMBER")},
	{"corrlen", tuple<int, string> (corrlen_, "NUMBER")},
	{"permit", tuple<int, string> (permit_, "NUMBER")},
	{"thickness", tuple<int, string> (thickness_, "NUMBER")},
	{"wakeon", tuple<int, string> (wakeon_, "BOOLEAN")},
	{"resistive", tuple<int, string> (resistive_, "BOOLEAN")},
	{"paralell", tuple<int, string> (paralell_, "BOOLEAN")},
	{"roughness", tuple<int, string> (roughness_, "BOOLEAN")},
	{"dielec", tuple<int, string> (dielec_, "BOOLEAN")},
	{"spcharge", tuple<int, string> (spcharge_, "BOOLEAN")},
	{"wakecustom", tuple<int, string> (wakecustom_, "BOOLEAN")},
	{"wakecustomdata", tuple<int, string> (wakecustomdata_, "data")}
};

const vector<double> DefWakePrm {
	0.0035, 1.68e-8, 8e-15, 0.000002, 0.00004, 2, 2e-8
};

const vector<vector<double>> DefWakeVec {};

const vector<bool> DefWakeBool {
	false, false, true, false, false, false, false
};

const vector<string> DefWakeSel {};

const vector<string> DefWakeStr {};

// Lattice
enum LatticeIndex {
	qfg_ = 0, qdg_, qfl_, qdl_, dist_, lperiods_, optbeta_, NumLatticePrm,
	betaxy0_ = 0, alphaxy0_, NumLatticeVec,
	ltype_ = 0, NumLatticeSel
};

const map<string, tuple<int, string>> Lattice {
	{"QF Gradient (T/m)", tuple<int, string> (qfg_, "NUMBER")},
	{"QD Gradient (T/m)", tuple<int, string> (qdg_, "NUMBER")},
	{"QF Length (m)", tuple<int, string> (qfl_, "NUMBER")},
	{"QD Length (m)", tuple<int, string> (qdl_, "NUMBER")},
	{"QF-QD Distance (m)", tuple<int, string> (dist_, "NUMBER")},
	{"# Periods/Segment", tuple<int, string> (lperiods_, "NUMBER")},
	{"Optimum &beta; (m)", tuple<int, string> (optbeta_, "NUMBER")},
	{"&beta;<sub>x0,y0</sub> (m)", tuple<int, string> (betaxy0_, "NUMBERARRAY")},
	{"&alpha;<sub>x0,y0</sub> (m)", tuple<int, string> (alphaxy0_, "NUMBERARRAY")},
	{"Lattice Type", tuple<int, string> (ltype_, "SELECTION")}
};

const map<string, tuple<int, string>> LatticeSimple {
	{"qfg", tuple<int, string> (qfg_, "NUMBER")},
	{"qdg", tuple<int, string> (qdg_, "NUMBER")},
	{"qfl", tuple<int, string> (qfl_, "NUMBER")},
	{"qdl", tuple<int, string> (qdl_, "NUMBER")},
	{"dist", tuple<int, string> (dist_, "NUMBER")},
	{"lperiods", tuple<int, string> (lperiods_, "NUMBER")},
	{"optbeta", tuple<int, string> (optbeta_, "NUMBER")},
	{"betaxy0", tuple<int, string> (betaxy0_, "NUMBERARRAY")},
	{"alphaxy0", tuple<int, string> (alphaxy0_, "NUMBERARRAY")},
	{"ltype", tuple<int, string> (ltype_, "SELECTION")}
};

const vector<double> DefLatticePrm {
	18.99, -17.44, 0.1, 0.1, 0.02, 18, 10
};

const vector<vector<double>> DefLatticeVec {
	{29.5483, 20.8583}, {1.05297, -0.757107}
};

const vector<bool> DefLatticeBool {};

const vector<string> DefLatticeSel {
	"FUDU (QF-U-QD-U)"
};

const vector<string> DefLatticeStr {};

// Chicane
enum ChicaneIndex {
	dipoleb_ = 0, dipolel_, dipoled_, offset_, delay_, chpos_, monoenergy_, bragg_,
		formfactor_, latticespace_, unitvol_, bandwidth_, xtalthickness_, reltiming_, NumChicanePrm,
	chicaneon_ = 0, rearrange_, NumChicaneBool,
	monotype_ = 0, xtaltype_, NumChicaneSel,
	monodata_ = 0, NumChicaneData
};

const map<string, tuple<int, string>> Chicane {
	{"Dipole Field (T)", tuple<int, string> (dipoleb_, "NUMBER")},
	{"Dipole Length", tuple<int, string> (dipolel_, "NUMBER")},
	{"Dipole Distance", tuple<int, string> (dipoled_, "NUMBER")},
	{"Beam Offset (mm)", tuple<int, string> (offset_, "NUMBER")},
	{"Electron Delay (fs)", tuple<int, string> (delay_, "NUMBER")},
	{"Chicane Position", tuple<int, string> (chpos_, "NUMBER")},
	{"&hbar;&omega; (eV)", tuple<int, string> (monoenergy_, "NUMBER")},
	{"Bragg Angle (&deg;)", tuple<int, string> (bragg_, "NUMBER")},
	{"|F<sub>g</sub>|", tuple<int, string> (formfactor_, "NUMBER")},
	{"Lattice Spacing (nm)", tuple<int, string> (latticespace_, "NUMBER")},
	{"Unit Cell Volume (nm<sup>3</sup>)", tuple<int, string> (unitvol_, "NUMBER")},
	{"Bandwidth", tuple<int, string> (bandwidth_, "NUMBER")},
	{"Crystal Thickness (mm)", tuple<int, string> (xtalthickness_, "NUMBER")},
	{"Relative Timing (fs)", tuple<int, string> (reltiming_, "NUMBER")},
	{"Chicane On", tuple<int, string> (chicaneon_, "BOOLEAN")},
	{"Rearrange After Chicane", tuple<int, string> (rearrange_, "BOOLEAN")},
	{"Monochromator Type", tuple<int, string> (monotype_, "SELECTION")},
	{"Crystal Type", tuple<int, string> (xtaltype_, "SELECTION")},
	{"Monochromator Data", tuple<int, string> (monodata_, "data")}
};

const map<string, tuple<int, string>> ChicaneSimple {
	{"dipoleb", tuple<int, string> (dipoleb_, "NUMBER")},
	{"dipolel", tuple<int, string> (dipolel_, "NUMBER")},
	{"dipoled", tuple<int, string> (dipoled_, "NUMBER")},
	{"offset", tuple<int, string> (offset_, "NUMBER")},
	{"delay", tuple<int, string> (delay_, "NUMBER")},
	{"chpos", tuple<int, string> (chpos_, "NUMBER")},
	{"monoenergy", tuple<int, string> (monoenergy_, "NUMBER")},
	{"bragg", tuple<int, string> (bragg_, "NUMBER")},
	{"formfactor", tuple<int, string> (formfactor_, "NUMBER")},
	{"latticespace", tuple<int, string> (latticespace_, "NUMBER")},
	{"unitvol", tuple<int, string> (unitvol_, "NUMBER")},
	{"bandwidth", tuple<int, string> (bandwidth_, "NUMBER")},
	{"xtalthickness", tuple<int, string> (xtalthickness_, "NUMBER")},
	{"reltiming", tuple<int, string> (reltiming_, "NUMBER")},
	{"chicaneon", tuple<int, string> (chicaneon_, "BOOLEAN")},
	{"rearrange", tuple<int, string> (rearrange_, "BOOLEAN")},
	{"monotype", tuple<int, string> (monotype_, "SELECTION")},
	{"xtaltype", tuple<int, string> (xtaltype_, "SELECTION")},
	{"monodata", tuple<int, string> (monodata_, "data")}
};

const vector<double> DefChicanePrm {
	0.4, 0.2, 0.5, 1.5, 10, 10, 10000, 11.4024,
	12.72, 0.089175, 0.045385, 0.0000467811, 0.1, 0
};

const vector<vector<double>> DefChicaneVec {};

const vector<bool> DefChicaneBool {
	false, false
};

const vector<string> DefChicaneSel {
	"N.A.", "Diamond (400)"
};

const vector<string> DefChicaneStr {};

// Alignment
enum AlignmentIndex {
	Ktol_ = 0, sliptol_, alrandseed_, NumAlignmentPrm,
	xytol_ = 0, NumAlignmentVec,
	alautoseed_ = 0, NumAlignmentBool,
	ualign_ = 0, BPMalign_, NumAlignmentSel,
	sigsegment_ = 0, NumAlignmentData
};

const map<string, tuple<int, string>> Alignment {
	{"&Delta;K Tolerance", tuple<int, string> (Ktol_, "NUMBER")},
	{"Slippage Tolerance (&deg;)", tuple<int, string> (sliptol_, "NUMBER")},
	{"Random Number Seed", tuple<int, string> (alrandseed_, "NUMBER")},
	{"x,y Tolerance (mm)", tuple<int, string> (xytol_, "NUMBERARRAY")},
	{"Random Number Auto Seeding", tuple<int, string> (alautoseed_, "BOOLEAN")},
	{"Undulator Alignment", tuple<int, string> (ualign_, "SELECTION")},
	{"BPM Alignment", tuple<int, string> (BPMalign_, "SELECTION")},
	{"Offset for Each Segment", tuple<int, string> (sigsegment_, "GRID")}
};

const map<string, tuple<int, string>> AlignmentSimple {
	{"Ktol", tuple<int, string> (Ktol_, "NUMBER")},
	{"sliptol", tuple<int, string> (sliptol_, "NUMBER")},
	{"alrandseed", tuple<int, string> (alrandseed_, "NUMBER")},
	{"xytol", tuple<int, string> (xytol_, "NUMBERARRAY")},
	{"alautoseed", tuple<int, string> (alautoseed_, "BOOLEAN")},
	{"ualign", tuple<int, string> (ualign_, "SELECTION")},
	{"BPMalign", tuple<int, string> (BPMalign_, "SELECTION")},
	{"sigsegment", tuple<int, string> (sigsegment_, "GRID")}
};

const vector<double> DefAlignmentPrm {
	0, 0, 1
};

const vector<vector<double>> DefAlignmentVec {
	{0.05, 0.05}
};

const vector<bool> DefAlignmentBool {
	false
};

const vector<string> DefAlignmentSel {
	"Ideal", "Ideal"
};

const vector<string> DefAlignmentStr {};

// Dispersion
enum DispersionIndex {
	kickpos_ = 0, NumDispersionPrm,
	exy_ = 0, exyp_, kickangle_, sxy_, sxyp_, NumDispersionVec,
	einjec_ = 0, kick_, sinjec_, NumDispersionBool
};

const map<string, tuple<int, string>> Dispersion {
	{"Kick Position (m)", tuple<int, string> (kickpos_, "NUMBER")},
	{"&Delta;x,y (mm)", tuple<int, string> (exy_, "NUMBERARRAY")},
	{"&Delta;x',y' (mrad)", tuple<int, string> (exyp_, "NUMBERARRAY")},
	{"Kick Angle x,y (mrad)", tuple<int, string> (kickangle_, "NUMBERARRAY")},
	{"Seed &Delta;x,y (mm)", tuple<int, string> (sxy_, "NUMBERARRAY")},
	{"Seed &Delta;x',y' (mrad)", tuple<int, string> (sxyp_, "NUMBERARRAY")},
	{"e<sup>-</sup> Injection Error", tuple<int, string> (einjec_, "BOOLEAN")},
	{"Single Kick", tuple<int, string> (kick_, "BOOLEAN")},
	{"Seed Injection Error", tuple<int, string> (sinjec_, "BOOLEAN")}
};

const map<string, tuple<int, string>> DispersionSimple {
	{"kickpos", tuple<int, string> (kickpos_, "NUMBER")},
	{"exy", tuple<int, string> (exy_, "NUMBERARRAY")},
	{"exyp", tuple<int, string> (exyp_, "NUMBERARRAY")},
	{"kickangle", tuple<int, string> (kickangle_, "NUMBERARRAY")},
	{"sxy", tuple<int, string> (sxy_, "NUMBERARRAY")},
	{"sxyp", tuple<int, string> (sxyp_, "NUMBERARRAY")},
	{"einjec", tuple<int, string> (einjec_, "BOOLEAN")},
	{"kick", tuple<int, string> (kick_, "BOOLEAN")},
	{"sinjec", tuple<int, string> (sinjec_, "BOOLEAN")}
};

const vector<double> DefDispersionPrm {
	0
};

const vector<vector<double>> DefDispersionVec {
	{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}
};

const vector<bool> DefDispersionBool {
	false, false, false
};

const vector<string> DefDispersionSel {};

const vector<string> DefDispersionStr {};

// Simulation Conditions
enum SimCtrlIndex {
	randseed_ = 0, step_, stepsseg_, driftsteps_, beamlets_, slicebmlets_, slicebmletsss_, electrons_,
		sliceels_, sliceelsss_, maxharmonic_, particles_, spatwin_, gpointsl_, gpoints_, simpos_,
		slices_, mpiprocs_, threads_, NumSimCtrlPrm,
	simrange_ = 0, NumSimCtrlVec,
	skipwave_ = 0, autostep_, autoseed_, NumSimCtrlBool,
	simmode_ = 0, simoption_, parascheme_, NumSimCtrlSel
};

const map<string, tuple<int, string>> SimCtrl {
	{"Random Number Seed", tuple<int, string> (randseed_, "NUMBER")},
	{"Integration Step", tuple<int, string> (step_, "NUMBER")},
	{"Steps/Segment", tuple<int, string> (stepsseg_, "NUMBER")},
	{"Steps in Drift Section", tuple<int, string> (driftsteps_, "NUMBER")},
	{"Total Beamlets", tuple<int, string> (beamlets_, "NUMBER")},
	{"Max. Beamlets/Slice", tuple<int, string> (slicebmlets_, "NUMBER")},
	{"Beamlets/Slice", tuple<int, string> (slicebmletsss_, "NUMBER")},
	{"Total Electrons", tuple<int, string> (electrons_, "NUMBER")},
	{"Max. Electrons/Slice", tuple<int, string> (sliceels_, "NUMBER")},
	{"Electrons/Slice", tuple<int, string> (sliceelsss_, "NUMBER")},
	{"Max. Harmonic", tuple<int, string> (maxharmonic_, "NUMBER")},
	{"Particles/Beamlet", tuple<int, string> (particles_, "NUMBER")},
	{"Spatial Window/&sigma;", tuple<int, string> (spatwin_, "NUMBER")},
	{"Grid Points Level", tuple<int, string> (gpointsl_, "NUMBER")},
	{"Grid Points", tuple<int, string> (gpoints_, "NUMBER")},
	{"Bunch Position (m)", tuple<int, string> (simpos_, "NUMBER")},
	{"Total Slices", tuple<int, string> (slices_, "NUMBER")},
	{"Number of Processes", tuple<int, string> (mpiprocs_, "NUMBER")},
	{"Number of Threads", tuple<int, string> (threads_, "NUMBER")},
	{"Temporal Window (m)", tuple<int, string> (simrange_, "NUMBERARRAY")},
	{"Skip Wavefront Transfer Process", tuple<int, string> (skipwave_, "BOOLEAN")},
	{"Auto Integration Step", tuple<int, string> (autostep_, "BOOLEAN")},
	{"Random Number Auto Seeding", tuple<int, string> (autoseed_, "BOOLEAN")},
	{"Simulation Mode", tuple<int, string> (simmode_, "SELECTION")},
	{"Simulation Option", tuple<int, string> (simoption_, "SELECTION")},
	{"Parallel Computing", tuple<int, string> (parascheme_, "SELECTION")}
};

const map<string, tuple<int, string>> SimCtrlSimple {
	{"randseed", tuple<int, string> (randseed_, "NUMBER")},
	{"step", tuple<int, string> (step_, "NUMBER")},
	{"stepsseg", tuple<int, string> (stepsseg_, "NUMBER")},
	{"driftsteps", tuple<int, string> (driftsteps_, "NUMBER")},
	{"beamlets", tuple<int, string> (beamlets_, "NUMBER")},
	{"slicebmlets", tuple<int, string> (slicebmlets_, "NUMBER")},
	{"slicebmletsss", tuple<int, string> (slicebmletsss_, "NUMBER")},
	{"electrons", tuple<int, string> (electrons_, "NUMBER")},
	{"sliceels", tuple<int, string> (sliceels_, "NUMBER")},
	{"sliceelsss", tuple<int, string> (sliceelsss_, "NUMBER")},
	{"maxharmonic", tuple<int, string> (maxharmonic_, "NUMBER")},
	{"particles", tuple<int, string> (particles_, "NUMBER")},
	{"spatwin", tuple<int, string> (spatwin_, "NUMBER")},
	{"gpointsl", tuple<int, string> (gpointsl_, "NUMBER")},
	{"gpoints", tuple<int, string> (gpoints_, "NUMBER")},
	{"simpos", tuple<int, string> (simpos_, "NUMBER")},
	{"slices", tuple<int, string> (slices_, "NUMBER")},
	{"mpiprocs", tuple<int, string> (mpiprocs_, "NUMBER")},
	{"threads", tuple<int, string> (threads_, "NUMBER")},
	{"simrange", tuple<int, string> (simrange_, "NUMBERARRAY")},
	{"skipwave", tuple<int, string> (skipwave_, "BOOLEAN")},
	{"autostep", tuple<int, string> (autostep_, "BOOLEAN")},
	{"autoseed", tuple<int, string> (autoseed_, "BOOLEAN")},
	{"simmode", tuple<int, string> (simmode_, "SELECTION")},
	{"simoption", tuple<int, string> (simoption_, "SELECTION")},
	{"parascheme", tuple<int, string> (parascheme_, "SELECTION")}
};

const vector<double> DefSimCtrlPrm {
	1, 5, 20, 2, 10000000, 2000, 2000, 10000000,
	2000, 2000, 1, 4, 4, 1, 1, 0,
	4000, 4, 4
};

const vector<vector<double>> DefSimCtrlVec {
	{-0.000006, 0.000006}
};

const vector<bool> DefSimCtrlBool {
	false, true, false
};

const vector<string> DefSimCtrlSel {
	"Time Dependent", "N.A.", "N.A."
};

const vector<string> DefSimCtrlStr {};

// Data Dump Configurations
enum DataDumpIndex {
	profstep_ = 0, iniseg_, segint_, stepinterv_, pfilesize_, rfilesize_, NumDataDumpPrm,
	temporal_ = 0, spectral_, spatial_, angular_, particle_, radiation_, NumDataDumpBool,
	expstep_ = 0, NumDataDumpSel
};

const map<string, tuple<int, string>> DataDump {
	{"Output Interval", tuple<int, string> (profstep_, "NUMBER")},
	{"Initial Segment", tuple<int, string> (iniseg_, "NUMBER")},
	{"Segment Step", tuple<int, string> (segint_, "NUMBER")},
	{"Step Interval", tuple<int, string> (stepinterv_, "NUMBER")},
	{"Particle Data Size (MB)", tuple<int, string> (pfilesize_, "NUMBER")},
	{"Radiation Data Size (MB)", tuple<int, string> (rfilesize_, "NUMBER")},
	{"Temporal Profile", tuple<int, string> (temporal_, "BOOLEAN")},
	{"Spectral Profile", tuple<int, string> (spectral_, "BOOLEAN")},
	{"Spatial Profile", tuple<int, string> (spatial_, "BOOLEAN")},
	{"Angular Profile", tuple<int, string> (angular_, "BOOLEAN")},
	{"Particle Data", tuple<int, string> (particle_, "BOOLEAN")},
	{"Radiation Data", tuple<int, string> (radiation_, "BOOLEAN")},
	{"Output Steps", tuple<int, string> (expstep_, "SELECTION")}
};

const map<string, tuple<int, string>> DataDumpSimple {
	{"profstep", tuple<int, string> (profstep_, "NUMBER")},
	{"iniseg", tuple<int, string> (iniseg_, "NUMBER")},
	{"segint", tuple<int, string> (segint_, "NUMBER")},
	{"stepinterv", tuple<int, string> (stepinterv_, "NUMBER")},
	{"pfilesize", tuple<int, string> (pfilesize_, "NUMBER")},
	{"rfilesize", tuple<int, string> (rfilesize_, "NUMBER")},
	{"temporal", tuple<int, string> (temporal_, "BOOLEAN")},
	{"spectral", tuple<int, string> (spectral_, "BOOLEAN")},
	{"spatial", tuple<int, string> (spatial_, "BOOLEAN")},
	{"angular", tuple<int, string> (angular_, "BOOLEAN")},
	{"particle", tuple<int, string> (particle_, "BOOLEAN")},
	{"radiation", tuple<int, string> (radiation_, "BOOLEAN")},
	{"expstep", tuple<int, string> (expstep_, "SELECTION")}
};

const vector<double> DefDataDumpPrm {
	1, 1, 1, 1, 2000, 2000
};

const vector<vector<double>> DefDataDumpVec {};

const vector<bool> DefDataDumpBool {
	false, false, false, false, false, false
};

const vector<string> DefDataDumpSel {
	"All Segments"
};

const vector<string> DefDataDumpStr {};

// Output File
enum OutfileIndex {
	serial_ = 0, NumOutfilePrm,
	folder_ = 0, prefix_, comment_, NumOutfileStr
};

const map<string, tuple<int, string>> Outfile {
	{"Serial Number", tuple<int, string> (serial_, "NUMBER")},
	{"Folder", tuple<int, string> (folder_, "STRING")},
	{"Prefix", tuple<int, string> (prefix_, "STRING")},
	{"Comment", tuple<int, string> (comment_, "STRING")}
};

const map<string, tuple<int, string>> OutfileSimple {
	{"serial", tuple<int, string> (serial_, "NUMBER")},
	{"folder", tuple<int, string> (folder_, "STRING")},
	{"prefix", tuple<int, string> (prefix_, "STRING")},
	{"comment", tuple<int, string> (comment_, "STRING")}
};

const vector<double> DefOutfilePrm {
	-1
};

const vector<vector<double>> DefOutfileVec {};

const vector<bool> DefOutfileBool {};

const vector<string> DefOutfileSel {};

const vector<string> DefOutfileStr {
	"", "untitled", ""
};

// Particle Data Format
enum PartFmtIndex {
	colx_ = 0, colxp_, coly_, colyp_, colt_, colE_, pcharge_, bins_,
		NumPartFmtPrm,
	unitxy_ = 0, unitxyp_, unitt_, unitE_, NumPartFmtSel
};

const map<string, tuple<int, string>> PartFmt {
	{"x", tuple<int, string> (colx_, "NUMBER")},
	{"x'", tuple<int, string> (colxp_, "NUMBER")},
	{"y", tuple<int, string> (coly_, "NUMBER")},
	{"y'", tuple<int, string> (colyp_, "NUMBER")},
	{"t", tuple<int, string> (colt_, "NUMBER")},
	{"E", tuple<int, string> (colE_, "NUMBER")},
	{"Charge/Particle (C)", tuple<int, string> (pcharge_, "NUMBER")},
	{"Slices in 1&sigma;<sub>s</sub>", tuple<int, string> (bins_, "NUMBER")},
	{"x & y", tuple<int, string> (unitxy_, "SELECTION")},
	{"x' & y'", tuple<int, string> (unitxyp_, "SELECTION")},
	{"Time", tuple<int, string> (unitt_, "SELECTION")},
	{"Energy", tuple<int, string> (unitE_, "SELECTION")}
};

const map<string, tuple<int, string>> PartFmtSimple {
	{"colx", tuple<int, string> (colx_, "NUMBER")},
	{"colxp", tuple<int, string> (colxp_, "NUMBER")},
	{"coly", tuple<int, string> (coly_, "NUMBER")},
	{"colyp", tuple<int, string> (colyp_, "NUMBER")},
	{"colt", tuple<int, string> (colt_, "NUMBER")},
	{"colE", tuple<int, string> (colE_, "NUMBER")},
	{"pcharge", tuple<int, string> (pcharge_, "NUMBER")},
	{"bins", tuple<int, string> (bins_, "NUMBER")},
	{"unitxy", tuple<int, string> (unitxy_, "SELECTION")},
	{"unitxyp", tuple<int, string> (unitxyp_, "SELECTION")},
	{"unitt", tuple<int, string> (unitt_, "SELECTION")},
	{"unitE", tuple<int, string> (unitE_, "SELECTION")}
};

const vector<double> DefPartFmtPrm {
	1, 2, 3, 4, 5, 6, 1e-15, 100
};

const vector<vector<double>> DefPartFmtVec {};

const vector<bool> DefPartFmtBool {};

const vector<string> DefPartFmtSel {
	"m", "rad", "s", "GeV"
};

const vector<string> DefPartFmtStr {};

// Pre-Processing
enum PrePIndex {
	targetuseg_ = 0, plotpoints_, tolbeta_, cqfg_, cqdg_, NumPrePPrm,
	avbetaxy_ = 0, cbetaxy0_, calphaxy0_, NumPrePVec,
	betamethod_ = 0, NumPrePSel
};

const map<string, tuple<int, string>> PreP {
	{"Target Segment", tuple<int, string> (targetuseg_, "NUMBER")},
	{"Data Points", tuple<int, string> (plotpoints_, "NUMBER")},
	{"Tolerance", tuple<int, string> (tolbeta_, "NUMBER")},
	{"QF Gradient (T/m)", tuple<int, string> (cqfg_, "NUMBER")},
	{"QD Gradient (T/m)", tuple<int, string> (cqdg_, "NUMBER")},
	{"&lt;&beta;<sub>x,y</sub>&gt;", tuple<int, string> (avbetaxy_, "NUMBERARRAY")},
	{"&beta;<sub>x0,y0</sub> (m)", tuple<int, string> (cbetaxy0_, "NUMBERARRAY")},
	{"&alpha;<sub>x0,y0</sub> (m)", tuple<int, string> (calphaxy0_, "NUMBERARRAY")},
	{"Target Item", tuple<int, string> (betamethod_, "SELECTION")}
};

const map<string, tuple<int, string>> PrePSimple {
	{"targetuseg", tuple<int, string> (targetuseg_, "NUMBER")},
	{"plotpoints", tuple<int, string> (plotpoints_, "NUMBER")},
	{"tolbeta", tuple<int, string> (tolbeta_, "NUMBER")},
	{"cqfg", tuple<int, string> (cqfg_, "NUMBER")},
	{"cqdg", tuple<int, string> (cqdg_, "NUMBER")},
	{"avbetaxy", tuple<int, string> (avbetaxy_, "NUMBERARRAY")},
	{"cbetaxy0", tuple<int, string> (cbetaxy0_, "NUMBERARRAY")},
	{"calphaxy0", tuple<int, string> (calphaxy0_, "NUMBERARRAY")},
	{"betamethod", tuple<int, string> (betamethod_, "SELECTION")}
};

const vector<double> DefPrePPrm {
	1, 100, 0.01, 18.99, -17.44
};

const vector<vector<double>> DefPrePVec {
	{0, 0}, {29.5483, 20.8583}, {1.05297, -0.757107}
};

const vector<bool> DefPrePBool {};

const vector<string> DefPrePSel {
	"Average"
};

const vector<string> DefPrePStr {};

// Post-Processing
enum PostPIndex {
	harmonic_ = 0, r56pp_, serialpp_, bmletspp_, particlespp_, NumPostPPrm,
	zwindow_ = 0, timewindow_, energywindow_, spatwindow_, anglindow_, zvalue_, timevalue_, energyvalue_,
		spatvalue_, anglvalue_, smoothing_, smvalues_, NumPostPVec,
	s1_ = 0, s2_, s3_, alongs_, overxy_, overxyf_, NumPostPBool,
	item_ = 0, domain_, realimag_, Exy_, axis_, zone_, coord_, zrange_,
		timerange_, energyrange_, spatrange_, anglrange_, NumPostPSel
};

const map<string, tuple<int, string>> PostP {
	{"Harmonic Number", tuple<int, string> (harmonic_, "NUMBER")},
	{"R<sub>56</sub> (m)", tuple<int, string> (r56pp_, "NUMBER")},
	{"Data Serial Number", tuple<int, string> (serialpp_, "NUMBER")},
	{"Beamlets", tuple<int, string> (bmletspp_, "NUMBER")},
	{"Particles/Beamlet", tuple<int, string> (particlespp_, "NUMBER")},
	{"Step (z)", tuple<int, string> (zwindow_, "NUMBERARRAY")},
	{"Slice (s)", tuple<int, string> (timewindow_, "NUMBERARRAY")},
	{"Energy (&hbar;&omega;)", tuple<int, string> (energywindow_, "NUMBERARRAY")},
	{"Spatial (x,y)", tuple<int, string> (spatwindow_, "NUMBERARRAY")},
	{"Angular (x',y')", tuple<int, string> (anglindow_, "NUMBERARRAY")},
	{"z (m)", tuple<int, string> (zvalue_, "NUMBERARRAY")},
	{"s (m)", tuple<int, string> (timevalue_, "NUMBERARRAY")},
	{"&hbar;&omega; (eV)", tuple<int, string> (energyvalue_, "NUMBERARRAY")},
	{"&Delta;x,y (mm)", tuple<int, string> (spatvalue_, "NUMBERARRAY")},
	{"&Delta;x',y' (mrad)", tuple<int, string> (anglvalue_, "NUMBERARRAY")},
	{"Smoothing: (s,&hbar;&omega;)", tuple<int, string> (smoothing_, "NUMBERARRAY")},
	{"&sigma;<sub>s</sub> (m), &sigma;<sub>&hbar;&omega;</sub> (eV)", tuple<int, string> (smvalues_, "NUMBERARRAY")},
	{"S<sub>1</sub> (Horizontal)", tuple<int, string> (s1_, "BOOLEAN")},
	{"S<sub>2</sub> (45-deg.)", tuple<int, string> (s2_, "BOOLEAN")},
	{"S<sub>3</sub> (Circular)", tuple<int, string> (s3_, "BOOLEAN")},
	{"Integration (s)", tuple<int, string> (alongs_, "BOOLEAN")},
	{"Integration (x,y)", tuple<int, string> (overxy_, "BOOLEAN")},
	{"Integration (x',y')", tuple<int, string> (overxyf_, "BOOLEAN")},
	{"Target ", tuple<int, string> (item_, "SELECTION")},
	{"Domain", tuple<int, string> (domain_, "SELECTION")},
	{"Real/Imaginary Part", tuple<int, string> (realimag_, "SELECTION")},
	{"E<sub>x,y</sub>", tuple<int, string> (Exy_, "SELECTION")},
	{"Axis", tuple<int, string> (axis_, "SELECTION")},
	{"Zone", tuple<int, string> (zone_, "SELECTION")},
	{"Coordinate System", tuple<int, string> (coord_, "SELECTION")},
	{"Step", tuple<int, string> (zrange_, "SELECTION")},
	{"Slice", tuple<int, string> (timerange_, "SELECTION")},
	{"Photon Energy", tuple<int, string> (energyrange_, "SELECTION")},
	{"Space", tuple<int, string> (spatrange_, "SELECTION")},
	{"Angle", tuple<int, string> (anglrange_, "SELECTION")}
};

const map<string, tuple<int, string>> PostPSimple {
	{"harmonic", tuple<int, string> (harmonic_, "NUMBER")},
	{"r56pp", tuple<int, string> (r56pp_, "NUMBER")},
	{"serialpp", tuple<int, string> (serialpp_, "NUMBER")},
	{"bmletspp", tuple<int, string> (bmletspp_, "NUMBER")},
	{"particlespp", tuple<int, string> (particlespp_, "NUMBER")},
	{"zwindow", tuple<int, string> (zwindow_, "NUMBERARRAY")},
	{"timewindow", tuple<int, string> (timewindow_, "NUMBERARRAY")},
	{"energywindow", tuple<int, string> (energywindow_, "NUMBERARRAY")},
	{"spatwindow", tuple<int, string> (spatwindow_, "NUMBERARRAY")},
	{"anglindow", tuple<int, string> (anglindow_, "NUMBERARRAY")},
	{"zvalue", tuple<int, string> (zvalue_, "NUMBERARRAY")},
	{"timevalue", tuple<int, string> (timevalue_, "NUMBERARRAY")},
	{"energyvalue", tuple<int, string> (energyvalue_, "NUMBERARRAY")},
	{"spatvalue", tuple<int, string> (spatvalue_, "NUMBERARRAY")},
	{"anglvalue", tuple<int, string> (anglvalue_, "NUMBERARRAY")},
	{"smoothing", tuple<int, string> (smoothing_, "NUMBERARRAY")},
	{"smvalues", tuple<int, string> (smvalues_, "NUMBERARRAY")},
	{"s1", tuple<int, string> (s1_, "BOOLEAN")},
	{"s2", tuple<int, string> (s2_, "BOOLEAN")},
	{"s3", tuple<int, string> (s3_, "BOOLEAN")},
	{"alongs", tuple<int, string> (alongs_, "BOOLEAN")},
	{"overxy", tuple<int, string> (overxy_, "BOOLEAN")},
	{"overxyf", tuple<int, string> (overxyf_, "BOOLEAN")},
	{"item", tuple<int, string> (item_, "SELECTION")},
	{"domain", tuple<int, string> (domain_, "SELECTION")},
	{"realimag", tuple<int, string> (realimag_, "SELECTION")},
	{"Exy", tuple<int, string> (Exy_, "SELECTION")},
	{"axis", tuple<int, string> (axis_, "SELECTION")},
	{"zone", tuple<int, string> (zone_, "SELECTION")},
	{"coord", tuple<int, string> (coord_, "SELECTION")},
	{"zrange", tuple<int, string> (zrange_, "SELECTION")},
	{"timerange", tuple<int, string> (timerange_, "SELECTION")},
	{"energyrange", tuple<int, string> (energyrange_, "SELECTION")},
	{"spatrange", tuple<int, string> (spatrange_, "SELECTION")},
	{"anglrange", tuple<int, string> (anglrange_, "SELECTION")}
};

const vector<double> DefPostPPrm {
	1, 0, -1, 1, 1
};

const vector<vector<double>> DefPostPVec {
	{1, 10}, {-100, 100}, {-10, 10}, {16, 16}, {16, 16}, {0, 10}, {0, 10}, {0, 10},
	{0, 10}, {0, 10}, {0, 0}, {0, 0}
};

const vector<bool> DefPostPBool {
	false, false, false, false, true, true
};

const vector<string> DefPostPSel {
	"Radiation Power", "Spatial", "Real Part", "x",
	"x", "Near Field", "(s, &Delta;&gamma;/&gamma;)", "Whole",
	"Whole", "Whole", "Whole", "Whole"
};

const vector<string> DefPostPStr {};

// import data format
const map<string, tuple<int, vector<string>>> DataFormat {
	{"Slice Parameters", tuple<int, vector<string>> (1, {"s (m)","I (A)","Energy (GeV)","Energy Spread","&epsilon;<sub>x</sub> (mm.mrad)","&epsilon;<sub>y</sub> (mm.mrad)","&beta;<sub>x</sub> (m)","&beta;<sub>y</sub> (m)","&alpha;<sub>x</sub>","&alpha;<sub>y</sub>","&lt;x&gt; (m)","&lt;y&gt; (m)","&lt;x'&gt; (rad)","&lt;y'&gt; (rad)"})},
	{"Current Profile", tuple<int, vector<string>> (1, {"s (m)","I (A)"})},
	{"E-t Profile", tuple<int, vector<string>> (2, {"s (m)","&Delta;&gamma;/&gamma;","j (A/100%)"})},
	{"Particle Distribution", tuple<int, vector<string>> (1, {"x (m)","x' (rad)","y (m)","y' (rad)","s (m)","Energy (GeV)"})},
	{"Undulator Data", tuple<int, vector<string>> (1, {"z (m)","B<sub>x</sub> (T)","B<sub>y</sub> (T)"})},
	{"Wakefield Data", tuple<int, vector<string>> (1, {"s (m)","Point-Charge Wake (V/m/C)"})},
	{"Monochromator Data", tuple<int, vector<string>> (1, {"Photon Energy (eV)","Transmission Real","Transmission Imaginary"})}
};

const map<string, tuple<int, vector<string>>> DataFormatSimple {
	{"slicefile", tuple<int, vector<string>> (1, {"s (m)","I (A)","Energy (GeV)","Energy Spread","&epsilon;<sub>x</sub> (mm.mrad)","&epsilon;<sub>y</sub> (mm.mrad)","&beta;<sub>x</sub> (m)","&beta;<sub>y</sub> (m)","&alpha;<sub>x</sub>","&alpha;<sub>y</sub>","&lt;x&gt; (m)","&lt;y&gt; (m)","&lt;x'&gt; (rad)","&lt;y'&gt; (rad)"})},
	{"currfile", tuple<int, vector<string>> (1, {"s (m)","I (A)"})},
	{"etfile", tuple<int, vector<string>> (2, {"s (m)","&Delta;&gamma;/&gamma;","j (A/100%)"})},
	{"partfile", tuple<int, vector<string>> (1, {"x (m)","x' (rad)","y (m)","y' (rad)","s (m)","Energy (GeV)"})},
	{"wakecustomdata", tuple<int, vector<string>> (1, {"s (m)","Point-Charge Wake (V/m/C)"})},
	{"monodata", tuple<int, vector<string>> (1, {"Photon Energy (eV)","Transmission Real","Transmission Imaginary"})}
};

const map<string, int> SliceIndex {
	{"s (m)", 0},
	{"I (A)", 1},
	{"Energy (GeV)", 2},
	{"Energy Spread", 3},
	{"&epsilon;<sub>x</sub> (mm.mrad)", 4},
	{"&epsilon;<sub>y</sub> (mm.mrad)", 5},
	{"&beta;<sub>x</sub> (m)", 6},
	{"&beta;<sub>y</sub> (m)", 7},
	{"&alpha;<sub>x</sub>", 8},
	{"&alpha;<sub>y</sub>", 9},
	{"&lt;x&gt; (m)", 10},
	{"&lt;y&gt; (m)", 11},
	{"&lt;x'&gt; (rad)", 12},
	{"&lt;y'&gt; (rad)", 13}
};

// parameter categories
enum CategoryOrder {
	EBeam_ = 0, Seed_, Mbunch_, SPXOut_, Und_, Wake_, Lattice_, Chicane_,
	Alignment_, Dispersion_, SimCtrl_, DataDump_, Outfile_, PartFmt_, PreP_, PostP_,
	Categories
};

const vector<string>  CategoryNames {
	"Electron Beam", "Seed Light", "Microbunch Evaluation", "SIMPLEX Output", "Undulator", "Wakefield", "Lattice", "Chicane",
	"Alignment", "Dispersion", "Simulation Conditions", "Data Dump Configurations", "Output File", "Particle Data Format", "Pre-Processing", "Post-Processing"
};

const vector<map<string, tuple<int, string>>>  ParameterFullNames {
	EBeam, Seed, Mbunch, SPXOut, Und, Wake, Lattice, Chicane,
	Alignment, Dispersion, SimCtrl, DataDump, Outfile, PartFmt, PreP, PostP
};

const vector<map<string, tuple<int, string>>>  ParameterSimples {
	EBeamSimple, SeedSimple, MbunchSimple, SPXOutSimple, UndSimple, WakeSimple, LatticeSimple, ChicaneSimple,
	AlignmentSimple, DispersionSimple, SimCtrlSimple, DataDumpSimple, OutfileSimple, PartFmtSimple, PrePSimple, PostPSimple
};

const vector<vector<double>>  DefaultPrm {
	DefEBeamPrm, DefSeedPrm, DefMbunchPrm, DefSPXOutPrm, DefUndPrm, DefWakePrm, DefLatticePrm, DefChicanePrm,
	DefAlignmentPrm, DefDispersionPrm, DefSimCtrlPrm, DefDataDumpPrm, DefOutfilePrm, DefPartFmtPrm, DefPrePPrm, DefPostPPrm
};

const vector<vector<vector<double>>>  DefaultVec {
	DefEBeamVec, DefSeedVec, DefMbunchVec, DefSPXOutVec, DefUndVec, DefWakeVec, DefLatticeVec, DefChicaneVec,
	DefAlignmentVec, DefDispersionVec, DefSimCtrlVec, DefDataDumpVec, DefOutfileVec, DefPartFmtVec, DefPrePVec, DefPostPVec
};

const vector<vector<bool>>  DefaultBool {
	DefEBeamBool, DefSeedBool, DefMbunchBool, DefSPXOutBool, DefUndBool, DefWakeBool, DefLatticeBool, DefChicaneBool,
	DefAlignmentBool, DefDispersionBool, DefSimCtrlBool, DefDataDumpBool, DefOutfileBool, DefPartFmtBool, DefPrePBool, DefPostPBool
};

const vector<vector<string>>  DefaultSel {
	DefEBeamSel, DefSeedSel, DefMbunchSel, DefSPXOutSel, DefUndSel, DefWakeSel, DefLatticeSel, DefChicaneSel,
	DefAlignmentSel, DefDispersionSel, DefSimCtrlSel, DefDataDumpSel, DefOutfileSel, DefPartFmtSel, DefPrePSel, DefPostPSel
};

const vector<vector<string>>  DefaultStr {
	DefEBeamStr, DefSeedStr, DefMbunchStr, DefSPXOutStr, DefUndStr, DefWakeStr, DefLatticeStr, DefChicaneStr,
	DefAlignmentStr, DefDispersionStr, DefSimCtrlStr, DefDataDumpStr, DefOutfileStr, DefPartFmtStr, DefPrePStr, DefPostPStr
};

const double GainPerStep = 0.2;

const int MinimumParticles = 1000;

const int JSONIndent = 2;

#endif