/**
 * CSVt@Cǂݍ݃NX
 * @author      kLX
 * @version     CVS $Id: CSVReader.h,v 1.1 2008/03/26 12:45:24 tamamo Exp $
 * @license     BSD license:
 * Copyright (c) 2008, Taipei Cat Project
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Taipei Cat Project nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CSVREADER_H__
#define _CSVREADER_H__

#include <string>
#include <vector>
#include <fstream>
using namespace std;

#define DEFAULT_SEPARATOR	','
#define DEFAULT_QUOTE_CHARACTER	'"'

class CSVReader
{
public:

	/**
	 * RXgN^
	 * @param stream t@CXg[
	 * @comment Zp[^(,), GNI[g(")
	 */
	CSVReader(fstream& stream);

	/**
	 * RXgN^
	 * @param stream t@CXg[
	 * @param sep Zp[^
 	 * @comment GNI[g(")
	 */
	CSVReader(fstream& stream, const char sep);

	/**
	 * RXgN^
	 * @param stream t@CXg[
	 * @param sep Zp[^
 	 * @param quo GNI[g
	 */
	CSVReader(fstream& stream, const char sep, const char quo);

	/**
	 * fXgN^
	 */
	virtual ~CSVReader(void);

	/**
	 * CSVt@CPsǂݍŁAĔzŕԂ܂B
	 * @param tokens g[N(OUT)
	 * @return 0: -1:EOF
	 */
	int Read(vector<string>& tokens);

	/**
	 * t@CXg[N[Y܂B
	 * @return 0: -1:ُ
	 */
	int Close(void);

private:

	/**
	 * t@CPsǂݍ݂܂B
	 * @param line sf[^
	 * @return >=0Fǂݍ񂾃f[^ -1FEOF
	 */
	int GetNextLine(string& line);

	/**
	 * f[^p[X܂B
	 * @param nextLine sf[^
	 * @param tokens p[Xf[^̔z(OUT)
	 * @return 0
	 */
	int Parse(string& nextLine, vector<string>& tokens);

	std::fstream* pstream;
	char separator;
	char quote;

};

#endif
