/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.security.KeyException;
import javax.security.auth.login.LoginException;
import org.ow2.proactive.scheduler.common.exception.JobAlreadyFinishedException;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UnknownJobException;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.signal.SignalApiException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.JobAlreadyFinishedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.JobCreationRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.PermissionRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SchedulerRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SignalApiRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SubmissionClosedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.UnknownJobRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.UnknownTaskRestException;

public class ExceptionUtility {
    private ExceptionUtility() {
    }

    public static void throwNCE(Exception e) throws NotConnectedException {
        if (e instanceof NotConnectedRestException) {
            throw ExceptionUtility.reconstructError(e, NotConnectedException.class);
        }
        throw new RuntimeException(e);
    }

    public static RuntimeException throwNCEOrKEOrLEOrSE(Exception e) throws SchedulerException, LoginException, KeyException {
        if (e instanceof LoginException) {
            throw (LoginException)e;
        }
        if (e instanceof KeyException) {
            throw (KeyException)e;
        }
        if (e instanceof SchedulerRestException) {
            throw ExceptionUtility.reconstructError(e, SchedulerException.class);
        }
        ExceptionUtility.throwNCE(e);
        return new RuntimeException(e);
    }

    public static RuntimeException throwNCEOrPE(Exception e) throws NotConnectedException, PermissionException {
        if (e instanceof PermissionRestException) {
            throw ExceptionUtility.reconstructError(e, PermissionException.class);
        }
        ExceptionUtility.throwNCE(e);
        return new RuntimeException(e);
    }

    public static void throwUJEOrNCEOrPE(Exception e) throws UnknownJobException, NotConnectedException, PermissionException {
        if (e instanceof UnknownJobRestException) {
            throw ExceptionUtility.reconstructError(e, UnknownJobException.class);
        }
        ExceptionUtility.throwNCEOrPE(e);
    }

    public static void throwUJEOrNCE(Exception e) throws UnknownJobException, NotConnectedException {
        if (e instanceof UnknownJobRestException) {
            throw ExceptionUtility.reconstructError(e, UnknownJobException.class);
        }
        ExceptionUtility.throwNCE(e);
    }

    public static void throwSAEorUJEOrNCEOrPE(Exception e) throws SignalApiException, UnknownJobException, NotConnectedException, PermissionException {
        if (e instanceof SignalApiRestException) {
            throw ExceptionUtility.reconstructError(e, SignalApiException.class);
        }
        ExceptionUtility.throwUJEOrNCEOrPE(e);
    }

    public static void throwUJEOrNCEOrPEOrUTE(Exception e) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException {
        if (e instanceof UnknownTaskRestException) {
            throw ExceptionUtility.reconstructError(e, UnknownTaskException.class);
        }
        ExceptionUtility.throwUJEOrNCEOrPE(e);
    }

    public static void throwNCEOrPEOrSCEOrJCE(Exception e) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        if (e instanceof SubmissionClosedRestException) {
            throw ExceptionUtility.reconstructError(e, SubmissionClosedException.class);
        }
        if (e instanceof JobCreationRestException) {
            throw ExceptionUtility.reconstructError(e, JobCreationException.class);
        }
        ExceptionUtility.throwNCEOrPE(e);
    }

    public static void throwJAFEOrUJEOrNCEOrPE(Exception e) throws JobAlreadyFinishedException, UnknownJobException, NotConnectedException, PermissionException {
        if (e instanceof JobAlreadyFinishedRestException) {
            throw ExceptionUtility.reconstructError(e, JobAlreadyFinishedException.class);
        }
        ExceptionUtility.throwUJEOrNCEOrPE(e);
    }

    public static Exception exception(Throwable t) {
        return t instanceof Exception ? (Exception)t : new RuntimeException(t);
    }

    private static <T extends Exception> T reconstructError(Exception source, Class<T> target) {
        Throwable cause;
        boolean found = false;
        for (cause = source.getCause(); cause != null; cause = cause.getCause()) {
            if (!Strings.nullToEmpty((String)cause.getMessage()).startsWith(target.getName())) continue;
            found = true;
            break;
        }
        try {
            Exception reconstructed = null;
            if (found) {
                Constructor<T> ctor = target.getConstructor(String.class);
                reconstructed = (Exception)ctor.newInstance(cause.getMessage());
                reconstructed.setStackTrace(cause.getStackTrace());
            } else {
                Constructor<T> ctor = target.getConstructor(Throwable.class);
                reconstructed = (Exception)ctor.newInstance(source);
            }
            return (T)((Exception)target.cast(reconstructed));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

