# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class RestoreRequest(Resource):
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource Name.
    :type name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Resource Location.
    :type location: str
    :param type: Resource type.
    :type type: str
    :param tags: Resource tags.
    :type tags: dict
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param blob_name: Name of a blob which contains the backup.
    :type blob_name: str
    :param overwrite: <code>true</code> if the restore operation can overwrite
     target app; otherwise, <code>false</code>. <code>true</code> is needed if
     trying to restore over an existing app.
    :type overwrite: bool
    :param site_name: Name of an app.
    :type site_name: str
    :param databases: Collection of databases which should be restored. This
     list has to match the list of databases included in the backup.
    :type databases: list of :class:`DatabaseBackupSetting
     <azure.mgmt.web.models.DatabaseBackupSetting>`
    :param ignore_conflicting_host_names: Changes a logic when restoring an
     app with custom domains. <code>true</code> to remove custom domains
     automatically. If <code>false</code>, custom domains are added to
     the app's object when it is being restored, but that might fail due to
     conflicts during the operation. Default value: False .
    :type ignore_conflicting_host_names: bool
    :param operation_type: Operation type. Possible values include: 'Default',
     'Clone', 'Relocation'. Default value: "Default" .
    :type operation_type: str or :class:`BackupRestoreOperationType
     <azure.mgmt.web.models.BackupRestoreOperationType>`
    :param adjust_connection_strings: <code>true</code> if
     SiteConfig.ConnectionStrings should be set in new app; otherwise,
     <code>false</code>.
    :type adjust_connection_strings: bool
    :param hosting_environment: App Service Environment name, if needed (only
     when restoring an app to an App Service Environment).
    :type hosting_environment: str
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'operation_type': {'key': 'properties.operationType', 'type': 'BackupRestoreOperationType'},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
    }

    def __init__(self, location, name=None, kind=None, type=None, tags=None, storage_account_url=None, blob_name=None, overwrite=None, site_name=None, databases=None, ignore_conflicting_host_names=False, operation_type="Default", adjust_connection_strings=None, hosting_environment=None):
        super(RestoreRequest, self).__init__(name=name, kind=kind, location=location, type=type, tags=tags)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment
