# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventData(Model):
    """The Azure event log entries are of type EventData.

    :param authorization:
    :type authorization: ~azure.mgmt.monitor.models.SenderAuthorization
    :param claims: key value pairs to identify ARM permissions.
    :type claims: dict[str, str]
    :param caller: the email address of the user who has performed the
     operation, the UPN claim or SPN claim based on availability.
    :type caller: str
    :param description: the description of the event.
    :type description: str
    :param id: the Id of this event as required by ARM for RBAC. It contains
     the EventDataID and a timestamp information.
    :type id: str
    :param event_data_id: the event data Id. This is a unique identifier for
     an event.
    :type event_data_id: str
    :param correlation_id: the correlation Id, usually a GUID in the string
     format. The correlation Id is shared among the events that belong to the
     same uber operation.
    :type correlation_id: str
    :param event_name: the event name. This value should not be confused with
     OperationName. For practical purposes, OperationName might be more
     appealing to end users.
    :type event_name: ~azure.mgmt.monitor.models.LocalizableString
    :param category: the event category.
    :type category: ~azure.mgmt.monitor.models.LocalizableString
    :param http_request: the HTTP request info. Usually includes the
     'clientRequestId', 'clientIpAddress' (IP address of the user who initiated
     the event) and 'method' (HTTP method e.g. PUT).
    :type http_request: ~azure.mgmt.monitor.models.HttpRequestInfo
    :param level: the event level. Possible values include: 'Critical',
     'Error', 'Warning', 'Informational', 'Verbose'
    :type level: str or ~azure.mgmt.monitor.models.EventLevel
    :param resource_group_name: the resource group name of the impacted
     resource.
    :type resource_group_name: str
    :param resource_provider_name: the resource provider name of the impacted
     resource.
    :type resource_provider_name: ~azure.mgmt.monitor.models.LocalizableString
    :param resource_id: the resource uri that uniquely identifies the resource
     that caused this event.
    :type resource_id: str
    :param resource_type: the resource type
    :type resource_type: ~azure.mgmt.monitor.models.LocalizableString
    :param operation_id: It is usually a GUID shared among the events
     corresponding to single operation. This value should not be confused with
     EventName.
    :type operation_id: str
    :param operation_name: the operation name.
    :type operation_name: ~azure.mgmt.monitor.models.LocalizableString
    :param properties: the set of <Key, Value> pairs (usually a
     Dictionary<String, String>) that includes details about the event.
    :type properties: dict[str, str]
    :param status: a string describing the status of the operation. Some
     typical values are: Started, In progress, Succeeded, Failed, Resolved.
    :type status: ~azure.mgmt.monitor.models.LocalizableString
    :param sub_status: the event sub status. Most of the time, when included,
     this captures the HTTP status code of the REST call. Common values are: OK
     (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted (HTTP
     Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP
     Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP
     Status Code: 409), Internal Server Error (HTTP Status Code: 500), Service
     Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code:
     504)
    :type sub_status: ~azure.mgmt.monitor.models.LocalizableString
    :param event_timestamp: the timestamp of when the event was generated by
     the Azure service processing the request corresponding the event. It in
     ISO 8601 format.
    :type event_timestamp: datetime
    :param submission_timestamp: the timestamp of when the event became
     available for querying via this API. It is in ISO 8601 format. This value
     should not be confused eventTimestamp. As there might be a delay between
     the occurrence time of the event, and the time that the event is submitted
     to the Azure logging infrastructure.
    :type submission_timestamp: datetime
    :param subscription_id: the Azure subscription Id usually a GUID.
    :type subscription_id: str
    :param tenant_id: the Azure tenant Id
    :type tenant_id: str
    """

    _validation = {
        'level': {'required': True},
        'event_timestamp': {'required': True},
        'submission_timestamp': {'required': True},
    }

    _attribute_map = {
        'authorization': {'key': 'authorization', 'type': 'SenderAuthorization'},
        'claims': {'key': 'claims', 'type': '{str}'},
        'caller': {'key': 'caller', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'event_data_id': {'key': 'eventDataId', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'LocalizableString'},
        'category': {'key': 'category', 'type': 'LocalizableString'},
        'http_request': {'key': 'httpRequest', 'type': 'HttpRequestInfo'},
        'level': {'key': 'level', 'type': 'EventLevel'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'LocalizableString'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'LocalizableString'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'LocalizableString'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'LocalizableString'},
        'sub_status': {'key': 'subStatus', 'type': 'LocalizableString'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'iso-8601'},
        'submission_timestamp': {'key': 'submissionTimestamp', 'type': 'iso-8601'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, level, event_timestamp, submission_timestamp, authorization=None, claims=None, caller=None, description=None, id=None, event_data_id=None, correlation_id=None, event_name=None, category=None, http_request=None, resource_group_name=None, resource_provider_name=None, resource_id=None, resource_type=None, operation_id=None, operation_name=None, properties=None, status=None, sub_status=None, subscription_id=None, tenant_id=None):
        self.authorization = authorization
        self.claims = claims
        self.caller = caller
        self.description = description
        self.id = id
        self.event_data_id = event_data_id
        self.correlation_id = correlation_id
        self.event_name = event_name
        self.category = category
        self.http_request = http_request
        self.level = level
        self.resource_group_name = resource_group_name
        self.resource_provider_name = resource_provider_name
        self.resource_id = resource_id
        self.resource_type = resource_type
        self.operation_id = operation_id
        self.operation_name = operation_name
        self.properties = properties
        self.status = status
        self.sub_status = sub_status
        self.event_timestamp = event_timestamp
        self.submission_timestamp = submission_timestamp
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id
