# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceFromTemplateDescription(Model):
    """Defines description for creating a Service Fabric service from a template
    defined in the application manifest.
    .

    :param application_name:
    :type application_name: str
    :param service_name:
    :type service_name: str
    :param service_type_name:
    :type service_type_name: str
    :param initialization_data:
    :type initialization_data: list of int
    :param service_package_activation_mode: Possible values include:
     'SharedProcess', 'ExclusiveProcess'
    :type service_package_activation_mode: str or :class:`enum
     <azure.servicefabric.models.enum>`
    :param service_dns_name: The DNS name of the service. It requires the DNS
     system service to be enabled in Service Fabric cluster.
    :type service_dns_name: str
    """

    _validation = {
        'application_name': {'required': True},
        'service_name': {'required': True},
        'service_type_name': {'required': True},
    }

    _attribute_map = {
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'initialization_data': {'key': 'InitializationData', 'type': '[int]'},
        'service_package_activation_mode': {'key': 'ServicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'ServiceDnsName', 'type': 'str'},
    }

    def __init__(self, application_name, service_name, service_type_name, initialization_data=None, service_package_activation_mode=None, service_dns_name=None):
        self.application_name = application_name
        self.service_name = service_name
        self.service_type_name = service_type_name
        self.initialization_data = initialization_data
        self.service_package_activation_mode = service_package_activation_mode
        self.service_dns_name = service_dns_name
