# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FabricErrorError(Model):
    """Error object containing error code and error message.

    :param code: Possible values include: 'FABRIC_E_INVALID_PARTITION_KEY',
     'FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR', 'FABRIC_E_INVALID_ADDRESS',
     'FABRIC_E_APPLICATION_NOT_UPGRADING',
     'FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR',
     'FABRIC_E_FABRIC_NOT_UPGRADING',
     'FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR',
     'FABRIC_E_INVALID_CONFIGURATION', 'FABRIC_E_INVALID_NAME_URI',
     'FABRIC_E_PATH_TOO_LONG', 'FABRIC_E_KEY_TOO_LARGE',
     'FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED',
     'FABRIC_E_INVALID_ATOMIC_GROUP', 'FABRIC_E_VALUE_EMPTY',
     'FABRIC_E_NODE_NOT_FOUND', 'FABRIC_E_APPLICATION_TYPE_NOT_FOUND',
     'FABRIC_E_APPLICATION_NOT_FOUND', 'FABRIC_E_SERVICE_TYPE_NOT_FOUND',
     'FABRIC_E_SERVICE_DOES_NOT_EXIST',
     'FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND',
     'FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND',
     'FABRIC_E_PARTITION_NOT_FOUND', 'FABRIC_E_REPLICA_DOES_NOT_EXIST',
     'FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST',
     'FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND',
     'FABRIC_E_DIRECTORY_NOT_FOUND', 'FABRIC_E_FABRIC_VERSION_NOT_FOUND',
     'FABRIC_E_FILE_NOT_FOUND', 'FABRIC_E_NAME_DOES_NOT_EXIST',
     'FABRIC_E_PROPERTY_DOES_NOT_EXIST', 'FABRIC_E_ENUMERATION_COMPLETED',
     'FABRIC_E_SERVICE_MANIFEST_NOT_FOUND', 'FABRIC_E_KEY_NOT_FOUND',
     'FABRIC_E_HEALTH_ENTITY_NOT_FOUND',
     'FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS',
     'FABRIC_E_APPLICATION_ALREADY_EXISTS',
     'FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION',
     'FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS',
     'FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS',
     'FABRIC_E_SERVICE_ALREADY_EXISTS',
     'FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS',
     'FABRIC_E_APPLICATION_TYPE_IN_USE',
     'FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION',
     'FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS',
     'FABRIC_E_FABRIC_VERSION_IN_USE', 'FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS',
     'FABRIC_E_NAME_ALREADY_EXISTS', 'FABRIC_E_NAME_NOT_EMPTY',
     'FABRIC_E_PROPERTY_CHECK_FAILED', 'FABRIC_E_SERVICE_METADATA_MISMATCH',
     'FABRIC_E_SERVICE_TYPE_MISMATCH', 'FABRIC_E_HEALTH_STALE_REPORT',
     'FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED',
     'FABRIC_E_NODE_HAS_NOT_STOPPED_YET', 'FABRIC_E_INSTANCE_ID_MISMATCH',
     'FABRIC_E_VALUE_TOO_LARGE', 'FABRIC_E_NO_WRITE_QUORUM',
     'FABRIC_E_NOT_PRIMARY', 'FABRIC_E_NOT_READY',
     'FABRIC_E_RECONFIGURATION_PENDING', 'FABRIC_E_SERVICE_OFFLINE', 'E_ABORT',
     'FABRIC_E_COMMUNICATION_ERROR', 'FABRIC_E_OPERATION_NOT_COMPLETE',
     'FABRIC_E_TIMEOUT', 'FABRIC_E_NODE_IS_UP'
    :type code: str or :class:`enum <azure.servicefabric.models.enum>`
    :param message: Error message.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(self, code, message=None):
        self.code = code
        self.message = message
